/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.dnd;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import org.netbeans.core.windows.Constants;
import org.netbeans.core.windows.Debug;
import org.netbeans.core.windows.view.dnd.TopComponentDroppable;
import org.netbeans.core.windows.view.dnd.WindowDnDManager;
import org.netbeans.core.windows.view.ui.Tabbed;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakSet;
import org.openide.windows.TopComponent;

final class TopComponentDragSupport
implements AWTEventListener,
DragSourceListener {
    public static final String MIME_TOP_COMPONENT = "application/x-java-jvm-local-objectref; class=org.openide.windows.TopComponent";
    public static final String MIME_TOP_COMPONENT_CLONEABLE = "application/x-java-jvm-local-objectref; class=org.openide.windows.TopComponent$Cloneable";
    public static final String MIME_TOP_COMPONENT_ARRAY = "application/x-java-jvm-local-objectref; class=org.netbeans.core.windows.view.dnd.TopComponentDragSupport$TopComponentArray";
    private static final int CURSOR_COPY = 0;
    private static final int CURSOR_COPY_NO = 1;
    private static final int CURSOR_MOVE = 2;
    private static final int CURSOR_MOVE_NO = 3;
    private static final int CURSOR_COPY_NO_MOVE = 4;
    private static final int CURSOR_MOVE_FREE = 5;
    private static final String NAME_CURSOR_COPY = "CursorTopComponentCopy";
    private static final String NAME_CURSOR_COPY_NO = "CursorTopComponentCopyNo";
    private static final String NAME_CURSOR_MOVE = "CursorTopComponentMove";
    private static final String NAME_CURSOR_MOVE_NO = "CursorTopComponentMoveNo";
    private static final String NAME_CURSOR_COPY_NO_MOVE = "CursorTopComponentCopyNoMove";
    private static final String NAME_CURSOR_MOVE_FREE = "CursorTopComponentMoveFree";
    private static final boolean DEBUG = Debug.isLoggable(TopComponentDragSupport.class);
    private final WindowDnDManager windowDnDManager;
    private Reference<DragSourceContext> dragContextWRef = new WeakReference<Object>(null);
    private boolean canCopy;
    private int hackUserDropAction;
    private boolean hackESC;
    private final Set keyObservers = new WeakSet(4);
    private Point startingPoint;
    private Component startingComponent;
    private long startingTime;
    private AWTEventListener keyListener = new AWTEventListener(){

        public void eventDispatched(AWTEvent aWTEvent) {
            KeyEvent keyEvent = (KeyEvent)aWTEvent;
            if (keyEvent.getID() == 402 && keyEvent.getKeyCode() == 27) {
                TopComponentDragSupport.this.hackESC = true;
            }
        }
    };

    TopComponentDragSupport(WindowDnDManager windowDnDManager) {
        this.windowDnDManager = windowDnDManager;
    }

    public boolean isCopyOperationPossible() {
        return this.canCopy;
    }

    public void eventDispatched(AWTEvent aWTEvent) {
        Point point;
        Object object;
        MouseEvent mouseEvent = (MouseEvent)aWTEvent;
        if (mouseEvent.getID() == 501 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.startingPoint = mouseEvent.getPoint();
            this.startingComponent = mouseEvent.getComponent();
            this.startingTime = mouseEvent.getWhen();
        } else if (mouseEvent.getID() == 502) {
            this.startingPoint = null;
            this.startingComponent = null;
        }
        if (aWTEvent.getID() != 506) {
            return;
        }
        if (this.windowDnDManager.isDragging()) {
            return;
        }
        if (this.startingPoint == null) {
            return;
        }
        if (aWTEvent.getSource() instanceof JButton) {
            return;
        }
        Component component = this.startingComponent;
        if (component == null) {
            return;
        }
        Point point2 = new Point(this.startingPoint);
        Point point3 = mouseEvent.getPoint();
        Component component2 = mouseEvent.getComponent();
        if (component2 == null) {
            return;
        }
        point3 = SwingUtilities.convertPoint(component2, point3, component);
        if (Math.abs(point3.x - point2.x) <= 10 && Math.abs(point3.y - point2.y) <= 10) {
            return;
        }
        if (mouseEvent.getWhen() - this.startingTime <= 200L) {
            return;
        }
        this.startingPoint = null;
        this.startingComponent = null;
        if (DEBUG) {
            TopComponentDragSupport.debugLog("");
            TopComponentDragSupport.debugLog("eventDispatched (MOUSE_DRAGGED)");
        }
        if (component instanceof JTree && ((JTree)component).getPathForLocation(mouseEvent.getX(), mouseEvent.getY()) != null) {
            return;
        }
        component = SwingUtilities.getDeepestComponentAt(component, point2.x, point2.y);
        boolean bl = mouseEvent.isControlDown();
        TopComponent topComponent = null;
        Tabbed tabbed = component instanceof Tabbed ? (Tabbed)((Object)component) : (Tabbed)((Object)SwingUtilities.getAncestorOfClass(Tabbed.class, component));
        if (tabbed == null) {
            if (component instanceof Tabbed.Accessor) {
                tabbed = ((Tabbed.Accessor)((Object)component)).getTabbed();
            } else {
                object = (Tabbed.Accessor)((Object)SwingUtilities.getAncestorOfClass(Tabbed.Accessor.class, component));
                Tabbed tabbed2 = tabbed = object != null ? object.getTabbed() : null;
            }
        }
        if (tabbed == null) {
            return;
        }
        object = new Point(point2);
        Point point4 = SwingUtilities.convertPoint(component, (Point)object, tabbed.getComponent());
        topComponent = tabbed.getTopComponentAt(tabbed.tabForCoordinate(point4));
        if (topComponent == null) {
            return;
        }
        this.hackUserDropAction = bl ? 1 : 2;
        ArrayList<MouseEvent> arrayList = new ArrayList<MouseEvent>();
        arrayList.add(mouseEvent);
        TopComponentDroppable topComponentDroppable = (TopComponentDroppable)((Object)SwingUtilities.getAncestorOfClass(TopComponentDroppable.class, (Component)topComponent));
        if (topComponentDroppable == null) {
            topComponentDroppable = (TopComponentDroppable)((Object)SwingUtilities.getAncestorOfClass(TopComponentDroppable.class, tabbed.getComponent()));
        }
        if (topComponentDroppable != null) {
            point = point2;
            Point point5 = new Point(point2);
            point = SwingUtilities.convertPoint(component, point5, (Component)((Object)topComponentDroppable));
        } else {
            point = null;
        }
        this.doStartDrag(component, topComponent, new DragGestureEvent(new FakeDragGestureRecognizer(this.windowDnDManager, mouseEvent), this.hackUserDropAction, point2, arrayList), topComponentDroppable, point);
    }

    private void doStartDrag(Component component, Object object, DragGestureEvent dragGestureEvent, TopComponentDroppable topComponentDroppable, Point point) {
        Object object2;
        TopComponent topComponent;
        Dialog dialog;
        if (DEBUG) {
            TopComponentDragSupport.debugLog("");
            TopComponentDragSupport.debugLog("doStartDrag");
        }
        if ((dialog = (Dialog)SwingUtilities.getAncestorOfClass(Dialog.class, (Component)(topComponent = object instanceof TopComponent ? (TopComponent)object : ((TopComponent[])object)[0]))) != null && dialog.isModal()) {
            return;
        }
        this.canCopy = topComponent instanceof TopComponent.Cloneable;
        this.windowDnDManager.dragStarting(topComponentDroppable, point, topComponent);
        Cursor cursor = this.hackUserDropAction == 2 ? TopComponentDragSupport.getDragCursor(component, 2) : (this.canCopy ? TopComponentDragSupport.getDragCursor(component, 0) : TopComponentDragSupport.getDragCursor(component, 4));
        this.addListening();
        this.hackESC = false;
        Tabbed tabbed = (Tabbed)((Object)SwingUtilities.getAncestorOfClass(Tabbed.class, component));
        if (tabbed == null) {
            object2 = (Tabbed.Accessor)((Object)SwingUtilities.getAncestorOfClass(Tabbed.Accessor.class, component));
            tabbed = object2 != null ? object2.getTabbed() : null;
        }
        object2 = null;
        if (tabbed != null && Constants.SWITCH_USE_DRAG_IMAGES) {
            int n = tabbed.indexOf((Component)topComponent);
            object2 = tabbed.createImageOfTab(n);
        }
        try {
            dragGestureEvent.startDrag(cursor, (Image)object2, new Point(0, 0), object instanceof TopComponent ? new TopComponentTransferable((TopComponent)object) : new TopComponentArrayTransferable((TopComponent[])object), this);
        }
        catch (InvalidDnDOperationException invalidDnDOperationException) {
            Logger.getLogger(TopComponentDragSupport.class.getName()).log(Level.WARNING, null, invalidDnDOperationException);
            this.removeListening();
            this.windowDnDManager.resetDragSource();
        }
    }

    private void addListening() {
        Toolkit.getDefaultToolkit().addAWTEventListener(this.keyListener, 8L);
    }

    private void removeListening() {
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.keyListener);
    }

    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        if (DEBUG) {
            TopComponentDragSupport.debugLog("");
            TopComponentDragSupport.debugLog("dragEnter");
        }
        if (this.dragContextWRef.get() == null) {
            this.dragContextWRef = new WeakReference<DragSourceContext>(dragSourceDragEvent.getDragSourceContext());
        }
    }

    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        if (DEBUG) {
            TopComponentDragSupport.debugLog("");
            TopComponentDragSupport.debugLog("dragOver");
        }
    }

    public void dragExit(DragSourceEvent dragSourceEvent) {
        if (DEBUG) {
            TopComponentDragSupport.debugLog("");
            TopComponentDragSupport.debugLog("dragExit");
        }
        if (this.dragContextWRef.get() == null) {
            this.dragContextWRef = new WeakReference<DragSourceContext>(dragSourceEvent.getDragSourceContext());
        }
    }

    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        int n;
        String string;
        if (DEBUG) {
            TopComponentDragSupport.debugLog("");
            TopComponentDragSupport.debugLog("dropActionChanged");
        }
        if ((string = dragSourceDragEvent.getDragSourceContext().getCursor().getName()) == null) {
            return;
        }
        int n2 = dragSourceDragEvent.getUserAction();
        if (n2 == 0) {
            n2 = 2;
        }
        this.hackUserDropAction = n2;
        if ((NAME_CURSOR_COPY.equals(string) || NAME_CURSOR_COPY_NO_MOVE.equals(string)) && n2 == 2) {
            n = 2;
        } else if (NAME_CURSOR_COPY_NO.equals(string) && n2 == 2) {
            n = 3;
        } else if (NAME_CURSOR_MOVE.equals(string) && n2 == 1) {
            n = 0;
        } else if (NAME_CURSOR_MOVE_NO.equals(string) && n2 == 1) {
            n = 1;
        } else {
            return;
        }
        if (n == 0 && !this.canCopy) {
            n = 4;
        }
        if (TopComponentDragSupport.getDragCursorName(n).equals(dragSourceDragEvent.getDragSourceContext().getCursor().getName())) {
            return;
        }
        dragSourceDragEvent.getDragSourceContext().setCursor(TopComponentDragSupport.getDragCursor(dragSourceDragEvent.getDragSourceContext().getComponent(), n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dragDropEnd(final DragSourceDropEvent dragSourceDropEvent) {
        if (DEBUG) {
            TopComponentDragSupport.debugLog("");
            TopComponentDragSupport.debugLog("dragDropEnd");
        }
        this.windowDnDManager.dragFinished();
        try {
            if (this.checkDropSuccess(dragSourceDropEvent)) {
                this.removeListening();
                return;
            }
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    SwingUtilities.invokeLater(TopComponentDragSupport.this.createDropIntoFreeAreaTask(dragSourceDropEvent, dragSourceDropEvent.getLocation()));
                }
            }, 250);
        }
        finally {
            this.windowDnDManager.dragFinishedEx();
        }
    }

    private boolean checkDropSuccess(DragSourceDropEvent dragSourceDropEvent) {
        if (this.windowDnDManager.isDropSuccess()) {
            return true;
        }
        Point point = dragSourceDropEvent.getLocation();
        if (point == null) {
            return true;
        }
        if (WindowDnDManager.isInMainWindow(point) || this.windowDnDManager.isInFloatingFrame(point) || WindowDnDManager.isAroundCenterPanel(point)) {
            return false;
        }
        return false;
    }

    private Runnable createDropIntoFreeAreaTask(final DragSourceDropEvent dragSourceDropEvent, final Point point) {
        return new Runnable(){

            public void run() {
                if (TopComponentDragSupport.this.hackESC) {
                    TopComponentDragSupport.this.removeListening();
                    return;
                }
                TopComponent[] topComponentArray = WindowDnDManager.extractTopComponent(false, dragSourceDropEvent.getDragSourceContext().getTransferable());
                if (topComponentArray != null) {
                    TopComponentDragSupport.this.windowDnDManager.tryPerformDrop(TopComponentDragSupport.this.windowDnDManager.getController(), TopComponentDragSupport.this.windowDnDManager.getFloatingFrames(), point, 2, dragSourceDropEvent.getDragSourceContext().getTransferable());
                }
            }
        };
    }

    private static Rectangle getBoundsForNewMode(TopComponent topComponent, Point point) {
        Cloneable cloneable;
        int n = topComponent.getWidth();
        int n2 = topComponent.getHeight();
        Window window = SwingUtilities.getWindowAncestor((Component)topComponent);
        if (window != null) {
            cloneable = window.getInsets();
            n += cloneable.left + cloneable.right;
            n2 += cloneable.top + cloneable.bottom;
        }
        cloneable = topComponent.getBounds();
        Rectangle rectangle = new Rectangle(point.x, point.y, n, n2);
        return rectangle;
    }

    void setSuccessCursor(boolean bl) {
        int n;
        int n2 = this.hackUserDropAction;
        DragSourceContext dragSourceContext = this.dragContextWRef.get();
        if (dragSourceContext == null) {
            return;
        }
        if (n2 == 2) {
            n = bl ? 5 : 2;
        } else if (n2 == 1) {
            n = this.canCopy ? 0 : 4;
        } else {
            Logger.getLogger(TopComponentDragSupport.class.getName()).log(Level.WARNING, null, new IllegalStateException("Invalid action type->" + n2));
            return;
        }
        if (TopComponentDragSupport.getDragCursorName(n).equals(dragSourceContext.getCursor().getName())) {
            return;
        }
        dragSourceContext.setCursor(TopComponentDragSupport.getDragCursor(dragSourceContext.getComponent(), n));
    }

    void setUnsuccessCursor() {
        int n;
        DragSourceContext dragSourceContext = this.dragContextWRef.get();
        if (dragSourceContext == null) {
            return;
        }
        String string = dragSourceContext.getCursor().getName();
        if (NAME_CURSOR_COPY.equals(string) || NAME_CURSOR_COPY_NO_MOVE.equals(string)) {
            n = 1;
        } else if (NAME_CURSOR_MOVE.equals(string) || NAME_CURSOR_MOVE_NO.equals(string)) {
            n = 3;
        } else {
            return;
        }
        dragSourceContext.setCursor(TopComponentDragSupport.getDragCursor(dragSourceContext.getComponent(), n));
    }

    void dragFinished() {
        this.dragContextWRef = new WeakReference<Object>(null);
    }

    private static void debugLog(String string) {
        Debug.log(TopComponentDragSupport.class, string);
    }

    private static String getDragCursorName(int n) {
        if (n == 0) {
            return NAME_CURSOR_COPY;
        }
        if (n == 1) {
            return NAME_CURSOR_COPY_NO;
        }
        if (n == 2) {
            return NAME_CURSOR_MOVE;
        }
        if (n == 3) {
            return NAME_CURSOR_MOVE_NO;
        }
        if (n == 4) {
            return NAME_CURSOR_COPY_NO_MOVE;
        }
        if (n == 5) {
            return NAME_CURSOR_MOVE_FREE;
        }
        return null;
    }

    private static Cursor getDragCursor(Component component, int n) {
        Image image = null;
        String string = null;
        if (n == 0) {
            image = Utilities.loadImage((String)"org/netbeans/core/resources/topComponentDragCopy.gif");
            string = NAME_CURSOR_COPY;
        } else if (n == 1) {
            image = Utilities.loadImage((String)"org/netbeans/core/resources/topComponentDragCopyNo.gif");
            string = NAME_CURSOR_COPY_NO;
        } else if (n == 2) {
            image = Utilities.loadImage((String)"org/netbeans/core/resources/topComponentDragMove.gif");
            string = NAME_CURSOR_MOVE;
        } else if (n == 3) {
            image = Utilities.loadImage((String)"org/netbeans/core/resources/topComponentDragMoveNo.gif");
            string = NAME_CURSOR_MOVE_NO;
        } else if (n == 4) {
            image = Utilities.loadImage((String)"org/netbeans/core/resources/topComponentDragCopyNo.gif");
            string = NAME_CURSOR_COPY_NO_MOVE;
        } else if (n == 5) {
            image = Utilities.loadImage((String)"org/netbeans/core/windows/resources/topComponentDragMoveFreeArea.gif");
            string = NAME_CURSOR_MOVE_FREE;
        } else {
            throw new IllegalArgumentException("Unknown cursor type=" + n);
        }
        return Utilities.createCustomCursor((Component)component, (Image)image, (String)string);
    }

    private static class FakeDragGestureRecognizer
    extends DragGestureRecognizer {
        public FakeDragGestureRecognizer(WindowDnDManager windowDnDManager, MouseEvent mouseEvent) {
            super(windowDnDManager.getWindowDragSource(), (Component)mouseEvent.getSource(), 3, null);
            this.appendEvent(mouseEvent);
        }

        public void registerListeners() {
        }

        public void unregisterListeners() {
        }
    }

    static class TopComponentArray {
        TopComponentArray() {
        }
    }

    private static class TopComponentArrayTransferable
    implements Transferable {
        private TopComponent[] tcArray;

        public TopComponentArrayTransferable(TopComponent[] topComponentArray) {
            this.tcArray = topComponentArray;
        }

        public Object getTransferData(DataFlavor dataFlavor) {
            if (TopComponentDragSupport.MIME_TOP_COMPONENT_ARRAY.equals(dataFlavor.getMimeType())) {
                return this.tcArray;
            }
            return null;
        }

        public DataFlavor[] getTransferDataFlavors() {
            try {
                return new DataFlavor[]{new DataFlavor(TopComponentDragSupport.MIME_TOP_COMPONENT_ARRAY, null, TopComponent.class.getClassLoader())};
            }
            catch (ClassNotFoundException classNotFoundException) {
                Logger.getLogger(TopComponentDragSupport.class.getName()).log(Level.WARNING, classNotFoundException.getMessage(), classNotFoundException);
                return new DataFlavor[0];
            }
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return TopComponentDragSupport.MIME_TOP_COMPONENT_ARRAY.equals(dataFlavor.getMimeType());
        }
    }

    private static class TopComponentTransferable
    implements Transferable {
        private TopComponent tc;

        public TopComponentTransferable(TopComponent topComponent) {
            this.tc = topComponent;
        }

        public Object getTransferData(DataFlavor dataFlavor) {
            if (TopComponentDragSupport.MIME_TOP_COMPONENT.equals(dataFlavor.getMimeType())) {
                return this.tc;
            }
            if (TopComponentDragSupport.MIME_TOP_COMPONENT_CLONEABLE.equals(dataFlavor.getMimeType()) && this.tc instanceof TopComponent.Cloneable) {
                return this.tc;
            }
            return null;
        }

        public DataFlavor[] getTransferDataFlavors() {
            try {
                if (this.tc instanceof TopComponent.Cloneable) {
                    return new DataFlavor[]{new DataFlavor(TopComponentDragSupport.MIME_TOP_COMPONENT, null, TopComponent.class.getClassLoader()), new DataFlavor(TopComponentDragSupport.MIME_TOP_COMPONENT_CLONEABLE, null, TopComponent.Cloneable.class.getClassLoader())};
                }
                return new DataFlavor[]{new DataFlavor(TopComponentDragSupport.MIME_TOP_COMPONENT, null, TopComponent.class.getClassLoader())};
            }
            catch (ClassNotFoundException classNotFoundException) {
                Logger.getLogger(TopComponentDragSupport.class.getName()).log(Level.WARNING, classNotFoundException.getMessage(), classNotFoundException);
                return new DataFlavor[0];
            }
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            if (TopComponentDragSupport.MIME_TOP_COMPONENT.equals(dataFlavor.getMimeType())) {
                return true;
            }
            return TopComponentDragSupport.MIME_TOP_COMPONENT_CLONEABLE.equals(dataFlavor.getMimeType()) && this.tc instanceof TopComponent.Cloneable;
        }
    }
}

