/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JSeparator;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.core.windows.Constants;
import org.netbeans.core.windows.RegistryImpl;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.view.ui.StatusLine;
import org.netbeans.core.windows.view.ui.toolbars.ToolbarConfiguration;
import org.openide.LifecycleManager;
import org.openide.awt.MenuBar;
import org.openide.awt.StatusLineElementProvider;
import org.openide.awt.ToolbarPool;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class MainWindow
extends JFrame {
    static final long serialVersionUID = -1160791973145645501L;
    private Component desktop;
    private JPanel desktopPanel;
    private static JPanel innerIconsPanel;
    private boolean inited;
    private static Lookup.Result<StatusLineElementProvider> result;
    private static final String ICON_SMALL = "org/netbeans/core/startup/frame.gif";
    private static final String ICON_BIG = "org/netbeans/core/startup/frame32.gif";
    private Rectangle forcedBounds = null;
    private Image waitingForPaintDummyImage;
    private Graphics waitingForPaintDummyGraphic;
    boolean isOlderJDK = System.getProperty("java.version").startsWith("1.5");
    private boolean isFullScreenMode = false;
    private Rectangle restoreBounds;
    private int restoreExtendedState = 0;

    protected void setRootPane(JRootPane jRootPane) {
        super.setRootPane(jRootPane);
        if (jRootPane != null) {
            HelpCtx.setHelpIDString((JComponent)jRootPane, (String)new HelpCtx(MainWindow.class).getHelpID());
        }
        jRootPane.setOpaque(true);
        if (Utilities.isWindows()) {
            JPanel jPanel = new JPanel(){

                public void setVisible(boolean bl) {
                    if (bl != this.isVisible()) {
                        super.setVisible(bl);
                    }
                }
            };
            jPanel.setName(jRootPane.getName() + ".nbGlassPane");
            jPanel.setVisible(false);
            ((JPanel)jPanel).setOpaque(false);
            jRootPane.setGlassPane(jPanel);
        }
    }

    public void initializeComponents() {
        JComponent jComponent;
        if (this.inited) {
            return;
        }
        this.inited = true;
        this.setIconImage(MainWindow.createIDEImage());
        this.initListeners();
        this.setDefaultCloseOperation(0);
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(MainWindow.class).getString("ACSD_MainWindow"));
        this.setJMenuBar(MainWindow.createMenuBar());
        if (!Constants.NO_TOOLBARS) {
            jComponent = MainWindow.getToolbarComponent();
            this.getContentPane().add((Component)jComponent, "North");
        }
        if (!Constants.SWITCH_STATUSLINE_IN_MENUBAR) {
            if (Constants.CUSTOM_STATUS_LINE_PATH == null) {
                jComponent = new StatusLine();
                ((JLabel)jComponent).setText(" ");
                jComponent.setPreferredSize(new Dimension(0, jComponent.getPreferredSize().height));
                jComponent.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
                JPanel jPanel = new JPanel(new BorderLayout());
                int n = 0;
                if (Utilities.isMac()) {
                    n = 12;
                }
                jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 0, 0, n), jPanel.getBorder()));
                jPanel.add((Component)new JSeparator(), "North");
                jPanel.add((Component)jComponent, "Center");
                MainWindow.decoratePanel(jPanel);
                jPanel.setName("statusLine");
                this.getContentPane().add((Component)jPanel, "South");
            } else {
                jComponent = MainWindow.getCustomStatusLine();
                if (jComponent != null) {
                    this.getContentPane().add((Component)jComponent, "South");
                }
            }
        }
        this.desktopPanel = new JPanel();
        this.desktopPanel.setBorder(MainWindow.getDesktopBorder());
        this.desktopPanel.setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.desktopPanel, "Center");
        MenuSelectionManager.defaultManager().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
                if (menuElementArray != null && menuElementArray.length > 0 && menuElementArray[0] == MainWindow.this.getJMenuBar() && !MainWindow.this.isActive()) {
                    MainWindow.this.toFront();
                }
            }
        });
        this.setTitle(NbBundle.getMessage(MainWindow.class, (String)"CTL_MainWindow_Title_No_Project", (Object)System.getProperty("netbeans.buildnumber")));
    }

    private static void decoratePanel(JPanel jPanel) {
        assert (SwingUtilities.isEventDispatchThread()) : "Must run in AWT queue.";
        if (innerIconsPanel != null) {
            jPanel.remove(innerIconsPanel);
        }
        if ((innerIconsPanel = MainWindow.getStatusLineElements(jPanel)) != null) {
            jPanel.add((Component)innerIconsPanel, "East");
        }
    }

    static JPanel getStatusLineElements(JPanel jPanel) {
        Collection collection;
        if (result == null) {
            result = Lookup.getDefault().lookup(new Lookup.Template(StatusLineElementProvider.class));
            result.addLookupListener((LookupListener)new StatusLineElementsListener(jPanel));
        }
        if ((collection = result.allInstances()) == null || collection.isEmpty()) {
            return null;
        }
        Iterator iterator = collection.iterator();
        JPanel jPanel2 = new JPanel(new FlowLayout(2, 0, 0));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(1, 0, 0, 2));
        boolean bl = false;
        while (iterator.hasNext()) {
            StatusLineElementProvider statusLineElementProvider = (StatusLineElementProvider)iterator.next();
            Component component = statusLineElementProvider.getStatusLineElement();
            if (component == null) continue;
            bl = true;
            jPanel2.add(component);
        }
        return bl ? jPanel2 : null;
    }

    private static Border getDesktopBorder() {
        Border border = (Border)UIManager.get("nb.desktop.splitpane.border");
        if (border != null) {
            return border;
        }
        return new EmptyBorder(1, 1, 1, 1);
    }

    static Image createIDEImage() {
        return Utilities.loadImage((String)(Utilities.isLargeFrameIcons() ? ICON_BIG : ICON_SMALL), (boolean)true);
    }

    private void initListeners() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                LifecycleManager.getDefault().exit();
            }

            public void windowActivated(WindowEvent windowEvent) {
                RegistryImpl.cancelMenu(MainWindow.this);
            }
        });
    }

    private static JMenuBar createMenuBar() {
        JMenuBar jMenuBar = MainWindow.getCustomMenuBar();
        if (jMenuBar == null) {
            jMenuBar = new MenuBar(null);
        }
        jMenuBar.setBorderPainted(false);
        if (jMenuBar instanceof MenuBar) {
            ((MenuBar)jMenuBar).waitFinished();
        }
        if (Constants.SWITCH_STATUSLINE_IN_MENUBAR) {
            if (Constants.CUSTOM_STATUS_LINE_PATH == null) {
                StatusLine statusLine = new StatusLine();
                JSeparator jSeparator = new JSeparator(1);
                Dimension dimension = jSeparator.getPreferredSize();
                dimension.width += 6;
                jSeparator.setPreferredSize(dimension);
                JPanel jPanel = new JPanel(new BorderLayout());
                jPanel.add((Component)jSeparator, "West");
                jPanel.add((Component)statusLine, "Center");
                MainWindow.decoratePanel(jPanel);
                jPanel.setName("statusLine");
                jMenuBar.add(jPanel);
            } else {
                JComponent jComponent = MainWindow.getCustomStatusLine();
                if (jComponent != null) {
                    jMenuBar.add(jComponent);
                }
            }
        }
        return jMenuBar;
    }

    private static JMenuBar getCustomMenuBar() {
        try {
            DataObject dataObject;
            InstanceCookie instanceCookie;
            String string = Constants.CUSTOM_MENU_BAR_PATH;
            if (string == null) {
                return null;
            }
            FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource(string);
            if (fileObject != null && (instanceCookie = (InstanceCookie)(dataObject = DataObject.find((FileObject)fileObject)).getCookie(InstanceCookie.class)) != null) {
                return (JMenuBar)instanceCookie.instanceCreate();
            }
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
        }
        return null;
    }

    private static JComponent getCustomStatusLine() {
        try {
            DataObject dataObject;
            InstanceCookie instanceCookie;
            String string = Constants.CUSTOM_STATUS_LINE_PATH;
            if (string == null) {
                return null;
            }
            FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource(string);
            if (fileObject != null && (instanceCookie = (InstanceCookie)(dataObject = DataObject.find((FileObject)fileObject)).getCookie(InstanceCookie.class)) != null) {
                return (JComponent)instanceCookie.instanceCreate();
            }
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
        }
        return null;
    }

    private static JComponent getToolbarComponent() {
        ToolbarPool toolbarPool = ToolbarPool.getDefault();
        toolbarPool.waitFinished();
        return toolbarPool;
    }

    private void initializeBounds() {
        Rectangle rectangle = WindowManagerImpl.getInstance().getEditorAreaState() == 0 ? WindowManagerImpl.getInstance().getMainWindowBoundsJoined() : WindowManagerImpl.getInstance().getMainWindowBoundsSeparated();
        if (null != this.forcedBounds) {
            rectangle = new Rectangle(this.forcedBounds);
            this.setPreferredSize(rectangle.getSize());
            this.forcedBounds = null;
        }
        if (!rectangle.isEmpty()) {
            this.setBounds(rectangle);
        }
    }

    public void setBounds(Rectangle rectangle) {
        Rectangle rectangle2 = rectangle;
        if (rectangle2 != null && rectangle2.height < this.getPreferredSize().height) {
            rectangle2 = new Rectangle(rectangle2.x, rectangle2.y, rectangle2.width, this.getPreferredSize().height);
        }
        super.setBounds(rectangle2);
    }

    public void prepareWindow() {
        this.initializeBounds();
    }

    public void setDesktop(Component component) {
        if (this.desktop == component) {
            if (this.desktop != null && !Arrays.asList(this.desktopPanel.getComponents()).contains(this.desktop)) {
                this.desktopPanel.add(this.desktop, "Center");
            }
            return;
        }
        if (this.desktop != null) {
            this.desktopPanel.remove(this.desktop);
        }
        this.desktop = component;
        if (this.desktop != null) {
            this.desktopPanel.add(this.desktop, "Center");
        }
        this.invalidate();
        this.validate();
        if (this.isOlderJDK && !System.getProperty("os.name").startsWith("Windows")) {
            this.releaseWaitingForPaintDummyGraphic();
        }
        this.repaint();
    }

    public Component getDesktop() {
        return this.desktop;
    }

    public boolean hasDesktop() {
        return this.desktop != null;
    }

    public Rectangle getPureMainWindowBounds() {
        Rectangle rectangle = this.getBounds();
        if (this.desktop != null) {
            Dimension dimension = this.desktop.getSize();
            rectangle.height -= dimension.height;
        }
        return rectangle;
    }

    public void setVisible(boolean bl) {
        if (bl && this.isOlderJDK) {
            this.waitingForPaintDummyImage = new BufferedImage(1, 1, 1);
            this.waitingForPaintDummyGraphic = this.waitingForPaintDummyImage.getGraphics();
        }
        super.setVisible(bl);
    }

    public void paint(Graphics graphics) {
        if (this.waitingForPaintDummyGraphic != null) {
            this.releaseWaitingForPaintDummyGraphic();
            graphics = this.getGraphics();
        }
        super.paint(graphics);
    }

    public Graphics getGraphics() {
        if (this.waitingForPaintDummyGraphic != null) {
            AWTEvent aWTEvent = EventQueue.getCurrentEvent();
            if (aWTEvent == null || aWTEvent.getID() != 800 && aWTEvent.getSource() != this) {
                return this.waitingForPaintDummyGraphic;
            }
            this.releaseWaitingForPaintDummyGraphic();
        }
        return super.getGraphics();
    }

    private void releaseWaitingForPaintDummyGraphic() {
        if (this.waitingForPaintDummyGraphic != null) {
            this.waitingForPaintDummyGraphic.dispose();
            this.waitingForPaintDummyGraphic = null;
            this.waitingForPaintDummyImage = null;
        }
    }

    public void setFullScreenMode(boolean bl) {
        boolean bl2;
        ToolbarConfiguration toolbarConfiguration;
        if (this.isFullScreenMode == bl) {
            return;
        }
        TopComponent topComponent = WindowManager.getDefault().getRegistry().getActivated();
        if (!this.isFullScreenMode) {
            this.restoreExtendedState = this.getExtendedState();
            this.restoreBounds = this.getBounds();
        }
        this.isFullScreenMode = bl;
        if (Utilities.isWindows()) {
            this.setVisible(false);
        } else {
            WindowManagerImpl.getInstance().setVisible(false);
        }
        this.dispose();
        this.setUndecorated(this.isFullScreenMode);
        this.setExtendedState(this.isFullScreenMode ? 6 : this.restoreExtendedState);
        String string = ToolbarPool.getDefault().getConfiguration();
        if (null != string && null != (toolbarConfiguration = ToolbarConfiguration.findConfiguration(string))) {
            toolbarConfiguration.rebuildMenu();
        }
        MainWindow.getToolbarComponent().setVisible(!this.isFullScreenMode);
        boolean bl3 = bl2 = !this.isFullScreenMode;
        if (bl2 || this.isFullScreenMode() && !Utilities.isWindows()) {
            if (bl2) {
                this.forcedBounds = this.restoreBounds;
            } else {
                GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
                this.forcedBounds = graphicsEnvironment.getMaximumWindowBounds();
            }
        }
        if (Utilities.isWindows()) {
            this.setVisible(true);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MainWindow.this.invalidate();
                    MainWindow.this.validate();
                    MainWindow.this.repaint();
                    if (bl2) {
                        MainWindow.this.setPreferredSize(MainWindow.this.restoreBounds.getSize());
                        MainWindow.this.setBounds(MainWindow.this.restoreBounds);
                    }
                }
            });
        } else {
            WindowManagerImpl.getInstance().setVisible(true);
        }
    }

    public boolean isFullScreenMode() {
        return this.isFullScreenMode;
    }

    private static class StatusLineElementsListener
    implements LookupListener {
        private JPanel decoratingPanel;

        StatusLineElementsListener(JPanel jPanel) {
            this.decoratingPanel = jPanel;
        }

        public void resultChanged(LookupEvent lookupEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MainWindow.decoratePanel(StatusLineElementsListener.this.decoratingPanel);
                }
            });
        }
    }
}

