/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.diff;

import java.io.File;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.editor.errorstripe.privatespi.MarkProvider;
import org.netbeans.modules.versioning.VersioningConfig;
import org.netbeans.modules.versioning.diff.DiffSidebar;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.RequestProcessor;

public class DiffSidebarManager
implements PreferenceChangeListener {
    static final String SIDEBAR_ENABLED = "diff.sidebarEnabled";
    private static DiffSidebarManager instance;
    private boolean sidebarEnabled;
    private final Map<DiffSidebar, Object> sideBars = new WeakHashMap<DiffSidebar, Object>();

    public static synchronized DiffSidebarManager getInstance() {
        if (instance == null) {
            instance = new DiffSidebarManager();
        }
        return instance;
    }

    private DiffSidebarManager() {
        this.sidebarEnabled = VersioningConfig.getDefault().getPreferences().getBoolean(SIDEBAR_ENABLED, true);
        VersioningConfig.getDefault().getPreferences().addPreferenceChangeListener(this);
    }

    public void refreshAllSidebars() {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Map map = DiffSidebarManager.this.sideBars;
                synchronized (map) {
                    for (DiffSidebar diffSidebar : DiffSidebarManager.this.sideBars.keySet()) {
                        diffSidebar.refresh();
                    }
                }
            }
        });
    }

    RequestProcessor.Task createDiffSidebarTask(Runnable runnable) {
        return Utils.createTask(runnable);
    }

    JComponent createSideBar(JTextComponent jTextComponent) {
        return this.getSideBar(jTextComponent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DiffSidebar getSideBar(JTextComponent jTextComponent) {
        Map<DiffSidebar, Object> map = this.sideBars;
        synchronized (map) {
            DiffSidebar object = null;
            for (DiffSidebar object2 : this.sideBars.keySet()) {
                if (object2.getTextComponent() != jTextComponent) continue;
                object = object2;
                break;
            }
            if (object == null) {
                Object object3 = null;
                Document document = jTextComponent.getDocument();
                DataObject dataObject = (DataObject)document.getProperty("stream");
                if (dataObject != null) {
                    FileObject fileObject = dataObject.getPrimaryFile();
                    object3 = FileUtil.toFile((FileObject)fileObject);
                }
                if (object3 == null) {
                    return null;
                }
                object = new DiffSidebar(jTextComponent, (File)object3);
                this.sideBars.put(object, null);
                object.setSidebarVisible(this.sidebarEnabled);
            }
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSidebarEnabled(boolean bl) {
        Map<DiffSidebar, Object> map = this.sideBars;
        synchronized (map) {
            for (DiffSidebar diffSidebar : this.sideBars.keySet()) {
                diffSidebar.setSidebarVisible(bl);
            }
            this.sidebarEnabled = bl;
        }
    }

    MarkProvider createMarkProvider(JTextComponent jTextComponent) {
        DiffSidebar diffSidebar = this.getSideBar(jTextComponent);
        return diffSidebar != null ? diffSidebar.getMarkProvider() : null;
    }

    DiffSidebar t9y_getSidebar() {
        return this.sideBars.keySet().iterator().next();
    }

    public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
        if (preferenceChangeEvent.getKey().equals(SIDEBAR_ENABLED)) {
            this.setSidebarEnabled(Boolean.valueOf(preferenceChangeEvent.getNewValue()));
        }
    }
}

