/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.spi;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Set;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OriginalContent {
    public static final String PROP_CONTENT_CHANGED = "contentChanged";
    protected final File workingCopy;
    protected final PropertyChangeSupport support = new PropertyChangeSupport(this);

    protected OriginalContent(File file) {
        this.workingCopy = FileUtil.normalizeFile((File)file);
    }

    public Reader getText() {
        FileObject fileObject = FileUtil.toFileObject((File)this.workingCopy);
        if (fileObject == null) {
            return null;
        }
        File file = Utils.getTempFolder();
        HashSet<File> hashSet = new HashSet<File>(2);
        hashSet.add(this.workingCopy);
        DataObject dataObject = null;
        try {
            dataObject = DataObject.find((FileObject)fileObject);
            Set set = dataObject.files();
            for (FileObject fileObject2 : set) {
                File file2 = FileUtil.toFile((FileObject)fileObject2);
                hashSet.add(file2);
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            // empty catch block
        }
        try {
            this.getOriginalFiles(file, hashSet);
        }
        catch (Exception exception) {
            return null;
        }
        return this.createReader(new File(file, this.workingCopy.getName()));
    }

    protected abstract void getOriginalFiles(File var1, Set<File> var2) throws Exception;

    public final File getWorkingCopy() {
        return this.workingCopy;
    }

    public final boolean equals(Object object) {
        return object instanceof OriginalContent && this.workingCopy.equals(((OriginalContent)object).workingCopy);
    }

    public final int hashCode() {
        return this.workingCopy.hashCode();
    }

    private Reader createReader(File file) {
        try {
            FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
            StyledDocument styledDocument = editorCookie.openDocument();
            return new StringReader(styledDocument.getText(0, styledDocument.getLength()));
        }
        catch (Exception exception) {
            try {
                return new FileReader(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }
}

