/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform;

import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.java.j2seplatform.platformdefinition.J2SEPlatformImpl;
import org.netbeans.modules.java.j2seplatform.platformdefinition.PlatformConvertor;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.modules.ModuleInstall;
import org.openide.util.Exceptions;

public class J2SEPlatformModule
extends ModuleInstall {
    private static final String DEFAULT_PLATFORM = "Services/Platforms/org-netbeans-api-java-Platform/default_platform.xml";
    static /* synthetic */ Class class$org$netbeans$modules$java$j2seplatform$J2SEPlatformModule;

    public void restored() {
        super.restored();
        J2SEPlatformModule.updateBuildProperties();
    }

    public static void updateBuildProperties() {
        ProjectManager.mutex().postWriteRequest(new Runnable(){

            public void run() {
                try {
                    J2SEPlatformModule.recoverDefaultPlatform();
                    EditableProperties editableProperties = PropertyUtils.getGlobalProperties();
                    boolean bl = J2SEPlatformModule.updateSourceLevel(editableProperties);
                    if (bl |= J2SEPlatformModule.updateBuildProperties(editableProperties)) {
                        PropertyUtils.putGlobalProperties((EditableProperties)editableProperties);
                    }
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        });
    }

    private static boolean updateSourceLevel(EditableProperties editableProperties) {
        JavaPlatform javaPlatform = JavaPlatformManager.getDefault().getDefaultPlatform();
        String string = javaPlatform.getSpecification().getVersion().toString();
        if (!string.equals(editableProperties.getProperty("default.javac.source"))) {
            editableProperties.setProperty("default.javac.source", string);
            editableProperties.setProperty("default.javac.target", string);
            return true;
        }
        return false;
    }

    private static boolean updateBuildProperties(EditableProperties editableProperties) {
        boolean bl = false;
        JavaPlatform[] javaPlatformArray = JavaPlatformManager.getDefault().getPlatforms(null, new Specification("j2se", null));
        for (int i = 0; i < javaPlatformArray.length; ++i) {
            String string;
            String string2;
            if (javaPlatformArray[i].equals(JavaPlatformManager.getDefault().getDefaultPlatform()) || !(javaPlatformArray[i] instanceof J2SEPlatformImpl) || editableProperties.containsKey((Object)(string2 = PlatformConvertor.createName(string = ((J2SEPlatformImpl)javaPlatformArray[i]).getAntName(), "home")))) continue;
            try {
                PlatformConvertor.generatePlatformProperties(javaPlatformArray[i], string, editableProperties);
                bl = true;
                continue;
            }
            catch (PlatformConvertor.BrokenPlatformException brokenPlatformException) {
                Logger.getLogger((class$org$netbeans$modules$java$j2seplatform$J2SEPlatformModule == null ? J2SEPlatformModule.class$("org.netbeans.modules.java.j2seplatform.J2SEPlatformModule") : class$org$netbeans$modules$java$j2seplatform$J2SEPlatformModule).getName()).info("Platform: " + javaPlatformArray[i].getDisplayName() + " is missing: " + brokenPlatformException.getMissingTool());
                continue;
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return bl;
    }

    private static void recoverDefaultPlatform() {
        FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource(DEFAULT_PLATFORM);
        if (fileObject != null) {
            try {
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                boolean bl = false;
                InstanceCookie instanceCookie = (InstanceCookie)dataObject.getCookie(InstanceCookie.class);
                if (instanceCookie != null) {
                    try {
                        instanceCookie.instanceCreate();
                        bl = true;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (!bl) {
                    Logger.getLogger("global").log(Level.WARNING, "default_platform.xml is broken, regenerating.");
                    Object object = fileObject.getAttribute("removeWritables");
                    if (object instanceof Callable) {
                        ((Callable)object).call();
                    }
                }
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
        } else {
            Logger.getLogger("global").log(Level.WARNING, "The default platform is hidden.");
        }
    }
}

