/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URL;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.tools.JavaFileManager;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.preprocessorbridge.spi.JavaFileFilterImplementation;
import org.netbeans.modules.java.source.classpath.CacheClassPath;
import org.netbeans.modules.java.source.parsing.CachingArchiveProvider;
import org.netbeans.modules.java.source.parsing.CachingFileManager;
import org.netbeans.modules.java.source.parsing.OutputFileManager;
import org.netbeans.modules.java.source.parsing.ProxyFileManager;
import org.netbeans.modules.java.source.parsing.SourceFileManager;
import org.netbeans.modules.java.source.usages.ClasspathInfoAccessor;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.WeakListeners;

public final class ClasspathInfo {
    private static final ClassPath EMPTY_PATH = ClassPathSupport.createClassPath((URL[])new URL[0]);
    private final CachingArchiveProvider archiveProvider;
    private final ClassPath srcClassPath;
    private final ClassPath bootClassPath;
    private final ClassPath compileClassPath;
    private ClassPath outputClassPath;
    private final ClassPathListener cpListener;
    private final boolean backgroundCompilation;
    private final boolean ignoreExcludes;
    private final JavaFileFilterImplementation filter;
    private JavaFileManager fileManager;
    private EventListenerList listenerList = null;
    private ClassIndex usagesQuery;

    private ClasspathInfo(CachingArchiveProvider cachingArchiveProvider, ClassPath classPath, ClassPath classPath2, ClassPath classPath3, JavaFileFilterImplementation javaFileFilterImplementation, boolean bl, boolean bl2) {
        assert (cachingArchiveProvider != null && classPath != null && classPath2 != null);
        this.cpListener = new ClassPathListener();
        this.archiveProvider = cachingArchiveProvider;
        this.bootClassPath = CacheClassPath.forBootPath(classPath);
        this.compileClassPath = CacheClassPath.forClassPath(classPath2);
        this.bootClassPath.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.cpListener, (Object)this.bootClassPath));
        this.compileClassPath.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.cpListener, (Object)this.compileClassPath));
        if (classPath3 != null) {
            this.srcClassPath = classPath3;
            this.outputClassPath = CacheClassPath.forSourcePath(this.srcClassPath);
            this.srcClassPath.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.cpListener, (Object)this.srcClassPath));
        } else {
            this.srcClassPath = ClassPathSupport.createClassPath((URL[])new URL[0]);
            this.outputClassPath = ClassPathSupport.createClassPath((URL[])new URL[0]);
        }
        this.backgroundCompilation = bl;
        this.ignoreExcludes = bl2;
        this.filter = javaFileFilterImplementation;
    }

    public String toString() {
        return "ClasspathInfo boot:[" + this.bootClassPath + "],compile:[" + this.compileClassPath + "],src:[" + this.srcClassPath + "]";
    }

    public static ClasspathInfo create(File file) {
        if (file == null) {
            throw new IllegalArgumentException("Cannot pass null as parameter of ClasspathInfo.create(java.io.File)");
        }
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject == null) {
            return null;
        }
        return ClasspathInfo.create(fileObject);
    }

    private static ClasspathInfo create(FileObject fileObject, JavaFileFilterImplementation javaFileFilterImplementation, boolean bl, boolean bl2) {
        ClassPath classPath;
        ClassPath classPath2;
        ClassPath classPath3 = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/boot");
        if (classPath3 == null) {
            classPath3 = JavaPlatformManager.getDefault().getDefaultPlatform().getBootstrapLibraries();
        }
        if ((classPath2 = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/compile")) == null) {
            classPath2 = EMPTY_PATH;
        }
        if ((classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source")) == null) {
            classPath = EMPTY_PATH;
        }
        return ClasspathInfo.create(classPath3, classPath2, classPath, javaFileFilterImplementation, bl, bl2);
    }

    public static ClasspathInfo create(FileObject fileObject) {
        return ClasspathInfo.create(fileObject, null, false, false);
    }

    private static ClasspathInfo create(ClassPath classPath, ClassPath classPath2, ClassPath classPath3, JavaFileFilterImplementation javaFileFilterImplementation, boolean bl, boolean bl2) {
        return new ClasspathInfo(CachingArchiveProvider.getDefault(), classPath, classPath2, classPath3, javaFileFilterImplementation, bl, bl2);
    }

    public static ClasspathInfo create(ClassPath classPath, ClassPath classPath2, ClassPath classPath3) {
        return new ClasspathInfo(CachingArchiveProvider.getDefault(), classPath, classPath2, classPath3, null, false, false);
    }

    public synchronized void addChangeListener(ChangeListener changeListener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    public synchronized void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(ChangeListener.class, changeListener);
    }

    public ClassPath getClassPath(PathKind pathKind) {
        switch (pathKind) {
            case BOOT: {
                return this.bootClassPath;
            }
            case COMPILE: {
                return this.compileClassPath;
            }
            case SOURCE: {
                return this.srcClassPath;
            }
            case OUTPUT: {
                return this.outputClassPath;
            }
        }
        assert (false) : "Unknown path type";
        return null;
    }

    public synchronized ClassIndex getClassIndex() {
        if (this.usagesQuery == null) {
            this.usagesQuery = new ClassIndex(this.bootClassPath, this.compileClassPath, this.srcClassPath);
        }
        return this.usagesQuery;
    }

    synchronized JavaFileManager getFileManager() {
        if (this.fileManager == null) {
            boolean bl = this.srcClassPath != null;
            this.fileManager = new ProxyFileManager(new CachingFileManager(this.archiveProvider, this.bootClassPath, true, true), new CachingFileManager(this.archiveProvider, this.compileClassPath, false, true), bl ? (this.backgroundCompilation ? new CachingFileManager(this.archiveProvider, this.srcClassPath, this.filter, false, this.ignoreExcludes) : new SourceFileManager(this.srcClassPath, this.ignoreExcludes)) : null, bl ? new OutputFileManager(this.archiveProvider, this.outputClassPath, this.srcClassPath) : null);
        }
        return this.fileManager;
    }

    private void fireChangeListenerStateChanged() {
        ChangeEvent changeEvent = null;
        if (this.listenerList == null) {
            return;
        }
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ChangeListener.class) continue;
            if (changeEvent == null) {
                changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)objectArray[i + 1]).stateChanged(changeEvent);
        }
    }

    static {
        ClasspathInfoAccessor.INSTANCE = new ClasspathInfoAccessorImpl();
        try {
            Class.forName(ClassIndex.class.getName(), true, CompilationInfo.class.getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            ErrorManager.getDefault().notify((Throwable)classNotFoundException);
        }
    }

    private class ClassPathListener
    implements PropertyChangeListener {
        private ClassPathListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("roots".equals(propertyChangeEvent.getPropertyName())) {
                ClassPathListener classPathListener = this;
                synchronized (classPathListener) {
                    ClasspathInfo.this.fileManager = null;
                    ClasspathInfo.this.usagesQuery = null;
                }
                ClasspathInfo.this.fireChangeListenerStateChanged();
            }
        }
    }

    private static class ClasspathInfoAccessorImpl
    extends ClasspathInfoAccessor {
        private ClasspathInfoAccessorImpl() {
        }

        public JavaFileManager getFileManager(ClasspathInfo classpathInfo) {
            return classpathInfo.getFileManager();
        }

        public ClasspathInfo create(ClassPath classPath, ClassPath classPath2, ClassPath classPath3, JavaFileFilterImplementation javaFileFilterImplementation, boolean bl, boolean bl2) {
            return ClasspathInfo.create(classPath, classPath2, classPath3, javaFileFilterImplementation, bl, bl2);
        }

        public ClasspathInfo create(FileObject fileObject, JavaFileFilterImplementation javaFileFilterImplementation, boolean bl, boolean bl2) {
            return ClasspathInfo.create(fileObject, javaFileFilterImplementation, bl, bl2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PathKind {
        BOOT,
        COMPILE,
        SOURCE,
        OUTPUT;

    }
}

