/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.util.Trees;
import com.sun.tools.javac.api.JavacTaskImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.swing.text.Document;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.TypeUtilities;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.modules.java.preprocessorbridge.spi.JavaFileFilterImplementation;
import org.netbeans.modules.java.source.parsing.SourceFileObject;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompilationInfo {
    private JavaSource.Phase phase = JavaSource.Phase.MODIFIED;
    private CompilationUnitTree compilationUnit;
    private List<Diagnostic> errors;
    private JavacTaskImpl javacTask;
    private FileObject fo;
    final JavaFileObject jfo;
    final JavaSource javaSource;
    boolean needsRestart;
    private ElementUtilities elementUtilities;
    private TreeUtilities treeUtilities;
    private TypeUtilities typeUtilities;

    CompilationInfo() {
        this.javaSource = null;
        this.jfo = null;
        this.javacTask = null;
        this.errors = null;
    }

    CompilationInfo(JavaSource javaSource, FileObject fileObject, JavaFileFilterImplementation javaFileFilterImplementation, JavacTaskImpl javacTaskImpl) throws IOException {
        assert (javaSource != null);
        this.javaSource = javaSource;
        this.fo = fileObject;
        this.jfo = fileObject != null ? JavaSource.jfoProvider.createJavaFileObject(fileObject, javaFileFilterImplementation) : null;
        this.javacTask = javacTaskImpl;
        this.errors = new ArrayList<Diagnostic>();
    }

    public JavaSource.Phase getPhase() {
        return this.phase;
    }

    public CompilationUnitTree getCompilationUnit() {
        if (this.jfo == null) {
            throw new IllegalStateException();
        }
        return this.compilationUnit;
    }

    public String getText() {
        if (this.jfo == null) {
            throw new IllegalStateException();
        }
        try {
            return ((Object)this.jfo.getCharContent(false)).toString();
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
            return null;
        }
    }

    public TokenHierarchy getTokenHierarchy() {
        if (this.jfo == null) {
            throw new IllegalStateException();
        }
        try {
            return ((SourceFileObject)this.jfo).getTokenHierarchy();
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
            return null;
        }
    }

    public List<Diagnostic> getDiagnostics() {
        if (this.jfo == null) {
            throw new IllegalStateException();
        }
        ArrayList<Diagnostic> arrayList = new ArrayList<Diagnostic>(this.errors.size());
        for (Diagnostic diagnostic : this.errors) {
            if (this.jfo != diagnostic.getSource()) continue;
            arrayList.add(diagnostic);
        }
        return arrayList;
    }

    public Trees getTrees() {
        return Trees.instance(this.getJavacTask());
    }

    public Types getTypes() {
        return this.getJavacTask().getTypes();
    }

    public Elements getElements() {
        return this.getJavacTask().getElements();
    }

    public JavaSource getJavaSource() {
        return this.javaSource;
    }

    public ClasspathInfo getClasspathInfo() {
        return this.javaSource.getClasspathInfo();
    }

    public FileObject getFileObject() {
        return this.fo;
    }

    public Document getDocument() throws IOException {
        if (this.fo == null) {
            return null;
        }
        DataObject dataObject = DataObject.find((FileObject)this.fo);
        EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        if (editorCookie != null) {
            return editorCookie.getDocument();
        }
        return null;
    }

    public synchronized TreeUtilities getTreeUtilities() {
        if (this.treeUtilities == null) {
            this.treeUtilities = new TreeUtilities(this);
        }
        return this.treeUtilities;
    }

    public synchronized ElementUtilities getElementUtilities() {
        if (this.elementUtilities == null) {
            this.elementUtilities = new ElementUtilities(this);
        }
        return this.elementUtilities;
    }

    public synchronized TypeUtilities getTypeUtilities() {
        if (this.typeUtilities == null) {
            this.typeUtilities = new TypeUtilities(this);
        }
        return this.typeUtilities;
    }

    void setPhase(JavaSource.Phase phase) {
        assert (phase != null);
        this.phase = phase;
    }

    void setCompilationUnit(CompilationUnitTree compilationUnitTree) {
        assert (compilationUnitTree != null);
        this.compilationUnit = compilationUnitTree;
    }

    synchronized JavacTaskImpl getJavacTask() {
        if (this.javacTask == null) {
            this.javacTask = this.javaSource.createJavacTask(new DiagnosticListenerImpl(this.errors));
        }
        return this.javacTask;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DiagnosticListenerImpl
    implements DiagnosticListener {
        private final List<Diagnostic> errors;

        public DiagnosticListenerImpl(List<Diagnostic> list) {
            this.errors = list;
        }

        public void report(Diagnostic diagnostic) {
            this.errors.add(diagnostic);
        }
    }
}

