/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source;

import com.sun.javadoc.Doc;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Scope;
import com.sun.source.util.JavacTask;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.model.JavacElements;
import com.sun.tools.javac.model.JavacTypes;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javadoc.DocEnv;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.source.JavadocEnv;
import org.netbeans.modules.java.source.builder.ASTService;
import org.netbeans.modules.java.source.builder.ElementsService;
import org.netbeans.modules.java.source.engine.RootTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ElementUtilities {
    private Context ctx;
    private ElementsService delegate;

    ElementUtilities(CompilationInfo compilationInfo) {
        this(compilationInfo.getJavacTask());
    }

    public ElementUtilities(JavacTask javacTask) {
        this.ctx = ((JavacTaskImpl)javacTask).getContext();
        this.delegate = ElementsService.instance(this.ctx);
    }

    public TypeElement enclosingTypeElement(Element element) {
        return this.delegate.enclosingTypeElement(element);
    }

    public TypeElement outermostTypeElement(Element element) {
        return this.delegate.outermostTypeElement(element);
    }

    public PackageElement packageElement(Element element) {
        return this.delegate.packageElement(element);
    }

    public Element getImplementationOf(ExecutableElement executableElement, TypeElement typeElement) {
        return this.delegate.getImplementationOf(executableElement, typeElement);
    }

    public boolean isSynthetic(Element element) {
        return this.delegate.isSynthetic(element);
    }

    public boolean overridesMethod(ExecutableElement executableElement) {
        return this.delegate.overridesMethod(executableElement);
    }

    public static String getBinaryName(TypeElement typeElement) throws IllegalArgumentException {
        if (typeElement instanceof Symbol.TypeSymbol) {
            return ((Symbol.TypeSymbol)((Object)typeElement)).flatName().toString();
        }
        throw new IllegalArgumentException();
    }

    public Doc javaDocFor(Element element) {
        if (element != null) {
            DocEnv docEnv = DocEnv.instance((Context)this.ctx);
            switch (element.getKind()) {
                case ANNOTATION_TYPE: 
                case CLASS: 
                case ENUM: 
                case INTERFACE: {
                    return docEnv.getClassDoc((Symbol.ClassSymbol)element);
                }
                case ENUM_CONSTANT: 
                case FIELD: {
                    return docEnv.getFieldDoc((Symbol.VarSymbol)element);
                }
                case METHOD: {
                    if (element.getEnclosingElement().getKind() == ElementKind.ANNOTATION_TYPE) {
                        return docEnv.getAnnotationTypeElementDoc((Symbol.MethodSymbol)element);
                    }
                    return docEnv.getMethodDoc((Symbol.MethodSymbol)element);
                }
                case CONSTRUCTOR: {
                    return docEnv.getConstructorDoc((Symbol.MethodSymbol)element);
                }
                case PACKAGE: {
                    return docEnv.getPackageDoc((Symbol.PackageSymbol)element);
                }
            }
        }
        return null;
    }

    public Element elementFor(Doc doc) {
        return doc instanceof JavadocEnv.ElementHolder ? ((JavadocEnv.ElementHolder)doc).getElement() : null;
    }

    public Iterable<? extends Element> getMembers(TypeMirror typeMirror, ElementAcceptor elementAcceptor) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        if (typeMirror != null) {
            JavacElements javacElements = JavacElements.instance(this.ctx);
            switch (typeMirror.getKind()) {
                case DECLARED: {
                    for (Element object : javacElements.getAllMembers((TypeElement)((DeclaredType)typeMirror).asElement())) {
                        if (elementAcceptor != null && !elementAcceptor.accept(object, typeMirror)) continue;
                        arrayList.add(object);
                    }
                }
                case BOOLEAN: 
                case BYTE: 
                case CHAR: 
                case DOUBLE: 
                case FLOAT: 
                case INT: 
                case LONG: 
                case SHORT: 
                case VOID: {
                    Object object2 = Symtab.instance((Context)this.ctx).classType;
                    List<Type> list = Source.instance(this.ctx).allowGenerics() ? List.of((Type)typeMirror) : List.nil();
                    object2 = new Type.ClassType(((Type)object2).getEnclosingType(), list, ((Type)object2).tsym);
                    Symbol.VarSymbol varSymbol = new Symbol.VarSymbol(25L, Name.Table.instance((Context)this.ctx)._class, (Type)object2, ((Type)typeMirror).tsym);
                    if (elementAcceptor != null && !elementAcceptor.accept(varSymbol, typeMirror)) break;
                    arrayList.add(varSymbol);
                    break;
                }
                case ARRAY: {
                    for (Element element : javacElements.getAllMembers((TypeElement)((Object)((Type)typeMirror).tsym))) {
                        if (elementAcceptor != null && !elementAcceptor.accept(element, typeMirror)) continue;
                        arrayList.add(element);
                    }
                    break;
                }
            }
        }
        return arrayList;
    }

    public Iterable<? extends Element> getLocalMembersAndVars(Scope scope, ElementAcceptor elementAcceptor) {
        Object object2;
        ArrayList<Element> arrayList;
        TypeElement typeElement;
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        HashMap<Object, ArrayList<Object>> hashMap = new HashMap<Object, ArrayList<Object>>();
        JavacElements javacElements = JavacElements.instance(this.ctx);
        JavacTypes javacTypes = JavacTypes.instance(this.ctx);
        while (scope != null && (typeElement = scope.getEnclosingClass()) != null) {
            for (Element element : scope.getLocalElements()) {
                if (elementAcceptor != null && !elementAcceptor.accept(element, null) || this.isHidden(element, (Iterable<Element>)(arrayList = (ArrayList)hashMap.get(object2 = element.getSimpleName().toString())), javacElements, javacTypes)) continue;
                arrayList2.add(element);
                if (arrayList == null) {
                    arrayList = new ArrayList<Element>();
                    hashMap.put(object2, arrayList);
                }
                arrayList.add(element);
            }
            TypeMirror typeMirror = typeElement.asType();
            for (Object object2 : javacElements.getAllMembers(typeElement)) {
                ArrayList<Object> arrayList3;
                if (elementAcceptor != null && !elementAcceptor.accept((Element)object2, typeMirror) || this.isHidden((Element)object2, (Iterable<Element>)(arrayList3 = (ArrayList<Object>)hashMap.get(arrayList = object2.getSimpleName().toString())), javacElements, javacTypes)) continue;
                arrayList2.add(object2);
                if (arrayList3 == null) {
                    arrayList3 = new ArrayList<Object>();
                    hashMap.put(arrayList, arrayList3);
                }
                arrayList3.add(object2);
            }
            scope = scope.getEnclosingScope();
        }
        while (scope != null) {
            for (Element element : scope.getLocalElements()) {
                if (element.getKind().isClass() || element.getKind().isInterface() || elementAcceptor != null && !elementAcceptor.accept(element, element.getEnclosingElement().asType()) || this.isHidden(element, (Iterable<Element>)(arrayList = (ArrayList)hashMap.get(object2 = element.getSimpleName().toString())), javacElements, javacTypes)) continue;
                arrayList2.add(element);
                if (arrayList == null) {
                    arrayList = new ArrayList();
                    hashMap.put(object2, arrayList);
                }
                arrayList.add(element);
            }
            scope = scope.getEnclosingScope();
        }
        return arrayList2;
    }

    public Iterable<? extends Element> getLocalVars(Scope scope, ElementAcceptor elementAcceptor) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        HashMap<String, ArrayList<Element>> hashMap = new HashMap<String, ArrayList<Element>>();
        JavacElements javacElements = JavacElements.instance(this.ctx);
        JavacTypes javacTypes = JavacTypes.instance(this.ctx);
        while (scope != null && scope.getEnclosingClass() != null) {
            for (Element element : scope.getLocalElements()) {
                String string;
                ArrayList<Element> arrayList2;
                if (elementAcceptor != null && !elementAcceptor.accept(element, null) || this.isHidden(element, (Iterable<Element>)(arrayList2 = (ArrayList<Element>)hashMap.get(string = element.getSimpleName().toString())), javacElements, javacTypes)) continue;
                arrayList.add(element);
                if (arrayList2 == null) {
                    arrayList2 = new ArrayList<Element>();
                    hashMap.put(string, arrayList2);
                }
                arrayList2.add(element);
            }
            scope = scope.getEnclosingScope();
        }
        return arrayList;
    }

    public Iterable<? extends TypeElement> getGlobalTypes(ElementAcceptor elementAcceptor) {
        HashSet<TypeElement> hashSet = new HashSet<TypeElement>();
        JavacTrees javacTrees = JavacTrees.instance(this.ctx);
        RootTree rootTree = (RootTree)ASTService.instance(this.ctx).getRoot();
        for (CompilationUnitTree compilationUnitTree : rootTree.getCompilationUnits()) {
            Object object;
            TreePath treePath = new TreePath(compilationUnitTree);
            Element element = ((Trees)javacTrees).getElement(treePath);
            if (element != null && element.getKind() == ElementKind.PACKAGE) {
                object = element.getEnclosedElements().iterator();
                while (object.hasNext()) {
                    Element element2 = (Element)object.next();
                    if (elementAcceptor != null && !elementAcceptor.accept(element2, null)) continue;
                    hashSet.add((TypeElement)element2);
                }
            }
            for (object = ((Trees)javacTrees).getScope(treePath); object != null; object = object.getEnclosingScope()) {
                for (Element element3 : object.getLocalElements()) {
                    if (!element3.getKind().isClass() && !element3.getKind().isInterface() || elementAcceptor != null && !elementAcceptor.accept(element3, null)) continue;
                    hashSet.add((TypeElement)element3);
                }
            }
        }
        return hashSet;
    }

    private boolean isHidden(Element element, Iterable<Element> iterable, Elements elements, Types types) {
        if (iterable != null) {
            for (Element element2 : iterable) {
                if (element2 != element && (element2.getClass() != element.getClass() || element2.getSimpleName() != element.getSimpleName() || (element2.getKind() == ElementKind.METHOD || element2.getKind() == ElementKind.CONSTRUCTOR) && !types.isSubsignature((ExecutableType)element2.asType(), (ExecutableType)element.asType()))) continue;
                return true;
            }
        }
        return false;
    }

    public boolean referenced(Element element, Element element2) {
        return this.delegate.referenced(element, element2);
    }

    public boolean assigned(Element element, Element element2) {
        return this.delegate.assigned(element, element2);
    }

    public boolean parameter(Element element, Element element2) {
        return this.delegate.parameter(element, element2);
    }

    public boolean isLocal(Element element) {
        return this.delegate.isLocal(element);
    }

    public boolean alreadyDefinedIn(CharSequence charSequence, ExecutableType executableType, TypeElement typeElement) {
        return this.delegate.alreadyDefinedIn(charSequence, executableType, typeElement);
    }

    public boolean isMemberOf(Element element, TypeElement typeElement) {
        return this.delegate.isMemberOf(element, typeElement);
    }

    public CharSequence getFullName(Element element) {
        return this.delegate.getFullName(element);
    }

    public ExecutableElement getOverriddenMethod(ExecutableElement executableElement) {
        return this.delegate.getOverriddenMethod(executableElement);
    }

    public boolean implementsMethod(ExecutableElement executableElement) {
        return this.delegate.implementsMethod(executableElement);
    }

    public static interface ElementAcceptor {
        public boolean accept(Element var1, TypeMirror var2);
    }
}

