/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.comp.Enter;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Abort;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.CouplingAbort;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javadoc.JavadocEnter;
import com.sun.tools.javadoc.JavadocMemberEnter;
import com.sun.tools.javadoc.Messager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Stack;
import java.util.WeakHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.ToolProvider;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.java.source.query.QueryEnvironment;
import org.netbeans.api.timers.TimesCollector;
import org.netbeans.editor.Registry;
import org.netbeans.modules.java.preprocessorbridge.spi.JavaFileFilterImplementation;
import org.netbeans.modules.java.source.JavaFileFilterQuery;
import org.netbeans.modules.java.source.JavaSourceAccessor;
import org.netbeans.modules.java.source.JavadocEnv;
import org.netbeans.modules.java.source.builder.ASTService;
import org.netbeans.modules.java.source.builder.Scanner;
import org.netbeans.modules.java.source.builder.UndoListService;
import org.netbeans.modules.java.source.engine.ReattributionException;
import org.netbeans.modules.java.source.engine.RootTree;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.usages.ClassIndexImpl;
import org.netbeans.modules.java.source.usages.ClassIndexManager;
import org.netbeans.modules.java.source.usages.RepositoryUpdater;
import org.netbeans.modules.java.source.usages.SymbolClassReader;
import org.netbeans.modules.java.source.util.LowMemoryEvent;
import org.netbeans.modules.java.source.util.LowMemoryListener;
import org.netbeans.modules.java.source.util.LowMemoryNotifier;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JavaSource {
    private static final int INVALID = 1;
    private static final int CHANGE_EXPECTED = 2;
    private static final int RESCHEDULE_FINISHED_TASKS = 4;
    private static final int UPDATE_INDEX = 8;
    private static final boolean reportSlowTasks = Boolean.getBoolean("org.netbeans.api.java.source.JavaSource.reportSlowTasks");
    private static final int SLOW_TASK_LIMIT = 250;
    private static final int SLOW_CANCEL_LIMIT = 50;
    static int REPARSE_DELAY = 500;
    static JavaFileObjectProvider jfoProvider = new DefaultJavaFileObjectProvider();
    private static Map<Phase, String> phase2Key = new HashMap<Phase, String>();
    private static Map<Phase, String> phase2Message = new HashMap<Phase, String>();
    private static final PriorityBlockingQueue<Request> requests;
    private static final Map<JavaSource, Collection<Request>> finishedRequests;
    private static final Map<JavaSource, Collection<Request>> waitingRequests;
    private static final Collection<CancellableTask> toRemove;
    private static final SingleThreadFactory factory;
    private static final CurrentRequestReference currentRequest;
    private static final EditorRegistryListener editorRegistryListener;
    private static final ReentrantLock javacLock;
    private final Collection<FileObject> files;
    private final FileObject rootFo;
    private final FileChangeListener fileChangeListener;
    private DocListener listener;
    private DataObjectListener dataObjectListener;
    private final ClasspathInfo classpathInfo;
    private CompilationInfo currentInfo;
    private Stack<CompilationInfo> infoStack = new Stack();
    private int flags = 0;
    private FilterListener filterListener;
    private static Map<FileObject, Reference<JavaSource>> file2JavaSource;
    private static final RequestProcessor RP;
    private final RequestProcessor.Task resetTask = RP.create(new Runnable(){

        public void run() {
            JavaSource.this.resetStateImpl();
        }
    });
    private static final int MAX_DUMPS = 255;

    public static JavaSource create(ClasspathInfo classpathInfo, Collection<? extends FileObject> collection) throws IllegalArgumentException {
        if (collection == null || classpathInfo == null) {
            throw new IllegalArgumentException();
        }
        try {
            return new JavaSource(classpathInfo, collection);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            Logger.getLogger("global").warning("Ignoring non existent file: " + FileUtil.getFileDisplayName((FileObject)dataObjectNotFoundException.getFileObject()));
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return null;
    }

    public static JavaSource create(ClasspathInfo classpathInfo, FileObject ... fileObjectArray) throws IllegalArgumentException {
        if (fileObjectArray == null || classpathInfo == null) {
            throw new IllegalArgumentException();
        }
        return JavaSource.create(classpathInfo, Arrays.asList(fileObjectArray));
    }

    public static JavaSource forFileObject(FileObject fileObject) throws IllegalArgumentException {
        JavaSource javaSource;
        if (fileObject == null) {
            throw new IllegalArgumentException("fileObject == null");
        }
        if (!fileObject.isValid()) {
            return null;
        }
        if (!"text/x-java".equals(FileUtil.getMIMEType((FileObject)fileObject)) && !"java".equals(fileObject.getExt())) {
            return null;
        }
        Reference<JavaSource> reference = file2JavaSource.get(fileObject);
        JavaSource javaSource2 = javaSource = reference != null ? reference.get() : null;
        if (javaSource == null) {
            javaSource = JavaSource.create(ClasspathInfo.create(fileObject), fileObject);
            file2JavaSource.put(fileObject, new WeakReference<JavaSource>(javaSource));
        }
        return javaSource;
    }

    public static JavaSource forDocument(Document document) throws IllegalArgumentException {
        DataObject dataObject;
        JavaSource javaSource;
        if (document == null) {
            throw new IllegalArgumentException("doc == null");
        }
        Reference reference = (Reference)document.getProperty(JavaSource.class);
        JavaSource javaSource2 = javaSource = reference != null ? (JavaSource)reference.get() : null;
        if (javaSource == null && (dataObject = (DataObject)document.getProperty("stream")) != null) {
            javaSource = JavaSource.forFileObject(dataObject.getPrimaryFile());
        }
        return javaSource;
    }

    private JavaSource(ClasspathInfo classpathInfo, Collection<? extends FileObject> collection) throws IOException {
        this.files = Collections.unmodifiableList(new ArrayList<FileObject>(collection));
        this.fileChangeListener = new FileChangeListenerImpl();
        boolean bl = this.files.size() > 1;
        boolean bl2 = false;
        Iterator<FileObject> iterator = this.files.iterator();
        while (iterator.hasNext()) {
            FileObject fileObject = iterator.next();
            try {
                TimesCollector.getDefault().reportReference(fileObject, JavaSource.class.toString(), "[M] JavaSource", (Object)this);
                if (!bl) {
                    fileObject.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this.fileChangeListener, (Object)fileObject));
                    this.assignDocumentListener(fileObject);
                    this.dataObjectListener = new DataObjectListener(fileObject);
                }
                if (bl2) continue;
                bl2 = true;
                JavaFileFilterImplementation javaFileFilterImplementation = JavaFileFilterQuery.getFilter(fileObject);
                if (javaFileFilterImplementation == null) continue;
                this.filterListener = new FilterListener(javaFileFilterImplementation);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                if (bl) {
                    Logger.getLogger("global").warning("Ignoring non existent file: " + FileUtil.getFileDisplayName((FileObject)fileObject));
                    iterator.remove();
                    continue;
                }
                throw dataObjectNotFoundException;
            }
        }
        this.classpathInfo = classpathInfo;
        this.rootFo = this.files.size() == 1 ? this.classpathInfo.getClassPath(ClasspathInfo.PathKind.SOURCE).findOwnerRoot(this.files.iterator().next()) : null;
        this.classpathInfo.addChangeListener(WeakListeners.change((ChangeListener)this.listener, (Object)this.classpathInfo));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runUserActionTask(CancellableTask<CompilationController> cancellableTask, boolean bl) throws IOException {
        block45: {
            if (cancellableTask == null) {
                throw new IllegalArgumentException("Task cannot be null");
            }
            assert (!JavaSource.holdsDocumentWriteLock(this.files)) : "JavaSource.runCompileControlTask called under Document write lock.";
            if (this.files.size() <= 1) {
                CompilationInfo compilationInfo = null;
                Object object = this;
                synchronized (object) {
                    if (this.currentInfo != null && (this.flags & 1) == 0) {
                        compilationInfo = this.currentInfo;
                    }
                    if (!bl) {
                        this.flags |= 1;
                    }
                }
                if (compilationInfo == null) {
                    compilationInfo = JavaSource.createCurrentInfo(this, this.files.isEmpty() ? null : this.files.iterator().next(), this.filterListener, null);
                    if (bl) {
                        object = this;
                        synchronized (object) {
                            if (this.currentInfo == null || (this.flags & 1) != 0) {
                                this.currentInfo = compilationInfo;
                                this.flags &= 0xFFFFFFFE;
                            } else {
                                compilationInfo = this.currentInfo;
                            }
                        }
                    }
                }
                assert (compilationInfo != null);
                object = currentRequest.getTaskToCancel();
                try {
                    if (object != null) {
                        ((Request)object).task.cancel();
                    }
                    javacLock.lock();
                    try {
                        if (bl) {
                            if (!this.infoStack.isEmpty()) {
                                compilationInfo = this.infoStack.peek();
                            }
                        } else {
                            this.infoStack.push(compilationInfo);
                        }
                        try {
                            cancellableTask.run(new CompilationController(compilationInfo));
                            break block45;
                        }
                        finally {
                            if (!bl) {
                                this.infoStack.pop();
                            }
                        }
                    }
                    catch (Exception exception) {
                        IOException iOException = new IOException();
                        iOException.initCause(exception);
                        throw iOException;
                    }
                    finally {
                        javacLock.unlock();
                    }
                }
                finally {
                    currentRequest.cancelCompleted((Request)object);
                }
            }
            Request request = currentRequest.getTaskToCancel();
            try {
                if (request != null) {
                    request.task.cancel();
                }
                javacLock.lock();
                try {
                    JavacTaskImpl javacTaskImpl = null;
                    FileObject fileObject = null;
                    Iterator<FileObject> iterator = this.files.iterator();
                    while (iterator.hasNext() || fileObject != null) {
                        boolean bl2;
                        if (fileObject == null) {
                            fileObject = iterator.next();
                            bl2 = false;
                        } else {
                            bl2 = true;
                        }
                        CompilationInfo compilationInfo = JavaSource.createCurrentInfo(this, fileObject, this.filterListener, javacTaskImpl);
                        cancellableTask.run(new CompilationController(compilationInfo));
                        if (!compilationInfo.needsRestart) {
                            javacTaskImpl = compilationInfo.getJavacTask();
                            Log.instance((Context)javacTaskImpl.getContext()).nerrors = 0;
                            fileObject = null;
                            continue;
                        }
                        javacTaskImpl = null;
                        compilationInfo = null;
                        System.gc();
                        if (!bl2) continue;
                        throw new InsufficientMemoryException(fileObject);
                    }
                }
                catch (Exception exception) {
                    IOException iOException = new IOException();
                    iOException.initCause(exception);
                    throw iOException;
                }
                finally {
                    javacLock.unlock();
                }
            }
            finally {
                currentRequest.cancelCompleted(request);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModificationResult runModificationTask(CancellableTask<WorkingCopy> cancellableTask) throws IOException {
        if (cancellableTask == null) {
            throw new IllegalArgumentException("Task cannot be null");
        }
        assert (!JavaSource.holdsDocumentWriteLock(this.files)) : "JavaSource.runModificationTask called under Document write lock.";
        ModificationResult modificationResult = new ModificationResult(this);
        if (this.files.size() <= 1) {
            long l = System.currentTimeMillis();
            CompilationInfo compilationInfo = null;
            Object object = this;
            synchronized (object) {
                if (this.currentInfo != null && (this.flags & 1) == 0) {
                    compilationInfo = this.currentInfo;
                }
            }
            if (compilationInfo == null) {
                compilationInfo = JavaSource.createCurrentInfo(this, this.files.isEmpty() ? null : this.files.iterator().next(), this.filterListener, null);
                object = this;
                synchronized (object) {
                    if (this.currentInfo == null || (this.flags & 1) != 0) {
                        this.currentInfo = compilationInfo;
                        this.flags &= 0xFFFFFFFE;
                    } else {
                        compilationInfo = this.currentInfo;
                    }
                }
            }
            assert (compilationInfo != null);
            object = currentRequest.getTaskToCancel();
            try {
                if (object != null) {
                    ((Request)object).task.cancel();
                }
                javacLock.lock();
                try {
                    WorkingCopy workingCopy = new WorkingCopy(compilationInfo);
                    cancellableTask.run(workingCopy);
                    java.util.List<ModificationResult.Difference> list = workingCopy.getChanges();
                    if (list != null && list.size() > 0) {
                        modificationResult.diffs.put(compilationInfo.getFileObject(), list);
                    }
                }
                catch (Exception exception) {
                    IOException iOException = new IOException();
                    iOException.initCause(exception);
                    throw iOException;
                }
                finally {
                    javacLock.unlock();
                }
            }
            finally {
                currentRequest.cancelCompleted((Request)object);
            }
            TimesCollector.getDefault().reportTime(compilationInfo.getFileObject(), "java-source-modification-task", "Modification Task", System.currentTimeMillis() - l);
        } else {
            Request request = currentRequest.getTaskToCancel();
            try {
                if (request != null) {
                    request.task.cancel();
                }
                javacLock.lock();
                try {
                    JavacTaskImpl javacTaskImpl = null;
                    FileObject fileObject = null;
                    Iterator<FileObject> iterator = this.files.iterator();
                    while (iterator.hasNext() || fileObject != null) {
                        boolean bl;
                        if (fileObject == null) {
                            fileObject = iterator.next();
                            bl = false;
                        } else {
                            bl = true;
                        }
                        CompilationInfo compilationInfo = JavaSource.createCurrentInfo(this, fileObject, this.filterListener, javacTaskImpl);
                        WorkingCopy workingCopy = new WorkingCopy(compilationInfo);
                        cancellableTask.run(workingCopy);
                        if (!compilationInfo.needsRestart) {
                            javacTaskImpl = compilationInfo.getJavacTask();
                            Log.instance((Context)javacTaskImpl.getContext()).nerrors = 0;
                            java.util.List<ModificationResult.Difference> list = workingCopy.getChanges();
                            if (list != null && list.size() > 0) {
                                modificationResult.diffs.put(compilationInfo.getFileObject(), list);
                            }
                            fileObject = null;
                            continue;
                        }
                        javacTaskImpl = null;
                        compilationInfo = null;
                        System.gc();
                        if (!bl) continue;
                        throw new InsufficientMemoryException(fileObject);
                    }
                }
                catch (Exception exception) {
                    IOException iOException = new IOException();
                    iOException.initCause(exception);
                    throw iOException;
                }
                finally {
                    javacLock.unlock();
                }
            }
            finally {
                currentRequest.cancelCompleted(request);
            }
        }
        JavaSource javaSource = this;
        synchronized (javaSource) {
            this.flags |= 1;
        }
        return modificationResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addPhaseCompletionTask(CancellableTask<CompilationInfo> cancellableTask, Phase phase, Priority priority) throws IOException {
        CompilationInfo compilationInfo;
        if (cancellableTask == null) {
            throw new IllegalArgumentException("Task cannot be null");
        }
        if (phase == null || phase == Phase.MODIFIED) {
            throw new IllegalArgumentException(String.format("The %s is not a legal value of phase", new Object[]{phase}));
        }
        if (priority == null) {
            throw new IllegalArgumentException("The priority cannot be null");
        }
        JavaSource javaSource = this;
        synchronized (javaSource) {
            compilationInfo = this.currentInfo;
        }
        if (compilationInfo == null) {
            compilationInfo = JavaSource.createCurrentInfo(this, this.files.isEmpty() ? null : this.files.iterator().next(), this.filterListener, null);
        }
        javaSource = this;
        synchronized (javaSource) {
            if (this.currentInfo == null) {
                this.currentInfo = compilationInfo;
            }
        }
        JavaSource.handleAddRequest(new Request(cancellableTask, this, phase, priority, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removePhaseCompletionTask(CancellableTask<CompilationInfo> cancellableTask) {
        Class<JavaSource> clazz = JavaSource.class;
        synchronized (JavaSource.class) {
            toRemove.add(cancellableTask);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rescheduleTask(CancellableTask<CompilationInfo> cancellableTask) {
        Class<JavaSource> clazz = JavaSource.class;
        synchronized (JavaSource.class) {
            block8: {
                Request request = currentRequest.getTaskToCancel(cancellableTask);
                if (request == null) {
                    Iterator<Collection<Request>> iterator = finishedRequests.values().iterator();
                    while (iterator.hasNext()) {
                        Collection<Request> collection = iterator.next();
                        Iterator<Request> iterator2 = collection.iterator();
                        while (iterator2.hasNext()) {
                            Request request2 = iterator2.next();
                            if (cancellableTask != request2.task) continue;
                            iterator2.remove();
                            requests.add(request2);
                            if (collection.size() == 0) {
                                iterator.remove();
                            }
                            break block8;
                        }
                    }
                } else {
                    currentRequest.cancelCompleted(request);
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    void revalidate() {
        this.resetState(true, false);
    }

    public ClasspathInfo getClasspathInfo() {
        return this.classpathInfo;
    }

    public Collection<FileObject> getFileObjects() {
        return this.files;
    }

    JavacTaskImpl createJavacTask(DiagnosticListener<? super JavaFileObject> diagnosticListener) {
        String string = null;
        if (!this.files.isEmpty()) {
            string = SourceLevelQuery.getSourceLevel((FileObject)this.files.iterator().next());
        }
        if (string == null) {
            string = JavaPlatformManager.getDefault().getDefaultPlatform().getSpecification().getVersion().toString();
        }
        JavacTaskImpl javacTaskImpl = JavaSource.createJavacTask(this.getClasspathInfo(), diagnosticListener, string, false);
        Context context = javacTaskImpl.getContext();
        Messager.preRegister((Context)context, null);
        ErrorHandlingJavadocEnter.preRegister(context);
        JavadocMemberEnter.preRegister((Context)context);
        JavadocEnv.preRegister(context, this.getClasspathInfo());
        Scanner.Factory.instance(context);
        com.sun.tools.javac.main.JavaCompiler.instance((Context)context).keepComments = true;
        return javacTaskImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JavacTaskImpl createJavacTask(ClasspathInfo classpathInfo, DiagnosticListener<? super JavaFileObject> diagnosticListener, String string, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!bl) {
            if (Boolean.getBoolean("org.netbeans.api.java.source.JavaSource.USE_COMPILER_LINT")) {
                arrayList.add("-Xlint");
                arrayList.add("-Xlint:-serial");
            }
            arrayList.add("-Xjcov");
        } else {
            arrayList.add("-XDbackgroundCompilation");
            arrayList.add("-XDcompilePolicy=byfile");
        }
        arrayList.add("-g:");
        arrayList.add("-g:lines");
        arrayList.add("-g:vars");
        arrayList.add("-source");
        arrayList.add(JavaSource.validateSourceLevel(string));
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(ClasspathInfo.class.getClassLoader());
            JavaCompiler javaCompiler = ToolProvider.getSystemJavaCompiler();
            JavacTaskImpl javacTaskImpl = (JavacTaskImpl)javaCompiler.getTask(null, classpathInfo.getFileManager(), diagnosticListener, arrayList, null, Collections.emptySet());
            Context context = javacTaskImpl.getContext();
            if (bl) {
                SymbolClassReader.preRegister(context, false);
            } else {
                SymbolClassReader.preRegister(context, true);
            }
            JavacTaskImpl javacTaskImpl2 = javacTaskImpl;
            return javacTaskImpl2;
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    static Phase moveToPhase(Phase phase, CompilationInfo compilationInfo, boolean bl) throws IOException {
        Phase phase2 = compilationInfo.getPhase();
        boolean bl2 = compilationInfo.getJavaSource().files.size() > 1;
        LowMemoryNotifier lowMemoryNotifier = null;
        LMListener lMListener = null;
        if (bl2) {
            lowMemoryNotifier = LowMemoryNotifier.getDefault();
            assert (lowMemoryNotifier != null);
            lMListener = new LMListener();
            lowMemoryNotifier.addLowMemoryListener(lMListener);
        }
        try {
            long l;
            if (lMListener != null && lMListener.lowMemory.getAndSet(false)) {
                compilationInfo.needsRestart = true;
                Phase phase3 = phase2;
                return phase3;
            }
            if (phase2.compareTo(Phase.PARSED) < 0 && phase.compareTo(Phase.PARSED) >= 0) {
                if (bl && currentRequest.isCanceled()) {
                    Phase phase4 = Phase.MODIFIED;
                    return phase4;
                }
                l = System.currentTimeMillis();
                Iterable iterable = compilationInfo.getJavacTask().parse(new JavaFileObject[]{compilationInfo.jfo});
                assert (iterable != null) : "Did not parse anything";
                Iterator iterator = iterable.iterator();
                assert (iterator.hasNext());
                CompilationUnitTree compilationUnitTree = (CompilationUnitTree)iterator.next();
                compilationInfo.setCompilationUnit(compilationUnitTree);
                JCTree.JCCompilationUnit jCCompilationUnit = (JCTree.JCCompilationUnit)compilationUnitTree;
                ASTService aSTService = ASTService.instance(compilationInfo.getJavacTask().getContext());
                if (jCCompilationUnit.endPositions != null) {
                    aSTService.setEndPosTable(jCCompilationUnit.sourcefile, (Map<JCTree, Integer>)((Object)jCCompilationUnit.endPositions));
                }
                ArrayList<CompilationUnitTree> arrayList = new ArrayList<CompilationUnitTree>();
                arrayList.add(jCCompilationUnit);
                aSTService.setRoot(new RootTree(arrayList));
                UndoListService undoListService = UndoListService.instance(compilationInfo.getJavacTask().getContext());
                if (undoListService != null) {
                    undoListService.reset();
                }
                assert (!iterator.hasNext());
                phase2 = Phase.PARSED;
                long l2 = System.currentTimeMillis();
                FileObject fileObject = compilationInfo.getFileObject();
                TimesCollector.getDefault().reportReference(fileObject, "compilationUnit", "[M] Compilation Unit", (Object)compilationUnitTree);
                JavaSource.logTime(fileObject, phase2, l2 - l);
            }
            if (lMListener != null && lMListener.lowMemory.getAndSet(false)) {
                compilationInfo.needsRestart = true;
                Phase phase5 = phase2;
                return phase5;
            }
            if (phase2 == Phase.PARSED && phase.compareTo(Phase.ELEMENTS_RESOLVED) >= 0) {
                if (bl && currentRequest.isCanceled()) {
                    Phase phase6 = Phase.MODIFIED;
                    return phase6;
                }
                l = System.currentTimeMillis();
                compilationInfo.getJavacTask().enter();
                phase2 = Phase.ELEMENTS_RESOLVED;
                long l3 = System.currentTimeMillis();
                JavaSource.logTime(compilationInfo.getFileObject(), phase2, l3 - l);
            }
            if (lMListener != null && lMListener.lowMemory.getAndSet(false)) {
                compilationInfo.needsRestart = true;
                Phase phase7 = phase2;
                return phase7;
            }
            if (phase2 == Phase.ELEMENTS_RESOLVED && phase.compareTo(Phase.RESOLVED) >= 0) {
                if (bl && currentRequest.isCanceled()) {
                    Phase phase8 = Phase.MODIFIED;
                    return phase8;
                }
                l = System.currentTimeMillis();
                compilationInfo.getJavacTask().analyze();
                phase2 = Phase.RESOLVED;
                long l4 = System.currentTimeMillis();
                JavaSource.logTime(compilationInfo.getFileObject(), phase2, l4 - l);
            }
            if (lMListener != null && lMListener.lowMemory.getAndSet(false)) {
                compilationInfo.needsRestart = true;
                Phase phase9 = phase2;
                return phase9;
            }
            if (phase2 == Phase.RESOLVED && phase.compareTo(Phase.UP_TO_DATE) >= 0) {
                phase2 = Phase.UP_TO_DATE;
            }
        }
        catch (CouplingAbort couplingAbort) {
            RepositoryUpdater.couplingAbort(couplingAbort, compilationInfo.jfo);
            compilationInfo.needsRestart = true;
            Phase phase10 = phase2;
            return phase10;
        }
        catch (Abort abort) {
            phase2 = Phase.UP_TO_DATE;
        }
        catch (IOException iOException) {
            JavaSource.dumpSource(compilationInfo, iOException);
            throw iOException;
        }
        catch (ReattributionException reattributionException) {
            JavaSource.dumpSource(compilationInfo, reattributionException);
            throw new RuntimeException(reattributionException);
        }
        catch (RuntimeException runtimeException) {
            JavaSource.dumpSource(compilationInfo, runtimeException);
            throw runtimeException;
        }
        catch (Error error) {
            JavaSource.dumpSource(compilationInfo, error);
            throw error;
        }
        finally {
            if (bl2) {
                assert (lowMemoryNotifier != null);
                assert (lMListener != null);
                lowMemoryNotifier.removeLowMemoryListener(lMListener);
            }
            compilationInfo.setPhase(phase2);
        }
        return phase2;
    }

    static void logTime(FileObject fileObject, Phase phase, long l) {
        assert (fileObject != null && phase != null);
        String string = phase2Key.get((Object)phase);
        String string2 = phase2Message.get((Object)phase);
        assert (string != null && string2 != null);
        TimesCollector.getDefault().reportTime(fileObject, string, string2, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetState(boolean bl, boolean bl2) {
        boolean bl3;
        Object object = this;
        synchronized (object) {
            bl3 = (this.flags & 1) != 0;
            this.flags |= 2;
            if (bl) {
                this.flags |= 5;
            }
            if (bl2) {
                this.flags |= 8;
            }
        }
        if (bl2 && !bl3) {
            this.updateIndex();
        }
        object = currentRequest.getTaskToCancel(this);
        try {
            if (object != null) {
                ((Request)object).task.cancel();
            }
        }
        finally {
            currentRequest.cancelCompleted((Request)object);
        }
        this.resetTask.schedule(REPARSE_DELAY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetStateImpl() {
        Class<JavaSource> clazz = JavaSource.class;
        synchronized (JavaSource.class) {
            boolean bl;
            boolean bl2;
            Collection<Request> collection = this;
            synchronized (collection) {
                bl2 = (this.flags & 4) != 0;
                bl = (this.flags & 8) != 0;
                this.flags &= 0xFFFFFFF1;
            }
            if (bl) {
                this.updateIndex();
            }
            if (bl2 && (collection = finishedRequests.remove(this)) != null && collection.size() > 0) {
                requests.addAll(collection);
            }
            if ((collection = waitingRequests.remove(this)) != null && collection.size() > 0) {
                requests.addAll(collection);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void updateIndex() {
        if (this.rootFo != null) {
            try {
                ClassIndexImpl classIndexImpl = ClassIndexManager.getDefault().getUsagesQuery(this.rootFo.getURL());
                if (classIndexImpl != null) {
                    classIndexImpl.setDirty(this);
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    private void assignDocumentListener(FileObject fileObject) throws IOException {
        DataObject dataObject = DataObject.find((FileObject)fileObject);
        EditorCookie.Observable observable = (EditorCookie.Observable)dataObject.getCookie(EditorCookie.Observable.class);
        if (observable != null) {
            this.listener = new DocListener(observable);
        } else {
            Logger.getLogger("global").log(Level.WARNING, String.format("File: %s has no EditorCookie.Observable", FileUtil.getFileDisplayName((FileObject)fileObject)));
        }
    }

    private static CompilationInfo createCurrentInfo(JavaSource javaSource, FileObject fileObject, FilterListener filterListener, JavacTaskImpl javacTaskImpl) throws IOException {
        CompilationInfo compilationInfo = new CompilationInfo(javaSource, fileObject, filterListener == null ? null : filterListener.filter, javacTaskImpl);
        TimesCollector.getDefault().reportReference(fileObject, CompilationInfo.class.toString(), "[M] CompilationInfo", (Object)compilationInfo);
        return compilationInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleAddRequest(Request request) {
        assert (request != null);
        requests.add(request);
        Request request2 = currentRequest.getTaskToCancel(request.priority);
        try {
            if (request2 != null) {
                request2.task.cancel();
            }
        }
        finally {
            currentRequest.cancelCompleted(request2);
        }
    }

    private static boolean holdsDocumentWriteLock(Iterable<FileObject> iterable) {
        Class<AbstractDocument> clazz = AbstractDocument.class;
        try {
            Method method = clazz.getDeclaredMethod("getCurrentWriter", new Class[0]);
            method.setAccessible(true);
            Thread thread = Thread.currentThread();
            for (FileObject fileObject : iterable) {
                try {
                    Object object;
                    StyledDocument styledDocument;
                    DataObject dataObject = DataObject.find((FileObject)fileObject);
                    EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
                    if (editorCookie == null || !((styledDocument = editorCookie.getDocument()) instanceof AbstractDocument) || (object = method.invoke((Object)styledDocument, new Object[0])) != thread) continue;
                    return true;
                }
                catch (Exception exception) {
                    Exceptions.printStackTrace((Throwable)exception);
                }
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Exceptions.printStackTrace((Throwable)noSuchMethodException);
        }
        return false;
    }

    private static String validateSourceLevel(String string) {
        SpecificationVersion specificationVersion = Source.values();
        if (string == null) {
            return specificationVersion[((Source[])specificationVersion).length - 1].name;
        }
        for (Source source : specificationVersion) {
            if (!source.name.equals(string)) continue;
            return string;
        }
        SpecificationVersion specificationVersion2 = new SpecificationVersion("1.2");
        SpecificationVersion specificationVersion3 = new SpecificationVersion(string);
        if (specificationVersion2.compareTo((Object)specificationVersion3) > 0) {
            return specificationVersion[0].name;
        }
        return specificationVersion[((SpecificationVersion)specificationVersion).length - 1].name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dumpSource(CompilationInfo compilationInfo, Throwable throwable) {
        Object object;
        String string = System.getProperty("netbeans.user") + "/var/log/";
        String string2 = compilationInfo.getText();
        FileObject fileObject = compilationInfo.getFileObject();
        String string3 = FileUtil.getFileDisplayName((FileObject)compilationInfo.getFileObject());
        String string4 = fileObject.getName();
        File file = new File(string + string4 + ".dump");
        boolean bl = false;
        for (int i = 1; i < 255 && file.exists(); ++i) {
            file = new File(string + string4 + '_' + i + ".dump");
        }
        if (!file.exists()) {
            try {
                object = new FileOutputStream(file);
                PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)object, "UTF-8"));
                try {
                    printWriter.println(string2);
                    printWriter.println("----- Classpath: ---------------------------------------------");
                    ClassPath classPath = compilationInfo.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.BOOT);
                    ClassPath classPath2 = compilationInfo.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.COMPILE);
                    ClassPath classPath3 = compilationInfo.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.SOURCE);
                    printWriter.println("bootPath: " + (classPath != null ? classPath.toString() : "null"));
                    printWriter.println("classPath: " + (classPath2 != null ? classPath2.toString() : "null"));
                    printWriter.println("sourcePath: " + (classPath3 != null ? classPath3.toString() : "null"));
                    printWriter.println("----- Original exception ---------------------------------------------");
                    throwable.printStackTrace(printWriter);
                }
                finally {
                    printWriter.close();
                    bl = true;
                }
            }
            catch (IOException iOException) {
                Logger.getLogger("global").log(Level.INFO, "Error when writing parser dump file!", iOException);
            }
        }
        if (bl) {
            object = Exceptions.attachMessage((Throwable)throwable, (String)("An error occurred during parsing of '" + string3 + "'. Please report a bug against java/source and attach dump file '" + file.getAbsolutePath() + "'."));
            Exceptions.printStackTrace((Throwable)object);
        } else {
            Logger.getLogger("global").log(Level.WARNING, "Dump could not be written. Either dump file could not be created or all dump files were already used. Please check that you have write permission to '" + string + "' and " + "clean all *.dump files in that directory.");
        }
    }

    static {
        JavaSourceAccessor.INSTANCE = new JavaSourceAccessorImpl();
        phase2Key.put(Phase.PARSED, "parsed");
        phase2Message.put(Phase.PARSED, "Parsed");
        phase2Key.put(Phase.ELEMENTS_RESOLVED, "sig-attributed");
        phase2Message.put(Phase.ELEMENTS_RESOLVED, "Signatures Attributed");
        phase2Key.put(Phase.RESOLVED, "attributed");
        phase2Message.put(Phase.RESOLVED, "Attributed");
        requests = new PriorityBlockingQueue<Request>(10, new RequestComparator());
        finishedRequests = new WeakHashMap<JavaSource, Collection<Request>>();
        waitingRequests = new WeakHashMap<JavaSource, Collection<Request>>();
        toRemove = new LinkedList<CancellableTask>();
        factory = new SingleThreadFactory();
        currentRequest = new CurrentRequestReference();
        editorRegistryListener = new EditorRegistryListener();
        javacLock = new ReentrantLock(true);
        Executors.newSingleThreadExecutor(factory).submit(new CompilationJob());
        file2JavaSource = new WeakHashMap<FileObject, Reference<JavaSource>>();
        RP = new RequestProcessor("JavaSource-event-collector", 1);
    }

    private static class CompilationJob
    implements Runnable {
        private CompilationJob() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            try {
                while (true) {
                    try {}
                    catch (Throwable throwable) {
                        if (throwable instanceof InterruptedException) {
                            throw (InterruptedException)throwable;
                        }
                        if (throwable instanceof ThreadDeath) {
                            throw (ThreadDeath)throwable;
                        }
                        Exceptions.printStackTrace((Throwable)throwable);
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
                return;
            }
            while (true) {
                Collection<Object> collection;
                boolean bl;
                Object object;
                Object object2;
                Object object3;
                Object object4;
                block61: {
                    object4 = JavaSource.class;
                    // MONITORENTER : org.netbeans.api.java.source.JavaSource.class
                    if (!toRemove.isEmpty()) {
                        object3 = finishedRequests.values().iterator();
                        while (object3.hasNext()) {
                            Collection collection2 = (Collection)object3.next();
                            object2 = collection2.iterator();
                            while (object2.hasNext()) {
                                object = (Request)object2.next();
                                if (!toRemove.remove(((Request)object).task)) continue;
                                object2.remove();
                            }
                            if (collection2.size() != 0) continue;
                            object3.remove();
                        }
                    }
                    // MONITOREXIT : object4
                    object4 = (Request)requests.poll(2L, TimeUnit.SECONDS);
                    if (object4 == null) continue;
                    currentRequest.setCurrentTask((Request)object4);
                    object3 = ((Request)object4).javaSource;
                    if (object3 == null) {
                        assert (((Request)object4).phase == null);
                        assert (!((Request)object4).reschedule);
                        javacLock.lock();
                        try {
                            ((Request)object4).task.run(null);
                            continue;
                        }
                        catch (RuntimeException runtimeException) {
                            Exceptions.printStackTrace((Throwable)runtimeException);
                            continue;
                        }
                        finally {
                            javacLock.unlock();
                        }
                    }
                    assert (((JavaSource)object3).files.size() <= 1);
                    object = JavaSource.class;
                    // MONITORENTER : org.netbeans.api.java.source.JavaSource.class
                    if (!toRemove.remove(((Request)object4).task)) break block61;
                    // MONITOREXIT : object
                    currentRequest.setCurrentTask(null);
                    continue;
                }
                Object object5 = object3;
                // MONITORENTER : object5
                boolean bl2 = bl = (((JavaSource)object3).flags & 2) != 0;
                if (bl) {
                    collection = (LinkedList<Object>)waitingRequests.get(((Request)object4).javaSource);
                    if (collection == null) {
                        collection = new LinkedList<Object>();
                        waitingRequests.put(((Request)object4).javaSource, collection);
                    }
                    collection.add(object4);
                    // MONITOREXIT : object5
                    // MONITOREXIT : object
                    currentRequest.setCurrentTask(null);
                    continue;
                }
                try {
                    boolean bl3 = (((JavaSource)object3).flags & 1) != 0;
                    object2 = ((JavaSource)object3).currentInfo;
                    // MONITOREXIT : object5
                    // MONITOREXIT : object
                    try {
                        boolean bl4;
                        block62: {
                            if (bl3) {
                                object2 = JavaSource.createCurrentInfo((JavaSource)object3, ((JavaSource)object3).files.isEmpty() ? null : (FileObject)((JavaSource)object3).files.iterator().next(), ((JavaSource)object3).filterListener, null);
                                object = object3;
                                // MONITORENTER : object
                                if ((((JavaSource)object3).flags & 1) != 0) {
                                    ((JavaSource)object3).currentInfo = (CompilationInfo)object2;
                                    ((JavaSource)object3).flags &= -2;
                                } else {
                                    object2 = ((JavaSource)object3).currentInfo;
                                }
                                // MONITOREXIT : object
                            }
                            assert (object2 != null);
                            javacLock.lock();
                            try {
                                object = JavaSource.moveToPhase(((Request)object4).phase, (CompilationInfo)object2, true);
                                boolean bl5 = bl4 = ((Enum)object).compareTo(((Request)object4).phase) >= 0;
                                if (!bl4) break block62;
                                Object object6 = object3;
                                // MONITORENTER : object6
                                boolean bl6 = (((JavaSource)object3).flags & 1) == 0;
                                // MONITOREXIT : object6
                                if (!(bl4 &= bl6)) break block62;
                                try {
                                    long l = System.currentTimeMillis();
                                    ((Request)object4).task.run(object2);
                                    long l2 = System.currentTimeMillis();
                                    if (reportSlowTasks) {
                                        long l3;
                                        if (l2 - l > 250L) {
                                            Logger.getLogger("global").log(Level.INFO, String.format("JavaSource executed a slow task: %s in %d ms.", ((Request)object4).task.getClass().toString(), l2 - l));
                                        }
                                        if ((l3 = currentRequest.getCancelTime()) >= l && l2 - l3 > 50L) {
                                            Logger.getLogger("global").log(Level.INFO, String.format("Task: %s ignored cancel for %d ms.", ((Request)object4).task.getClass().toString(), l2 - l3));
                                        }
                                    }
                                }
                                catch (Exception exception) {
                                    Exceptions.printStackTrace((Throwable)exception);
                                }
                            }
                            finally {
                                javacLock.unlock();
                            }
                        }
                        if (!((Request)object4).reschedule) continue;
                        object = JavaSource.class;
                        // MONITORENTER : org.netbeans.api.java.source.JavaSource.class
                        bl4 = currentRequest.setCurrentTask(null);
                        Object object7 = object3;
                        // MONITORENTER : object7
                        if ((((JavaSource)object3).flags & 1) != 0 || bl4) {
                            requests.add(object4);
                        } else {
                            collection = (Collection)finishedRequests.get(((Request)object4).javaSource);
                            if (collection == null) {
                                collection = new LinkedList();
                                finishedRequests.put(((Request)object4).javaSource, collection);
                            }
                            collection.add(object4);
                        }
                        // MONITOREXIT : object7
                        // MONITOREXIT : object
                    }
                    catch (FileObjects.InvalidFileException invalidFileException) {
                        // empty catch block
                    }
                    continue;
                }
                finally {
                    currentRequest.setCurrentTask(null);
                    continue;
                }
                break;
            }
        }
    }

    private static class CurrentRequestReference {
        private Request reference;
        private Request canceledReference;
        private long cancelTime;
        private boolean canceled;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean setCurrentTask(Request request) throws InterruptedException {
            boolean bl = false;
            CurrentRequestReference currentRequestReference = this;
            synchronized (currentRequestReference) {
                while (this.canceledReference != null) {
                    this.wait();
                }
                bl = this.canceled;
                this.canceled = false;
                this.cancelTime = 0L;
                this.reference = request;
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Request getTaskToCancel(Priority priority) {
            Request request = null;
            if (!factory.isDispatchThread(Thread.currentThread())) {
                CurrentRequestReference currentRequestReference = this;
                synchronized (currentRequestReference) {
                    if (this.reference != null && priority.compareTo(this.reference.priority) < 0) {
                        assert (this.canceledReference == null);
                        this.canceledReference = request = this.reference;
                        this.reference = null;
                        this.canceled = true;
                        if (reportSlowTasks) {
                            this.cancelTime = System.currentTimeMillis();
                        }
                    }
                }
            }
            return request;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Request getTaskToCancel(JavaSource javaSource) {
            Request request = null;
            if (!factory.isDispatchThread(Thread.currentThread())) {
                CurrentRequestReference currentRequestReference = this;
                synchronized (currentRequestReference) {
                    if (this.reference != null && javaSource.equals(this.reference.javaSource)) {
                        assert (this.canceledReference == null);
                        this.canceledReference = request = this.reference;
                        this.reference = null;
                        this.canceled = true;
                        if (reportSlowTasks) {
                            this.cancelTime = System.currentTimeMillis();
                        }
                    }
                }
            }
            return request;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Request getTaskToCancel(CancellableTask cancellableTask) {
            Request request = null;
            if (!factory.isDispatchThread(Thread.currentThread())) {
                CurrentRequestReference currentRequestReference = this;
                synchronized (currentRequestReference) {
                    if (this.reference != null && cancellableTask == this.reference.task) {
                        assert (this.canceledReference == null);
                        this.canceledReference = request = this.reference;
                        this.reference = null;
                        this.canceled = true;
                    }
                }
            }
            return request;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Request getTaskToCancel() {
            Request request = null;
            if (!factory.isDispatchThread(Thread.currentThread())) {
                CurrentRequestReference currentRequestReference = this;
                synchronized (currentRequestReference) {
                    request = this.reference;
                    if (request != null) {
                        assert (this.canceledReference == null);
                        this.canceledReference = request;
                        this.reference = null;
                        this.canceled = true;
                        if (reportSlowTasks) {
                            this.cancelTime = System.currentTimeMillis();
                        }
                    }
                }
            }
            return request;
        }

        public synchronized boolean isCanceled() {
            return this.canceled;
        }

        public synchronized long getCancelTime() {
            return this.cancelTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancelCompleted(Request request) {
            if (request != null) {
                CurrentRequestReference currentRequestReference = this;
                synchronized (currentRequestReference) {
                    assert (request == this.canceledReference);
                    this.canceledReference = null;
                    this.notify();
                }
            }
        }
    }

    private final class DataObjectListener
    implements PropertyChangeListener {
        private DataObject dobj;
        private final FileObject fobj;
        private PropertyChangeListener wlistener;

        public DataObjectListener(FileObject fileObject) throws DataObjectNotFoundException {
            this.fobj = fileObject;
            this.dobj = DataObject.find((FileObject)fileObject);
            this.wlistener = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.dobj);
            this.dobj.addPropertyChangeListener(this.wlistener);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            DataObject dataObject = (DataObject)propertyChangeEvent.getSource();
            if (dataObject != this.dobj) {
                return;
            }
            if ("valid".equals(propertyChangeEvent.getPropertyName())) {
                this.handleInvalidDataObject(dataObject);
            } else if (propertyChangeEvent.getPropertyName() == null && !this.dobj.isValid()) {
                this.handleInvalidDataObject(dataObject);
            }
        }

        private void handleInvalidDataObject(final DataObject dataObject) {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    DataObjectListener.this.handleInvalidDataObjectImpl(dataObject);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleInvalidDataObjectImpl(DataObject dataObject) {
            dataObject.removePropertyChangeListener(this.wlistener);
            if (this.fobj.isValid()) {
                try {
                    DataObject dataObject2 = DataObject.find((FileObject)this.fobj);
                    DataObjectListener dataObjectListener = this;
                    synchronized (dataObjectListener) {
                        if (dataObject2 == this.dobj) {
                            return;
                        }
                        this.dobj = dataObject2;
                        this.dobj.addPropertyChangeListener(this.wlistener);
                    }
                    JavaSource.this.assignDocumentListener(this.fobj);
                    JavaSource.this.resetState(true, true);
                }
                catch (IOException iOException) {
                    Logger.getLogger(JavaSource.class.getName()).log(Level.SEVERE, iOException.getMessage(), iOException);
                }
            }
        }
    }

    static final class DefaultJavaFileObjectProvider
    implements JavaFileObjectProvider {
        DefaultJavaFileObjectProvider() {
        }

        public JavaFileObject createJavaFileObject(FileObject fileObject, JavaFileFilterImplementation javaFileFilterImplementation) throws IOException {
            return FileObjects.nbFileObject(fileObject, javaFileFilterImplementation, true);
        }
    }

    private class DocListener
    implements DocumentListener,
    PropertyChangeListener,
    ChangeListener {
        private EditorCookie.Observable ec;
        private DocumentListener docListener;

        public DocListener(EditorCookie.Observable observable) {
            assert (observable != null);
            this.ec = observable;
            this.ec.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.ec));
            StyledDocument styledDocument = observable.getDocument();
            if (styledDocument != null) {
                this.docListener = (DocumentListener)WeakListeners.create(DocumentListener.class, (EventListener)this, (Object)styledDocument);
                styledDocument.addDocumentListener(this.docListener);
            }
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            JavaSource.this.resetState(true, true);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            JavaSource.this.resetState(true, true);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("document".equals(propertyChangeEvent.getPropertyName())) {
                StyledDocument styledDocument;
                Object object = propertyChangeEvent.getOldValue();
                if (object instanceof Document && this.docListener != null) {
                    ((Document)object).removeDocumentListener(this.docListener);
                    this.docListener = null;
                }
                if ((styledDocument = this.ec.getDocument()) != null) {
                    this.docListener = (DocumentListener)WeakListeners.create(DocumentListener.class, (EventListener)this, (Object)styledDocument);
                    styledDocument.addDocumentListener(this.docListener);
                }
            }
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JavaSource.this.resetState(true, false);
        }
    }

    private static class EditorRegistryListener
    implements ChangeListener,
    CaretListener {
        private JTextComponent lastEditor;

        public EditorRegistryListener() {
            Registry.addChangeListener((ChangeListener)this);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JTextComponent jTextComponent = Registry.getMostActiveComponent();
            if (this.lastEditor != jTextComponent) {
                if (this.lastEditor != null) {
                    this.lastEditor.removeCaretListener(this);
                }
                this.lastEditor = jTextComponent;
                if (this.lastEditor != null) {
                    this.lastEditor.addCaretListener(this);
                }
            }
        }

        public void caretUpdate(CaretEvent caretEvent) {
            JavaSource javaSource;
            Document document;
            if (this.lastEditor != null && (document = this.lastEditor.getDocument()) != null && (javaSource = JavaSource.forDocument(document)) != null) {
                javaSource.resetState(false, false);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ErrorHandlingJavadocEnter
    extends JavadocEnter {
        private Messager messager;

        public static void preRegister(final Context context) {
            context.put(enterKey, new Context.Factory<Enter>(){

                public Enter make() {
                    return new ErrorHandlingJavadocEnter(context);
                }
            });
        }

        protected ErrorHandlingJavadocEnter(Context context) {
            super(context);
            this.messager = Messager.instance0((Context)context);
        }

        public void main(List<JCTree.JCCompilationUnit> list) {
            this.complete(list, null);
        }
    }

    private class FileChangeListenerImpl
    extends FileChangeAdapter {
        private FileChangeListenerImpl() {
        }

        public void fileChanged(FileEvent fileEvent) {
            JavaSource.this.resetState(true, false);
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            JavaSource.this.resetState(true, false);
        }
    }

    private final class FilterListener
    implements ChangeListener {
        private final JavaFileFilterImplementation filter;

        public FilterListener(JavaFileFilterImplementation javaFileFilterImplementation) {
            this.filter = javaFileFilterImplementation;
            this.filter.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)this.filter));
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JavaSource.this.resetState(true, false);
        }
    }

    public static final class InsufficientMemoryException
    extends IOException {
        private FileObject fo;

        private InsufficientMemoryException(String string, FileObject fileObject) {
            super(string);
            this.fo = fileObject;
        }

        private InsufficientMemoryException(FileObject fileObject) {
            this(NbBundle.getMessage(JavaSource.class, (String)"MSG_UnsufficientMemoryException", (Object)FileUtil.getFileDisplayName((FileObject)fileObject)), fileObject);
        }

        public FileObject getFile() {
            return this.fo;
        }
    }

    static interface JavaFileObjectProvider {
        public JavaFileObject createJavaFileObject(FileObject var1, JavaFileFilterImplementation var2) throws IOException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JavaSourceAccessorImpl
    extends JavaSourceAccessor {
        private JavaSourceAccessorImpl() {
        }

        @Override
        protected void runSpecialTaskImpl(CancellableTask<CompilationInfo> cancellableTask, Priority priority) {
            JavaSource.handleAddRequest(new Request(cancellableTask, null, null, priority, false));
        }

        @Override
        public JavacTaskImpl createJavacTask(ClasspathInfo classpathInfo, DiagnosticListener<? super JavaFileObject> diagnosticListener, String string) {
            if (string == null) {
                string = JavaPlatformManager.getDefault().getDefaultPlatform().getSpecification().getVersion().toString();
            }
            return JavaSource.createJavacTask(classpathInfo, diagnosticListener, string, true);
        }

        @Override
        public JavacTaskImpl getJavacTask(CompilationInfo compilationInfo) {
            assert (compilationInfo != null);
            return compilationInfo.getJavacTask();
        }

        @Override
        public QueryEnvironment getCommandEnvironment(WorkingCopy workingCopy) {
            assert (workingCopy != null);
            return workingCopy.getCommandEnvironment();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CompilationInfo getCurrentCompilationInfo(JavaSource javaSource, Phase phase) throws IOException {
            assert (javaSource != null);
            assert (this.isDispatchThread());
            CompilationInfo compilationInfo = null;
            Object object = javaSource;
            synchronized (object) {
                if ((javaSource.flags & 1) == 0) {
                    compilationInfo = javaSource.currentInfo;
                }
            }
            if (compilationInfo == null) {
                return null;
            }
            object = JavaSource.moveToPhase(phase, compilationInfo, true);
            return ((Enum)object).compareTo(phase) < 0 ? null : compilationInfo;
        }

        @Override
        public void revalidate(JavaSource javaSource) {
            javaSource.revalidate();
        }

        @Override
        public boolean isDispatchThread() {
            return factory.isDispatchThread(Thread.currentThread());
        }
    }

    private static class LMListener
    implements LowMemoryListener {
        private AtomicBoolean lowMemory = new AtomicBoolean(false);

        private LMListener() {
        }

        public void lowMemory(LowMemoryEvent lowMemoryEvent) {
            this.lowMemory.set(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Phase {
        MODIFIED,
        PARSED,
        ELEMENTS_RESOLVED,
        RESOLVED,
        UP_TO_DATE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Priority {
        MAX,
        HIGH,
        ABOVE_NORMAL,
        NORMAL,
        BELOW_NORMAL,
        LOW,
        MIN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Request {
        private final CancellableTask<? extends CompilationInfo> task;
        private final JavaSource javaSource;
        private final Phase phase;
        private final Priority priority;
        private final boolean reschedule;

        public Request(CancellableTask<? extends CompilationInfo> cancellableTask, JavaSource javaSource, Phase phase, Priority priority, boolean bl) {
            assert (cancellableTask != null);
            this.task = cancellableTask;
            this.javaSource = javaSource;
            this.phase = phase;
            this.priority = priority;
            this.reschedule = bl;
        }

        public String toString() {
            if (this.reschedule) {
                return String.format("Periodic request for phase: %s with priority: %s to perform: %s", new Object[]{this.phase.name(), this.priority, this.task.toString()});
            }
            return String.format("One time request for phase: %s with priority: %s to perform: %s", new Object[]{this.phase != null ? this.phase.name() : "<null>", this.priority, this.task.toString()});
        }

        public int hashCode() {
            return this.priority.ordinal();
        }

        public boolean equals(Object object) {
            if (object instanceof Request) {
                Request request = (Request)object;
                return this.priority == request.priority && this.reschedule == request.reschedule && this.phase.equals((Object)request.phase) && this.task.equals(request.task);
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RequestComparator
    implements Comparator<Request> {
        private RequestComparator() {
        }

        @Override
        public int compare(Request request, Request request2) {
            assert (request != null && request2 != null);
            return request.priority.compareTo(request2.priority);
        }
    }

    private static class SingleThreadFactory
    implements ThreadFactory {
        private Thread t;

        private SingleThreadFactory() {
        }

        public Thread newThread(Runnable runnable) {
            assert (this.t == null);
            this.t = new Thread(runnable, "Java Source Worker Thread");
            return this.t;
        }

        public boolean isDispatchThread(Thread thread) {
            assert (thread != null);
            return this.t == thread;
        }
    }
}

