/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.JavacTask;
import com.sun.tools.javac.api.BasicJavacTask;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.util.Context;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.tools.JavaFileObject;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.query.QueryException;
import org.netbeans.api.java.source.transform.ChangeSet;
import org.netbeans.api.java.source.transform.Transformer;
import org.netbeans.modules.java.source.builder.ASTService;
import org.netbeans.modules.java.source.builder.DefaultEnvironment;
import org.netbeans.modules.java.source.builder.TreeFactory;
import org.netbeans.modules.java.source.builder.UndoListService;
import org.netbeans.modules.java.source.engine.DefaultApplicationContext;
import org.netbeans.modules.java.source.engine.EngineEnvironment;
import org.netbeans.modules.java.source.engine.ReattributionException;
import org.netbeans.modules.java.source.engine.RootTree;
import org.netbeans.modules.java.source.engine.SourceReader;
import org.netbeans.modules.java.source.engine.SourceRewriter;
import org.netbeans.modules.java.source.save.Commit;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.text.CloneableEditorSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkingCopy
extends CompilationController {
    private EngineEnvironment ce;
    private ChangeSet changes;
    private boolean afterCommit = false;
    private WorkingCopyContext wcc = new WorkingCopyContext();
    private TreeMaker treeMaker;

    WorkingCopy(CompilationInfo compilationInfo) throws IOException {
        super(compilationInfo);
    }

    private synchronized void init() throws ReattributionException {
        Object object;
        if (this.changes != null) {
            return;
        }
        CompilationUnitTree compilationUnitTree = this.getCompilationUnit();
        if (compilationUnitTree != null) {
            object = this.getContext();
            ASTService aSTService = ASTService.instance((Context)object);
            ArrayList<CompilationUnitTree> arrayList = new ArrayList<CompilationUnitTree>();
            arrayList.add(compilationUnitTree);
            aSTService.setRoot(TreeFactory.instance((Context)object).Root(arrayList));
            UndoListService.instance((Context)object).reset();
        }
        object = this.delegate.getJavacTask();
        this.ce = new DefaultEnvironment((JavacTask)object, this.getCompilationUnit(), Source.instance((Context)((BasicJavacTask)object).getContext()).name, this.wcc);
        this.treeMaker = new TreeMaker(this, this.ce.getTreeMaker());
        this.changes = new ChangeSet("<no-description>");
        this.changes.attach(this.ce);
    }

    private Context getContext() {
        return this.getJavacTask().getContext();
    }

    EngineEnvironment getCommandEnvironment() {
        return this.ce;
    }

    @Override
    public JavaSource.Phase toPhase(JavaSource.Phase phase) throws IOException {
        JavaSource.Phase phase2 = super.toPhase(phase);
        if (phase2.compareTo(JavaSource.Phase.PARSED) >= 0) {
            try {
                this.init();
            }
            catch (ReattributionException reattributionException) {
                IOException iOException = new IOException();
                iOException.initCause(reattributionException);
                throw iOException;
            }
        }
        return phase2;
    }

    public synchronized TreeMaker getTreeMaker() {
        if (this.treeMaker == null) {
            throw new IllegalStateException("Cannot call getTreeMaker before toPhase.");
        }
        return this.treeMaker;
    }

    void run(Transformer transformer) {
        if (this.afterCommit) {
            throw new IllegalStateException("The run method can't be called on a WorkingCopy instance after the commit");
        }
        transformer.init();
        transformer.attach(this.ce);
        transformer.apply();
        transformer.release();
        transformer.destroy();
    }

    void run(Transformer transformer, Tree tree) {
        if (this.afterCommit) {
            throw new IllegalStateException("The run method can't be called on a WorkingCopy instance after the commit");
        }
        transformer.init();
        transformer.attach(this.ce);
        transformer.apply(tree);
        transformer.release();
        transformer.destroy();
    }

    ChangeSet getChangeSet() {
        return this.changes;
    }

    public synchronized void rewrite(Tree tree, Tree tree2) {
        if (this.changes == null) {
            throw new IllegalStateException("Cannot call rewrite before toPhase.");
        }
        if (tree == null || tree2 == null) {
            throw new IllegalArgumentException("Null values are not allowed.");
        }
        this.changes.rewrite(tree, tree2);
    }

    List<ModificationResult.Difference> getChanges() throws IOException {
        if (this.afterCommit) {
            throw new IllegalStateException("The commit method can be called only once on a WorkingCopy instance");
        }
        this.afterCommit = true;
        if (this.changes == null) {
            return null;
        }
        try {
            RootTree rootTree = this.changes.commit((RootTree)this.ce.getRootNode());
            if (this.changes.hasChanges()) {
                this.getCommandEnvironment().getModel().setRoot(rootTree);
            }
            Commit commit = new Commit(this);
            commit.init();
            commit.attach(this.ce);
            commit.commit();
            commit.release();
            commit.destroy();
            return this.wcc.diffs;
        }
        catch (QueryException queryException) {
            Logger.getLogger("global").log(Level.WARNING, queryException.getMessage(), queryException);
            return null;
        }
        catch (ReattributionException reattributionException) {
            Logger.getLogger("global").log(Level.WARNING, reattributionException.getMessage(), reattributionException);
            return null;
        }
    }

    private class WorkingCopyContext
    extends DefaultApplicationContext {
        private ArrayList<ModificationResult.Difference> diffs = new ArrayList();
        private Map<Integer, String> userInfo = Collections.emptyMap();

        private WorkingCopyContext() {
        }

        public PrintWriter getOutputWriter(String string) {
            return new PrintWriter(new Writer(){

                public void write(char[] cArray, int n, int n2) throws IOException {
                }

                public void flush() throws IOException {
                }

                public void close() throws IOException {
                }
            }, true);
        }

        public void setResult(Object object, String string) {
            if ("user-info".equals(string)) {
                this.userInfo = (Map)Map.class.cast(object);
            }
        }

        public SourceRewriter getSourceRewriter(JavaFileObject javaFileObject) throws IOException {
            return new Rewriter();
        }

        private class Rewriter
        implements SourceRewriter {
            private int offset = 0;
            private CloneableEditorSupport ces;

            private Rewriter() throws IOException {
                FileObject fileObject = WorkingCopy.this.getFileObject();
                if (fileObject != null) {
                    DataObject dataObject = DataObject.find((FileObject)fileObject);
                    CloneableEditorSupport cloneableEditorSupport = this.ces = dataObject != null ? (CloneableEditorSupport)dataObject.getCookie(EditorCookie.class) : null;
                }
                if (this.ces == null) {
                    throw new IOException("Could not find CloneableEditorSupport for " + FileUtil.getFileDisplayName((FileObject)fileObject));
                }
            }

            public void writeTo(String string) throws IOException, BadLocationException {
                ModificationResult.Difference difference;
                ModificationResult.Difference difference2 = difference = WorkingCopyContext.this.diffs.size() > 0 ? (ModificationResult.Difference)WorkingCopyContext.this.diffs.get(WorkingCopyContext.this.diffs.size() - 1) : null;
                if (difference != null && difference.getKind() == ModificationResult.Difference.Kind.REMOVE && difference.getEndPosition().getOffset() == this.offset) {
                    difference.kind = ModificationResult.Difference.Kind.CHANGE;
                    difference.newText = string;
                } else {
                    WorkingCopyContext.this.diffs.add(new ModificationResult.Difference(ModificationResult.Difference.Kind.INSERT, this.ces.createPositionRef(this.offset, Position.Bias.Forward), this.ces.createPositionRef(this.offset, Position.Bias.Forward), null, string, (String)WorkingCopyContext.this.userInfo.get(this.offset)));
                }
            }

            public void skipThrough(SourceReader sourceReader, int n) throws IOException, BadLocationException {
                ModificationResult.Difference difference;
                char[] cArray = sourceReader.getCharsTo(n);
                ModificationResult.Difference difference2 = difference = WorkingCopyContext.this.diffs.size() > 0 ? (ModificationResult.Difference)WorkingCopyContext.this.diffs.get(WorkingCopyContext.this.diffs.size() - 1) : null;
                if (difference != null && difference.getKind() == ModificationResult.Difference.Kind.INSERT && difference.getStartPosition().getOffset() == this.offset) {
                    difference.kind = ModificationResult.Difference.Kind.CHANGE;
                    difference.oldText = new String(cArray);
                } else {
                    WorkingCopyContext.this.diffs.add(new ModificationResult.Difference(ModificationResult.Difference.Kind.REMOVE, this.ces.createPositionRef(this.offset, Position.Bias.Forward), this.ces.createPositionRef(this.offset + cArray.length, Position.Bias.Forward), new String(cArray), null, (String)WorkingCopyContext.this.userInfo.get(this.offset)));
                }
                this.offset += cArray.length;
            }

            public void copyTo(SourceReader sourceReader, int n) throws IOException {
                char[] cArray = sourceReader.getCharsTo(n);
                this.offset += cArray.length;
            }

            public void copyRest(SourceReader sourceReader) throws IOException {
            }

            public void close(boolean bl) {
            }
        }
    }
}

