/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source.query;

import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreeScanner;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.query.ElementReferenceList;
import org.netbeans.api.java.source.query.QueryEnvironment;
import org.netbeans.modules.java.source.engine.ASTModel;
import org.netbeans.modules.java.source.engine.EngineEnvironment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceFinder
extends TreeScanner<Void, Object> {
    private ASTModel model;
    private ElementUtilities elements;
    private Element currentSym;
    Map<Element, ElementReferenceList<Element>> elementReferences;

    public static ReferenceFinder findReferences(QueryEnvironment queryEnvironment, Set<Element> set, Tree tree) {
        ReferenceFinder referenceFinder = new ReferenceFinder(queryEnvironment, set);
        referenceFinder.scan(tree, (Object)null);
        return referenceFinder;
    }

    protected ReferenceFinder(QueryEnvironment queryEnvironment, Set<Element> set) {
        this.model = ((EngineEnvironment)queryEnvironment).getModel();
        this.elements = queryEnvironment.getElementUtilities();
        this.elementReferences = new HashMap<Element, ElementReferenceList<Element>>();
        for (Element element : set) {
            this.elementReferences.put(element, new ElementReferenceList(element));
        }
    }

    public ElementReferenceList<Element> get(Element element) {
        return this.elementReferences.get(element);
    }

    public boolean hasReferences(Element element) {
        return this.elementReferences.containsKey(element);
    }

    @Override
    public Void scan(Tree tree, Object object) {
        if (tree != null) {
            Tree.Kind kind = tree.getKind();
            boolean bl = kind == Tree.Kind.CLASS || kind == Tree.Kind.METHOD || kind == Tree.Kind.VARIABLE;
            Element element = this.model.getElement(tree);
            if (element != null && bl) {
                Element element2 = this.currentSym;
                this.currentSym = element;
                tree.accept(this, object);
                this.currentSym = element2;
            } else {
                tree.accept(this, object);
            }
        }
        return null;
    }

    private void add(Tree tree, int n) {
        Element element = this.model.getElement(tree);
        ElementReferenceList<Element> elementReferenceList = this.elementReferences.get(element);
        if (elementReferenceList == null) {
            return;
        }
        if (this.currentSym == null) {
            throw new AssertionError((Object)"no currentSym");
        }
        TypeElement typeElement = this.elements.enclosingTypeElement(this.currentSym);
        PackageElement packageElement = this.elements.packageElement(typeElement);
        int n2 = n << (typeElement == elementReferenceList.varClass ? 4 : (packageElement == elementReferenceList.varPackage ? 2 : 0));
        elementReferenceList.addReference(this.currentSym, n2);
    }

    @Override
    public Void visitAssignment(AssignmentTree assignmentTree, Object object) {
        if (assignmentTree.getVariable() instanceof MemberSelectTree) {
            MemberSelectTree memberSelectTree = (MemberSelectTree)assignmentTree.getVariable();
            this.add(memberSelectTree, 1);
            this.scan((Tree)memberSelectTree.getExpression(), object);
        } else if (assignmentTree.getVariable() instanceof IdentifierTree) {
            this.add(assignmentTree, 1);
        } else {
            this.scan((Tree)assignmentTree.getVariable(), object);
        }
        this.scan((Tree)assignmentTree.getExpression(), object);
        return null;
    }

    @Override
    public Void visitCompoundAssignment(CompoundAssignmentTree compoundAssignmentTree, Object object) {
        if (compoundAssignmentTree.getVariable() instanceof MemberSelectTree) {
            MemberSelectTree memberSelectTree = (MemberSelectTree)compoundAssignmentTree.getVariable();
            this.scan((Tree)memberSelectTree.getExpression(), object);
            this.add(memberSelectTree, 3);
        } else if (compoundAssignmentTree.getVariable() instanceof IdentifierTree) {
            this.add(compoundAssignmentTree, 3);
        } else {
            this.scan((Tree)compoundAssignmentTree.getVariable(), object);
        }
        this.scan((Tree)compoundAssignmentTree.getExpression(), object);
        return null;
    }

    @Override
    public Void visitUnary(UnaryTree unaryTree, Object object) {
        switch (unaryTree.getKind()) {
            case PREFIX_INCREMENT: 
            case PREFIX_DECREMENT: 
            case POSTFIX_INCREMENT: 
            case POSTFIX_DECREMENT: {
                ExpressionTree expressionTree = unaryTree.getExpression();
                if (expressionTree instanceof MemberSelectTree) {
                    this.scan((Tree)((MemberSelectTree)expressionTree).getExpression(), object);
                    this.add(expressionTree, 3);
                    break;
                }
                if (unaryTree.getExpression() instanceof IdentifierTree) {
                    this.add(expressionTree, 3);
                    break;
                }
                this.scan((Tree)unaryTree.getExpression(), object);
                break;
            }
            default: {
                this.scan((Tree)unaryTree.getExpression(), object);
            }
        }
        return null;
    }

    @Override
    public Void visitIdentifier(IdentifierTree identifierTree, Object object) {
        this.add(identifierTree, 2);
        return (Void)super.visitIdentifier(identifierTree, object);
    }

    @Override
    public Void visitVariable(VariableTree variableTree, Object object) {
        ElementReferenceList<Element> elementReferenceList = this.elementReferences.get(this.model.getElement(variableTree));
        if (elementReferenceList != null) {
            int n = 64;
            if (variableTree.getInitializer() != null) {
                n |= 0x10;
            }
            elementReferenceList.addReference(this.currentSym, n);
        }
        return (Void)super.visitVariable(variableTree, object);
    }

    @Override
    public Void visitMethod(MethodTree methodTree, Object object) {
        ExecutableElement executableElement;
        ExecutableElement executableElement2 = (ExecutableElement)this.model.getElement(methodTree);
        ElementReferenceList<Element> elementReferenceList = this.elementReferences.get(executableElement2);
        if (elementReferenceList != null) {
            elementReferenceList.addReference(executableElement2, 64);
        }
        if ((executableElement = this.elements.getOverriddenMethod(executableElement2)) != null && (elementReferenceList = this.elementReferences.get(executableElement)) != null) {
            elementReferenceList.addReference(executableElement, 2);
        }
        return (Void)super.visitMethod(methodTree, object);
    }

    @Override
    public Void visitMethodInvocation(MethodInvocationTree methodInvocationTree, Object object) {
        ExpressionTree expressionTree = methodInvocationTree.getMethodSelect();
        ElementReferenceList<Element> elementReferenceList = this.elementReferences.get(this.model.getElement(expressionTree));
        if (elementReferenceList != null) {
            elementReferenceList.addReference(this.currentSym, 2);
        }
        return (Void)super.visitMethodInvocation(methodInvocationTree, object);
    }

    @Override
    public Void visitNewClass(NewClassTree newClassTree, Object object) {
        ElementReferenceList<Element> elementReferenceList = this.elementReferences.get(this.model.getElement(newClassTree));
        if (elementReferenceList != null) {
            elementReferenceList.addReference(this.currentSym, 2);
        }
        return (Void)super.visitNewClass(newClassTree, object);
    }

    @Override
    public Void visitNewArray(NewArrayTree newArrayTree, Object object) {
        ElementReferenceList<Element> elementReferenceList;
        Tree tree = newArrayTree.getType();
        if (tree != null && (elementReferenceList = this.elementReferences.get(this.model.getElement(tree))) != null) {
            elementReferenceList.addReference(this.currentSym, 2);
        }
        return (Void)super.visitNewArray(newArrayTree, object);
    }

    @Override
    public Void visitMemberSelect(MemberSelectTree memberSelectTree, Object object) {
        this.add(memberSelectTree, 2);
        return (Void)super.visitMemberSelect(memberSelectTree, object);
    }

    @Override
    public Void visitImport(ImportTree importTree, Object object) {
        return null;
    }
}

