/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source.query;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.swing.ListSelectionModel;
import org.netbeans.api.java.source.query.Query;
import org.netbeans.api.java.source.query.QueryEnvironment;
import org.netbeans.api.java.source.query.QueryResult;
import org.netbeans.api.java.source.query.QueryResultTableModel;
import org.netbeans.api.java.source.query.SearchEntry;
import org.netbeans.api.java.source.query.SourceSelection;
import org.netbeans.modules.java.source.engine.ASTModel;
import org.netbeans.modules.java.source.engine.DefaultSourceSelection;
import org.netbeans.modules.java.source.engine.EngineEnvironment;
import org.netbeans.modules.java.source.engine.TreeFinder;
import org.netbeans.modules.java.source.save.SourceBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchResult
extends QueryResultTableModel {
    protected QueryEnvironment env;
    protected ASTModel model;
    private SearchEntry[] results;
    protected List<SearchEntry> sorted = new ArrayList<SearchEntry>();
    private boolean changed;
    boolean hasmeth = false;
    boolean hasnote = false;
    boolean hassym = false;
    private int ncols = -1;
    private String[] columnNames;
    static final long serialVersionUID = -4851462993177602438L;

    private void changed() {
        this.results = null;
        this.changed = true;
    }

    public SearchResult(Query query, String string) {
        super(query, string);
    }

    public void attach(QueryEnvironment queryEnvironment) {
        this.env = queryEnvironment;
        this.model = ((EngineEnvironment)queryEnvironment).getModel();
    }

    public void release() {
        this.env = null;
        this.model = null;
    }

    public SearchEntry[] getResults() {
        if (this.results == null) {
            Collections.sort(this.sorted);
            this.results = this.sorted.toArray(new SearchEntry[this.sorted.size()]);
        }
        return this.results;
    }

    public final boolean add(SearchEntry searchEntry) {
        this.sorted.add(searchEntry);
        this.changed();
        return true;
    }

    public String asLogMessage(SearchEntry searchEntry) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(searchEntry.className);
        if (searchEntry.methName != null) {
            stringBuffer.append('.');
            stringBuffer.append(searchEntry.methName);
        }
        if (searchEntry.note != null) {
            stringBuffer.append(" \"");
            stringBuffer.append(searchEntry.note);
            stringBuffer.append('\"');
        }
        return stringBuffer.toString();
    }

    public final void clear() {
        this.sorted.clear();
        this.changed();
    }

    public Iterator<SearchEntry> iterator() {
        return new Iterator<SearchEntry>(){
            private int pos = 0;
            private boolean deleted = false;
            {
                SearchResult.this.getResults();
            }

            @Override
            public boolean hasNext() {
                if (this.pos < SearchResult.this.results.length) {
                    return true;
                }
                if (this.deleted) {
                    SearchResult.access$002(SearchResult.this, null);
                }
                return false;
            }

            @Override
            public SearchEntry next() {
                return SearchResult.this.results[this.pos++];
            }

            @Override
            public void remove() {
                this.deleted = true;
                SearchResult.this.sorted.remove(SearchResult.this.results[this.pos - 1]);
            }
        };
    }

    public int getFlagsOr() {
        int n = 0;
        SearchEntry[] searchEntryArray = this.getResults();
        int n2 = searchEntryArray.length;
        while (--n2 >= 0) {
            n |= searchEntryArray[n2].flags;
        }
        return n;
    }

    public Element getSymbol(int n) {
        if (n < 0) {
            return null;
        }
        SearchEntry[] searchEntryArray = this.getResults();
        if (searchEntryArray == null || n >= searchEntryArray.length) {
            return null;
        }
        return searchEntryArray[n].sym;
    }

    public int getFlagsMask() {
        int n = 0;
        SearchEntry[] searchEntryArray = this.getResults();
        int n2 = searchEntryArray.length;
        while (--n2 >= 0) {
            n |= 1 << searchEntryArray[n2].flags;
        }
        return n;
    }

    public final void done() {
        if (this.changed) {
            this.changed = false;
            this.results = null;
            this.fireTableStructureChanged();
        }
    }

    @Override
    public final int getRowCount() {
        return this.getResults().length;
    }

    @Override
    public final int getResultCount() {
        return this.getRowCount();
    }

    @Override
    public QueryResult getResult(ListSelectionModel listSelectionModel) {
        int n = listSelectionModel.getMinSelectionIndex();
        return n < this.getRowCount() ? this.getResult(n) : null;
    }

    @Override
    public QueryResult getResult(int n) {
        final SearchEntry searchEntry = this.getResults()[n];
        return new QueryResult(){

            public String getQueryDescription() {
                return searchEntry.query.getQueryDescription();
            }

            public SourceSelection getSourceSelection() {
                return SearchResult.this.makeSelection(searchEntry.getElement(), searchEntry.tree, SearchResult.this.env.getRootNode());
            }

            public String getNote() {
                return searchEntry.getNote();
            }
        };
    }

    protected SourceSelection makeSelection(Element element, Tree tree, Tree tree2) {
        if (tree == null) {
            tree = this.env.getTrees().getTree(element);
        }
        final CompilationUnitTree compilationUnitTree = this.getTopLevel(element, tree, tree2);
        int n = this.model.getStartPos(tree);
        int n2 = this.model.getEndPos(tree, compilationUnitTree);
        String string = compilationUnitTree.getSourceFile().toUri().getPath();
        return new DefaultSourceSelection(element, n, this.model.getPos(tree), n2, string){

            public String getSource() {
                return SearchResult.this.fromSource(compilationUnitTree);
            }
        };
    }

    protected String fromSource(CompilationUnitTree compilationUnitTree) {
        String string = compilationUnitTree.getSourceFile().toUri().getPath();
        try {
            SourceBuffer sourceBuffer = new SourceBuffer(string);
            return sourceBuffer.getString(0, sourceBuffer.length());
        }
        catch (IOException iOException) {
            assert (false) : "source file not found: " + string;
            return "";
        }
    }

    protected CompilationUnitTree getTopLevel(Element element, Tree tree, Tree tree2) {
        final TypeElement typeElement = this.env.getElementUtilities().outermostTypeElement(element);
        if (typeElement == null) {
            return this.model.getTopLevel(tree);
        }
        Element element2 = typeElement.getEnclosingElement();
        assert (element2 != null);
        final CompilationUnitTree[] compilationUnitTreeArray = new CompilationUnitTree[1];
        tree2.accept(new TreeFinder(tree){

            public Boolean visitCompilationUnit(CompilationUnitTree compilationUnitTree, Object object) {
                if (!this.found && ((Boolean)this.scan(compilationUnitTree.getTypeDecls(), object)).booleanValue()) {
                    compilationUnitTreeArray[0] = compilationUnitTree;
                }
                return this.found;
            }

            public Boolean visitClass(ClassTree classTree, Object object) {
                if (!this.found && ((Object)SearchResult.this.model.getElement(classTree)).equals(typeElement)) {
                    this.found = true;
                }
                return this.found;
            }
        }, null);
        assert (compilationUnitTreeArray[0] != null);
        return compilationUnitTreeArray[0];
    }

    @Override
    public int getColumnCount() {
        if (this.ncols == -1) {
            SearchEntry[] searchEntryArray = this.getResults();
            int n = searchEntryArray.length;
            while (--n >= 0) {
                if (searchEntryArray[n].methName != null) {
                    this.hasmeth = true;
                }
                if (searchEntryArray[n].note != null) {
                    this.hasnote = true;
                    continue;
                }
                if (searchEntryArray[n].symName == null) continue;
                this.hassym = true;
            }
            this.ncols = 1;
            if (this.hasmeth) {
                ++this.ncols;
            }
            if (this.hasnote) {
                ++this.ncols;
            }
            if (this.hassym) {
                ++this.ncols;
            }
        }
        return this.ncols;
    }

    @Override
    public String getColumnName(int n) {
        if (this.columnNames == null) {
            this.columnNames = new String[this.ncols];
            this.columnNames[0] = "Class";
            int n2 = 1;
            if (this.hasmeth) {
                this.columnNames[n2++] = "Member";
            }
            if (this.hassym) {
                this.columnNames[n2++] = "Symbol";
            }
            if (this.hasnote) {
                this.columnNames[n2] = "Notes";
            }
        }
        assert (n < this.columnNames.length) : "column=" + Integer.toString(n);
        return this.columnNames[n];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        SearchEntry searchEntry = this.getResults()[n];
        switch (n2) {
            case 0: {
                return searchEntry.className;
            }
            case 1: {
                if (this.hasmeth) {
                    return searchEntry.methName;
                }
                if (this.hassym) {
                    return searchEntry.getSymName();
                }
                if (!this.hasnote) break;
                return searchEntry.getNote();
            }
            case 2: {
                if (this.hassym) {
                    return searchEntry.getSymName();
                }
                if (!this.hasnote) break;
                return searchEntry.getNote();
            }
            case 3: {
                return searchEntry.getNote();
            }
        }
        return "Bug!!";
    }

    public String toString() {
        int n = this.getColumnCount();
        int n2 = this.getRowCount();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                stringBuffer.append(this.getColumnName(j));
                stringBuffer.append('=');
                stringBuffer.append(this.getValueAt(i, j));
                if (j + 1 >= n) continue;
                stringBuffer.append(", ");
            }
            if (i + 1 >= n2) continue;
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    public int size() {
        return this.getResults().length;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean contains(Object object) {
        return this.sorted.contains(object);
    }

    public Object[] toArray() {
        return this.getResults();
    }

    public <E> boolean containsAll(Collection<E> collection) {
        return this.sorted.containsAll(collection);
    }

    public boolean remove(Object object) {
        this.changed();
        return this.sorted.remove(object);
    }

    public <E> boolean removeAll(Collection<E> collection) {
        this.changed();
        return this.sorted.removeAll(collection);
    }

    public <E> boolean retainAll(Collection<E> collection) {
        this.changed();
        return this.sorted.retainAll(collection);
    }

    public <E extends SearchEntry> boolean addAll(Collection<E> collection) {
        Iterator<E> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add((SearchEntry)iterator.next());
        }
        return true;
    }

    static /* synthetic */ SearchEntry[] access$002(SearchResult searchResult, SearchEntry[] searchEntryArray) {
        searchResult.results = searchEntryArray;
        return searchEntryArray;
    }

    static interface SourceMaker {
        public String getSource();
    }
}

