/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source.query;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.AssertTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.BreakTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ContinueTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EmptyStatementTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ErroneousTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.LabeledStatementTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TreeVisitor;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.tree.WildcardTree;
import java.util.List;
import org.netbeans.api.java.source.query.QueryEnvironment;
import org.netbeans.api.java.source.transform.Transformer;
import org.netbeans.modules.java.source.engine.ASTModel;
import org.netbeans.modules.java.source.engine.EngineEnvironment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeMatcher
implements TreeVisitor<Void, Tree> {
    protected boolean matches;
    protected ASTModel model;

    public TreeMatcher(QueryEnvironment queryEnvironment) {
        this.model = ((EngineEnvironment)queryEnvironment).getModel();
    }

    public boolean matches(Tree tree, Tree tree2) {
        this.matches = true;
        this.match(tree, tree2);
        return this.matches;
    }

    public boolean matches(List<? extends Tree> list, List<? extends Tree> list2) {
        this.matches = true;
        int n = list.size();
        if (n != list2.size()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (this.matches(list.get(i), list2.get(i))) continue;
            return false;
        }
        return true;
    }

    private void match(Tree tree, Tree tree2) {
        if (this.matches) {
            if ((tree = Transformer.deblock(tree)) != null && (tree2 = Transformer.deblock(tree2)) != null) {
                if (tree.getKind() != tree2.getKind()) {
                    this.matches = false;
                } else {
                    tree.accept(this, tree2);
                }
            } else if (tree2 != tree) {
                this.matches = false;
            }
        }
    }

    private void match(List<? extends Tree> list, List<? extends Tree> list2) {
        if (!this.matches) {
            return;
        }
        if (list == null && list2 == null) {
            return;
        }
        if (list == null || list2 == null) {
            this.matches = false;
            return;
        }
        int n = list.size();
        if (n != list2.size()) {
            this.matches = false;
            return;
        }
        for (int i = 0; i < n && this.matches; ++i) {
            this.match(list.get(i), list2.get(i));
        }
    }

    private void match(CharSequence charSequence, CharSequence charSequence2) {
        this.matches = this.matches && charSequence == null && charSequence2 == null || charSequence != null && charSequence.equals(charSequence2);
    }

    @Override
    public Void visitCompilationUnit(CompilationUnitTree compilationUnitTree, Tree tree) {
        CompilationUnitTree compilationUnitTree2 = (CompilationUnitTree)tree;
        this.match(compilationUnitTree.getPackageAnnotations(), compilationUnitTree2.getPackageAnnotations());
        this.match(compilationUnitTree.getPackageName(), compilationUnitTree2.getPackageName());
        this.match(compilationUnitTree.getImports(), compilationUnitTree2.getImports());
        this.match(compilationUnitTree.getTypeDecls(), compilationUnitTree2.getTypeDecls());
        return null;
    }

    @Override
    public Void visitImport(ImportTree importTree, Tree tree) {
        ImportTree importTree2 = (ImportTree)tree;
        this.match(importTree.getQualifiedIdentifier(), importTree2.getQualifiedIdentifier());
        return null;
    }

    @Override
    public Void visitClass(ClassTree classTree, Tree tree) {
        ClassTree classTree2 = (ClassTree)tree;
        this.match(classTree.getSimpleName(), classTree2.getSimpleName());
        this.match(classTree.getModifiers(), classTree2.getModifiers());
        this.match(classTree.getTypeParameters(), classTree2.getTypeParameters());
        this.match(classTree.getExtendsClause(), classTree2.getExtendsClause());
        this.match(classTree.getImplementsClause(), classTree2.getImplementsClause());
        this.match(classTree.getMembers(), classTree2.getMembers());
        return null;
    }

    @Override
    public Void visitMethod(MethodTree methodTree, Tree tree) {
        MethodTree methodTree2 = (MethodTree)tree;
        this.match(methodTree.getName(), methodTree2.getName());
        this.match(methodTree.getModifiers(), methodTree2.getModifiers());
        this.match(methodTree.getTypeParameters(), methodTree2.getTypeParameters());
        this.match(methodTree.getParameters(), methodTree2.getParameters());
        this.match(methodTree.getReturnType(), methodTree2.getReturnType());
        this.match(methodTree.getThrows(), methodTree2.getThrows());
        this.match(methodTree.getDefaultValue(), methodTree2.getDefaultValue());
        this.match(methodTree.getBody(), methodTree2.getBody());
        return null;
    }

    @Override
    public Void visitVariable(VariableTree variableTree, Tree tree) {
        VariableTree variableTree2 = (VariableTree)tree;
        this.match(variableTree.getName(), variableTree2.getName());
        this.match(variableTree.getModifiers(), variableTree2.getModifiers());
        this.match(variableTree.getType(), variableTree2.getType());
        this.match(variableTree.getInitializer(), variableTree2.getInitializer());
        return null;
    }

    @Override
    public Void visitAnnotation(AnnotationTree annotationTree, Tree tree) {
        AnnotationTree annotationTree2 = (AnnotationTree)tree;
        this.match(annotationTree.getAnnotationType(), annotationTree2.getAnnotationType());
        this.match(annotationTree.getArguments(), annotationTree2.getArguments());
        return null;
    }

    @Override
    public Void visitMethodInvocation(MethodInvocationTree methodInvocationTree, Tree tree) {
        MethodInvocationTree methodInvocationTree2 = (MethodInvocationTree)tree;
        this.match(methodInvocationTree.getMethodSelect(), methodInvocationTree2.getMethodSelect());
        this.match(methodInvocationTree.getTypeArguments(), methodInvocationTree2.getTypeArguments());
        this.match(methodInvocationTree.getArguments(), methodInvocationTree2.getArguments());
        return null;
    }

    @Override
    public Void visitAssert(AssertTree assertTree, Tree tree) {
        AssertTree assertTree2 = (AssertTree)tree;
        this.match(assertTree.getCondition(), assertTree2.getCondition());
        this.match(assertTree.getDetail(), assertTree2.getDetail());
        return null;
    }

    @Override
    public Void visitAssignment(AssignmentTree assignmentTree, Tree tree) {
        AssignmentTree assignmentTree2 = (AssignmentTree)tree;
        this.match(assignmentTree.getVariable(), assignmentTree2.getVariable());
        this.match(assignmentTree.getExpression(), assignmentTree2.getExpression());
        return null;
    }

    @Override
    public Void visitCompoundAssignment(CompoundAssignmentTree compoundAssignmentTree, Tree tree) {
        CompoundAssignmentTree compoundAssignmentTree2 = (CompoundAssignmentTree)tree;
        this.match(compoundAssignmentTree.getVariable(), compoundAssignmentTree2.getVariable());
        this.match(compoundAssignmentTree.getExpression(), compoundAssignmentTree2.getExpression());
        return null;
    }

    @Override
    public Void visitBinary(BinaryTree binaryTree, Tree tree) {
        BinaryTree binaryTree2 = (BinaryTree)tree;
        this.match(binaryTree.getLeftOperand(), binaryTree2.getLeftOperand());
        this.match(binaryTree.getRightOperand(), binaryTree2.getRightOperand());
        return null;
    }

    @Override
    public Void visitBlock(BlockTree blockTree, Tree tree) {
        BlockTree blockTree2 = (BlockTree)tree;
        this.match(blockTree.getStatements(), blockTree2.getStatements());
        this.matches = this.matches && blockTree.isStatic() == blockTree2.isStatic();
        return null;
    }

    @Override
    public Void visitBreak(BreakTree breakTree, Tree tree) {
        BreakTree breakTree2 = (BreakTree)tree;
        this.match(breakTree.getLabel(), breakTree2.getLabel());
        return null;
    }

    @Override
    public Void visitCase(CaseTree caseTree, Tree tree) {
        CaseTree caseTree2 = (CaseTree)tree;
        this.match(caseTree.getExpression(), caseTree2.getExpression());
        this.match(caseTree.getStatements(), caseTree2.getStatements());
        return null;
    }

    @Override
    public Void visitCatch(CatchTree catchTree, Tree tree) {
        CatchTree catchTree2 = (CatchTree)tree;
        this.match(catchTree.getParameter(), catchTree2.getParameter());
        this.match(catchTree.getBlock(), catchTree2.getBlock());
        return null;
    }

    @Override
    public Void visitConditionalExpression(ConditionalExpressionTree conditionalExpressionTree, Tree tree) {
        ConditionalExpressionTree conditionalExpressionTree2 = (ConditionalExpressionTree)tree;
        this.match(conditionalExpressionTree.getCondition(), conditionalExpressionTree2.getCondition());
        this.match(conditionalExpressionTree.getFalseExpression(), conditionalExpressionTree2.getFalseExpression());
        this.match(conditionalExpressionTree.getTrueExpression(), conditionalExpressionTree2.getTrueExpression());
        return null;
    }

    @Override
    public Void visitContinue(ContinueTree continueTree, Tree tree) {
        ContinueTree continueTree2 = (ContinueTree)tree;
        this.match(continueTree.getLabel(), continueTree2.getLabel());
        return null;
    }

    @Override
    public Void visitDoWhileLoop(DoWhileLoopTree doWhileLoopTree, Tree tree) {
        DoWhileLoopTree doWhileLoopTree2 = (DoWhileLoopTree)tree;
        this.match(doWhileLoopTree.getCondition(), doWhileLoopTree2.getCondition());
        this.match(doWhileLoopTree.getStatement(), doWhileLoopTree2.getStatement());
        return null;
    }

    @Override
    public Void visitErroneous(ErroneousTree erroneousTree, Tree tree) {
        return null;
    }

    @Override
    public Void visitExpressionStatement(ExpressionStatementTree expressionStatementTree, Tree tree) {
        ExpressionStatementTree expressionStatementTree2 = (ExpressionStatementTree)tree;
        this.match(expressionStatementTree.getExpression(), expressionStatementTree2.getExpression());
        return null;
    }

    @Override
    public Void visitEnhancedForLoop(EnhancedForLoopTree enhancedForLoopTree, Tree tree) {
        EnhancedForLoopTree enhancedForLoopTree2 = (EnhancedForLoopTree)tree;
        this.match(enhancedForLoopTree.getVariable(), enhancedForLoopTree2.getVariable());
        this.match(enhancedForLoopTree.getExpression(), enhancedForLoopTree2.getExpression());
        this.match(enhancedForLoopTree.getStatement(), enhancedForLoopTree2.getStatement());
        return null;
    }

    @Override
    public Void visitForLoop(ForLoopTree forLoopTree, Tree tree) {
        ForLoopTree forLoopTree2 = (ForLoopTree)tree;
        this.match(forLoopTree.getInitializer(), forLoopTree2.getInitializer());
        this.match(forLoopTree.getCondition(), forLoopTree2.getCondition());
        this.match(forLoopTree.getUpdate(), forLoopTree2.getUpdate());
        this.match(forLoopTree.getStatement(), forLoopTree2.getStatement());
        return null;
    }

    @Override
    public Void visitIdentifier(IdentifierTree identifierTree, Tree tree) {
        IdentifierTree identifierTree2 = (IdentifierTree)tree;
        this.match(identifierTree.getName(), identifierTree2.getName());
        return null;
    }

    @Override
    public Void visitIf(IfTree ifTree, Tree tree) {
        IfTree ifTree2 = (IfTree)tree;
        this.match(ifTree.getCondition(), ifTree2.getCondition());
        this.match(ifTree.getThenStatement(), ifTree2.getThenStatement());
        this.match(ifTree.getElseStatement(), ifTree2.getElseStatement());
        return null;
    }

    @Override
    public Void visitArrayAccess(ArrayAccessTree arrayAccessTree, Tree tree) {
        ArrayAccessTree arrayAccessTree2 = (ArrayAccessTree)tree;
        this.match(arrayAccessTree.getExpression(), arrayAccessTree2.getExpression());
        this.match(arrayAccessTree.getIndex(), arrayAccessTree2.getIndex());
        return null;
    }

    @Override
    public Void visitLabeledStatement(LabeledStatementTree labeledStatementTree, Tree tree) {
        LabeledStatementTree labeledStatementTree2 = (LabeledStatementTree)tree;
        this.match(labeledStatementTree.getLabel(), labeledStatementTree2.getLabel());
        this.match(labeledStatementTree.getStatement(), labeledStatementTree2.getStatement());
        return null;
    }

    @Override
    public Void visitLiteral(LiteralTree literalTree, Tree tree) {
        LiteralTree literalTree2 = (LiteralTree)tree;
        Object object = literalTree.getValue();
        Object object2 = literalTree2.getValue();
        this.matches = this.matches && (object == null && object2 == null || object != null && object.equals(object2));
        return null;
    }

    @Override
    public Void visitModifiers(ModifiersTree modifiersTree, Tree tree) {
        ModifiersTree modifiersTree2 = (ModifiersTree)tree;
        this.matches = this.matches && ((Object)modifiersTree.getFlags()).equals(modifiersTree2.getFlags());
        this.match(modifiersTree.getAnnotations(), modifiersTree2.getAnnotations());
        return null;
    }

    @Override
    public Void visitNewArray(NewArrayTree newArrayTree, Tree tree) {
        NewArrayTree newArrayTree2 = (NewArrayTree)tree;
        this.match(newArrayTree.getType(), newArrayTree2.getType());
        this.match(newArrayTree.getDimensions(), newArrayTree2.getDimensions());
        this.match(newArrayTree.getInitializers(), newArrayTree2.getInitializers());
        return null;
    }

    @Override
    public Void visitNewClass(NewClassTree newClassTree, Tree tree) {
        NewClassTree newClassTree2 = (NewClassTree)tree;
        this.match(newClassTree.getIdentifier(), newClassTree2.getIdentifier());
        this.match(newClassTree.getTypeArguments(), newClassTree2.getTypeArguments());
        this.match(newClassTree.getArguments(), newClassTree2.getArguments());
        this.match(newClassTree.getClassBody(), newClassTree2.getClassBody());
        this.match(newClassTree.getEnclosingExpression(), newClassTree2.getEnclosingExpression());
        return null;
    }

    @Override
    public Void visitParenthesized(ParenthesizedTree parenthesizedTree, Tree tree) {
        ParenthesizedTree parenthesizedTree2 = (ParenthesizedTree)tree;
        this.match(parenthesizedTree.getExpression(), parenthesizedTree2.getExpression());
        return null;
    }

    @Override
    public Void visitReturn(ReturnTree returnTree, Tree tree) {
        ReturnTree returnTree2 = (ReturnTree)tree;
        this.match(returnTree.getExpression(), returnTree2.getExpression());
        return null;
    }

    @Override
    public Void visitMemberSelect(MemberSelectTree memberSelectTree, Tree tree) {
        MemberSelectTree memberSelectTree2 = (MemberSelectTree)tree;
        this.match(memberSelectTree.getIdentifier(), memberSelectTree2.getIdentifier());
        this.match(memberSelectTree.getExpression(), memberSelectTree2.getExpression());
        return null;
    }

    @Override
    public Void visitEmptyStatement(EmptyStatementTree emptyStatementTree, Tree tree) {
        return null;
    }

    @Override
    public Void visitSwitch(SwitchTree switchTree, Tree tree) {
        SwitchTree switchTree2 = (SwitchTree)tree;
        this.match(switchTree.getCases(), switchTree2.getCases());
        this.match(switchTree.getExpression(), switchTree2.getExpression());
        return null;
    }

    @Override
    public Void visitSynchronized(SynchronizedTree synchronizedTree, Tree tree) {
        SynchronizedTree synchronizedTree2 = (SynchronizedTree)tree;
        this.match(synchronizedTree.getBlock(), synchronizedTree2.getBlock());
        this.match(synchronizedTree.getExpression(), synchronizedTree2.getExpression());
        return null;
    }

    @Override
    public Void visitThrow(ThrowTree throwTree, Tree tree) {
        ThrowTree throwTree2 = (ThrowTree)tree;
        this.match(throwTree.getExpression(), throwTree2.getExpression());
        return null;
    }

    @Override
    public Void visitTry(TryTree tryTree, Tree tree) {
        TryTree tryTree2 = (TryTree)tree;
        this.match(tryTree.getBlock(), tryTree2.getBlock());
        this.match(tryTree.getCatches(), tryTree2.getCatches());
        this.match(tryTree.getFinallyBlock(), tryTree2.getFinallyBlock());
        return null;
    }

    @Override
    public Void visitParameterizedType(ParameterizedTypeTree parameterizedTypeTree, Tree tree) {
        ParameterizedTypeTree parameterizedTypeTree2 = (ParameterizedTypeTree)tree;
        this.match(parameterizedTypeTree.getType(), parameterizedTypeTree2.getType());
        this.match(parameterizedTypeTree.getTypeArguments(), parameterizedTypeTree2.getTypeArguments());
        return null;
    }

    @Override
    public Void visitArrayType(ArrayTypeTree arrayTypeTree, Tree tree) {
        ArrayTypeTree arrayTypeTree2 = (ArrayTypeTree)tree;
        this.match(arrayTypeTree.getType(), arrayTypeTree2.getType());
        return null;
    }

    @Override
    public Void visitTypeCast(TypeCastTree typeCastTree, Tree tree) {
        TypeCastTree typeCastTree2 = (TypeCastTree)tree;
        this.match(typeCastTree.getType(), typeCastTree2.getType());
        this.match(typeCastTree.getExpression(), typeCastTree2.getExpression());
        return null;
    }

    @Override
    public Void visitPrimitiveType(PrimitiveTypeTree primitiveTypeTree, Tree tree) {
        PrimitiveTypeTree primitiveTypeTree2 = (PrimitiveTypeTree)tree;
        this.matches = this.matches && primitiveTypeTree.getPrimitiveTypeKind() == primitiveTypeTree2.getPrimitiveTypeKind();
        return null;
    }

    @Override
    public Void visitTypeParameter(TypeParameterTree typeParameterTree, Tree tree) {
        TypeParameterTree typeParameterTree2 = (TypeParameterTree)tree;
        this.match(typeParameterTree.getName(), typeParameterTree2.getName());
        this.match(typeParameterTree.getBounds(), typeParameterTree2.getBounds());
        return null;
    }

    @Override
    public Void visitInstanceOf(InstanceOfTree instanceOfTree, Tree tree) {
        InstanceOfTree instanceOfTree2 = (InstanceOfTree)tree;
        this.match(instanceOfTree.getType(), instanceOfTree2.getType());
        this.match(instanceOfTree.getExpression(), instanceOfTree2.getExpression());
        return null;
    }

    @Override
    public Void visitUnary(UnaryTree unaryTree, Tree tree) {
        UnaryTree unaryTree2 = (UnaryTree)tree;
        this.match(unaryTree.getExpression(), unaryTree2.getExpression());
        return null;
    }

    @Override
    public Void visitWhileLoop(WhileLoopTree whileLoopTree, Tree tree) {
        WhileLoopTree whileLoopTree2 = (WhileLoopTree)tree;
        this.match(whileLoopTree.getCondition(), whileLoopTree2.getCondition());
        this.match(whileLoopTree.getStatement(), whileLoopTree2.getStatement());
        return null;
    }

    @Override
    public Void visitWildcard(WildcardTree wildcardTree, Tree tree) {
        WildcardTree wildcardTree2 = (WildcardTree)tree;
        this.match(wildcardTree.getBound(), wildcardTree2.getBound());
        return null;
    }

    @Override
    public Void visitOther(Tree tree, Tree tree2) {
        return null;
    }
}

