/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source.query;

import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.query.NodeScanner;
import org.netbeans.api.java.source.query.QueryEnvironment;
import org.netbeans.api.java.source.query.SearchEntry;
import org.netbeans.api.java.source.query.SearchResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UseFinder
extends NodeScanner<Void, Object> {
    public static final int SETUSE = 1;
    public static final int GETUSE = 2;
    public static final int CLASSSHIFT = 4;
    public static final int PACKAGESHIFT = 2;
    public static final int WORLDSHIFT = 0;
    public static final int DECLARATION = 64;
    private Element target;
    private SearchResult results;
    private PackageElement homePackage;
    private TypeElement homeClass;
    private static final String[] sgtable = new String[128];

    public UseFinder(QueryEnvironment queryEnvironment) {
        this.attach(queryEnvironment);
    }

    public SearchResult find(Element element, Tree tree) {
        if (element == null) {
            return null;
        }
        this.target = element;
        this.homePackage = this.env.getElementUtilities().packageElement(element);
        this.homeClass = this.env.getElementUtilities().enclosingTypeElement(element);
        this.results = new SearchResult(null, "Uses of " + element);
        if (tree != null) {
            this.results.attach(this.env);
            tree.accept(this, null);
        }
        return this.results;
    }

    public static String getMsg(int n) {
        String string = sgtable[n];
        if (string == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append((n & 0x40) == 0 ? (char)'-' : 'd');
            int n2 = 6;
            while (--n2 >= 0) {
                stringBuffer.append((char)((n & 1 << n2) == 0 ? 45 : ((n2 & 1) == 0 ? 119 : 114)));
            }
            UseFinder.sgtable[n] = string = stringBuffer.toString();
        }
        return string;
    }

    private void add(Tree tree, int n) {
        if (this.currentSym == null) {
            this.results.add(new SearchEntry(null, null, tree, this.model.getPos(tree), "No currentSym", 0));
            return;
        }
        TypeElement typeElement = this.env.getElementUtilities().enclosingTypeElement(this.currentSym);
        PackageElement packageElement = this.env.getElementUtilities().packageElement(typeElement);
        int n2 = n << (typeElement == this.homeClass ? 4 : (packageElement == this.homePackage ? 2 : 0));
        this.results.add(new SearchEntry(null, this.currentSym, tree, this.model.getPos(tree), UseFinder.getMsg(n2), n2));
    }

    private boolean isTarget(Tree tree) {
        return (tree instanceof MemberSelectTree || tree instanceof IdentifierTree) && this.model.getElement(tree) == this.target;
    }

    @Override
    public Void visitAssignment(AssignmentTree assignmentTree, Object object) {
        if (assignmentTree.getVariable() instanceof MemberSelectTree) {
            MemberSelectTree memberSelectTree = (MemberSelectTree)assignmentTree.getVariable();
            this.scan(memberSelectTree.getExpression(), object);
            if (this.model.getElement(memberSelectTree) == this.target) {
                this.add(assignmentTree, 1);
            }
        } else if (assignmentTree.getVariable() instanceof IdentifierTree) {
            if (this.model.getElement(assignmentTree.getVariable()) == this.target) {
                this.add(assignmentTree, 1);
            }
        } else {
            this.scan(assignmentTree.getVariable(), object);
        }
        this.scan(assignmentTree.getExpression(), object);
        return null;
    }

    @Override
    public Void visitCompoundAssignment(CompoundAssignmentTree compoundAssignmentTree, Object object) {
        if (compoundAssignmentTree.getVariable() instanceof MemberSelectTree) {
            MemberSelectTree memberSelectTree = (MemberSelectTree)compoundAssignmentTree.getVariable();
            this.scan(memberSelectTree.getExpression(), object);
            if (this.model.getElement(memberSelectTree) == this.target) {
                this.add(compoundAssignmentTree, 3);
            }
        } else if (compoundAssignmentTree.getVariable() instanceof IdentifierTree) {
            if (this.model.getElement(compoundAssignmentTree.getVariable()) == this.target) {
                this.add(compoundAssignmentTree, 3);
            }
        } else {
            this.scan(compoundAssignmentTree.getVariable(), object);
        }
        this.scan(compoundAssignmentTree.getExpression(), object);
        return null;
    }

    @Override
    public Void visitUnary(UnaryTree unaryTree, Object object) {
        switch (unaryTree.getKind()) {
            case PREFIX_INCREMENT: 
            case PREFIX_DECREMENT: 
            case POSTFIX_INCREMENT: 
            case POSTFIX_DECREMENT: {
                if (unaryTree.getExpression() instanceof MemberSelectTree) {
                    MemberSelectTree memberSelectTree = (MemberSelectTree)unaryTree.getExpression();
                    this.scan(memberSelectTree.getExpression(), object);
                    if (this.model.getElement(memberSelectTree) != this.target) break;
                    this.add(unaryTree, 3);
                    break;
                }
                if (unaryTree.getExpression() instanceof IdentifierTree) {
                    if (this.model.getElement(unaryTree.getExpression()) != this.target) break;
                    this.add(unaryTree, 3);
                    break;
                }
                this.scan(unaryTree.getExpression(), object);
                break;
            }
            default: {
                this.scan(unaryTree.getExpression(), object);
            }
        }
        return null;
    }

    @Override
    public Void visitIdentifier(IdentifierTree identifierTree, Object object) {
        if (this.model.getElement(identifierTree) == this.target) {
            this.add(identifierTree, 2);
        }
        return (Void)super.visitIdentifier(identifierTree, object);
    }

    @Override
    public Void visitVariable(VariableTree variableTree, Object object) {
        if (this.model.getElement(variableTree) == this.target) {
            int n = 64;
            if (variableTree.getInitializer() != null) {
                n |= 0x10;
            }
            this.results.add(new SearchEntry(null, this.currentSym, variableTree, this.model.getPos(variableTree), UseFinder.getMsg(n), n));
        }
        this.scan(variableTree.getInitializer(), object);
        return (Void)super.visitVariable(variableTree, object);
    }

    @Override
    public Void visitMemberSelect(MemberSelectTree memberSelectTree, Object object) {
        if (this.model.getElement(memberSelectTree) == this.target) {
            this.add(memberSelectTree, 2);
        }
        return (Void)super.visitMemberSelect(memberSelectTree, object);
    }
}

