/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source.transform;

import com.sun.source.tree.Tree;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.java.source.query.QueryEnvironment;
import org.netbeans.api.java.source.query.SearchEntry;
import org.netbeans.api.java.source.transform.Change;
import org.netbeans.api.java.source.transform.ChangeList;
import org.netbeans.api.java.source.transform.ImmutableTreeTranslator;
import org.netbeans.api.java.source.transform.TreeChange;
import org.netbeans.api.java.source.transform.UndoEntry;
import org.netbeans.api.java.source.transform.UndoList;
import org.netbeans.modules.java.source.engine.RootTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ChangeSet
extends ChangeList {
    private Translator translator = new Translator();
    private UndoList undo;

    public ChangeSet(String string) {
        super(string);
    }

    public void attach(QueryEnvironment queryEnvironment) {
        this.translator.attach(queryEnvironment);
        this.undo = queryEnvironment.getUndoList();
    }

    public void release() {
        this.translator.release();
        this.undo = null;
    }

    public void rewrite(final Tree tree, final Tree tree2) {
        if (tree2 != tree) {
            TreeChange treeChange;
            final Tree tree3 = this.getChange(tree);
            if (tree3 != null) {
                treeChange = new TreeChange(tree3, tree2);
                this.undo.addAndApply(new UndoEntry(){

                    @Override
                    public void undo() {
                        ChangeSet.this.remove(treeChange);
                    }

                    @Override
                    public void redo() {
                        ChangeSet.this.addLast(treeChange);
                    }

                    @Override
                    public <T> T getOld(T t) {
                        return (T)(t == tree2 ? tree3 : null);
                    }
                });
            }
            treeChange = new TreeChange(tree, tree2);
            this.undo.addAndApply(new UndoEntry(){

                @Override
                public void undo() {
                    ChangeSet.this.remove(treeChange);
                }

                @Override
                public void redo() {
                    ChangeSet.this.addLast(treeChange);
                }

                @Override
                public <T> T getOld(T t) {
                    return (T)(t == tree2 ? tree : null);
                }
            });
            this.addFirst(new TreeChange(tree, tree2));
        }
    }

    public void rewrite(Change change) {
        this.addFirst(change);
    }

    public boolean hasChanges() {
        return this.size() > 0;
    }

    public RootTree commit(RootTree rootTree) {
        if (this.hasChanges()) {
            HashMap<Tree, Tree> hashMap = new HashMap<Tree, Tree>();
            this.addToMap(hashMap);
            RootTree rootTree2 = (RootTree)this.translator.translate(rootTree, hashMap);
            return rootTree2;
        }
        return rootTree;
    }

    public RootTree rollback(RootTree rootTree) {
        if (this.hasChanges()) {
            HashMap<Tree, Tree> hashMap = new HashMap<Tree, Tree>();
            this.addToMap(hashMap);
            RootTree rootTree2 = (RootTree)this.untranslate(rootTree, hashMap);
            return rootTree2;
        }
        return rootTree;
    }

    private Tree untranslate(Tree tree, Map<Tree, Tree> map) {
        if (tree == null) {
            return null;
        }
        Tree tree2 = this.getOriginal(tree);
        return this.translator.translate(tree2 != null ? tree2 : tree, map);
    }

    Change getResultChanges(SearchEntry searchEntry) {
        for (Change change : this) {
            if (!change.hasOriginal(searchEntry.tree)) continue;
            return change;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Translator
    extends ImmutableTreeTranslator {
        private Map<Tree, Tree> changeMap;

        Translator() {
        }

        Tree translate(Tree tree, Map<Tree, Tree> map) {
            this.changeMap = new HashMap<Tree, Tree>(map);
            return this.translate(tree);
        }

        @Override
        public Tree translate(Tree tree) {
            assert (this.changeMap != null);
            if (tree == null) {
                return null;
            }
            Tree tree2 = this.changeMap.remove(tree);
            Tree tree3 = super.translate(tree2 != null ? tree2 : tree);
            return tree3;
        }
    }
}

