/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java;

import java.awt.Image;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.queries.FileBuiltQuery;
import org.netbeans.spi.java.loaders.RenameHandler;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public final class JavaNode
extends DataNode
implements ChangeListener {
    private static final long serialVersionUID = -7396485743899766258L;
    private static final String JAVA_ICON_BASE = "org/netbeans/modules/java/resources/class.gif";
    private static final String CLASS_ICON_BASE = "org/netbeans/modules/java/resources/clazz.gif";
    private static final Image NEEDS_COMPILE = Utilities.loadImage((String)"org/netbeans/modules/java/resources/needs-compile.gif");
    private final FileBuiltQuery.Status status;
    private final AtomicBoolean isCompiled;
    private static BlockingQueue<Task> queue;

    public JavaNode(DataObject dataObject, boolean bl) {
        super(dataObject, Children.LEAF);
        this.setIconBaseWithExtension(bl ? JAVA_ICON_BASE : CLASS_ICON_BASE);
        if (bl) {
            FileObject fileObject = dataObject.getPrimaryFile();
            this.isCompiled = new AtomicBoolean(true);
            this.status = FileBuiltQuery.getStatus((FileObject)fileObject);
            if (this.status != null) {
                this.status.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)this.status));
                queue.add(new Task(false, true, this));
            }
        } else {
            this.status = null;
            this.isCompiled = null;
        }
    }

    public void setName(String string) {
        RenameHandler renameHandler = JavaNode.getRenameHandler();
        if (renameHandler == null) {
            super.setName(string);
        } else {
            try {
                renameHandler.handleRename((Node)this, string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                super.setName(string);
            }
        }
    }

    private static synchronized RenameHandler getRenameHandler() {
        Collection collection = Lookup.getDefault().lookupAll(RenameHandler.class);
        if (collection.size() == 0) {
            return null;
        }
        if (collection.size() > 1) {
            ErrorManager.getDefault().log(16, "Multiple instances of RenameHandler found in Lookup; only using first one: " + collection);
        }
        return (RenameHandler)collection.iterator().next();
    }

    protected final Sheet createSheet() {
        Sheet sheet = super.createSheet();
        if (JavaNode.getRenameHandler() != null) {
            sheet.get("properties").put(this.createNameProperty());
        }
        Sheet.Set set = new Sheet.Set();
        set.setName("classpaths");
        set.setDisplayName(NbBundle.getMessage(JavaNode.class, (String)"LBL_JavaNode_sheet_classpaths"));
        set.setShortDescription(NbBundle.getMessage(JavaNode.class, (String)"HINT_JavaNode_sheet_classpaths"));
        set.put(new Node.Property[]{new ClasspathProperty("classpath/compile", NbBundle.getMessage(JavaNode.class, (String)"PROP_JavaNode_compile_classpath"), NbBundle.getMessage(JavaNode.class, (String)"HINT_JavaNode_compile_classpath")), new ClasspathProperty("classpath/execute", NbBundle.getMessage(JavaNode.class, (String)"PROP_JavaNode_execute_classpath"), NbBundle.getMessage(JavaNode.class, (String)"HINT_JavaNode_execute_classpath")), new ClasspathProperty("classpath/boot", NbBundle.getMessage(JavaNode.class, (String)"PROP_JavaNode_boot_classpath"), NbBundle.getMessage(JavaNode.class, (String)"HINT_JavaNode_boot_classpath"))});
        sheet.put(set);
        return sheet;
    }

    private Node.Property createNameProperty() {
        PropertySupport.ReadWrite<String> readWrite = new PropertySupport.ReadWrite<String>("name", String.class, NbBundle.getMessage(DataObject.class, (String)"PROP_name"), NbBundle.getMessage(DataObject.class, (String)"HINT_name")){

            public String getValue() {
                return JavaNode.this.getName();
            }

            public Object getValue(String string) {
                if ("suppressCustomEditor".equals(string)) {
                    return Boolean.TRUE;
                }
                return super.getValue(string);
            }

            public void setValue(String string) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                if (!this.canWrite()) {
                    throw new IllegalAccessException();
                }
                JavaNode.this.setName(string);
            }

            public boolean canWrite() {
                return JavaNode.this.canRename();
            }
        };
        return readWrite;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        queue.add(new Task(false, true, this));
    }

    public Image getIcon(int n) {
        Image image = super.getIcon(n);
        return this.enhanceIcon(image);
    }

    public Image getOpenedIcon(int n) {
        Image image = super.getOpenedIcon(n);
        return this.enhanceIcon(image);
    }

    private Image enhanceIcon(Image image) {
        if (this.isCompiled != null && !this.isCompiled.get()) {
            image = Utilities.mergeImages((Image)image, (Image)NEEDS_COMPILE, (int)16, (int)0);
        }
        return image;
    }

    static {
        new RequestProcessor("Java Node Badge Processor", 1).post(new Runnable(){

            public void run() {
                while (true) {
                    try {
                        while (true) {
                            Task task;
                            if ((task = (Task)queue.poll(Long.MAX_VALUE, TimeUnit.SECONDS)) == null) {
                                continue;
                            }
                            boolean bl = task.fire;
                            JavaNode javaNode = task.node;
                            if (task.computeBuiltStatus) {
                                boolean bl2 = javaNode.status != null ? javaNode.status.isBuilt() : true;
                                boolean bl3 = javaNode.isCompiled.getAndSet(bl2);
                                bl |= bl2 != bl3;
                            }
                            if (!bl) continue;
                            javaNode.fireIconChange();
                            javaNode.fireOpenedIconChange();
                        }
                    }
                    catch (ThreadDeath threadDeath) {
                        throw threadDeath;
                    }
                    catch (Throwable throwable) {
                        Exceptions.printStackTrace((Throwable)throwable);
                        continue;
                    }
                    break;
                }
            }
        });
        queue = new LinkedBlockingQueue<Task>();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ClasspathProperty
    extends PropertySupport.ReadOnly<String> {
        private final String id;

        public ClasspathProperty(String string, String string2, String string3) {
            super(string, String.class, string2, string3);
            this.id = string;
            this.setValue("oneline", false);
        }

        public String getValue() {
            ClassPath classPath = ClassPath.getClassPath((FileObject)JavaNode.this.getDataObject().getPrimaryFile(), (String)this.id);
            if (classPath != null) {
                StringBuffer stringBuffer = new StringBuffer();
                for (ClassPath.Entry entry : classPath.entries()) {
                    URL uRL = entry.getURL();
                    String string = uRL.toExternalForm();
                    if (uRL.getProtocol().equals("file")) {
                        string = new File(URI.create(string)).getAbsolutePath();
                    } else if (uRL.getProtocol().equals("jar") && string.endsWith("!/")) {
                        URL uRL2 = FileUtil.getArchiveFile((URL)uRL);
                        assert (uRL2 != null) : uRL;
                        if (uRL2.getProtocol().equals("file")) {
                            string = new File(URI.create(uRL2.toExternalForm())).getAbsolutePath();
                        }
                    }
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(File.pathSeparatorChar);
                    }
                    stringBuffer.append(string);
                }
                return stringBuffer.toString();
            }
            return NbBundle.getMessage(JavaNode.class, (String)"LBL_JavaNode_classpath_unknown");
        }
    }

    private static class Task {
        private boolean fire;
        private boolean computeBuiltStatus;
        private JavaNode node;

        public Task(boolean bl, boolean bl2, JavaNode javaNode) {
            this.fire = bl;
            this.computeBuiltStatus = bl2;
            this.node = javaNode;
        }
    }
}

