/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.actions;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.swing.AbstractAction;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.UiUtils;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.java.actions.GoToPanel;
import org.netbeans.modules.java.actions.TypeDescription;
import org.netbeans.modules.java.actions.UiOptions;
import org.netbeans.modules.java.source.usages.RepositoryUpdater;
import org.netbeans.modules.java.source.util.Models;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

public class GoToTypeAction
extends AbstractAction
implements GoToPanel.ContentProvider {
    private static final Logger LOGGER = Logger.getLogger(GoToTypeAction.class.getName());
    private static final ClassPath EMPTY_CLASSPATH = ClassPathSupport.createClassPath((FileObject[])new FileObject[0]);
    private ClassIndex.NameKind nameKind;
    private static ListModel EMPTY_LIST_MODEL = new DefaultListModel();
    private static final RequestProcessor rp = new RequestProcessor("GoToTypeAction-RequestProcessor", 1);
    private Worker running;
    private RequestProcessor.Task task;
    private GoToPanel panel;
    private Set<CacheItem> cache;
    private Dialog dialog;
    private JButton okButton;

    public GoToTypeAction() {
        super(NbBundle.getMessage(GoToTypeAction.class, (String)"TXT_GoToType"));
        this.putValue("PopupMenuText", NbBundle.getBundle(GoToTypeAction.class).getString("editor-popup-TXT_GoToType"));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            JEditorPane[] jEditorPaneArray;
            EditorCookie editorCookie;
            this.cache = null;
            this.panel = new GoToPanel(this);
            this.dialog = this.createDialog(this.panel);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    GoToTypeAction.this.dialog.setVisible(true);
                }
            });
            Node[] nodeArray = TopComponent.getRegistry().getActivatedNodes();
            String string = null;
            if (nodeArray.length > 0 && (editorCookie = (EditorCookie)nodeArray[0].getCookie(EditorCookie.class)) != null && (jEditorPaneArray = editorCookie.getOpenedPanes()) != null && (string = Utilities.getSelectionOrIdentifier((JTextComponent)jEditorPaneArray[0])) != null && org.openide.util.Utilities.isJavaIdentifier((String)string)) {
                this.panel.setInitialText(string);
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
    }

    public ListCellRenderer getListCellRenderer(JList jList) {
        return new Renderer(jList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setListModel(GoToPanel goToPanel, String string) {
        if (this.okButton != null) {
            this.okButton.setEnabled(false);
        }
        if (this.running != null) {
            this.running.cancel();
            this.task.cancel();
            this.running = null;
        }
        if (string == null) {
            goToPanel.setModel(EMPTY_LIST_MODEL);
            return;
        }
        if ((string = string.trim()).length() == 0) {
            goToPanel.setModel(EMPTY_LIST_MODEL);
            return;
        }
        if (GoToTypeAction.isAllUpper(string)) {
            this.nameKind = ClassIndex.NameKind.CAMEL_CASE;
        } else if (GoToTypeAction.containsWildCard(string) != -1) {
            if (!Character.isJavaIdentifierStart(string.charAt(0))) {
                goToPanel.setModel(EMPTY_LIST_MODEL);
                return;
            }
            this.nameKind = goToPanel.isCaseSensitive() ? ClassIndex.NameKind.REGEXP : ClassIndex.NameKind.CASE_INSENSITIVE_REGEXP;
        } else {
            this.nameKind = goToPanel.isCaseSensitive() ? ClassIndex.NameKind.PREFIX : ClassIndex.NameKind.CASE_INSENSITIVE_PREFIX;
        }
        GoToTypeAction goToTypeAction = this;
        synchronized (goToTypeAction) {
            this.running = new Worker(string);
            this.task = rp.post((Runnable)this.running, 220);
            return;
        }
    }

    public void closeDialog() {
        this.dialog.setVisible(false);
        this.cleanup();
    }

    public boolean hasValidContent() {
        return this.okButton != null && this.okButton.isEnabled();
    }

    private static boolean isAllUpper(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isUpperCase(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static int containsWildCard(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != '?' && string.charAt(i) != '*') continue;
            return i;
        }
        return -1;
    }

    private Dialog createDialog(GoToPanel goToPanel) {
        this.okButton = new JButton(NbBundle.getMessage(GoToTypeAction.class, (String)"CTL_OK"));
        this.okButton.setEnabled(false);
        goToPanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GoToTypeAction.class, (String)"AN_GoToType"));
        goToPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GoToTypeAction.class, (String)"AD_GoToType"));
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)goToPanel, NbBundle.getMessage(GoToTypeAction.class, (String)"DLG_GoToType"), true, new Object[]{this.okButton, DialogDescriptor.CANCEL_OPTION}, (Object)this.okButton, 0, HelpCtx.DEFAULT_HELP, (ActionListener)new DialogButtonListener(goToPanel));
        dialogDescriptor.setClosingOptions(new Object[]{this.okButton, DialogDescriptor.CANCEL_OPTION});
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setPreferredSize(new Dimension(UiOptions.GoToTypeDialog.getWidth(), UiOptions.GoToTypeDialog.getHeight()));
        Rectangle rectangle = org.openide.util.Utilities.getUsableScreenBounds();
        int n = rectangle.width * 9 / 10;
        int n2 = rectangle.height * 9 / 10;
        Dimension dimension = dialog.getPreferredSize();
        dimension.width = Math.min(dimension.width, n);
        dimension.height = Math.min(dimension.height, n2);
        dialog.setBounds(org.openide.util.Utilities.findCenterBounds((Dimension)dimension));
        dialog.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                GoToTypeAction.this.cleanup();
            }
        });
        return dialog;
    }

    private void cleanup() {
        if (this.dialog != null) {
            UiOptions.GoToTypeDialog.setHeight(this.dialog.getHeight());
            UiOptions.GoToTypeDialog.setWidth(this.dialog.getWidth());
            this.dialog.dispose();
            this.dialog = null;
            this.cache = null;
        }
    }

    static class CacheItem {
        public final boolean isBinary;
        public final FileObject fileObject;
        public final ClasspathInfo classpathInfo;
        public String projectName;
        public Icon projectIcon;
        private ClassPath.Entry defEntry;

        public CacheItem(FileObject fileObject, ClasspathInfo classpathInfo, boolean bl) {
            this.isBinary = bl;
            this.fileObject = fileObject;
            this.classpathInfo = classpathInfo;
        }

        public int hashCode() {
            return this.fileObject == null ? 0 : this.fileObject.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof CacheItem) {
                CacheItem cacheItem = (CacheItem)object;
                return this.fileObject == null ? cacheItem.fileObject == null : this.fileObject.equals(cacheItem.fileObject);
            }
            return false;
        }

        public FileObject getRoot() {
            return this.fileObject;
        }

        public boolean isBinary() {
            return this.isBinary;
        }

        public synchronized String getProjectName() {
            if (!this.isBinary && this.projectName == null) {
                this.initProjectInfo();
            }
            return this.projectName;
        }

        public synchronized Icon getProjectIcon() {
            if (!this.isBinary && this.projectIcon == null) {
                this.initProjectInfo();
            }
            return this.projectIcon;
        }

        private void initProjectInfo() {
            Project project = FileOwnerQuery.getOwner((FileObject)this.fileObject);
            if (project != null) {
                ProjectInformation projectInformation = ProjectUtils.getInformation((Project)project);
                this.projectName = projectInformation.getDisplayName();
                this.projectIcon = projectInformation.getIcon();
            }
        }
    }

    private class DialogButtonListener
    implements ActionListener {
        private GoToPanel panel;

        public DialogButtonListener(GoToPanel goToPanel) {
            this.panel = goToPanel;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == GoToTypeAction.this.okButton) {
                this.panel.openSelectedItem();
            }
        }
    }

    private static class Renderer
    extends DefaultListCellRenderer
    implements ChangeListener {
        private JPanel rendererComponent;
        private JLabel jlName = new JLabel();
        private JLabel jlPkg = new JLabel();
        private JLabel jlPrj = new JLabel();
        private int DARKER_COLOR_COMPONENT = 5;
        private int LIGHTER_COLOR_COMPONENT = 80;
        private Color fgColor;
        private Color fgColorLighter;
        private Color bgColor;
        private Color bgColorDarker;
        private Color bgSelectionColor;
        private Color fgSelectionColor;
        private JList jList;

        public Renderer(JList jList) {
            this.jList = jList;
            Container container = jList.getParent();
            if (container instanceof JViewport) {
                ((JViewport)container).addChangeListener(this);
                this.stateChanged(new ChangeEvent(container));
            }
            this.rendererComponent = new JPanel();
            this.rendererComponent.setLayout(new BorderLayout());
            this.rendererComponent.add((Component)this.jlName, "West");
            this.rendererComponent.add((Component)this.jlPkg, "Center");
            this.rendererComponent.add((Component)this.jlPrj, "East");
            this.jlName.setOpaque(false);
            this.jlPkg.setOpaque(false);
            this.jlPrj.setOpaque(false);
            this.jlName.setFont(jList.getFont());
            this.jlPkg.setFont(jList.getFont());
            this.jlPrj.setFont(jList.getFont());
            this.jlPrj.setHorizontalAlignment(4);
            this.jlPrj.setHorizontalTextPosition(2);
            this.fgColor = jList.getForeground();
            this.fgColorLighter = new Color(Math.min(255, this.fgColor.getRed() + this.LIGHTER_COLOR_COMPONENT), Math.min(255, this.fgColor.getGreen() + this.LIGHTER_COLOR_COMPONENT), Math.min(255, this.fgColor.getBlue() + this.LIGHTER_COLOR_COMPONENT));
            this.bgColor = jList.getBackground();
            this.bgColorDarker = new Color(Math.abs(this.bgColor.getRed() - this.DARKER_COLOR_COMPONENT), Math.abs(this.bgColor.getGreen() - this.DARKER_COLOR_COMPONENT), Math.abs(this.bgColor.getBlue() - this.DARKER_COLOR_COMPONENT));
            this.bgSelectionColor = jList.getSelectionBackground();
            this.fgSelectionColor = jList.getSelectionForeground();
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            int n2 = jList.getFixedCellHeight();
            int n3 = jList.getFixedCellWidth() - 1;
            n3 = n3 < 200 ? 200 : n3;
            Dimension dimension = new Dimension(n3, n2);
            this.rendererComponent.setMaximumSize(dimension);
            this.rendererComponent.setPreferredSize(dimension);
            if (bl) {
                this.jlName.setForeground(this.fgSelectionColor);
                this.jlPkg.setForeground(this.fgSelectionColor);
                this.jlPrj.setForeground(this.fgSelectionColor);
                this.rendererComponent.setBackground(this.bgSelectionColor);
            } else {
                this.jlName.setForeground(this.fgColor);
                this.jlPkg.setForeground(this.fgColorLighter);
                this.jlPrj.setForeground(this.fgColor);
                this.rendererComponent.setBackground(n % 2 == 0 ? this.bgColor : this.bgColorDarker);
            }
            if (object instanceof TypeDescription) {
                TypeDescription typeDescription = (TypeDescription)object;
                this.jlName.setIcon(typeDescription.getIcon());
                this.jlName.setText(typeDescription.getTypeName());
                this.jlPkg.setText(typeDescription.getPackageName());
                this.jlPrj.setText(typeDescription.getProjectName());
                this.jlPrj.setIcon(typeDescription.getProjectIcon());
                this.rendererComponent.setToolTipText(FileUtil.getFileDisplayName((FileObject)typeDescription.getFileObject()));
            } else {
                this.jlName.setText(object.toString());
            }
            return this.rendererComponent;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JViewport jViewport = (JViewport)changeEvent.getSource();
            this.jlName.setText("Sample");
            this.jlName.setIcon(UiUtils.getElementIcon(ElementKind.CLASS, null));
            this.jList.setFixedCellHeight(this.jlName.getPreferredSize().height);
            this.jList.setFixedCellWidth(jViewport.getExtentSize().width);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Worker
    implements Runnable {
        private volatile boolean isCanceled = false;
        private final String text;

        public Worker(String string) {
            this.text = string;
        }

        @Override
        public void run() {
            List<TypeDescription> list = this.getTypeNames(this.text);
            if (this.isCanceled) {
                return;
            }
            ListModel listModel = Models.fromList(list);
            if (this.isCanceled) {
                return;
            }
            if (!this.isCanceled && listModel != null) {
                GoToTypeAction.this.panel.setModel(listModel);
                if (GoToTypeAction.this.okButton != null && !list.isEmpty()) {
                    GoToTypeAction.this.okButton.setEnabled(true);
                }
            }
        }

        public void cancel() {
            this.isCanceled = true;
        }

        private List<TypeDescription> getTypeNames(String string) {
            Object object;
            Object object2;
            long l;
            long l2 = 0L;
            long l3 = 0L;
            long l4 = 0L;
            long l5 = 0L;
            long l6 = 0L;
            long l7 = 0L;
            long l8 = 0L;
            if (GoToTypeAction.this.cache == null) {
                Object object3;
                int n;
                LOGGER.fine("GoToTypeAction.getTypeNames recreates cache\n");
                l = System.currentTimeMillis();
                object2 = RepositoryUpdater.getDefault().getScannedSources();
                Object object4 = object2.getRoots();
                l7 += System.currentTimeMillis() - l;
                Object object5 = new FileObject[1];
                object = new HashSet(((FileObject[])object4).length);
                for (n = 0; n < ((FileObject[])object4).length; ++n) {
                    object5[0] = object4[n];
                    l = System.currentTimeMillis();
                    object3 = ClasspathInfo.create(EMPTY_CLASSPATH, EMPTY_CLASSPATH, ClassPathSupport.createClassPath((FileObject[])object5));
                    LOGGER.fine("GoToTypeAction.getTypeNames created ClasspathInfo for source: " + FileUtil.getFileDisplayName((FileObject)object4[n]) + "\n");
                    if (this.isCanceled) {
                        return null;
                    }
                    object.add(new CacheItem((FileObject)object4[n], (ClasspathInfo)object3, false));
                    l8 += System.currentTimeMillis() - l;
                }
                l = System.currentTimeMillis();
                object2 = RepositoryUpdater.getDefault().getScannedBinaries();
                object4 = object2.getRoots();
                l6 += System.currentTimeMillis() - l;
                object5 = new FileObject[1];
                for (n = 0; n < ((Object)object4).length; ++n) {
                    try {
                        l = System.currentTimeMillis();
                        object3 = SourceForBinaryQuery.findSourceRoots((URL)object4[n].getURL());
                        if (object3.getRoots().length == 0) continue;
                        l5 += System.currentTimeMillis() - l;
                        l = System.currentTimeMillis();
                        object5[0] = object4[n];
                        ClasspathInfo object6 = ClasspathInfo.create(ClassPathSupport.createClassPath((FileObject[])object5), EMPTY_CLASSPATH, EMPTY_CLASSPATH);
                        LOGGER.fine("GoToTypeAction.getTypeNames created ClasspathInfo for binary: " + FileUtil.getFileDisplayName((FileObject)object4[n]) + "\n");
                        object.add(new CacheItem((FileObject)object4[n], object6, true));
                        l8 += System.currentTimeMillis() - l;
                        continue;
                    }
                    catch (FileStateInvalidException fileStateInvalidException) {
                        // empty catch block
                    }
                }
                if (!this.isCanceled) {
                    GoToTypeAction.this.cache = (Set)object;
                } else {
                    return null;
                }
            }
            LOGGER.fine("GoToTypeAction.getTypeNames collected : " + GoToTypeAction.this.cache.size() + " elements\n");
            object2 = new ArrayList(GoToTypeAction.this.cache.size() * 20);
            for (Object object5 : GoToTypeAction.this.cache) {
                l = System.currentTimeMillis();
                switch (GoToTypeAction.this.nameKind) {
                    case REGEXP: 
                    case CASE_INSENSITIVE_REGEXP: {
                        String string2 = string + "*";
                        string2 = string2.replace("*", ".*").replace('?', '.');
                        object = string2;
                        break;
                    }
                    default: {
                        object = string;
                    }
                }
                LOGGER.fine("GoToTypeAction.getTypeNames queries usages of: " + object5.classpathInfo + "\n");
                Set<ElementHandle<TypeElement>> set = object5.classpathInfo.getClassIndex().getDeclaredTypes((String)object, GoToTypeAction.this.nameKind, EnumSet.of(object5.isBinary ? ClassIndex.SearchScope.DEPENDENCIES : ClassIndex.SearchScope.SOURCE));
                if (this.isCanceled) {
                    return null;
                }
                l4 += System.currentTimeMillis() - l;
                l = System.currentTimeMillis();
                for (ElementHandle elementHandle : set) {
                    TypeDescription typeDescription = new TypeDescription((CacheItem)object5, elementHandle);
                    ((ArrayList)object2).add(typeDescription);
                    if (!this.isCanceled) continue;
                    return null;
                }
                l3 += System.currentTimeMillis() - l;
            }
            if (!this.isCanceled) {
                l = System.currentTimeMillis();
                Collections.sort(object2);
                Logger.getLogger(GoToTypeAction.class.getName()).log(Level.INFO, "PERF -  GSS:  " + l7 + " GSB " + l6 + " CP: " + l8 + " SFB: " + l5 + " GTN: " + l4 + "  ADD: " + l3 + "  SORT: " + (l2 += System.currentTimeMillis() - l));
                return object2;
            }
            return null;
        }
    }
}

