/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.actions;

import java.io.IOException;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.swing.Icon;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.UiUtils;
import org.netbeans.modules.java.actions.GoToTypeAction;
import org.netbeans.modules.java.ui.Icons;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TypeDescription
implements Comparable<TypeDescription> {
    private static final String EMPTY_STRING = "";
    private Icon icon;
    private final GoToTypeAction.CacheItem cacheItem;
    private final ElementHandle<TypeElement> handle;
    private String simpleName;
    private String outerName;
    private String packageName;

    public TypeDescription(GoToTypeAction.CacheItem cacheItem, ElementHandle<TypeElement> elementHandle) {
        this.cacheItem = cacheItem;
        this.handle = elementHandle;
        this.init();
    }

    public void open() {
        if (this.cacheItem.isBinary()) {
            final ClasspathInfo classpathInfo = ClasspathInfo.create(this.cacheItem.getRoot());
            JavaSource javaSource = JavaSource.create(classpathInfo, new FileObject[0]);
            final ElementHandle<TypeElement> elementHandle = this.handle;
            final Element[] elementArray = new Element[1];
            try {
                javaSource.runUserActionTask(new CancellableTask<CompilationController>(){

                    @Override
                    public void cancel() {
                    }

                    @Override
                    public void run(CompilationController compilationController) {
                        elementArray[0] = elementHandle.resolve(compilationController);
                        UiUtils.open(classpathInfo, elementArray[0]);
                    }
                }, true);
            }
            catch (IOException iOException) {
                Logger.getLogger(TypeDescription.class.getName()).info("Source not found: " + elementHandle.getBinaryName());
                Exceptions.printStackTrace((Throwable)iOException);
            }
        } else {
            FileObject fileObject;
            FileObject fileObject2 = fileObject = this.packageName != null ? this.cacheItem.getRoot().getFileObject(this.packageName.replace(".", "/")) : this.cacheItem.getRoot();
            if (fileObject != null) {
                FileObject[] fileObjectArray = fileObject.getChildren();
                String string = this.outerName == null ? this.simpleName : this.outerName;
                int n = string.indexOf(46);
                if (n != -1) {
                    string = string.substring(0, n);
                }
                for (FileObject fileObject3 : fileObjectArray) {
                    if (!string.equals(fileObject3.getName()) || !"java".equals(fileObject3.getExt().toLowerCase())) continue;
                    UiUtils.open(fileObject3, this.handle);
                }
            } else {
                Logger.getLogger(TypeDescription.class.getName()).info("Package " + this.packageName + " doesn't exist in root: " + FileUtil.getFileDisplayName((FileObject)this.cacheItem.getRoot()));
            }
        }
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public FileObject getFileObject() {
        return this.cacheItem.getRoot();
    }

    public String getTypeName() {
        StringBuilder stringBuilder = new StringBuilder(this.simpleName);
        if (this.outerName != null) {
            stringBuilder.append(" in ").append(this.outerName);
        }
        return stringBuilder.toString();
    }

    public String getPackageName() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" (").append(this.packageName == null ? "Default Package" : this.packageName).append(")");
        return stringBuilder.toString();
    }

    public String getProjectName() {
        String string = this.cacheItem.getProjectName();
        return string == null ? EMPTY_STRING : string;
    }

    public Icon getProjectIcon() {
        return this.cacheItem.getProjectIcon();
    }

    private void init() {
        String string = this.handle.getBinaryName();
        int n = string.lastIndexOf(46);
        int n2 = string.lastIndexOf(36);
        if (n == -1) {
            if (n2 == -1) {
                this.simpleName = string;
            } else {
                this.simpleName = string.substring(n2 + 1);
                this.outerName = string.substring(0, n2).replace('$', '.');
            }
        } else {
            this.packageName = string.substring(0, n);
            if (n2 == -1) {
                this.simpleName = string.substring(n + 1).replace('$', '.');
            } else {
                this.simpleName = string.substring(n2 + 1);
                this.outerName = string.substring(n + 1, n2).replace('$', '.');
            }
        }
        this.icon = Icons.getElementIcon(this.handle.getKind(), null);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.simpleName);
        if (this.outerName != null) {
            stringBuilder.append(" in ").append(this.outerName);
        }
        stringBuilder.append(" (").append(this.packageName == null ? "Default Package" : this.packageName).append(")");
        if (this.cacheItem.getProjectName() != null) {
            stringBuilder.append(" [").append(this.cacheItem.getProjectName()).append("]");
        }
        return stringBuilder.toString();
    }

    @Override
    public int compareTo(TypeDescription typeDescription) {
        int n = this.compareStrings(this.simpleName, typeDescription.simpleName);
        if (n != 0) {
            return n;
        }
        n = this.compareStrings(this.outerName, typeDescription.outerName);
        if (n != 0) {
            return n;
        }
        return this.compareStrings(this.packageName, typeDescription.packageName);
    }

    public synchronized Icon getIcon() {
        return this.icon;
    }

    private int compareStrings(String string, String string2) {
        if (string == null) {
            string = EMPTY_STRING;
        }
        if (string2 == null) {
            string2 = EMPTY_STRING;
        }
        return string.compareTo(string2);
    }
}

