/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source;

import java.io.IOException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.timers.TimesCollector;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Registry;
import org.netbeans.modules.java.source.JavaSourceAccessor;
import org.netbeans.modules.java.source.usages.RepositoryUpdater;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;

public class ActivatedDocumentListener
implements ChangeListener {
    private static ActivatedDocumentListener INSTANCE;
    private FileObject lastValidFile;
    public static boolean IGNORE_COMPILE_REQUESTS;

    public static void register() {
        INSTANCE = new ActivatedDocumentListener();
    }

    private ActivatedDocumentListener() {
        Registry.addChangeListener((ChangeListener)this);
    }

    public synchronized void stateChanged(ChangeEvent changeEvent) {
        JavaSource javaSource;
        BaseDocument baseDocument = Registry.getMostActiveDocument();
        if (baseDocument == null) {
            return;
        }
        Object object = baseDocument.getProperty("stream");
        if (!(object instanceof DataObject)) {
            return;
        }
        DataObject dataObject = (DataObject)object;
        if (dataObject == null) {
            return;
        }
        FileObject fileObject = dataObject.getPrimaryFile();
        if (this.lastValidFile == fileObject) {
            return;
        }
        if (this.lastValidFile != null) {
            if (!IGNORE_COMPILE_REQUESTS && (javaSource = ClassPath.getClassPath((FileObject)this.lastValidFile, (String)"classpath/source")) != null) {
                FileObject fileObject2 = javaSource.findOwnerRoot(this.lastValidFile);
                assert (fileObject2 != null);
                try {
                    if ("file".equals(this.lastValidFile.getURL().getProtocol())) {
                        RepositoryUpdater.getDefault().scheduleCompilation(this.lastValidFile, fileObject2);
                    }
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
            this.lastValidFile = null;
        }
        if ((javaSource = JavaSource.forFileObject(fileObject)) == null) {
            return;
        }
        this.lastValidFile = fileObject;
        TimesCollector.getDefault().select(fileObject);
        JavaSourceAccessor.INSTANCE.revalidate(javaSource);
    }

    static {
        IGNORE_COMPILE_REQUESTS = false;
    }
}

