/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source;

import com.sun.javadoc.ClassDoc;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Position;
import com.sun.tools.javadoc.AnnotationTypeDocImpl;
import com.sun.tools.javadoc.AnnotationTypeElementDocImpl;
import com.sun.tools.javadoc.ClassDocImpl;
import com.sun.tools.javadoc.ConstructorDocImpl;
import com.sun.tools.javadoc.DocEnv;
import com.sun.tools.javadoc.ExecutableMemberDocImpl;
import com.sun.tools.javadoc.FieldDocImpl;
import com.sun.tools.javadoc.MethodDocImpl;
import com.sun.tools.javadoc.ModifierFilter;
import com.sun.tools.javadoc.PackageDocImpl;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.lang.model.element.Element;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class JavadocEnv
extends DocEnv {
    private ClasspathInfo cpInfo;
    private Context ctx;

    public static void preRegister(final Context context, final ClasspathInfo classpathInfo) {
        context.put(docEnvKey, new Context.Factory<DocEnv>(){

            public DocEnv make() {
                return new JavadocEnv(context, classpathInfo);
            }
        });
    }

    private JavadocEnv(Context context, ClasspathInfo classpathInfo) {
        super(context);
        this.ctx = context;
        this.cpInfo = classpathInfo;
        this.showAccess = new ModifierFilter(-9223372036854775801L);
        this.legacyDoclet = false;
    }

    public ClassDocImpl getClassDoc(Symbol.ClassSymbol classSymbol) {
        Object object = (ClassDocImpl)this.classMap.get(classSymbol);
        if (object != null) {
            return object;
        }
        object = JavadocEnv.isAnnotationType((Symbol.ClassSymbol)classSymbol) ? new JavadocAnnotation((DocEnv)this, classSymbol) : new JavadocClass((DocEnv)this, classSymbol);
        this.classMap.put(classSymbol, object);
        return object;
    }

    protected void makeClassDoc(Symbol.ClassSymbol classSymbol, String string, JCTree.JCClassDecl jCClassDecl, Position.LineMap lineMap) {
        Object object = (ClassDocImpl)this.classMap.get(classSymbol);
        if (object != null) {
            if (string != null) {
                object.setRawCommentText(string);
            }
            return;
        }
        object = JavadocEnv.isAnnotationType((JCTree.JCClassDecl)jCClassDecl) ? new JavadocAnnotation(this, classSymbol, string) : new JavadocClass(this, classSymbol, string);
        this.classMap.put(classSymbol, object);
    }

    public FieldDocImpl getFieldDoc(Symbol.VarSymbol varSymbol) {
        FieldDocImpl fieldDocImpl = (FieldDocImpl)this.fieldMap.get(varSymbol);
        if (fieldDocImpl != null) {
            return fieldDocImpl;
        }
        fieldDocImpl = new JavadocField((DocEnv)this, varSymbol);
        this.fieldMap.put(varSymbol, fieldDocImpl);
        return fieldDocImpl;
    }

    protected void makeFieldDoc(Symbol.VarSymbol varSymbol, String string, JCTree.JCVariableDecl jCVariableDecl, Position.LineMap lineMap) {
        FieldDocImpl fieldDocImpl = (FieldDocImpl)this.fieldMap.get(varSymbol);
        if (fieldDocImpl != null) {
            if (string != null) {
                fieldDocImpl.setRawCommentText(string);
            }
        } else {
            fieldDocImpl = new JavadocField(this, varSymbol, string);
            this.fieldMap.put(varSymbol, fieldDocImpl);
        }
    }

    public MethodDocImpl getMethodDoc(Symbol.MethodSymbol methodSymbol) {
        ExecutableMemberDocImpl executableMemberDocImpl = (ExecutableMemberDocImpl)this.methodMap.get(methodSymbol);
        if (executableMemberDocImpl != null && !executableMemberDocImpl.isMethod()) {
            return null;
        }
        MethodDocImpl methodDocImpl = (MethodDocImpl)executableMemberDocImpl;
        if (methodDocImpl != null) {
            return methodDocImpl;
        }
        methodDocImpl = new JavadocMethod((DocEnv)this, methodSymbol);
        this.methodMap.put(methodSymbol, methodDocImpl);
        return methodDocImpl;
    }

    protected void makeMethodDoc(Symbol.MethodSymbol methodSymbol, String string, JCTree.JCMethodDecl jCMethodDecl, Position.LineMap lineMap) {
        MethodDocImpl methodDocImpl = (MethodDocImpl)this.methodMap.get(methodSymbol);
        if (methodDocImpl != null) {
            if (string != null) {
                methodDocImpl.setRawCommentText(string);
            }
        } else {
            methodDocImpl = new JavadocMethod(this, methodSymbol, string);
            this.methodMap.put(methodSymbol, methodDocImpl);
        }
    }

    public ConstructorDocImpl getConstructorDoc(Symbol.MethodSymbol methodSymbol) {
        ConstructorDocImpl constructorDocImpl = (ConstructorDocImpl)this.methodMap.get(methodSymbol);
        if (constructorDocImpl != null) {
            return constructorDocImpl;
        }
        constructorDocImpl = new JavadocConstructor((DocEnv)this, methodSymbol);
        this.methodMap.put(methodSymbol, constructorDocImpl);
        return constructorDocImpl;
    }

    protected void makeConstructorDoc(Symbol.MethodSymbol methodSymbol, String string, JCTree.JCMethodDecl jCMethodDecl, Position.LineMap lineMap) {
        ConstructorDocImpl constructorDocImpl = (ConstructorDocImpl)this.methodMap.get(methodSymbol);
        if (constructorDocImpl != null) {
            if (string != null) {
                constructorDocImpl.setRawCommentText(string);
            }
        } else {
            constructorDocImpl = new JavadocConstructor(this, methodSymbol, string);
            this.methodMap.put(methodSymbol, constructorDocImpl);
        }
    }

    public AnnotationTypeElementDocImpl getAnnotationTypeElementDoc(Symbol.MethodSymbol methodSymbol) {
        AnnotationTypeElementDocImpl annotationTypeElementDocImpl = (AnnotationTypeElementDocImpl)this.methodMap.get(methodSymbol);
        if (annotationTypeElementDocImpl != null) {
            return annotationTypeElementDocImpl;
        }
        annotationTypeElementDocImpl = new JavadocAnnotationTypeElement((DocEnv)this, methodSymbol);
        this.methodMap.put(methodSymbol, annotationTypeElementDocImpl);
        return annotationTypeElementDocImpl;
    }

    protected void makeAnnotationTypeElementDoc(Symbol.MethodSymbol methodSymbol, String string, JCTree.JCMethodDecl jCMethodDecl, Position.LineMap lineMap) {
        AnnotationTypeElementDocImpl annotationTypeElementDocImpl = (AnnotationTypeElementDocImpl)this.methodMap.get(methodSymbol);
        if (annotationTypeElementDocImpl != null) {
            if (string != null) {
                annotationTypeElementDocImpl.setRawCommentText(string);
            }
        } else {
            annotationTypeElementDocImpl = new JavadocAnnotationTypeElement(this, methodSymbol, string);
            this.methodMap.put(methodSymbol, annotationTypeElementDocImpl);
        }
    }

    public PackageDocImpl getPackageDoc(Symbol.PackageSymbol packageSymbol) {
        PackageDocImpl packageDocImpl = (PackageDocImpl)this.packageMap.get(packageSymbol);
        if (packageDocImpl != null) {
            return packageDocImpl;
        }
        packageDocImpl = new JavaDocPackage(this, packageSymbol, this.ctx);
        this.packageMap.put(packageSymbol, packageDocImpl);
        return packageDocImpl;
    }

    public ClassDocImpl lookupClass(String string) {
        ClassDocImpl classDocImpl = super.lookupClass(string);
        if (classDocImpl == null) {
            classDocImpl = this.loadClass(string);
        }
        return classDocImpl;
    }

    private String getRawCommentFor(Element element) {
        try {
            JavaSource javaSource;
            FileObject fileObject = SourceUtils.getFile(element, this.cpInfo);
            if (fileObject != null && (javaSource = JavaSource.forFileObject(fileObject)) != null) {
                final String[] stringArray = new String[1];
                final ElementHandle<Element> elementHandle = ElementHandle.create(element);
                javaSource.runUserActionTask(new CancellableTask<CompilationController>(){

                    @Override
                    public void cancel() {
                    }

                    @Override
                    public void run(CompilationController compilationController) throws Exception {
                        compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        Object t = elementHandle.resolve(compilationController);
                        if (t != null) {
                            stringArray[0] = compilationController.getElements().getDocComment((Element)t);
                        }
                    }
                }, true);
                return stringArray[0] != null ? stringArray[0] : "";
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return "";
    }

    public static interface ElementHolder {
        public Element getElement();
    }

    private class JavaDocPackage
    extends PackageDocImpl
    implements ElementHolder {
        private JavaDocPackage(DocEnv docEnv, Symbol.PackageSymbol packageSymbol, Context context) {
            super(docEnv, packageSymbol);
        }

        public ClassDoc findClass(String string) {
            Name.Table table = Name.Table.instance((Context)JavadocEnv.this.ctx);
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            Symbol.TypeSymbol typeSymbol = this.sym;
            block0: while (typeSymbol != null && stringTokenizer.hasMoreTokens()) {
                Name name = table.fromString(stringTokenizer.nextToken());
                Scope.Entry entry = typeSymbol.members().lookup(name);
                typeSymbol = null;
                while (entry.scope != null) {
                    if (entry.sym.kind == 2 && (entry.sym.flags_field & 0x1000L) == 0L) {
                        typeSymbol = (Symbol.TypeSymbol)entry.sym;
                        continue block0;
                    }
                    entry = entry.next();
                }
            }
            return typeSymbol instanceof Symbol.ClassSymbol ? this.env.getClassDoc((Symbol.ClassSymbol)typeSymbol) : null;
        }

        public Element getElement() {
            return this.sym;
        }
    }

    private class JavadocAnnotation
    extends AnnotationTypeDocImpl
    implements ElementHolder {
        private JavadocAnnotation(DocEnv docEnv, Symbol.ClassSymbol classSymbol) {
            this(docEnv, classSymbol, (String)null);
        }

        private JavadocAnnotation(DocEnv docEnv, Symbol.ClassSymbol classSymbol, String string) {
            super(docEnv, classSymbol, string, null, null);
        }

        protected String documentation() {
            if (this.documentation == null) {
                this.setRawCommentText(JavadocEnv.this.getRawCommentFor(this.getElement()));
            }
            return this.documentation;
        }

        public Element getElement() {
            return this.tsym;
        }
    }

    private class JavadocAnnotationTypeElement
    extends AnnotationTypeElementDocImpl
    implements ElementHolder {
        private JavadocAnnotationTypeElement(DocEnv docEnv, Symbol.MethodSymbol methodSymbol) {
            this(docEnv, methodSymbol, (String)null);
        }

        private JavadocAnnotationTypeElement(DocEnv docEnv, Symbol.MethodSymbol methodSymbol, String string) {
            super(docEnv, methodSymbol, string, null, null);
        }

        protected String documentation() {
            if (this.documentation == null) {
                this.setRawCommentText(JavadocEnv.this.getRawCommentFor(this.getElement()));
            }
            return this.documentation;
        }

        public Element getElement() {
            return this.sym;
        }
    }

    private class JavadocClass
    extends ClassDocImpl
    implements ElementHolder {
        private JavadocClass(DocEnv docEnv, Symbol.ClassSymbol classSymbol) {
            this(docEnv, classSymbol, (String)null);
        }

        private JavadocClass(DocEnv docEnv, Symbol.ClassSymbol classSymbol, String string) {
            super(docEnv, classSymbol, string, null, null);
        }

        protected String documentation() {
            if (this.documentation == null) {
                this.setRawCommentText(JavadocEnv.this.getRawCommentFor(this.getElement()));
            }
            return this.documentation;
        }

        public Element getElement() {
            return this.tsym;
        }
    }

    private class JavadocConstructor
    extends ConstructorDocImpl
    implements ElementHolder {
        private JavadocConstructor(DocEnv docEnv, Symbol.MethodSymbol methodSymbol) {
            this(docEnv, methodSymbol, (String)null);
        }

        private JavadocConstructor(DocEnv docEnv, Symbol.MethodSymbol methodSymbol, String string) {
            super(docEnv, methodSymbol, string, null, null);
        }

        protected String documentation() {
            if (this.documentation == null) {
                this.setRawCommentText(JavadocEnv.this.getRawCommentFor(this.getElement()));
            }
            return this.documentation;
        }

        public Element getElement() {
            return this.sym;
        }
    }

    private class JavadocField
    extends FieldDocImpl
    implements ElementHolder {
        private JavadocField(DocEnv docEnv, Symbol.VarSymbol varSymbol) {
            this(docEnv, varSymbol, (String)null);
        }

        private JavadocField(DocEnv docEnv, Symbol.VarSymbol varSymbol, String string) {
            super(docEnv, varSymbol, string, null, null);
        }

        protected String documentation() {
            if (this.documentation == null) {
                this.setRawCommentText(JavadocEnv.this.getRawCommentFor(this.getElement()));
            }
            return this.documentation;
        }

        public Element getElement() {
            return this.sym;
        }
    }

    private class JavadocMethod
    extends MethodDocImpl
    implements ElementHolder {
        private JavadocMethod(DocEnv docEnv, Symbol.MethodSymbol methodSymbol) {
            this(docEnv, methodSymbol, (String)null);
        }

        private JavadocMethod(DocEnv docEnv, Symbol.MethodSymbol methodSymbol, String string) {
            super(docEnv, methodSymbol, string, null, null);
        }

        protected String documentation() {
            if (this.documentation == null) {
                this.setRawCommentText(JavadocEnv.this.getRawCommentFor(this.getElement()));
            }
            return this.documentation;
        }

        public Element getElement() {
            return this.sym;
        }
    }
}

