/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.builder;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;
import javax.tools.JavaFileObject;
import org.netbeans.api.java.source.transform.UndoEntry;
import org.netbeans.api.java.source.transform.UndoList;
import org.netbeans.modules.java.source.builder.ElementsService;
import org.netbeans.modules.java.source.builder.TreeFactory;
import org.netbeans.modules.java.source.builder.UndoListService;
import org.netbeans.modules.java.source.engine.ASTModel;
import org.netbeans.modules.java.source.engine.ReattributionException;
import org.netbeans.modules.java.source.engine.RootTree;
import org.netbeans.modules.java.source.engine.TreeFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ASTService
implements ASTModel {
    private RootTree root;
    private UndoList undoList;
    private TreeFactory treeFactory;
    private Name.Table names;
    private Symtab symtab;
    private ElementsService elements;
    private Source source;
    private Map<JavaFileObject, Map<JCTree, Integer>> endPosTables;
    private boolean reattribute = Boolean.getBoolean("jackpot.always.attribute");
    private static final Context.Key<ASTService> treeKey = new Context.Key();

    public static synchronized ASTService instance(Context context) {
        ASTService aSTService = context.get(treeKey);
        if (aSTService == null) {
            aSTService = new ASTService(context);
        }
        return aSTService;
    }

    protected ASTService(Context context) {
        context.put(treeKey, this);
        this.undoList = UndoListService.instance(context);
        this.treeFactory = TreeFactory.instance(context);
        this.names = Name.Table.instance((Context)context);
        this.symtab = Symtab.instance(context);
        this.elements = ElementsService.instance(context);
        this.source = Source.instance(context);
        this.endPosTables = new HashMap<JavaFileObject, Map<JCTree, Integer>>();
    }

    @Override
    public Tree getRoot() {
        return this.root;
    }

    @Override
    public void setRoot(final RootTree rootTree) throws ReattributionException {
        if (rootTree == this.root) {
            return;
        }
        this.undoList.addAndApply(new UndoEntry(){
            private final RootTree old;
            {
                this.old = ASTService.this.root;
            }

            @Override
            public void undo() {
                ASTService.this.root = this.old;
            }

            @Override
            public void redo() {
                ASTService.this.root = rootTree;
            }

            @Override
            public <T> T getOld(T t) {
                return (T)(t == rootTree ? this.old : null);
            }
        });
    }

    public Tree find(final Element element) {
        if (element == null) {
            return null;
        }
        final JCTree[] jCTreeArray = new JCTree[1];
        new TreeScanner<Void, Object>(){
            boolean found = false;

            @Override
            public Void scan(Tree tree, Object object) {
                if (!this.found && tree != null) {
                    boolean bl = this.found = TreeInfo.symbolFor((JCTree)tree) == element;
                    if (this.found) {
                        jCTreeArray[0] = (JCTree)tree;
                    } else {
                        super.scan(tree, null);
                    }
                }
                return null;
            }
        }.scan((Tree)this.root, (Object)null);
        return jCTreeArray[0];
    }

    public CompilationUnitTree findTopLevel(final String string) {
        final CompilationUnitTree[] compilationUnitTreeArray = new CompilationUnitTree[1];
        new TreeScanner<Void, Object>(){

            @Override
            public Void visitCompilationUnit(CompilationUnitTree compilationUnitTree, Object object) {
                if (compilationUnitTreeArray[0] == null && compilationUnitTree.getSourceFile().toUri().getPath().endsWith(string)) {
                    compilationUnitTreeArray[0] = (JCTree.JCCompilationUnit)compilationUnitTree;
                } else {
                    super.visitCompilationUnit(compilationUnitTree, object);
                }
                return null;
            }
        }.scan(this.root, null);
        return compilationUnitTreeArray[0];
    }

    @Override
    public CompilationUnitTree getTopLevel(Tree tree) {
        if (tree == null) {
            return null;
        }
        Tree[] treeArray = this.makePath(this.root, tree);
        for (int i = 0; i < treeArray.length; ++i) {
            if (!(treeArray[i] instanceof CompilationUnitTree)) continue;
            return (CompilationUnitTree)treeArray[i];
        }
        assert (tree instanceof RootTree);
        return null;
    }

    @Override
    public Element getElement(Tree tree) {
        if (tree == null) {
            return null;
        }
        switch (tree.getKind()) {
            case COMPILATION_UNIT: {
                return ((JCTree.JCCompilationUnit)tree).packge;
            }
            case CLASS: {
                return ((JCTree.JCClassDecl)tree).sym;
            }
            case METHOD: {
                return ((JCTree.JCMethodDecl)tree).sym;
            }
            case VARIABLE: {
                return ((JCTree.JCVariableDecl)tree).sym;
            }
            case MEMBER_SELECT: {
                return ((JCTree.JCFieldAccess)tree).sym;
            }
            case IDENTIFIER: {
                return ((JCTree.JCIdent)tree).sym;
            }
            case NEW_CLASS: {
                return ((JCTree.JCNewClass)tree).constructor;
            }
        }
        return null;
    }

    @Override
    public TypeMirror getType(Tree tree) {
        Element element;
        if (tree == null || tree instanceof RootTree) {
            return null;
        }
        TypeMirror typeMirror = ((JCTree)tree).type;
        if (typeMirror == null && (element = this.getElement(tree)) != null) {
            typeMirror = element.asType();
        }
        return typeMirror;
    }

    @Override
    public void setElement(Tree tree, Element element) {
        switch (((JCTree)tree).tag) {
            case 1: {
                ((JCTree.JCCompilationUnit)tree).packge = (Symbol.PackageSymbol)element;
                break;
            }
            case 3: {
                ((JCTree.JCClassDecl)tree).sym = (Symbol.ClassSymbol)element;
                break;
            }
            case 4: {
                ((JCTree.JCMethodDecl)tree).sym = (Symbol.MethodSymbol)element;
                break;
            }
            case 5: {
                ((JCTree.JCVariableDecl)tree).sym = (Symbol.VarSymbol)element;
                break;
            }
            case 34: {
                ((JCTree.JCFieldAccess)tree).sym = (Symbol)element;
                break;
            }
            case 35: {
                ((JCTree.JCIdent)tree).sym = (Symbol)element;
                break;
            }
            case 27: {
                ((JCTree.JCNewClass)tree).constructor = (Symbol)element;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid tree type: " + (Object)((Object)tree.getKind()));
            }
        }
    }

    @Override
    public void setType(Tree tree, TypeMirror typeMirror) {
        ((JCTree)tree).type = (Type)typeMirror;
    }

    @Override
    public boolean isThis(IdentifierTree identifierTree) {
        return identifierTree instanceof IdentifierTree && ASTService.isThis(((JCTree.JCIdent)identifierTree).name);
    }

    private static boolean isThis(Name name) {
        return name == name.table._this;
    }

    @Override
    public boolean isThis(Element element) {
        return element != null ? ASTService.isThis(((Symbol)element).name) : false;
    }

    @Override
    public boolean isSynthetic(Tree tree) {
        if (tree == null) {
            return false;
        }
        long l = 0L;
        JCTree jCTree = (JCTree)tree;
        switch (jCTree.tag) {
            case 3: {
                l = ((JCTree.JCClassDecl)jCTree).mods.flags;
                break;
            }
            case 4: {
                l = ((JCTree.JCMethodDecl)jCTree).mods.flags;
                break;
            }
            case 5: {
                l = ((JCTree.JCVariableDecl)jCTree).mods.flags;
                break;
            }
            case 7: {
                if (jCTree.pos == -1) {
                    return true;
                }
                l = ((JCTree.JCBlock)jCTree).flags;
                break;
            }
            case 44: {
                if (jCTree.pos != -1) break;
                return true;
            }
        }
        return (l & 0x1000L) != 0L;
    }

    @Override
    public Tree[] makePath(Tree tree, Tree tree2) {
        final Stack stack = new Stack();
        tree.accept(new TreeFinder(tree2){

            public Boolean scan(Tree tree, Object object) {
                super.scan(tree, object);
                if (this.found) {
                    stack.push(tree);
                }
                return this.found;
            }
        }, null);
        Tree[] treeArray = new Tree[stack.size()];
        for (int i = 0; i < treeArray.length; ++i) {
            treeArray[i] = (Tree)stack.pop();
        }
        return treeArray;
    }

    @Override
    public int getPos(Tree tree) {
        if (tree == null) {
            return -1;
        }
        return ((JCTree)tree).pos;
    }

    @Override
    public int getStartPos(Tree tree) {
        if (tree == null) {
            return -1;
        }
        switch (((JCTree)tree).tag) {
            case 26: {
                return this.getStartPos(((JCTree.JCMethodInvocation)tree).meth);
            }
            case 30: {
                return this.getStartPos(((JCTree.JCAssign)tree).lhs);
            }
            case 74: 
            case 75: 
            case 76: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: {
                return this.getStartPos(((JCTree.JCAssignOp)tree).lhs);
            }
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                return this.getStartPos(((JCTree.JCBinary)tree).lhs);
            }
            case 3: {
                JCTree.JCClassDecl jCClassDecl = (JCTree.JCClassDecl)tree;
                if (jCClassDecl.mods.pos == -1) break;
                return jCClassDecl.mods.pos;
            }
            case 18: {
                return this.getStartPos(((JCTree.JCConditional)tree).cond);
            }
            case 20: {
                return this.getStartPos(((JCTree.JCExpressionStatement)tree).expr);
            }
            case 33: {
                return this.getStartPos(((JCTree.JCArrayAccess)tree).indexed);
            }
            case 4: {
                JCTree.JCMethodDecl jCMethodDecl = (JCTree.JCMethodDecl)tree;
                if (jCMethodDecl.mods.pos != -1) {
                    return jCMethodDecl.mods.pos;
                }
                if (jCMethodDecl.restype != null) {
                    return this.getStartPos(jCMethodDecl.restype);
                }
                return jCMethodDecl.pos;
            }
            case 34: {
                return this.getStartPos(((JCTree.JCFieldAccess)tree).selected);
            }
            case 39: {
                return this.getStartPos(((JCTree.JCTypeApply)tree).clazz);
            }
            case 38: {
                return this.getStartPos(((JCTree.JCArrayTypeTree)tree).elemtype);
            }
            case 32: {
                return this.getStartPos(((JCTree.JCInstanceOf)tree).expr);
            }
            case 52: 
            case 53: {
                return this.getStartPos(((JCTree.JCUnary)tree).arg);
            }
            case 5: {
                JCTree.JCVariableDecl jCVariableDecl = (JCTree.JCVariableDecl)tree;
                if (jCVariableDecl.mods.pos != -1) {
                    return jCVariableDecl.mods.pos;
                }
                return this.getStartPos(jCVariableDecl.vartype);
            }
        }
        return ((JCTree)tree).pos;
    }

    @Override
    public int getEndPos(Tree tree, CompilationUnitTree compilationUnitTree) {
        Map<JCTree, Integer> map;
        Map<JCTree, Integer> map2 = map = compilationUnitTree != null ? this.endPosTables.get(compilationUnitTree.getSourceFile()) : null;
        if (tree == null || map == null) {
            return -1;
        }
        Integer n = map.get(tree);
        if (n != null) {
            return n;
        }
        JCTree jCTree = (JCTree)tree;
        switch (jCTree.tag) {
            case 74: 
            case 75: 
            case 76: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: {
                return this.getEndPos(((JCTree.JCAssignOp)tree).rhs, compilationUnitTree);
            }
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                return this.getEndPos(((JCTree.JCBinary)tree).rhs, compilationUnitTree);
            }
            case 14: {
                return this.getEndPos(((JCTree.JCCase)tree).stats.last(), compilationUnitTree);
            }
            case 17: {
                return this.getEndPos(((JCTree.JCCatch)tree).body, compilationUnitTree);
            }
            case 20: {
                return this.getEndPos(((JCTree.JCExpressionStatement)tree).expr, compilationUnitTree);
            }
            case 18: {
                return this.getEndPos(((JCTree.JCConditional)tree).falsepart, compilationUnitTree);
            }
            case 10: {
                if (tree instanceof JCTree.JCForLoop) {
                    return this.getEndPos(((JCTree.JCForLoop)tree).body, compilationUnitTree);
                }
                return this.getEndPos(((JCTree.JCEnhancedForLoop)tree).body, compilationUnitTree);
            }
            case 35: {
                return jCTree.pos + ((JCTree.JCIdent)tree).name.len;
            }
            case 19: {
                JCTree.JCIf jCIf = (JCTree.JCIf)tree;
                if (jCIf.elsepart == null) {
                    return this.getEndPos(jCIf.thenpart, compilationUnitTree);
                }
                return this.getEndPos(jCIf.elsepart, compilationUnitTree);
            }
            case 11: {
                return this.getEndPos(((JCTree.JCEnhancedForLoop)tree).body, compilationUnitTree);
            }
            case 12: {
                return this.getEndPos(((JCTree.JCLabeledStatement)tree).body, compilationUnitTree);
            }
            case 44: {
                return this.getEndPos(((JCTree.JCModifiers)tree).annotations.last(), compilationUnitTree);
            }
            case 34: {
                JCTree.JCFieldAccess jCFieldAccess = (JCTree.JCFieldAccess)tree;
                return this.getEndPos(jCFieldAccess.selected, compilationUnitTree) + 1 + jCFieldAccess.name.len;
            }
            case 15: {
                return this.getEndPos(((JCTree.JCSynchronized)tree).body, compilationUnitTree);
            }
            case 1: {
                return this.getEndPos(((JCTree.JCCompilationUnit)tree).defs.last(), compilationUnitTree);
            }
            case 16: {
                JCTree.JCTry jCTry = (JCTree.JCTry)tree;
                if (jCTry.finalizer == null) {
                    return this.getEndPos(jCTry.catchers.last(), compilationUnitTree);
                }
                return this.getEndPos(jCTry.finalizer, compilationUnitTree);
            }
            case 31: {
                return this.getEndPos(((JCTree.JCTypeCast)tree).expr, compilationUnitTree);
            }
            case 32: {
                return this.getEndPos(((JCTree.JCInstanceOf)tree).clazz, compilationUnitTree);
            }
            case 41: {
                return this.getEndPos(((JCTree.JCWildcard)tree).inner, compilationUnitTree);
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                return this.getEndPos(((JCTree.JCUnary)tree).arg, compilationUnitTree);
            }
            case 9: {
                return this.getEndPos(((JCTree.JCWhileLoop)tree).body, compilationUnitTree);
            }
        }
        return -1;
    }

    private Tree findChild(Tree tree, Symbol symbol) {
        for (Tree tree2 : this.getChildren(tree)) {
            if (this.getElement(tree2) != symbol) continue;
            return tree2;
        }
        return null;
    }

    private Symbol findChild(Symbol symbol, String string, String[] stringArray) {
        Scope scope = symbol.members();
        Scope.Entry entry = scope.lookup(this.names.fromString(string));
        if (entry != null && stringArray != null) {
            while (entry.scope == scope) {
                Symbol.MethodSymbol methodSymbol;
                if (entry.sym instanceof Symbol.MethodSymbol && this.compareParams((methodSymbol = (Symbol.MethodSymbol)entry.sym).params(), stringArray)) {
                    return methodSymbol;
                }
                entry = entry.next();
            }
            return null;
        }
        return entry != null ? entry.sym : null;
    }

    private boolean compareParams(List<Symbol.VarSymbol> list, String[] stringArray) {
        if (list.size() != stringArray.length) {
            return false;
        }
        int n = 0;
        for (Symbol.VarSymbol varSymbol : list) {
            String string;
            String string2 = varSymbol.type.toString();
            if (string2.equals(string = stringArray[n++])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isStatic(Tree tree) {
        if (tree == null) {
            return false;
        }
        Symbol symbol = (Symbol)this.getElement(tree);
        return symbol != null ? (symbol.flags() & 8L) != 0L : false;
    }

    @Override
    public int getInstanceReferenceCount(Tree tree) {
        if (tree == null) {
            return 0;
        }
        return this.elements.getCharacterization(this.getElement(tree)).getThisUseCount();
    }

    @Override
    public void setPos(Tree tree, int n) {
        ((JCTree)tree).pos = n;
    }

    @Override
    public SourceVersion sourceVersion() {
        return Source.toSourceVersion(this.source);
    }

    public void setEndPosTable(JavaFileObject javaFileObject, Map<JCTree, Integer> map) {
        this.endPosTables.put(javaFileObject, map);
    }

    @Override
    public java.util.List<? extends Tree> getChildren(Tree tree) {
        if (tree instanceof RootTree) {
            return ((RootTree)tree).getCompilationUnits();
        }
        if (tree instanceof CompilationUnitTree) {
            return ((CompilationUnitTree)tree).getTypeDecls();
        }
        if (tree instanceof ClassTree) {
            return ((ClassTree)tree).getMembers();
        }
        return Collections.emptyList();
    }
}

