/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.builder;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import org.netbeans.modules.java.source.builder.BufferRun;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BufferRunQueue
implements Iterable<BufferRun> {
    private ArrayList<BufferRun> runs = new ArrayList();
    private SortedMap<Integer, Integer> positionMap = new TreeMap<Integer, Integer>();
    private SortedMap<Integer, Integer> endPositionMap = new TreeMap<Integer, Integer>();
    private int next;

    void add(BufferRun bufferRun) {
        this.runs.add(bufferRun);
        int n = this.runs.size() - 1;
        this.positionMap.put(bufferRun.start, n);
        this.endPositionMap.put(bufferRun.end, n);
    }

    void addCoallescing(BufferRun bufferRun) {
        int n;
        if (bufferRun.kind == BufferRun.Kind.WHITESPACE && (n = this.runs.size()) > 0) {
            BufferRun bufferRun2 = this.runs.get(n - 1);
            if (bufferRun2.kind == BufferRun.Kind.WHITESPACE && bufferRun2.end == bufferRun.start) {
                bufferRun2.end = bufferRun.end;
                return;
            }
        }
        this.runs.add(bufferRun);
    }

    @Override
    public Iterator<BufferRun> iterator() {
        return new Iterator<BufferRun>(){
            int next = 0;

            @Override
            public boolean hasNext() {
                return this.next < BufferRunQueue.this.runs.size();
            }

            @Override
            public BufferRun next() {
                return BufferRunQueue.this.get(this.next++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public int size() {
        return this.runs.size();
    }

    public BufferRun get(int n) {
        return this.runs.get(n);
    }

    public int findRunStartingAt(int n) {
        Integer n2 = (Integer)this.positionMap.get(n);
        return n2 == null ? -1 : n2;
    }

    public int findRunEndingWith(int n) {
        Integer n2 = (Integer)this.endPositionMap.get(n);
        return n2 == null ? -1 : n2;
    }

    public BufferRun[] toArray() {
        return this.runs.toArray(new BufferRun[0]);
    }

    public void reset() {
        this.next = 0;
    }

    public int getPos() {
        return this.next;
    }

    public boolean hasNext() {
        return this.next < this.runs.size();
    }

    public BufferRun peekNext() {
        return this.next < this.runs.size() ? this.runs.get(this.next) : null;
    }

    public BufferRun getNext() {
        return this.next < this.runs.size() ? this.runs.get(this.next++) : null;
    }

    public BufferRun getNextBefore(int n) {
        BufferRun bufferRun;
        if (this.next < this.runs.size() && (bufferRun = this.runs.get(this.next)).getEnd() <= n) {
            ++this.next;
            return bufferRun;
        }
        return null;
    }

    public void unget() {
        if (this.next > 0) {
            --this.next;
        }
    }
}

