/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.builder;

import com.sun.source.util.JavacTask;
import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Options;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.tools.JavaFileObject;
import org.netbeans.api.java.source.query.Query;
import org.netbeans.api.java.source.query.ResultTableModel;
import org.netbeans.api.java.source.transform.ChangeSet;
import org.netbeans.api.java.source.transform.Transformer;
import org.netbeans.api.java.source.transform.UndoList;
import org.netbeans.modules.classfile.ClassFile;
import org.netbeans.modules.java.source.builder.Builder;
import org.netbeans.modules.java.source.builder.DefaultEnvironment;
import org.netbeans.modules.java.source.builder.MultiTransformer;
import org.netbeans.modules.java.source.engine.ApplicationContext;
import org.netbeans.modules.java.source.engine.BuildProgress;
import org.netbeans.modules.java.source.engine.EmptyScriptException;
import org.netbeans.modules.java.source.engine.EngineEnvironment;
import org.netbeans.modules.java.source.engine.EngineException;
import org.netbeans.modules.java.source.engine.JackpotEngine;
import org.netbeans.modules.java.source.engine.JavaFormatOptions;
import org.netbeans.modules.java.source.engine.PropertySheetInfo;
import org.netbeans.modules.java.source.engine.QueryProgress;
import org.netbeans.modules.java.source.engine.RecursiveRuleException;
import org.netbeans.modules.java.source.engine.RulesParseException;
import org.netbeans.modules.java.source.pretty.VeryPretty;
import org.netbeans.modules.java.source.save.Commit;
import org.netbeans.modules.java.source.script.TransformParser;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;

public class Engine
implements JackpotEngine {
    private EngineEnvironment env;
    ApplicationContext appContext;
    private boolean buildFinished;
    private String jackpotPath;
    static final Logger logger = Logger.getLogger("org.netbeans.modules.java.source");

    public Engine(ApplicationContext applicationContext, String string) {
        this.appContext = applicationContext;
        applicationContext.setStatusMessage("");
        this.jackpotPath = string;
    }

    public int initialize(String string, String string2, String string3) throws Exception {
        return this.initialize(string, string2, null, string3);
    }

    public int initialize(String string, String string2, String string3, String string4) throws Exception {
        return this.initialize(string, string2, string3, string4, null);
    }

    public int initialize(String string, String string2, String string3, String string4, String string5) throws Exception {
        if (this.buildFinished) {
            throw new AssertionError((Object)"engine already initialized");
        }
        JavacTaskImpl javacTaskImpl = Builder.createJavacTask(string, string2, string3, string4, string5);
        this.env = new DefaultEnvironment((JavacTask)javacTaskImpl, this.appContext, string4);
        BuildProgress buildProgress = this.appContext.getBuildProgress();
        Builder builder = new Builder(javacTaskImpl, this.getPaths(string), buildProgress);
        int n = 0;
        try {
            n = builder.build();
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.env = null;
            System.gc();
            throw outOfMemoryError;
        }
        finally {
            buildProgress.dispose();
        }
        this.buildFinished = true;
        return n;
    }

    private String[] getPaths(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n++] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    public boolean isInitialized() {
        return this.buildFinished;
    }

    public ResultTableModel runCommand(String string, String string2) throws Exception {
        return this.runCommand(string, null, string2);
    }

    public ResultTableModel runCommand(String string, String string2, String string3) throws Exception {
        Query query = null;
        QueryProgress queryProgress = this.appContext.getQueryProgress();
        queryProgress.setTotalQueries(1);
        try {
            query = this.createCommand(string, string2, string3);
            if (this.appContext.setProperties(query, string)) {
                queryProgress.queryStarted(string);
                query.init();
                query.attach(this.env);
                query.apply();
                query.release();
                query.destroy();
                queryProgress.queryFinished();
            }
            ResultTableModel resultTableModel = query.getResult();
            return resultTableModel;
        }
        catch (EmptyScriptException emptyScriptException) {
            throw emptyScriptException;
        }
        catch (RulesParseException rulesParseException) {
            throw rulesParseException;
        }
        catch (ThreadDeath threadDeath) {
            ResultTableModel resultTableModel = query != null ? query.getResult() : null;
            return resultTableModel;
        }
        catch (Throwable throwable) {
            throw new EngineException("Error executing operator", throwable);
        }
        finally {
            queryProgress.dispose();
        }
    }

    public ResultTableModel runCommands(String string, Query[] queryArray) throws Exception {
        MultiTransformer multiTransformer = null;
        QueryProgress queryProgress = this.appContext.getQueryProgress();
        try {
            multiTransformer = new MultiTransformer(string, queryArray, queryProgress);
            multiTransformer.init();
            multiTransformer.attach(this.env);
            multiTransformer.apply();
            ResultTableModel resultTableModel = multiTransformer.getResult();
            multiTransformer.release();
            ResultTableModel resultTableModel2 = resultTableModel;
            return resultTableModel2;
        }
        catch (EmptyScriptException emptyScriptException) {
            throw emptyScriptException;
        }
        catch (RulesParseException rulesParseException) {
            throw rulesParseException;
        }
        catch (ThreadDeath threadDeath) {
            ResultTableModel resultTableModel = multiTransformer != null ? multiTransformer.getResult() : null;
            return resultTableModel;
        }
        catch (Throwable throwable) {
            throw new EngineException("Error executing operator", throwable);
        }
        finally {
            multiTransformer.destroy();
            queryProgress.dispose();
        }
    }

    public Query createCommand(String string, String string2, String string3) throws Exception {
        Class clazz = this.createQueryClass(string3);
        Object t = clazz.newInstance();
        if (!(t instanceof Query)) {
            throw new EngineException("I don't know how to handle " + clazz);
        }
        Query query = (Query)t;
        query.setQueryDescription(string);
        if (query instanceof Transformer && string2 != null) {
            ((Transformer)query).setRefactoringDescription(string2);
        }
        return query;
    }

    public Transformer createScript(String string, String string2, String string3) throws Exception {
        Object object;
        long l;
        InputStream inputStream;
        FileObject fileObject;
        if (string3.startsWith("file:")) {
            string3 = string3.substring(5);
        }
        if ((fileObject = Repository.getDefault().getDefaultFileSystem().findResource(string3)) != null) {
            inputStream = fileObject.getInputStream();
            l = fileObject.lastModified().getTime();
        } else {
            object = new File(string3);
            inputStream = new FileInputStream((File)object);
            l = ((File)object).lastModified();
        }
        object = new InputStreamReader(inputStream);
        Class clazz = this.createScriptClass(string3, string, string2, (Reader)object, l);
        Object t = clazz.newInstance();
        if (!(t instanceof Transformer)) {
            throw new EngineException("I don't know how to handle " + clazz);
        }
        return (Transformer)t;
    }

    public ResultTableModel runScript(String string, String string2, String string3) throws Exception {
        QueryProgress queryProgress = this.appContext.getQueryProgress();
        queryProgress.setTotalQueries(1);
        try {
            Transformer transformer = this.createScript(string, string2, string3);
            if (this.appContext.setProperties(transformer, string)) {
                queryProgress.queryStarted(string);
                transformer.init();
                transformer.attach(this.env);
                transformer.apply();
                transformer.release();
                transformer.destroy();
                queryProgress.queryFinished();
            }
            ResultTableModel resultTableModel = transformer.getResult();
            return resultTableModel;
        }
        catch (RecursiveRuleException recursiveRuleException) {
            throw recursiveRuleException;
        }
        catch (EmptyScriptException emptyScriptException) {
            throw emptyScriptException;
        }
        catch (RulesParseException rulesParseException) {
            throw rulesParseException;
        }
        catch (Throwable throwable) {
            throw new EngineException("Error executing operator", throwable);
        }
        finally {
            queryProgress.dispose();
        }
    }

    private Class createScriptClass(String string, String string2, String string3, Reader reader, long l) throws Exception {
        Class clazz;
        TransformParser transformParser = new TransformParser(string, string2, string3, reader, l, this.jackpotPath);
        transformParser.parseRules();
        if (!transformParser.hasRules()) {
            throw new EmptyScriptException(string2);
        }
        if (transformParser.hasErrors()) {
            throw new RulesParseException(transformParser.getErrors());
        }
        Throwable throwable = null;
        try {
            clazz = transformParser.codeRules();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            clazz = null;
        }
        if (transformParser.hasErrors()) {
            throw new RulesParseException("script errors:\n" + transformParser.getErrors());
        }
        if (throwable != null) {
            throw new EngineException("script compilation failed", throwable);
        }
        return clazz;
    }

    private Class createQueryClass(String string) throws Exception {
        ClassLoader classLoader = new ClassLoader(this.getClass().getClassLoader()){

            public Class findClass(String string) throws ClassNotFoundException {
                if (string.endsWith(".class")) {
                    try {
                        if (string.startsWith("file://")) {
                            string = string.substring(7);
                        } else if (string.startsWith("file:")) {
                            string = string.substring(5);
                        }
                        FileInputStream fileInputStream = new FileInputStream(string);
                        int n = fileInputStream.available();
                        byte[] byArray = new byte[n];
                        int n2 = fileInputStream.read(byArray);
                        fileInputStream.close();
                        if (n2 != n) {
                            throw new ClassNotFoundException(string + ": read failure");
                        }
                        ClassFile classFile = new ClassFile(string);
                        return this.defineClass(classFile.getName().getExternalName(), byArray, 0, byArray.length);
                    }
                    catch (IOException iOException) {
                        throw new ClassNotFoundException("failed loading " + string, iOException);
                    }
                }
                Class<?> clazz = Engine.this.appContext.getCommandClass(string);
                return clazz == null ? super.findClass(string) : clazz;
            }
        };
        return classLoader.loadClass(string);
    }

    public void undo(boolean bl) {
        if (!this.buildFinished) {
            throw new AssertionError((Object)"engine not initialized");
        }
        UndoList undoList = this.env.getUndoList();
        undoList.undo();
        if (bl) {
            undoList.clearRedo();
        }
    }

    public void redo() {
        if (!this.buildFinished) {
            throw new AssertionError((Object)"engine not initialized");
        }
        this.env.getUndoList().redo();
    }

    public boolean canUndo() {
        return this.buildFinished ? this.env.getUndoList().canUndo() : false;
    }

    public boolean canRedo() {
        return this.buildFinished ? this.env.getUndoList().canRedo() : false;
    }

    public void applyChanges(final ChangeSet changeSet) {
        Transformer<Object, Object> transformer = new Transformer<Object, Object>(){

            @Override
            public void init() {
                super.init();
                this.changes = changeSet;
            }
        };
        transformer.init();
        transformer.attach(this.env);
        transformer.apply();
        transformer.release();
        transformer.destroy();
    }

    public boolean needsCommit() {
        if (!this.buildFinished) {
            return false;
        }
        Commit commit = new Commit();
        return commit.isEnabled(this.env);
    }

    public boolean commit() throws IOException {
        if (!this.buildFinished) {
            throw new AssertionError((Object)"engine not initialized");
        }
        Commit commit = new Commit();
        if (!commit.isEnabled(this.env)) {
            return true;
        }
        commit.init();
        commit.attach(this.env);
        commit.commit();
        commit.release();
        commit.destroy();
        return true;
    }

    public void close() {
        if (this.env != null) {
            UndoList undoList = this.env.getUndoList();
            undoList.reset();
        }
        this.env = null;
        this.appContext = null;
        this.jackpotPath = null;
        this.buildFinished = false;
    }

    public PropertySheetInfo getPropertySheetInfo(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            return PropertySheetInfo.find(clazz);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public JavaFormatOptions getFormatOptions() {
        return JavaFormatOptions.getDefault();
    }

    public String format(JavaFileObject javaFileObject, JavaFormatOptions javaFormatOptions) throws IOException {
        Context context = new Context();
        Options options = Options.instance(context);
        options.put("-source", "1.5");
        JavaCompiler javaCompiler = new JavaCompiler(context);
        Log.instance(context).useSource(javaFileObject);
        JCTree.JCCompilationUnit jCCompilationUnit = javaCompiler.parse(javaFileObject);
        VeryPretty veryPretty = new VeryPretty(context, javaFormatOptions);
        jCCompilationUnit.accept(veryPretty);
        return veryPretty.toString();
    }
}

