/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.builder;

import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.List;
import java.util.HashSet;
import javax.lang.model.element.Element;

class MethodCharacterization {
    final HashSet<? super Element> overridden = new HashSet();
    final HashSet<? super Element> overrides = new HashSet();

    public MethodCharacterization(final Types types, JCTree jCTree) {
        new TreeScanner(){

            public void visitMethodDef(JCTree.JCMethodDecl jCMethodDecl) {
                this.checkAll(jCMethodDecl.sym, jCMethodDecl.sym.owner.type);
            }

            private void checkAll(Symbol.MethodSymbol methodSymbol, Type type) {
                if (type.tag == 10) {
                    Object object;
                    if (type != methodSymbol.owner.type) {
                        object = type.tsym.members().lookup(methodSymbol.name);
                        while (((Scope.Entry)object).scope != null) {
                            if (methodSymbol.overrides(((Scope.Entry)object).sym, (Symbol.TypeSymbol)methodSymbol.owner, types, true)) {
                                MethodCharacterization.this.overridden.add(((Scope.Entry)object).sym);
                                MethodCharacterization.this.overrides.add(methodSymbol);
                            }
                            object = ((Scope.Entry)object).next();
                        }
                    }
                    object = types.interfaces(type.baseType());
                    while (((List)object).nonEmpty()) {
                        this.checkAll(methodSymbol, (Type)((List)object).head);
                        object = ((List)object).tail;
                    }
                    this.checkAll(methodSymbol, types.supertype(type.baseType()));
                }
            }
        }.scan(jCTree);
    }

    public boolean isOverridden(Element element) {
        return this.overridden.contains(element);
    }

    public boolean overrides(Element element) {
        return this.overrides.contains(element);
    }
}

