/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.builder;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.java.source.query.Query;
import org.netbeans.api.java.source.query.QueryEnvironment;
import org.netbeans.api.java.source.query.ResultTableModel;
import org.netbeans.api.java.source.transform.Transformer;
import org.netbeans.modules.java.source.engine.ASTModel;
import org.netbeans.modules.java.source.engine.EngineEnvironment;
import org.netbeans.modules.java.source.engine.QueryProgress;
import org.netbeans.modules.java.source.engine.ReattributionException;
import org.netbeans.modules.java.source.engine.RootTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MultiTransformer
extends Transformer<Object, Object> {
    ASTModel model;
    Query[] commands;
    List<ResultTableModel> resultsList;
    QueryProgress progressBar;
    int done;

    public MultiTransformer(String string, Query[] queryArray, QueryProgress queryProgress) throws Exception {
        this.setQueryDescription(string);
        this.commands = queryArray;
        this.resultsList = new ArrayList<ResultTableModel>();
        this.progressBar = queryProgress;
        this.progressBar.setTotalQueries(queryArray.length);
    }

    @Override
    public void init() {
        super.init();
        for (Query query : this.commands) {
            query.init();
        }
    }

    @Override
    public void attach(QueryEnvironment queryEnvironment) {
        super.attach(queryEnvironment);
        this.model = ((EngineEnvironment)queryEnvironment).getModel();
        for (Query query : this.commands) {
            query.attach(queryEnvironment);
        }
    }

    @Override
    public void release() {
        super.release();
        this.model = null;
        for (Query query : this.commands) {
            query.release();
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        this.resultsList = null;
        this.progressBar = null;
        for (Query query : this.commands) {
            query.destroy();
        }
    }

    @Override
    public void apply() {
        try {
            for (Query query : this.commands) {
                String string = query.getQueryDescription();
                this.progressBar.queryStarted(string);
                query.apply();
                if (query instanceof Transformer) {
                    this.changes.add(((Transformer)query).getChanges());
                }
                this.resultsList.add(query.getResult());
                this.progressBar.queryFinished();
            }
            RootTree reattributionException = this.commit((RootTree)this.model.getRoot());
            if (!this.translationSuccessful()) {
                this.result = null;
                this.env.setErrorMessage(this.getFailureMessage(), this.queryDescription);
            } else if (this.changes.hasChanges()) {
                this.model.setRoot(reattributionException);
            }
            this.show(this.resultsList.toArray(new ResultTableModel[0]), this.getQueryDescription());
        }
        catch (ReattributionException reattributionException) {
            this.error(reattributionException);
        }
    }
}

