/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.builder;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.netbeans.modules.java.source.builder.DefaultSourceFileFilter;
import org.netbeans.modules.java.source.builder.SourceFileFilter;
import org.netbeans.modules.java.source.engine.ElapsedTimer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceFileList {
    public static final String JAR_URL_PREFIX = "jar:/file:/";
    private static final SourceFileFilter allFilter = new DefaultSourceFileFilter();

    public static String[] findFiles(String[] stringArray) {
        return SourceFileList.findFiles(stringArray, allFilter, null);
    }

    public static String[] findFiles(String[] stringArray, Logger logger) {
        return SourceFileList.findFiles(stringArray, allFilter, logger);
    }

    public static String[] findFiles(String[] stringArray, SourceFileFilter sourceFileFilter) {
        return SourceFileList.findFiles(stringArray, sourceFileFilter, null);
    }

    public static String[] findFiles(String[] stringArray, SourceFileFilter sourceFileFilter, Logger logger) {
        ElapsedTimer elapsedTimer = new ElapsedTimer();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            SourceFileList.expand(null, stringArray[i], sourceFileFilter, arrayList);
        }
        String[] stringArray2 = arrayList.toArray(new String[0]);
        if (logger != null) {
            logger.fine("found " + Integer.toString(stringArray2.length) + " source files in " + elapsedTimer.toString());
        }
        return stringArray2;
    }

    private static void expand(File file, String string, SourceFileFilter sourceFileFilter, List<String> list) {
        File file2;
        File file3 = file2 = file != null ? new File(file, string) : new File(string);
        if (sourceFileFilter.acceptFile(string)) {
            String string2 = file2.getPath();
            if (!list.contains(string2)) {
                list.add(string2);
            }
            return;
        }
        if (string.endsWith(".jar") || string.endsWith(".zip")) {
            return;
        }
        String[] stringArray = file2.list();
        if (stringArray == null) {
            return;
        }
        for (String string3 : stringArray) {
            if (!sourceFileFilter.acceptDirectory(string3)) continue;
            SourceFileList.expand(file2, string3, sourceFileFilter, list);
        }
    }

    private static void expandZip(String string, SourceFileFilter sourceFileFilter, List<String> list) {
        try {
            ZipFile zipFile = new ZipFile(string);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                String string2 = zipEntry.getName();
                if (!sourceFileFilter.acceptFile(string2) || list.contains(string2 = JAR_URL_PREFIX + string + '!' + string2)) continue;
                list.add(string2);
            }
        }
        catch (IOException iOException) {
            System.err.println("failed reading zip file " + string + ": " + iOException);
        }
    }
}

