/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.builder;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Name;
import java.util.HashMap;
import javax.lang.model.element.TypeElement;
import org.netbeans.modules.java.source.builder.ElementsService;
import org.netbeans.modules.java.source.engine.ASTModel;

class VariableCharacterization {
    public static final int ASSIGN = 1;
    public static final int REFERENCE = 2;
    public static final int IDENT = 4;
    public static final int SELECT = 8;
    public static final int DECLARE = 16;
    public static final int PARAMETER = 32;
    int thisUseCount;
    private int allflags;
    private int allnotflags;
    final HashMap<Object, CNode> map = new HashMap();

    public VariableCharacterization(Tree tree, final ASTModel aSTModel, final ElementsService elementsService) {
        new TreeScanner<Void, Tree>(){
            Symbol.TypeSymbol owner = null;

            @Override
            public Void visitIdentifier(IdentifierTree identifierTree, Tree tree) {
                JCTree.JCIdent jCIdent = (JCTree.JCIdent)identifierTree;
                Symbol symbol = jCIdent.sym;
                this.checkBoth(jCIdent.name, symbol, 4 | this.parentContext(identifierTree, tree));
                if (aSTModel.isThis(jCIdent) || symbol != null && (symbol.kind & 3) == 0 && !symbol.isLocal()) {
                    ++VariableCharacterization.this.thisUseCount;
                }
                return null;
            }

            @Override
            public Void visitMemberSelect(MemberSelectTree memberSelectTree, Tree tree) {
                JCTree.JCFieldAccess jCFieldAccess = (JCTree.JCFieldAccess)memberSelectTree;
                this.checkBoth(jCFieldAccess.name, jCFieldAccess.sym, 8 | this.parentContext(memberSelectTree, tree));
                if (this.isThis(jCFieldAccess.name)) {
                    ++VariableCharacterization.this.thisUseCount;
                }
                super.visitMemberSelect(memberSelectTree, tree);
                return null;
            }

            @Override
            public Void visitNewClass(NewClassTree newClassTree, Tree tree) {
                this.checkBoth(null, ((JCTree.JCNewClass)newClassTree).constructor, 0);
                super.visitNewClass(newClassTree, tree);
                return null;
            }

            @Override
            public Void visitVariable(VariableTree variableTree, Tree tree) {
                int n = 16;
                if (tree != null && (tree.getKind() == Tree.Kind.METHOD || tree.getKind() == Tree.Kind.CATCH)) {
                    n |= 0x20;
                }
                JCTree.JCVariableDecl jCVariableDecl = (JCTree.JCVariableDecl)variableTree;
                this.checkBoth(jCVariableDecl.name, jCVariableDecl.sym, n);
                super.visitVariable(variableTree, tree);
                return null;
            }

            @Override
            public Void visitMethod(MethodTree methodTree, Tree tree) {
                Symbol.TypeSymbol typeSymbol = this.owner;
                JCTree.JCMethodDecl jCMethodDecl = (JCTree.JCMethodDecl)methodTree;
                if (jCMethodDecl.sym != null) {
                    this.owner = (Symbol.TypeSymbol)jCMethodDecl.sym.owner;
                }
                super.visitMethod(methodTree, tree);
                this.owner = typeSymbol;
                return null;
            }

            @Override
            public Void visitClass(ClassTree classTree, Tree tree) {
                Symbol.TypeSymbol typeSymbol = this.owner;
                JCTree.JCClassDecl jCClassDecl = (JCTree.JCClassDecl)classTree;
                if (jCClassDecl.sym != null && jCClassDecl.sym.owner instanceof Symbol.TypeSymbol) {
                    this.owner = (Symbol.TypeSymbol)jCClassDecl.sym.owner;
                }
                super.visitClass(classTree, tree);
                this.owner = typeSymbol;
                return null;
            }

            int parentContext(Tree tree, Tree tree2) {
                if (tree2 == null) {
                    return 0;
                }
                int n = ((JCTree)tree2).tag;
                if (74 <= n && n <= 90 ? ((JCTree.JCAssignOp)tree2).lhs == tree : n == 30 && ((JCTree.JCAssign)tree2).lhs == tree) {
                    return 1;
                }
                return 2;
            }

            private void checkBoth(Name name, Symbol symbol, int n) {
                if (name != null) {
                    this.checkOne(name, n);
                }
                if (symbol != null && this.checkOne(symbol, n) && symbol.owner != null && !symbol.isLocal() && this.owner != null && elementsService.isMemberOf(symbol, (TypeElement)((Object)this.owner))) {
                    long l = symbol.flags();
                    VariableCharacterization.this.allflags = (int)((long)VariableCharacterization.this.allflags | l);
                    VariableCharacterization.this.allnotflags = (int)((long)VariableCharacterization.this.allnotflags | l ^ 0xFFFFFFFFFFFFFFFFL);
                }
            }

            private boolean checkOne(Object object, int n) {
                CNode cNode = VariableCharacterization.this.map.get(object);
                if (cNode == null) {
                    cNode = new CNode();
                    VariableCharacterization.this.map.put(object, cNode);
                    cNode.usage |= n;
                    ++cNode.useCount;
                    return true;
                }
                ++cNode.useCount;
                cNode.usage |= n;
                return false;
            }

            private boolean isThis(Name name) {
                return name == name.table._this;
            }
        }.scan(tree, null);
    }

    public final int usage(Object object) {
        CNode cNode = this.map.get(object);
        return cNode == null ? 0 : cNode.usage;
    }

    public final int useCount(Object object) {
        CNode cNode = this.map.get(object);
        return cNode == null ? 0 : cNode.useCount;
    }

    public final boolean assigned(Object object) {
        return (this.usage(object) & 1) != 0;
    }

    public final boolean referenced(Object object) {
        return (this.usage(object) & 2) != 0;
    }

    public final boolean ident(Object object) {
        return (this.usage(object) & 4) != 0;
    }

    public final boolean selected(Object object) {
        return (this.usage(object) & 8) != 0;
    }

    public final boolean declared(Object object) {
        return (this.usage(object) & 0x10) != 0;
    }

    public final boolean parameter(Object object) {
        return (this.usage(object) & 0x20) != 0;
    }

    public final int getThisUseCount() {
        return this.thisUseCount;
    }

    public final int getAllFlags() {
        return this.allflags;
    }

    public final int getAllNotFlags() {
        return this.allnotflags;
    }

    private static class CNode {
        int usage;
        int useCount = 0;

        private CNode() {
        }
    }
}

