/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.engine;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.BeanDescriptor;
import java.beans.Customizer;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.java.source.engine.PickOne;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

public class PropertySheetInfo {
    private final Class base;
    private final ArrayList<Item> items = new ArrayList();
    private String title = null;
    private boolean hasTabs;
    private Preferences prefs;
    public static final String REMOVE_PANEL_ACTION = "remove PropertySheetInfo panel";
    private static final ErrorManager logger = ErrorManager.getDefault();
    private static final int DEFAULT_PAD = 12;
    char[] pname = new char[2];

    public static PropertySheetInfo find(Class clazz) {
        return new PropertySheetInfo(clazz);
    }

    public static JComponent findButtonedPanel(Object object, ActionListener actionListener, ActionListener actionListener2) {
        return PropertySheetInfo.find(object.getClass()).buildButtonedPanel(object, actionListener, actionListener2);
    }

    public static JComponent findPanel(Object object, Runnable runnable) {
        return PropertySheetInfo.find(object.getClass()).buildPanel(object, runnable);
    }

    private PropertySheetInfo(Class clazz) {
        Item item;
        Object object;
        Object object2;
        Class<?> clazz2;
        Object object3;
        Object object4;
        this.base = clazz;
        String string = clazz.getName().replace('.', '/');
        this.prefs = Preferences.userRoot().node(string);
        Method[] methodArray = clazz.getDeclaredMethods();
        Field[] fieldArray = clazz.getDeclaredFields();
        int n = fieldArray.length;
        while (--n >= 0) {
            object4 = fieldArray[n];
            if ((((Field)object4).getModifiers() & 1) == 0 || (((Field)object4).getModifiers() & 8) != 0) continue;
            object3 = ((Field)object4).getName();
            clazz2 = ((Field)object4).getType();
            PropertyEditor propertyEditor = PropertyEditorManager.findEditor(clazz2);
            if (propertyEditor == null && clazz2 != PickOne.class) continue;
            this.items.add(new FieldItem((String)object3, (Field)object4, clazz2, propertyEditor));
        }
        n = methodArray.length;
        while (--n >= 0) {
            MethodItem methodItem;
            Class<?> clazz3;
            boolean bl;
            object4 = methodArray[n];
            object3 = ((Method)object4).getName();
            Class<?> clazz4 = ((Method)object4).getReturnType();
            Class<?>[] classArray = ((Method)object4).getParameterTypes();
            if (clazz4 != Void.TYPE) {
                if (classArray.length != 0 || (clazz2 = this.pattern("get", (String)object3)) == null && (clazz2 = this.pattern("is", (String)object3)) == null) continue;
                bl = true;
                clazz3 = clazz4;
            } else {
                if (classArray.length != 1 || (clazz2 = this.pattern("set", (String)object3)) == null) continue;
                bl = false;
                clazz3 = classArray[0];
            }
            object2 = PropertyEditorManager.findEditor(clazz3);
            if (object2 == null && clazz3 != PickOne.class) continue;
            object = null;
            int n2 = this.items.size();
            while (--n2 >= 0) {
                item = this.items.get(n2);
                if (!item.name.equals(clazz2)) continue;
                object = item;
                break;
            }
            if (object == null) {
                methodItem = new MethodItem((String)((Object)clazz2), clazz3, (PropertyEditor)object2);
                this.items.add(methodItem);
            } else {
                if (!(object instanceof MethodItem)) continue;
                methodItem = (MethodItem)object;
                if (clazz3 != methodItem.propType) {
                    logger.log(256, "set/get type mismatch " + methodItem);
                    continue;
                }
            }
            if (bl) {
                methodItem.getter = object4;
                continue;
            }
            methodItem.setter = object4;
        }
        this.pname = null;
        if (clazz.getPackage() == null) {
            this.validate();
            return;
        }
        String string2 = clazz.getSimpleName();
        object4 = string2 + "-" + Locale.getDefault().getLanguage() + ".panel";
        object3 = null;
        object3 = clazz.getResourceAsStream((String)object4);
        if (object3 == null && (object3 = clazz.getResourceAsStream((String)(object4 = string2 + ".panel"))) == null) {
            this.validate();
            return;
        }
        clazz2 = new InputStreamReader(new BufferedInputStream((InputStream)object3));
        Object object5 = new char[2];
        int n3 = 0;
        try {
            int n4;
            int n5 = 0;
            object2 = null;
            while ((n4 = ((Reader)((Object)clazz2)).read()) >= 0) {
                if (n4 != 10 && n4 != 13) {
                    if (n4 == 58 && object2 == null) {
                        object2 = new String((char[])object5, 0, n5).trim();
                        n5 = 0;
                        continue;
                    }
                    if (n5 >= ((char[])object5).length) {
                        object = new char[n5 * 2];
                        System.arraycopy(object5, 0, object, 0, n5);
                        object5 = object;
                    }
                    object5[n5++] = (char)n4;
                    continue;
                }
                if (n5 > 0 && object2 != null && ((String)object2).length() > 0) {
                    object = new String((char[])object5, 0, n5).trim();
                    if (((String)object2).equals("*title")) {
                        this.title = object;
                        object2 = null;
                        n5 = 0;
                        continue;
                    }
                    if (((String)object2).equals("*tab")) {
                        this.items.add(n3++, new TabItem((String)object));
                        this.hasTabs = true;
                    } else if (!((String)object2).startsWith("#")) {
                        int n6 = this.items.size();
                        while (--n6 >= n3) {
                            item = this.items.get(n6);
                            if (!item.name.equals(object2)) continue;
                            item.setLabel((String)object);
                            this.items.remove(item);
                            this.items.add(n3++, item);
                            object = null;
                            break;
                        }
                        if (object != null) {
                            logger.log(256, "Panel field " + (String)object2 + " missing from object");
                        }
                    }
                }
                n5 = 0;
                object2 = null;
            }
            ((Reader)((Object)clazz2)).close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.validate();
    }

    private void validate() {
        int n = this.items.size();
        while (--n >= 0) {
            Item item = this.items.get(n);
            if (item.valid()) continue;
            this.items.remove(n);
        }
    }

    private String pattern(String string, String string2) {
        if (!string2.startsWith(string)) {
            return null;
        }
        int n = string2.length();
        int n2 = string.length();
        if (n2 == n) {
            return null;
        }
        if (this.pname.length < n) {
            this.pname = new char[n];
        }
        string2.getChars(0, n, this.pname, 0);
        if (Character.isUpperCase(this.pname[n2])) {
            this.pname[n2] = Character.toLowerCase(this.pname[n2]);
        }
        return new String(this.pname, n2, n - n2);
    }

    public String getTitle() {
        if (this.title == null) {
            this.title = this.base.getName();
            int n = this.title.lastIndexOf(46);
            if (n > 0) {
                this.title = this.title.substring(n + 1);
            }
        }
        return this.title;
    }

    public boolean nonEmpty() {
        return this.items.size() > 0;
    }

    public void print(PrintStream printStream) {
        for (int i = 0; i < this.items.size(); ++i) {
            Item item = this.items.get(i);
            printStream.print(item.toString());
            if (item.propertyEditor != null) {
                printStream.print(item.propertyEditor + "\n   isP=" + item.propertyEditor.isPaintable() + " sce=" + item.propertyEditor.supportsCustomEditor());
            }
            printStream.println();
        }
    }

    public void loadValues(Object object) {
        for (Item item : this.items) {
            item.set(object, item.get(object));
        }
    }

    public void saveValues(Object object) throws InstantiationException, IllegalAccessException {
        Object obj = object.getClass().newInstance();
        for (Item item : this.items) {
            Object object2 = item.get(object);
            item.set(obj, item.get(obj));
            item.set(object, object2);
        }
    }

    public int showDialog(Object object, ActionListener actionListener) {
        if (actionListener == null && object instanceof ActionListener) {
            actionListener = (ActionListener)object;
        }
        JFrame jFrame = new JFrame(this.getTitle());
        jFrame.getContentPane().add(this.buildButtonedPanel(object, actionListener));
        jFrame.setDefaultCloseOperation(3);
        jFrame.pack();
        jFrame.setVisible(true);
        return 0;
    }

    public JComponent buildButtonedPanel(Object object, ActionListener actionListener) {
        return this.buildButtonedPanel(object, actionListener, null);
    }

    public JComponent buildButtonedPanel(Object object, ActionListener actionListener, ActionListener actionListener2) {
        JButton jButton;
        if (actionListener == null && object instanceof ActionListener) {
            actionListener = (ActionListener)object;
        }
        Box box = Box.createVerticalBox();
        Box box2 = Box.createHorizontalBox();
        box.add(this.buildPanel(object));
        box.add(Box.createVerticalGlue());
        box.add(Box.createVerticalStrut(12));
        box.add(box2);
        box2.add(Box.createHorizontalGlue());
        RemovablePane removablePane = new RemovablePane(box);
        if (actionListener != null) {
            jButton = new JButton(NbBundle.getMessage(PropertySheetInfo.class, (String)"LBL_Apply"));
            jButton.addActionListener(actionListener);
            box2.add(jButton);
            if (actionListener2 != null) {
                box2.add(Box.createHorizontalStrut(6));
            }
        }
        if (actionListener2 != null) {
            jButton = new JButton(NbBundle.getMessage(PropertySheetInfo.class, (String)"LBL_Cancel"));
            if (actionListener2 != null) {
                removablePane.addActionListener(actionListener2);
                jButton.addActionListener(removablePane);
            }
            box2.add(jButton);
        }
        return removablePane;
    }

    private Component wrapLabel(String string) {
        int n;
        int n2 = string.length();
        if (n2 < 50 || (n = string.indexOf(32, string.length() >> 1)) <= 0) {
            return new JLabel(string);
        }
        Box box = Box.createVerticalBox();
        box.add(new JLabel(string.substring(0, n).trim()));
        box.add(new JLabel(string.substring(n + 1).trim()));
        return box;
    }

    public JComponent buildPanel() {
        try {
            Object t = this.base.newInstance();
            this.loadValues(t);
            return this.buildPanel(t);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public JComponent buildPanel(Object object) {
        return this.buildPanel(object, null);
    }

    public JComponent buildPanel(Object object, Runnable runnable) {
        Serializable serializable;
        Object object2;
        try {
            object2 = Introspector.getBeanInfo(this.base).getBeanDescriptor();
            serializable = ((BeanDescriptor)object2).getCustomizerClass();
            if (serializable != null) {
                Customizer customizer = (Customizer)((Class)serializable).newInstance();
                customizer.setObject(this);
                if (customizer instanceof JComponent) {
                    return (JComponent)((Object)customizer);
                }
                JPanel jPanel = new JPanel();
                jPanel.add((Component)((Object)customizer));
                return jPanel;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        object2 = null;
        serializable = this.hasTabs ? new JTabbedPane() : null;
        String string = NbBundle.getMessage(PropertySheetInfo.class, (String)"LBL_Properties_Tab");
        GridBagLayout gridBagLayout = new GridBagLayout();
        if (!this.base.isInstance(object)) {
            throw new IllegalArgumentException("Type mismatch");
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        int n = this.items.size() - 1;
        for (int i = 0; i <= n; ++i) {
            String string2;
            Item item = this.items.get(i);
            if (!item.valid()) continue;
            double d = gridBagConstraints.weighty = i == n || this.items.get(i + 1) instanceof TabItem ? 1000.0 : 1.0;
            if (item instanceof TabItem) {
                string = item.getLabel();
                object2 = null;
                continue;
            }
            if (object2 == null) {
                object2 = new JPanel();
                ((Container)object2).setLayout(gridBagLayout);
                gridBagConstraints.gridy = 0;
                if (serializable != null) {
                    ((JComponent)object2).setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
                    ((JTabbedPane)serializable).addTab(string, (Component)object2);
                }
            }
            if ((string2 = item.getLabel()) != null && string2.length() > 0) {
                gridBagConstraints.gridx = 0;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.insets.right = 12;
                ((Container)object2).add(this.wrapLabel(string2), gridBagConstraints);
            }
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets.right = 0;
            Component component = item.getInteractor(object, runnable);
            if (component instanceof JScrollPane) {
                gridBagConstraints.fill = 1;
            }
            ((Container)object2).add(component, gridBagConstraints);
            ++gridBagConstraints.gridy;
        }
        return serializable != null ? serializable : (object2 != null ? object2 : new JLabel(NbBundle.getMessage(PropertySheetInfo.class, (String)"MSG_No_items_to_edit")));
    }

    private static String ns(Object object) {
        return object == null ? "" : object.toString();
    }

    private class FieldItem
    extends Item {
        Field field;

        FieldItem(String string, Field field, Class clazz, PropertyEditor propertyEditor) {
            this.field = field;
            this.name = string;
            this.propType = clazz;
            this.propertyEditor = propertyEditor;
            this.trnsient = Modifier.isTransient(field.getModifiers());
        }

        public Object get0(Object object) {
            try {
                Object object2 = this.field.get(object);
                if (object2 == null) {
                    object2 = this.defaultItem(this.field.getType());
                }
                return object2;
            }
            catch (IllegalAccessException illegalAccessException) {
                return null;
            }
        }

        public void set0(Object object, Object object2) {
            try {
                this.field.set(object, object2);
            }
            catch (IllegalAccessException illegalAccessException) {
                logger.log(256, "bad set, value=" + object2);
            }
        }

        public String toString() {
            return this.name + " " + this.propType;
        }
    }

    public abstract class Item {
        public String name;
        boolean textarea = false;
        private String label;
        private Object oldValue;
        protected boolean trnsient = false;
        public Class propType;
        public PropertyEditor propertyEditor;

        protected abstract Object get0(Object var1);

        protected abstract void set0(Object var1, Object var2);

        public final Object get(Object object) {
            Object object2 = this.get0(object);
            if (this.oldValue == null && this.name != null && object2 != null) {
                if (object2 instanceof Boolean) {
                    object2 = PropertySheetInfo.this.prefs.getBoolean(this.name, (Boolean)object2);
                } else if (object2 instanceof String) {
                    object2 = PropertySheetInfo.this.prefs.get(this.name, (String)object2);
                } else if (object2 instanceof Integer) {
                    object2 = new Integer(PropertySheetInfo.this.prefs.getInt(this.name, (Integer)object2));
                } else if (object2 instanceof PickOne) {
                    ((PickOne)object2).value = PropertySheetInfo.this.prefs.getInt(this.name, ((PickOne)object2).value);
                } else {
                    logger.log(256, "Missing type " + object2.getClass().getName() + " for " + this.name);
                }
                this.set0(object, object2);
            }
            this.oldValue = object2;
            return object2;
        }

        public final void set(Object object, Object object2) {
            if (!this.trnsient && object2 != null && !object2.equals(this.oldValue)) {
                if (object2 instanceof Boolean) {
                    PropertySheetInfo.this.prefs.putBoolean(this.name, (Boolean)object2);
                } else if (object2 instanceof Integer) {
                    PropertySheetInfo.this.prefs.putInt(this.name, (Integer)object2);
                } else if (object2 instanceof String) {
                    PropertySheetInfo.this.prefs.put(this.name, (String)object2);
                }
                this.flush();
            }
            this.set0(object, object2);
        }

        void flush() {
            try {
                PropertySheetInfo.this.prefs.flush();
            }
            catch (BackingStoreException backingStoreException) {
                backingStoreException.printStackTrace();
            }
        }

        public void setLabel(String string) {
            if (string.startsWith("textarea")) {
                string = string.substring(8).trim();
                this.textarea = true;
            }
            this.label = string;
        }

        public String getLabel() {
            CharSequence charSequence;
            if (this.label == null) {
                charSequence = PropertySheetInfo.this.base.getSimpleName() + '.' + this.name;
                try {
                    this.label = NbBundle.getBundle((Class)PropertySheetInfo.this.base).getString((String)charSequence);
                }
                catch (MissingResourceException missingResourceException) {
                    ErrorManager.getDefault().log(16, (String)charSequence + " property not localized");
                }
            }
            if (this.label == null) {
                charSequence = new StringBuffer();
                char c = '\u0000';
                int n = this.name.length();
                for (int i = 0; i < n; ++i) {
                    char c2;
                    char c3 = this.name.charAt(i);
                    if (c3 == '_') {
                        c2 = ' ';
                    } else if (Character.isUpperCase(c3)) {
                        c2 = Character.toLowerCase(c3);
                        ((StringBuffer)charSequence).append(' ');
                    } else {
                        c2 = c3;
                    }
                    if (c == '\u0000' && Character.isLowerCase(c2)) {
                        c2 = Character.toUpperCase(c2);
                    }
                    ((StringBuffer)charSequence).append(c2);
                    c = c3;
                }
                this.label = ((StringBuffer)charSequence).toString();
            }
            return this.label;
        }

        public Component getInteractor(final Object object, final Runnable runnable) {
            try {
                PropertyEditor propertyEditor = this.propertyEditor;
                if (this.propType == String.class) {
                    JTextComponent jTextComponent;
                    JComponent jComponent;
                    if (this.textarea) {
                        jComponent = new JTextArea();
                        jTextComponent = jComponent;
                    } else {
                        jTextComponent = new JTextField();
                    }
                    jTextComponent.setText(PropertySheetInfo.ns(this.get(object)));
                    jTextComponent.addFocusListener(new FocusAdapter(){

                        public void focusLost(FocusEvent focusEvent) {
                            String string = jTextComponent.getText();
                            if (string.equals(Item.this.get(object))) {
                                return;
                            }
                            if (runnable != null) {
                                EventQueue.invokeLater(runnable);
                            }
                            Item.this.set(object, string);
                        }
                    });
                    if (this.textarea) {
                        jComponent = new JScrollPane(jTextComponent);
                        ((Component)jComponent).setPreferredSize(new Dimension(320, 200));
                        return jComponent;
                    }
                    return jTextComponent;
                }
                if (propertyEditor != null && propertyEditor.supportsCustomEditor()) {
                    propertyEditor.setValue(this.get(object));
                    propertyEditor.addPropertyChangeListener(new PropertyChangeListener(){

                        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                            if (runnable != null) {
                                EventQueue.invokeLater(runnable);
                            }
                        }
                    });
                    return propertyEditor.getCustomEditor();
                }
                if (this.propType == Boolean.TYPE) {
                    final JCheckBox jCheckBox = new JCheckBox(null, null, (Boolean)this.get(object));
                    jCheckBox.addChangeListener(new ChangeListener(){

                        public void stateChanged(ChangeEvent changeEvent) {
                            Boolean bl;
                            Boolean bl2 = bl = jCheckBox.isSelected() ? Boolean.TRUE : Boolean.FALSE;
                            if (((Object)bl).equals(Item.this.get(object))) {
                                return;
                            }
                            if (runnable != null) {
                                EventQueue.invokeLater(runnable);
                            }
                            Item.this.set(object, bl);
                        }
                    });
                    return jCheckBox;
                }
                if (this.propType == Integer.TYPE) {
                    final JSpinner jSpinner = new JSpinner();
                    jSpinner.setValue(this.get(object));
                    jSpinner.addChangeListener(new ChangeListener(){

                        public void stateChanged(ChangeEvent changeEvent) {
                            Object object2 = jSpinner.getValue();
                            if (object2.equals(Item.this.get(object))) {
                                return;
                            }
                            if (runnable != null) {
                                EventQueue.invokeLater(runnable);
                            }
                            Item.this.set(object, object2);
                        }
                    });
                    return jSpinner;
                }
                if (this.propType == PickOne.class) {
                    final PickOne pickOne = (PickOne)this.get(object);
                    if (pickOne == null) {
                        return new JLabel(NbBundle.getMessage(PropertySheetInfo.class, (String)"MSG_Null_PickOne"));
                    }
                    final JComboBox<String> jComboBox = new JComboBox<String>(pickOne.keys);
                    jComboBox.setSelectedIndex(pickOne.value);
                    jComboBox.addItemListener(new ItemListener(){

                        public void itemStateChanged(ItemEvent itemEvent) {
                            if (itemEvent.getStateChange() == 1) {
                                int n = jComboBox.getSelectedIndex();
                                if (n == pickOne.value) {
                                    return;
                                }
                                pickOne.value = n;
                                PropertySheetInfo.this.prefs.putInt(Item.this.name, n);
                                Item.this.flush();
                                if (runnable != null) {
                                    EventQueue.invokeLater(runnable);
                                }
                            }
                        }
                    });
                    return jComboBox;
                }
                String[] stringArray = propertyEditor.getTags();
                if (stringArray != null && stringArray.length > 0) {
                    JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
                    jComboBox.setEditable(false);
                    jComboBox.setSelectedItem(propertyEditor.getAsText());
                    return jComboBox;
                }
                return new JTextField(propertyEditor.getAsText());
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return new JLabel(exception.toString());
            }
        }

        public boolean valid() {
            return true;
        }

        protected final Object defaultItem(Class clazz) {
            if (clazz == String.class) {
                return "";
            }
            if (clazz == Boolean.class) {
                return false;
            }
            if (clazz == Integer.class) {
                return 0;
            }
            return null;
        }
    }

    private class MethodItem
    extends Item {
        Method setter;
        Method getter;

        MethodItem(String string, Class clazz, PropertyEditor propertyEditor) {
            this.propertyEditor = propertyEditor;
            this.propType = clazz;
            this.name = string;
        }

        public boolean valid() {
            return this.getter != null && this.setter != null;
        }

        public Object get0(Object object) {
            try {
                Object object2 = this.getter.invoke(object, new Object[0]);
                if (object2 == null) {
                    object2 = this.defaultItem(this.getter.getReturnType());
                }
                return object2;
            }
            catch (IllegalAccessException illegalAccessException) {
                return null;
            }
            catch (InvocationTargetException invocationTargetException) {
                return null;
            }
        }

        public void set0(Object object, Object object2) {
            try {
                this.setter.invoke(object, object2);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }

        public String toString() {
            return this.name + "/" + this.getter + "/" + this.setter;
        }
    }

    private static class PropertySheet {
        private Component sheet;
        private Box buttons;

        private PropertySheet() {
        }

        private void addButton(JComponent jComponent) {
            if (this.buttons == null) {
                this.buttons = Box.createHorizontalBox();
                Box box = Box.createVerticalBox();
                box.add(this.sheet);
                box.add(Box.createVerticalGlue());
                box.add(this.buttons);
                this.sheet = box;
                this.buttons.add(Box.createHorizontalGlue());
            } else {
                this.buttons.add(Box.createHorizontalStrut(10));
            }
            this.buttons.add(jComponent);
        }

        public PropertySheet addButton(String string, ActionListener actionListener) {
            JButton jButton = new JButton(string);
            jButton.addActionListener(actionListener);
            this.addButton(jButton);
            return this;
        }

        public Component getComponent() {
            return this.sheet;
        }
    }

    private static class RemovablePane
    extends JScrollPane
    implements ActionListener {
        private ActionListener listener = null;

        RemovablePane(Component component) {
            super(component);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.listener != null) {
                this.listener.actionPerformed(new ActionEvent(this, 0, PropertySheetInfo.REMOVE_PANEL_ACTION));
            }
        }

        public void addActionListener(ActionListener actionListener) {
            this.listener = actionListener;
        }
    }

    private class TabItem
    extends Item {
        TabItem(String string) {
            this.setLabel(string);
            this.propType = String.class;
        }

        public Object get0(Object object) {
            return NbBundle.getMessage(PropertySheetInfo.class, (String)"MSG_Invalid_TabItem");
        }

        public void set0(Object object, Object object2) {
        }
    }
}

