/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.parsing;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.tools.JavaFileObject;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.java.preprocessorbridge.spi.JavaFileFilterImplementation;
import org.netbeans.modules.java.source.parsing.Archive;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.util.Factory;
import org.netbeans.modules.java.source.util.Iterators;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingArchive
implements Archive {
    private final File archiveFile;
    private final boolean keepOpened;
    private ZipFile zipFile;
    private Map<String, List<ZipRecord>> folders2files;

    public CachingArchive(File file, boolean bl) {
        this.archiveFile = file;
        this.keepOpened = bl;
    }

    @Override
    public Iterable<JavaFileObject> getFiles(String string, ClassPath.Entry entry, JavaFileFilterImplementation javaFileFilterImplementation) throws IOException {
        this.doInit();
        List<ZipRecord> list = this.folders2files.get(string);
        if (list == null) {
            return Collections.emptyList();
        }
        assert (!this.keepOpened || this.zipFile != null);
        return Iterators.translating(list, new JFOFactory(string, this.archiveFile, this.zipFile));
    }

    @Override
    public synchronized void clear() {
        this.folders2files = null;
    }

    public synchronized boolean isInitialized() {
        return this.folders2files != null;
    }

    public synchronized void initialize() {
        this.folders2files = this.createMap(this.archiveFile);
    }

    private synchronized void doInit() {
        if (!this.isInitialized()) {
            this.initialize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, List<ZipRecord>> createMap(File file) {
        if (!file.canRead()) return Collections.emptyMap();
        try {
            ZipFile zipFile = new ZipFile(file);
            try {
                HashMap<String, ArrayList<ZipRecord>> hashMap = new HashMap<String, ArrayList<ZipRecord>>();
                Object object = zipFile.entries();
                while (object.hasMoreElements()) {
                    ArrayList<ZipRecord> arrayList;
                    ZipEntry zipEntry = object.nextElement();
                    String string = zipEntry.getName();
                    int n = string.lastIndexOf(47);
                    String string2 = n == -1 ? "" : string.substring(0, n);
                    String string3 = string.substring(n + 1);
                    if (string3.length() == 0) {
                        string3 = null;
                    }
                    if ((arrayList = (ArrayList<ZipRecord>)hashMap.get(string2)) == null) {
                        arrayList = new ArrayList<ZipRecord>();
                        hashMap.put(string2, arrayList);
                    }
                    if (string3 == null) continue;
                    arrayList.add(new ZipRecord(string3, zipEntry.getTime()));
                }
                object = hashMap;
                return object;
            }
            finally {
                if (this.keepOpened) {
                    this.zipFile = zipFile;
                } else {
                    try {
                        zipFile.close();
                    }
                    catch (IOException iOException) {
                        Exceptions.printStackTrace((Throwable)iOException);
                    }
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return Collections.emptyMap();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JFOFactory
    implements Factory<JavaFileObject, ZipRecord> {
        private final String pkg;
        private final File archiveFile;
        private final ZipFile zipFile;

        JFOFactory(String string, File file, ZipFile zipFile) {
            this.pkg = string;
            this.archiveFile = file;
            this.zipFile = zipFile;
        }

        @Override
        public JavaFileObject create(ZipRecord zipRecord) {
            if (this.zipFile == null) {
                return FileObjects.zipFileObject(this.archiveFile, this.pkg, zipRecord.baseName, zipRecord.mtime);
            }
            return FileObjects.zipFileObject(this.zipFile, this.pkg, zipRecord.baseName, zipRecord.mtime);
        }
    }

    private static class ZipRecord {
        private final long mtime;
        private final String baseName;

        public ZipRecord(String string, long l) {
            assert (string != null);
            this.mtime = l;
            this.baseName = string;
        }
    }
}

