/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.parsing;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.java.preprocessorbridge.spi.JavaFileFilterImplementation;
import org.netbeans.modules.java.source.parsing.Archive;
import org.netbeans.modules.java.source.parsing.CachingArchiveProvider;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.parsing.SourceFileObject;
import org.netbeans.modules.java.source.util.Iterators;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingFileManager
implements JavaFileManager {
    protected final CachingArchiveProvider provider;
    protected final JavaFileFilterImplementation filter;
    protected final ClassPath cp;
    protected final boolean cacheFile;
    protected final boolean ignoreExcludes;

    public CachingFileManager(CachingArchiveProvider cachingArchiveProvider, ClassPath classPath, boolean bl, boolean bl2) {
        this(cachingArchiveProvider, classPath, null, bl, bl2);
    }

    public CachingFileManager(CachingArchiveProvider cachingArchiveProvider, ClassPath classPath, JavaFileFilterImplementation javaFileFilterImplementation, boolean bl, boolean bl2) {
        this.provider = cachingArchiveProvider;
        this.cp = classPath;
        this.cacheFile = bl;
        this.filter = javaFileFilterImplementation;
        this.ignoreExcludes = bl2;
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String string, Set<JavaFileObject.Kind> set, boolean bl) {
        if (bl) {
            throw new UnsupportedOperationException("Recursive listing is not supported in archives");
        }
        String string2 = FileObjects.convertPackage2Folder(string);
        LinkedList linkedList = new LinkedList();
        for (ClassPath.Entry entry : this.cp.entries()) {
            try {
                Archive archive = this.provider.getArchive(entry.getURL(), this.cacheFile);
                if (archive == null) continue;
                Iterable<JavaFileObject> iterable = archive.getFiles(string2, this.ignoreExcludes ? null : entry, this.filter);
                linkedList.add(iterable.iterator());
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return Iterators.toIterable(Iterators.chained(linkedList));
    }

    @Override
    public javax.tools.FileObject getFileForInput(JavaFileManager.Location location, String string, String string2) {
        for (ClassPath.Entry entry : this.cp.entries()) {
            try {
                Archive archive = this.provider.getArchive(entry.getURL(), this.cacheFile);
                if (archive == null) continue;
                Iterable<JavaFileObject> iterable = archive.getFiles(FileObjects.convertPackage2Folder(string), this.ignoreExcludes ? null : entry, this.filter);
                for (JavaFileObject javaFileObject : iterable) {
                    if (!string2.equals(javaFileObject.getName())) continue;
                    return javaFileObject;
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return null;
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String string, JavaFileObject.Kind kind) {
        String[] stringArray = FileObjects.getParentRelativePathAndName(string);
        if (stringArray == null) {
            return null;
        }
        stringArray[1] = stringArray[1] + kind.extension;
        for (ClassPath.Entry entry : this.cp.entries()) {
            try {
                Archive archive = this.provider.getArchive(entry.getURL(), this.cacheFile);
                if (archive == null) continue;
                Iterable<JavaFileObject> iterable = archive.getFiles(stringArray[0], this.ignoreExcludes ? null : entry, this.filter);
                for (JavaFileObject javaFileObject : iterable) {
                    if (!stringArray[1].equals(javaFileObject.getName())) continue;
                    return javaFileObject;
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return null;
    }

    @Override
    public javax.tools.FileObject getFileForOutput(JavaFileManager.Location location, String string, String string2, javax.tools.FileObject fileObject) throws IOException, UnsupportedOperationException, IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String string, JavaFileObject.Kind kind, javax.tools.FileObject fileObject) throws IOException, UnsupportedOperationException, IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public int isSupportedOption(String string) {
        return -1;
    }

    @Override
    public boolean handleOption(String string, Iterator<String> iterator) {
        return false;
    }

    @Override
    public boolean hasLocation(JavaFileManager.Location location) {
        return true;
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        return null;
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject javaFileObject) {
        if (javaFileObject instanceof FileObjects.Base) {
            FileObjects.Base base = (FileObjects.Base)javaFileObject;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(base.getPackage());
            stringBuilder.append('.');
            stringBuilder.append(base.getNameWithoutExtension());
            return stringBuilder.toString();
        }
        if (javaFileObject instanceof SourceFileObject) {
            FileObject fileObject = ((SourceFileObject)javaFileObject).file;
            for (FileObject fileObject2 : this.cp.getRoots()) {
                if (!FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject)) continue;
                String string = FileUtil.getRelativePath((FileObject)fileObject2, (FileObject)fileObject);
                int n = string.lastIndexOf(46);
                assert (n > 0);
                String string2 = string.substring(0, n).replace('/', '.');
                return string2;
            }
        }
        return null;
    }

    public static URL[] getClassPathRoots(ClassPath classPath) {
        assert (classPath != null);
        List list = classPath.entries();
        ArrayList<URL> arrayList = new ArrayList<URL>(list.size());
        for (ClassPath.Entry entry : list) {
            arrayList.add(entry.getURL());
        }
        return arrayList.toArray(new URL[arrayList.size()]);
    }

    @Override
    public boolean isSameFile(javax.tools.FileObject fileObject, javax.tools.FileObject fileObject2) {
        return fileObject instanceof FileObjects.FileBase && fileObject2 instanceof FileObjects.FileBase && ((FileObjects.FileBase)fileObject).getFile().equals(((FileObjects.FileBase)fileObject).getFile());
    }
}

