/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.parsing;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.java.source.parsing.CachingArchiveProvider;
import org.netbeans.modules.java.source.parsing.CachingFileManager;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.parsing.OutputFileObject;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class OutputFileManager
extends CachingFileManager {
    private static boolean debug = Boolean.getBoolean("org.netbeans.modules.java.source.parsing.OutputFileManager.debug");
    private ClassPath scp;

    public OutputFileManager(CachingArchiveProvider cachingArchiveProvider, ClassPath classPath, ClassPath classPath2) {
        super(cachingArchiveProvider, classPath, false, true);
        assert (classPath2 != null && classPath != null);
        this.scp = classPath2;
    }

    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String string, JavaFileObject.Kind kind, javax.tools.FileObject fileObject) throws IOException, UnsupportedOperationException, IllegalArgumentException {
        Object object;
        if (kind != JavaFileObject.Kind.CLASS) {
            throw new IllegalArgumentException();
        }
        int n = fileObject != null ? this.getActiveRoot(fileObject) : this.getActiveRoot(FileObjects.convertPackage2Folder(string));
        assert (n >= 0) : "class: " + string + " sibling: " + fileObject + " srcRoots: " + this.scp + " cacheRoots: " + this.cp;
        assert (n < this.cp.entries().size()) : "index " + n + " class: " + string + " sibling: " + fileObject + " srcRoots: " + this.scp + " cacheRoots: " + this.cp;
        File file = new File(URI.create(((ClassPath.Entry)this.cp.entries().get(n)).getURL().toExternalForm()));
        String string2 = string.replace('.', File.separatorChar);
        String string3 = string2 + '.' + "sig";
        int n2 = string3.lastIndexOf(File.separatorChar);
        if (n2 != -1) {
            object = string3.substring(0, n2);
            new File(file, (String)object).mkdirs();
        } else {
            file.mkdirs();
        }
        object = FileUtil.normalizeFile((File)new File(file, string3));
        return OutputFileObject.create(file, (File)object);
    }

    public javax.tools.FileObject getFileForOutput(JavaFileManager.Location location, String string, String string2, javax.tools.FileObject fileObject) throws IOException, UnsupportedOperationException, IllegalArgumentException {
        assert (string != null);
        assert (string2 != null);
        if (fileObject == null) {
            throw new IllegalArgumentException("sibling == null");
        }
        int n = this.getActiveRoot(fileObject);
        assert (n >= 0 && n < this.cp.entries().size());
        File file = new File(URI.create(((ClassPath.Entry)this.cp.entries().get(n)).getURL().toExternalForm()));
        File file2 = string.length() == 0 ? file : new File(file, FileObjects.convertPackage2Folder(string));
        if (!file2.exists() && !file2.mkdirs()) {
            throw new IOException();
        }
        File file3 = new File(file2, string2);
        return OutputFileObject.create(file, file3);
    }

    private int getActiveRoot(javax.tools.FileObject fileObject) throws IOException {
        if (this.scp.entries().size() == 1) {
            return 0;
        }
        Iterator iterator = this.scp.entries().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            URL uRL = ((ClassPath.Entry)iterator.next()).getURL();
            if (this.isParentOf(uRL, fileObject.toUri().toURL())) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private boolean isParentOf(URL uRL, URL uRL2) throws IOException {
        assert (uRL != null && uRL2 != null);
        return uRL2.toExternalForm().startsWith(uRL.toExternalForm());
    }

    private int getActiveRoot(String string) {
        String string2;
        if (this.scp.entries().size() == 1) {
            return 0;
        }
        String string3 = null;
        int n = string.lastIndexOf(47);
        if (n < 0) {
            string2 = string;
        } else {
            string3 = string.substring(0, n);
            string2 = string.substring(n + 1);
        }
        n = string2.indexOf(36);
        if (n > 0) {
            string2 = string2.substring(0, n);
        }
        Iterator iterator = this.scp.entries().iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            FileObject fileObject;
            FileObject fileObject2 = ((ClassPath.Entry)iterator.next()).getRoot();
            if (fileObject2 != null && (fileObject = fileObject2.getFileObject(string3)) != null && fileObject.getFileObject(string2, "java") != null) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    private static boolean debug(String string) {
        if (debug) {
            Logger.getLogger("global").log(Level.INFO, string);
        }
        return true;
    }
}

