/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.pretty;

import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.List;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportAnalysis
extends TreeScanner {
    int starThreshhold;
    int useThreshhold;
    private static final int implicitImport = 9999;
    SymRefStats usedClasses;
    SymRefStats usedClassOwners;
    public Symbol.PackageSymbol containingPackage;
    public Symbol.ClassSymbol containingClass;
    Symtab syms;
    boolean includeExplicit;

    public ImportAnalysis(int n, int n2, JCTree.JCCompilationUnit jCCompilationUnit, Symtab symtab, Types types) {
        this(n, n2, jCCompilationUnit, symtab, types, true);
    }

    public ImportAnalysis(int n, int n2, JCTree.JCCompilationUnit jCCompilationUnit, Symtab symtab, Types types, boolean bl) {
        this.starThreshhold = n;
        this.useThreshhold = n2;
        this.syms = symtab;
        this.includeExplicit = bl;
        this.containingPackage = jCCompilationUnit.packge;
        if (this.containingPackage == null) {
            Logger.getLogger("org.netbeans.modules.java.source").warning("null package element in " + jCCompilationUnit.getSourceFile().toUri().getPath());
        }
        this.usedClassOwners = this.setImplicit(this.usedClassOwners, this.containingPackage);
        this.usedClassOwners = this.setImplicit(this.usedClassOwners, symtab.objectType.tsym.owner);
        if (jCCompilationUnit != null) {
            jCCompilationUnit.accept(this);
        }
    }

    public boolean starred(Symbol symbol) {
        SymRefStats symRefStats = this.usedClassOwners;
        while (symRefStats != null) {
            if (symRefStats.clazz == symbol) {
                return symRefStats.imported;
            }
            symRefStats = symRefStats.next;
        }
        return false;
    }

    public boolean imported(Symbol symbol) {
        SymRefStats symRefStats = this.usedClasses;
        while (symRefStats != null) {
            if (symRefStats.clazz == symbol) {
                return symRefStats.imported;
            }
            symRefStats = symRefStats.next;
        }
        return this.starred(symbol.owner);
    }

    public Set<Symbol> neededImports(List<JCTree.JCImport> list) {
        Object object;
        Object object2;
        Cloneable cloneable;
        HashSet<Symbol> hashSet = new HashSet<Symbol>(8);
        HashSet<Symbol> hashSet2 = new HashSet<Symbol>(8);
        while (list.nonEmpty()) {
            cloneable = ((JCTree.JCImport)list.head).qualid;
            if (((JCTree)cloneable).tag == 34) {
                object2 = cloneable;
                Symbol symbol = ((JCTree.JCFieldAccess)object2).sym;
                if (symbol == null) {
                    object = ((JCTree.JCFieldAccess)object2).selected;
                    Symbol symbol2 = symbol = ((JCTree)object).tag == 34 ? ((JCTree.JCFieldAccess)object).sym : ((JCTree.JCIdent)object).sym;
                    if (symbol != null) {
                        hashSet.add(symbol);
                    }
                } else {
                    hashSet2.add(symbol);
                }
            } else if (((JCTree)cloneable).tag == 35) {
                hashSet2.add(((JCTree.JCIdent)cloneable).sym);
            } else {
                throw new AssertionError((Object)"unknown qualid tree type");
            }
            list = list.tail;
        }
        hashSet.add(this.containingPackage);
        hashSet.add(this.syms.objectType.tsym.owner);
        cloneable = new HashSet();
        object2 = this.usedClasses;
        while (object2 != null) {
            boolean bl = ((SymRefStats)object2).implicitlyImported() || hashSet2.contains(((SymRefStats)object2).clazz) || hashSet.contains(((SymRefStats)object2).clazz.owner);
            boolean bl2 = ((SymRefStats)object2).imported = bl || ((SymRefStats)object2).used >= this.useThreshhold;
            if (!bl) {
                if (((SymRefStats)object2).imported) {
                    object = this.usedClasses;
                    while (object != null) {
                        if (object != object2 && ((SymRefStats)object).clazz.name == ((SymRefStats)object2).clazz.name) {
                            ((SymRefStats)object2).imported = false;
                            break;
                        }
                        object = ((SymRefStats)object).next;
                    }
                }
                if (((SymRefStats)object2).imported && this.otherPackageHasClassName((SymRefStats)object2)) {
                    ((SymRefStats)object2).imported = false;
                }
                if (((SymRefStats)object2).imported && !bl) {
                    cloneable.add(((SymRefStats)object2).clazz);
                }
            }
            object2 = ((SymRefStats)object2).next;
        }
        return cloneable;
    }

    public void decideImports() {
        SymRefStats symRefStats = this.usedClassOwners;
        while (symRefStats != null) {
            symRefStats.imported = symRefStats.used >= this.starThreshhold;
            symRefStats = symRefStats.next;
        }
        symRefStats = this.usedClasses;
        while (symRefStats != null) {
            boolean bl = false;
            if (symRefStats.used >= this.useThreshhold || this.starred(symRefStats.clazz.owner)) {
                bl = true;
                SymRefStats symRefStats2 = this.usedClasses;
                while (symRefStats2 != symRefStats) {
                    if (symRefStats2.clazz.name == symRefStats.clazz.name) {
                        if (symRefStats.implicitlyImported()) {
                            symRefStats2.imported = false;
                            break;
                        }
                        bl = false;
                        break;
                    }
                    symRefStats2 = symRefStats2.next;
                }
                if (this.otherPackageHasClassName(symRefStats)) {
                    bl = false;
                }
            }
            symRefStats.imported = bl;
            symRefStats = symRefStats.next;
        }
    }

    private boolean otherPackageHasClassName(SymRefStats symRefStats) {
        SymRefStats symRefStats2 = this.usedClassOwners;
        while (symRefStats2 != null) {
            Scope scope;
            if (symRefStats2.imported && symRefStats2.clazz != symRefStats.clazz.owner && (scope = symRefStats2.clazz.members()) != null) {
                Scope.Entry entry = scope.lookup(symRefStats.clazz.name);
                if (entry.scope == scope && entry.sym.kind == 2) {
                    return false;
                }
            }
            symRefStats2 = symRefStats2.next;
        }
        return true;
    }

    private void found2(Symbol symbol) {
        if (symbol instanceof Symbol.ClassSymbol && (symbol.owner instanceof Symbol.PackageSymbol || symbol.owner instanceof Symbol.ClassSymbol) && symbol.owner != this.syms.rootPackage && symbol.owner != this.syms.unnamedPackage) {
            SymRefStats symRefStats = this.incref(this.usedClasses, symbol);
            if (symRefStats != this.usedClasses && symbol.owner != null) {
                this.usedClassOwners = this.incref(this.usedClassOwners, symbol.owner);
            }
            this.usedClasses = symRefStats;
        }
    }

    private void found(Type type) {
        List<Type> list;
        while (type instanceof Type.ArrayType) {
            type = ((Type.ArrayType)type).elemtype;
        }
        if (type != null && type.tag == 10) {
            this.found2(type.tsym);
        }
        if (type instanceof Type.ClassType && (list = ((Type.ClassType)type).typarams_field) != null) {
            while (list.nonEmpty()) {
                this.found((Type)list.head);
                list = list.tail;
            }
        }
    }

    private SymRefStats setImplicit(SymRefStats symRefStats, Symbol symbol) {
        SymRefStats symRefStats2 = symRefStats;
        while (symRefStats2 != null) {
            if (symRefStats2.clazz == symbol) {
                symRefStats2.setImplicit();
                return symRefStats;
            }
            symRefStats2 = symRefStats2.next;
        }
        symRefStats = new SymRefStats(symbol, symRefStats);
        symRefStats.setImplicit();
        return symRefStats;
    }

    private SymRefStats incref(SymRefStats symRefStats, Symbol symbol) {
        SymRefStats symRefStats2 = symRefStats;
        while (symRefStats2 != null) {
            if (symRefStats2.clazz == symbol) {
                if (!symRefStats2.implicitlyImported()) {
                    ++symRefStats2.used;
                }
                return symRefStats;
            }
            symRefStats2 = symRefStats2.next;
        }
        return new SymRefStats(symbol, symRefStats);
    }

    public int used(SymRefStats symRefStats, Symbol symbol) {
        SymRefStats symRefStats2 = symRefStats;
        while (symRefStats2 != null) {
            if (symRefStats2.clazz == symbol) {
                return symRefStats2.used;
            }
            symRefStats2 = symRefStats2.next;
        }
        return 0;
    }

    @Override
    public void visitTopLevel(JCTree.JCCompilationUnit jCCompilationUnit) {
        this.scan(jCCompilationUnit.defs);
    }

    @Override
    public void visitImport(JCTree.JCImport jCImport) {
    }

    @Override
    public void visitClassDef(JCTree.JCClassDecl jCClassDecl) {
        if (jCClassDecl.sym == null) {
            return;
        }
        this.usedClasses = this.setImplicit(this.usedClasses, jCClassDecl.sym);
        this.usedClassOwners = this.setImplicit(this.usedClassOwners, jCClassDecl.sym);
        if ((jCClassDecl.mods.flags & 1L) != 0L || this.containingClass == null) {
            this.containingClass = jCClassDecl.sym;
        }
        super.visitClassDef(jCClassDecl);
    }

    @Override
    public void visitSelect(JCTree.JCFieldAccess jCFieldAccess) {
        Symbol symbol = TreeInfo.symbol(jCFieldAccess.selected);
        if (symbol != null && symbol.kind == 2 && !this.explicitReference(jCFieldAccess)) {
            this.found(jCFieldAccess.selected.type);
        } else if (this.includeExplicit || !this.explicitReference(jCFieldAccess)) {
            super.visitSelect(jCFieldAccess);
        }
    }

    @Override
    public void visitIdent(JCTree.JCIdent jCIdent) {
        if (jCIdent.sym instanceof Symbol.ClassSymbol) {
            this.found(jCIdent.type);
        }
    }

    @Override
    public void visitErroneous(JCTree.JCErroneous jCErroneous) {
        this.scan(jCErroneous.errs);
    }

    private boolean explicitReference(JCTree.JCFieldAccess jCFieldAccess) {
        Symbol symbol = TreeInfo.symbol(jCFieldAccess.selected);
        if (symbol != null && symbol.kind == true) {
            return true;
        }
        return symbol != null && jCFieldAccess.selected.tag == 34 ? this.explicitReference((JCTree.JCFieldAccess)jCFieldAccess.selected) : false;
    }

    static class SymRefStats {
        int used = 1;
        boolean imported = false;
        final Symbol clazz;
        final SymRefStats next;

        public final void setImplicit() {
            this.used = 9999;
        }

        public final boolean implicitlyImported() {
            return this.used == 9999;
        }

        SymRefStats(Symbol symbol, SymRefStats symRefStats) {
            this.clazz = symbol;
            this.next = symRefStats;
        }
    }
}

