/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.pretty;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import org.netbeans.modules.java.source.pretty.ImportAnalysis;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WidthEstimator
extends JCTree.Visitor {
    private int width;
    private int prec;
    private int maxwidth;
    private final Symtab symbols;
    private final TreeInfo treeinfo;
    private ImportAnalysis imports;

    public WidthEstimator(Context context) {
        this.symbols = Symtab.instance(context);
        this.treeinfo = TreeInfo.instance((Context)context);
    }

    public int estimateWidth(JCTree jCTree, int n) {
        this.width = 0;
        this.maxwidth = n;
        jCTree.accept(this);
        return this.width;
    }

    public int estimateWidth(JCTree jCTree) {
        return this.estimateWidth(jCTree, 100);
    }

    private void open(int n, int n2) {
        if (n2 < n) {
            this.width += 2;
        }
    }

    private void width(Name name) {
        this.width += name.len;
    }

    private void width(String string) {
        this.width += string.length();
    }

    private void width(JCTree jCTree) {
        if (this.width < this.maxwidth) {
            jCTree.accept(this);
        }
    }

    private void width(JCTree jCTree, Type type) {
        if (type == null) {
            this.width(jCTree);
        } else {
            this.width(type);
        }
    }

    public void setImports(ImportAnalysis importAnalysis) {
        this.imports = importAnalysis;
    }

    public ImportAnalysis getImports() {
        return this.imports;
    }

    private void width(Type type) {
        List<Type> list;
        while (type instanceof Type.ArrayType) {
            type = ((Type.ArrayType)type).elemtype;
            this.width += 2;
        }
        this.widthQ(type.tsym);
        if (type instanceof Type.ClassType && (list = ((Type.ClassType)type).typarams_field) != null && list.nonEmpty()) {
            ++this.width;
            while (list.nonEmpty()) {
                ++this.width;
                this.width((Type)list.head);
                list = list.tail;
            }
        }
    }

    public void widthQ(Symbol symbol) {
        if (!(symbol.owner == null || symbol.owner == this.symbols.rootPackage || symbol.owner == this.symbols.unnamedPackage || symbol.type instanceof Type.TypeVar || this.imports != null && this.imports.imported(symbol) || symbol.owner instanceof Symbol.MethodSymbol)) {
            ++this.width;
            this.widthQ(symbol.owner);
        }
        this.width(symbol.name);
    }

    private void width(List<? extends JCTree> list, int n) {
        int n2 = 0;
        while (!list.isEmpty() && this.width < this.maxwidth) {
            this.width((JCTree)list.head);
            list = list.tail;
            ++n2;
        }
        if (n2 > 1) {
            this.width += n * n2;
        }
    }

    private void width(List<? extends JCTree> list) {
        this.width(list, 2);
    }

    private void width(JCTree jCTree, int n) {
        if (jCTree != null) {
            int n2 = this.prec;
            this.prec = n;
            jCTree.accept(this);
            this.prec = n2;
        }
    }

    @Override
    public void visitTree(JCTree jCTree) {
        System.err.println("Need width calc for " + jCTree);
        this.width = this.maxwidth;
    }

    @Override
    public void visitParens(JCTree.JCParens jCParens) {
        this.width += 2;
        this.width(jCParens.expr);
    }

    @Override
    public void visitApply(JCTree.JCMethodInvocation jCMethodInvocation) {
        this.width += 2;
        this.width((JCTree)jCMethodInvocation.meth, 15);
        this.width(jCMethodInvocation.args);
    }

    @Override
    public void visitNewClass(JCTree.JCNewClass jCNewClass) {
        if (jCNewClass.encl != null) {
            this.width(jCNewClass.encl);
            ++this.width;
        }
        this.width += 4;
        if (jCNewClass.encl == null) {
            this.width((JCTree)jCNewClass.clazz, jCNewClass.clazz.type);
        } else if (jCNewClass.clazz.type != null) {
            this.width(jCNewClass.clazz.type.tsym.name);
        } else {
            this.width(jCNewClass.clazz);
        }
        this.width += 2;
        this.width(jCNewClass.args, 2);
        if (jCNewClass.def != null) {
            this.width += 4;
            this.width(jCNewClass.def.defs, 2);
        }
    }

    @Override
    public void visitNewArray(JCTree.JCNewArray jCNewArray) {
        if (jCNewArray.elemtype != null) {
            this.width += 4;
            JCTree.JCExpression jCExpression = jCNewArray.elemtype;
            while (jCExpression.tag == 38) {
                this.width += 2;
                jCExpression = ((JCTree.JCArrayTypeTree)jCExpression).elemtype;
            }
            this.width(jCExpression);
            List<JCTree.JCExpression> list = jCNewArray.dims;
            while (list.nonEmpty()) {
                this.width += 2;
                this.width((JCTree)list.head);
                list = list.tail;
            }
        }
        if (jCNewArray.elems != null) {
            this.width += 4;
            this.width(jCNewArray.elems);
        }
    }

    private void widthAnnotations(List<JCTree.JCAnnotation> list) {
        int n = 0;
        while (!list.isEmpty() && this.width < this.maxwidth) {
            ++this.width;
            this.width((JCTree)list.head);
            list = list.tail;
            ++n;
        }
        if (n > 1) {
            this.width += n;
        }
    }

    private void widthFlags(long l) {
        if ((l & 0x1000L) != 0L) {
            this.width += 14;
        }
        this.width += TreeInfo.flagNames(l).length();
        if ((l & 0xFFFL) != 0L) {
            ++this.width;
        }
    }

    @Override
    public void visitVarDef(JCTree.JCVariableDecl jCVariableDecl) {
        this.widthAnnotations(jCVariableDecl.mods.annotations);
        this.widthFlags(jCVariableDecl.mods.flags);
        this.width((JCTree)jCVariableDecl.vartype, jCVariableDecl.type);
        ++this.width;
        this.width(jCVariableDecl.name);
        if (jCVariableDecl.init != null) {
            this.width += 3;
            this.width(jCVariableDecl.init);
        }
    }

    @Override
    public void visitConditional(JCTree.JCConditional jCConditional) {
        this.open(this.prec, 3);
        this.width += 6;
        this.width((JCTree)jCConditional.cond, 2);
        this.width((JCTree)jCConditional.truepart, 3);
        this.width((JCTree)jCConditional.falsepart, 3);
    }

    @Override
    public void visitAssignop(JCTree.JCAssignOp jCAssignOp) {
        this.open(this.prec, 2);
        this.width += 3;
        this.width(this.treeinfo.operatorName(jCAssignOp.tag - 17));
        this.width((JCTree)jCAssignOp.lhs, 3);
        this.width((JCTree)jCAssignOp.rhs, 2);
    }

    @Override
    public void visitAssign(JCTree.JCAssign jCAssign) {
        this.open(this.prec, 1);
        this.width += 3;
        this.width((JCTree)jCAssign.lhs, 2);
        this.width((JCTree)jCAssign.rhs, 1);
    }

    @Override
    public void visitUnary(JCTree.JCUnary jCUnary) {
        int n = TreeInfo.opPrec((int)jCUnary.tag);
        Name name = this.treeinfo.operatorName(jCUnary.tag);
        this.open(this.prec, n);
        this.width(name);
        this.width((JCTree)jCUnary.arg, n);
    }

    @Override
    public void visitBinary(JCTree.JCBinary jCBinary) {
        int n = TreeInfo.opPrec((int)jCBinary.tag);
        Name name = this.treeinfo.operatorName(jCBinary.tag);
        this.open(this.prec, n);
        this.width(name);
        this.width += 2;
        this.width((JCTree)jCBinary.lhs, n);
        this.width((JCTree)jCBinary.rhs, n + 1);
    }

    @Override
    public void visitTypeCast(JCTree.JCTypeCast jCTypeCast) {
        this.width += 2;
        this.open(this.prec, 14);
        this.width(jCTypeCast.clazz, jCTypeCast.clazz.type);
        this.width((JCTree)jCTypeCast.expr, 14);
    }

    @Override
    public void visitTypeTest(JCTree.JCInstanceOf jCInstanceOf) {
        this.open(this.prec, 10);
        this.width += 12;
        this.width((JCTree)jCInstanceOf.expr, 10);
        this.width(jCInstanceOf.clazz, jCInstanceOf.clazz.type);
    }

    @Override
    public void visitIndexed(JCTree.JCArrayAccess jCArrayAccess) {
        this.width += 2;
        this.width((JCTree)jCArrayAccess.indexed, 15);
        this.width(jCArrayAccess.index);
    }

    @Override
    public void visitSelect(JCTree.JCFieldAccess jCFieldAccess) {
        if (jCFieldAccess.sym instanceof Symbol.ClassSymbol && jCFieldAccess.type != null) {
            this.width(jCFieldAccess.type);
        } else {
            ++this.width;
            this.width((JCTree)jCFieldAccess.selected, 15);
            this.width(jCFieldAccess.name);
        }
    }

    @Override
    public void visitIdent(JCTree.JCIdent jCIdent) {
        if (jCIdent.sym instanceof Symbol.ClassSymbol) {
            this.width(jCIdent.type);
        } else {
            this.width(jCIdent.name);
        }
    }

    @Override
    public void visitLiteral(JCTree.JCLiteral jCLiteral) {
        switch (jCLiteral.typetag) {
            case 5: 
            case 6: {
                ++this.width;
                this.width(jCLiteral.value.toString());
                break;
            }
            case 2: {
                this.width += 3;
                break;
            }
            case 10: {
                this.width += 2;
                this.width(jCLiteral.value.toString());
                break;
            }
            case 8: {
                this.width(((Number)jCLiteral.value).intValue() == 1 ? "true" : "false");
                break;
            }
            case 17: {
                this.width("null");
                break;
            }
            default: {
                this.width(jCLiteral.value.toString());
            }
        }
    }

    @Override
    public void visitTypeIdent(JCTree.JCPrimitiveTypeTree jCPrimitiveTypeTree) {
        this.width(this.symbols.typeOfTag[jCPrimitiveTypeTree.typetag].tsym.name);
    }

    @Override
    public void visitTypeArray(JCTree.JCArrayTypeTree jCArrayTypeTree) {
        this.width(jCArrayTypeTree.elemtype);
        this.width += 2;
    }
}

