/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.save;

import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.BoundKind;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.Pretty;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Name;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.Comment;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.java.source.query.CommentHandler;
import org.netbeans.api.java.source.query.CommentSet;
import org.netbeans.api.java.source.transform.UndoList;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.java.source.JavaSourceAccessor;
import org.netbeans.modules.java.source.builder.ASTService;
import org.netbeans.modules.java.source.builder.CommentHandlerService;
import org.netbeans.modules.java.source.builder.UndoListService;
import org.netbeans.modules.java.source.engine.ASTModel;
import org.netbeans.modules.java.source.engine.JavaFormatOptions;
import org.netbeans.modules.java.source.engine.SourceRewriter;
import org.netbeans.modules.java.source.engine.StringSourceRewriter;
import org.netbeans.modules.java.source.pretty.VeryPretty;
import org.netbeans.modules.java.source.save.ComputeDiff;
import org.netbeans.modules.java.source.save.Difference;
import org.netbeans.modules.java.source.save.EstimatorFactory;
import org.netbeans.modules.java.source.save.ListMatcher;
import org.netbeans.modules.java.source.save.Measure;
import org.netbeans.modules.java.source.save.PositionEstimator;
import org.netbeans.modules.java.source.save.TokenUtilities;
import org.netbeans.modules.java.source.save.TreeDiff;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public class CasualDiff {
    protected ListBuffer<TreeDiff.Diff> diffs;
    protected CommentHandler comments;
    protected ASTModel model;
    protected UndoList undo;
    protected JCTree oldParent;
    protected JCTree newParent;
    protected JCTree.JCCompilationUnit oldTopLevel;
    private WorkingCopy workingCopy;
    private TokenSequence<JavaTokenId> tokenSequence;
    private SourceRewriter output;
    private String origText;
    private VeryPretty printer;
    private int pointer;
    private Context context;
    private Map<Integer, String> diffInfo = new HashMap<Integer, String>();
    private Name origClassName = null;
    boolean anonClass = false;
    private static final EnumSet<Tree.Kind> compAssign = EnumSet.of(Tree.Kind.MULTIPLY_ASSIGNMENT, new Tree.Kind[]{Tree.Kind.DIVIDE_ASSIGNMENT, Tree.Kind.REMAINDER_ASSIGNMENT, Tree.Kind.PLUS_ASSIGNMENT, Tree.Kind.MINUS_ASSIGNMENT, Tree.Kind.LEFT_SHIFT_ASSIGNMENT, Tree.Kind.RIGHT_SHIFT_ASSIGNMENT, Tree.Kind.UNSIGNED_RIGHT_SHIFT_ASSIGNMENT, Tree.Kind.AND_ASSIGNMENT, Tree.Kind.XOR_ASSIGNMENT, Tree.Kind.OR_ASSIGNMENT});
    private static final EnumSet<Tree.Kind> binaries = EnumSet.of(Tree.Kind.MULTIPLY, new Tree.Kind[]{Tree.Kind.DIVIDE, Tree.Kind.REMAINDER, Tree.Kind.PLUS, Tree.Kind.MINUS, Tree.Kind.LEFT_SHIFT, Tree.Kind.RIGHT_SHIFT, Tree.Kind.UNSIGNED_RIGHT_SHIFT, Tree.Kind.LESS_THAN, Tree.Kind.GREATER_THAN, Tree.Kind.LESS_THAN_EQUAL, Tree.Kind.GREATER_THAN_EQUAL, Tree.Kind.EQUAL_TO, Tree.Kind.NOT_EQUAL_TO, Tree.Kind.AND, Tree.Kind.XOR, Tree.Kind.OR, Tree.Kind.CONDITIONAL_AND, Tree.Kind.CONDITIONAL_OR});
    private static final EnumSet<Tree.Kind> unaries = EnumSet.of(Tree.Kind.POSTFIX_INCREMENT, new Tree.Kind[]{Tree.Kind.POSTFIX_DECREMENT, Tree.Kind.PREFIX_INCREMENT, Tree.Kind.PREFIX_DECREMENT, Tree.Kind.UNARY_PLUS, Tree.Kind.UNARY_MINUS, Tree.Kind.BITWISE_COMPLEMENT, Tree.Kind.LOGICAL_COMPLEMENT});
    private static boolean logDiffs = false;

    public CasualDiff() {
    }

    protected CasualDiff(Context context, WorkingCopy workingCopy) {
        this.diffs = new ListBuffer();
        this.comments = CommentHandlerService.instance(context);
        this.model = ASTService.instance(context);
        this.undo = UndoListService.instance(context);
        this.workingCopy = workingCopy;
        this.tokenSequence = workingCopy.getTokenHierarchy().tokenSequence();
        this.output = new StringSourceRewriter();
        this.origText = workingCopy.getText();
        this.context = context;
        this.printer = new VeryPretty(context, JavaFormatOptions.getDefault());
    }

    public List<TreeDiff.Diff> getDiffs() {
        return this.diffs.toList();
    }

    public static List<TreeDiff.Diff> diff(Context context, WorkingCopy workingCopy, JCTree jCTree, JCTree jCTree2) {
        CasualDiff casualDiff = new CasualDiff(context, workingCopy);
        try {
            casualDiff.diffTree(jCTree, jCTree2, new int[]{-1, -1});
            String string = casualDiff.output.toString();
            casualDiff.makeListMatch(casualDiff.workingCopy.getText(), string);
            JavaSourceAccessor.INSTANCE.getCommandEnvironment(casualDiff.workingCopy).setResult(casualDiff.diffInfo, "user-info");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return casualDiff.getDiffs();
    }

    private void append(TreeDiff.Diff diff) {
        for (TreeDiff.Diff diff2 : this.diffs) {
            if (!diff2.equals(diff)) continue;
            return;
        }
        this.diffs.append(diff);
    }

    private int endPos(JCTree jCTree) {
        return this.model.getEndPos(jCTree, this.oldTopLevel);
    }

    private int endPos(List<? extends JCTree> list) {
        int n = -1;
        if (list.nonEmpty()) {
            n = this.endPos((JCTree)list.head);
            List list2 = list.tail;
            while (list2.nonEmpty()) {
                n = this.endPos((JCTree)list2.head);
                list2 = list2.tail;
            }
        }
        return n;
    }

    private int endPos(java.util.List<? extends JCTree> list) {
        if (list.isEmpty()) {
            return -1;
        }
        return this.endPos(list.get(list.size() - 1));
    }

    protected void diffTopLevel(JCTree.JCCompilationUnit jCCompilationUnit, JCTree.JCCompilationUnit jCCompilationUnit2) {
        this.oldTopLevel = jCCompilationUnit;
        int n = 0;
        try {
            n = this.diffPackageStatement(jCCompilationUnit, jCCompilationUnit2, this.pointer);
            PositionEstimator positionEstimator = EstimatorFactory.imports(jCCompilationUnit.getImports(), jCCompilationUnit2.getImports(), this.workingCopy);
            this.pointer = this.diffListImports(jCCompilationUnit.getImports(), jCCompilationUnit2.getImports(), n, positionEstimator, Measure.DEFAULT, this.printer);
            if (((List)jCCompilationUnit.getTypeDecls()).nonEmpty()) {
                n = this.getOldPos((JCTree)((List)jCCompilationUnit.getTypeDecls()).head);
            }
            this.output.writeTo(this.printer.toString());
            this.printer.reset(0);
            positionEstimator = EstimatorFactory.toplevel(jCCompilationUnit.getTypeDecls(), jCCompilationUnit2.getTypeDecls(), this.workingCopy);
            int[] nArray = this.diffList(jCCompilationUnit.getTypeDecls(), jCCompilationUnit2.getTypeDecls(), n, positionEstimator, Measure.DEFAULT, this.printer);
            if (this.pointer < nArray[0]) {
                this.output.writeTo(this.origText.substring(this.pointer, nArray[0]));
            }
            if (nArray[1] > this.pointer) {
                this.pointer = nArray[1];
            }
            this.output.writeTo(this.printer.toString());
            this.output.writeTo(this.origText.substring(this.pointer));
        }
        catch (Exception exception) {
            Logger.getLogger("global").log(Level.SEVERE, "Error during generating!", exception);
            this.output = new StringSourceRewriter();
            try {
                this.output.writeTo(this.origText);
            }
            catch (BadLocationException badLocationException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private ChangeKind getChangeKind(Tree tree, Tree tree2) {
        if (tree == tree2) {
            return ChangeKind.NOCHANGE;
        }
        if (tree != null && tree2 != null) {
            return ChangeKind.MODIFY;
        }
        if (tree != null) {
            return ChangeKind.DELETE;
        }
        return ChangeKind.INSERT;
    }

    private int diffPackageStatement(JCTree.JCCompilationUnit jCCompilationUnit, JCTree.JCCompilationUnit jCCompilationUnit2, int n) {
        ChangeKind changeKind = this.getChangeKind(jCCompilationUnit.pid, jCCompilationUnit2.pid);
        switch (changeKind) {
            case NOCHANGE: {
                break;
            }
            case INSERT: {
                this.printer.print("package ");
                this.printer.print(jCCompilationUnit2.pid);
                this.printer.print(";");
                this.printer.newline();
                break;
            }
            case DELETE: {
                TokenUtilities.movePrevious(this.tokenSequence, jCCompilationUnit.pid.getStartPosition());
                this.copyTo(n, this.tokenSequence.offset());
                TokenUtilities.moveNext(this.tokenSequence, this.endPos(jCCompilationUnit.pid));
                n = this.tokenSequence.offset() + 1;
                break;
            }
            case MODIFY: {
                this.copyTo(n, this.getOldPos(jCCompilationUnit.pid));
                n = this.endPos(jCCompilationUnit.pid);
                this.printer.print(jCCompilationUnit2.pid);
                this.diffInfo.put(this.getOldPos(jCCompilationUnit.pid), "Update package statement");
            }
        }
        return n;
    }

    protected int diffImport(JCTree.JCImport jCImport, JCTree.JCImport jCImport2, int[] nArray) {
        int n = nArray[0];
        int[] nArray2 = this.getBounds((JCTree)jCImport.getQualifiedIdentifier());
        this.copyTo(n, nArray2[0]);
        n = this.diffTree((JCTree)jCImport.getQualifiedIdentifier(), (JCTree)jCImport2.getQualifiedIdentifier(), nArray2);
        this.copyTo(n, nArray[1]);
        return nArray[1];
    }

    protected int diffClassDef(JCTree.JCClassDecl jCClassDecl, JCTree.JCClassDecl jCClassDecl2, int[] nArray) {
        PositionEstimator positionEstimator;
        int n;
        int n2 = n = nArray[0];
        JCTree jCTree = this.oldParent;
        this.oldParent = jCClassDecl;
        JCTree jCTree2 = this.newParent;
        this.newParent = jCClassDecl2;
        if (!this.anonClass) {
            this.tokenSequence.move(jCClassDecl.pos);
            this.tokenSequence.moveNext();
            this.tokenSequence.moveNext();
            n2 = TokenUtilities.moveNext(this.tokenSequence, this.tokenSequence.offset());
            n = this.diffModifiers(jCClassDecl.mods, jCClassDecl2.mods, jCClassDecl, n);
            if (this.nameChanged(jCClassDecl.name, jCClassDecl2.name)) {
                this.copyTo(n, n2);
                this.printer.print(jCClassDecl2.name);
                this.diffInfo.put(n2, "Change class name");
                n = n2 += jCClassDecl.name.length();
                this.origClassName = jCClassDecl.name;
            } else {
                n2 += jCClassDecl.name.length();
            }
            n = this.diffParameterList(jCClassDecl.typarams, jCClassDecl2.typarams, n);
            if (jCClassDecl.typarams.nonEmpty()) {
                n2 = this.endPos(jCClassDecl.typarams.last());
                TokenUtilities.moveFwdToToken(this.tokenSequence, n2, JavaTokenId.GT);
                n2 = this.tokenSequence.offset() + JavaTokenId.GT.fixedText().length();
            }
            switch (this.getChangeKind(jCClassDecl.extending, jCClassDecl2.extending)) {
                case NOCHANGE: {
                    n2 = jCClassDecl.extending != null ? this.endPos(jCClassDecl.extending) : n2;
                    int n3 = n;
                    n = n2;
                    this.copyTo(n3, n);
                    break;
                }
                case MODIFY: {
                    this.copyTo(n, this.getOldPos(jCClassDecl.extending));
                    n = this.diffTree((JCTree)jCClassDecl.extending, (JCTree)jCClassDecl2.extending, this.getBounds(jCClassDecl.extending));
                    break;
                }
                case INSERT: {
                    this.copyTo(n, n2);
                    this.printer.print(" extends ");
                    this.printer.print(jCClassDecl2.extending);
                    n = n2;
                    break;
                }
                case DELETE: {
                    this.copyTo(n, n2);
                    n = this.endPos(jCClassDecl.extending);
                }
            }
            if (jCClassDecl.implementing.isEmpty()) {
                if (jCClassDecl.extending != null) {
                    n2 = this.endPos(jCClassDecl.extending);
                }
            } else {
                n2 = jCClassDecl.implementing.iterator().next().getStartPosition();
            }
            long l = jCClassDecl.sym != null ? jCClassDecl.sym.flags() : jCClassDecl.mods.flags;
            PositionEstimator positionEstimator2 = positionEstimator = (l & 0x200L) == 0L ? EstimatorFactory.implementz(jCClassDecl.getImplementsClause(), jCClassDecl2.getImplementsClause(), this.workingCopy) : EstimatorFactory.extendz(jCClassDecl.getImplementsClause(), jCClassDecl2.getImplementsClause(), this.workingCopy);
            if (!jCClassDecl2.implementing.isEmpty()) {
                this.copyTo(n, n2);
            }
            n = this.diffList2(jCClassDecl.implementing, jCClassDecl2.implementing, n2, positionEstimator);
            n2 = this.endPos(jCClassDecl) - 1;
            n2 = this.filterHidden(jCClassDecl.defs).isEmpty() ? this.endPos(jCClassDecl) - 1 : this.filterHidden(jCClassDecl.defs).get(0).getStartPosition();
            this.tokenSequence.move(n2);
            this.tokenSequence.moveNext();
            n2 = TokenUtilities.moveBackToToken(this.tokenSequence, n2, JavaTokenId.LBRACE) + 1;
        } else {
            n2 = TokenUtilities.moveFwdToToken(this.tokenSequence, this.getOldPos(jCClassDecl), JavaTokenId.LBRACE);
            this.tokenSequence.moveNext();
            n2 = this.tokenSequence.offset();
        }
        int n4 = this.printer.indent();
        VeryPretty veryPretty = new VeryPretty(this.context, JavaFormatOptions.getDefault());
        veryPretty.reset(n4);
        veryPretty.indent();
        veryPretty.enclClassName = jCClassDecl2.getSimpleName();
        positionEstimator = EstimatorFactory.members(this.filterHidden(jCClassDecl.defs), this.filterHidden(jCClassDecl2.defs), this.workingCopy);
        if (n < n2) {
            this.copyTo(n, n2);
        }
        n = this.diffListImports(this.filterHidden(jCClassDecl.defs), this.filterHidden(jCClassDecl2.defs), n2, positionEstimator, Measure.MEMBER, veryPretty);
        this.printer.print(veryPretty.toString());
        if (n != -1) {
            this.copyTo(n, nArray[1]);
        }
        this.oldParent = jCTree;
        this.newParent = jCTree2;
        this.origClassName = null;
        this.printer.undent(n4);
        return nArray[1];
    }

    private boolean hasModifiers(JCTree.JCModifiers jCModifiers) {
        return jCModifiers != null && (!jCModifiers.getFlags().isEmpty() || !((List)jCModifiers.getAnnotations()).isEmpty());
    }

    protected int diffMethodDef(JCTree.JCMethodDecl jCMethodDecl, JCTree.JCMethodDecl jCMethodDecl2, int[] nArray) {
        Object object;
        int n;
        int n2 = nArray[0];
        if (!this.matchModifiers(jCMethodDecl.mods, jCMethodDecl2.mods)) {
            if (this.hasModifiers(jCMethodDecl2.mods)) {
                n2 = this.diffModifiers(jCMethodDecl.mods, jCMethodDecl2.mods, jCMethodDecl, n2);
            } else {
                n = this.getOldPos(jCMethodDecl.mods);
                this.copyTo(n2, n);
                int n3 = n2 = jCMethodDecl.restype != null ? this.getOldPos(jCMethodDecl.restype) : jCMethodDecl.pos;
            }
        }
        int n4 = jCMethodDecl.typarams.isEmpty() ? (jCMethodDecl.restype != null ? this.getOldPos(jCMethodDecl.restype) : jCMethodDecl.pos) : (n = this.getOldPos((JCTree)jCMethodDecl.typarams.head));
        if (!this.listsMatch(jCMethodDecl.typarams, jCMethodDecl2.typarams)) {
            if (jCMethodDecl2.typarams.nonEmpty()) {
                this.copyTo(n2, n);
            } else if (this.hasModifiers(jCMethodDecl.mods)) {
                this.copyTo(n2, this.endPos(jCMethodDecl.mods));
            }
            object = new VeryPretty(this.context);
            n2 = this.diffParameterList(jCMethodDecl.typarams, jCMethodDecl2.typarams, jCMethodDecl.typarams.isEmpty() || jCMethodDecl2.typarams.isEmpty(), n, (VeryPretty)object);
            this.printer.print(((VeryPretty)object).toString());
        }
        if (jCMethodDecl.restype != null) {
            object = this.getBounds(jCMethodDecl.restype);
            this.copyTo(n2, object[0]);
            int n5 = n2 = this.diffTree((JCTree)jCMethodDecl.restype, (JCTree)jCMethodDecl2.restype, (int[])object);
            n2 = object[1];
            this.copyTo(n5, n2);
        }
        int n6 = jCMethodDecl.typarams.isEmpty() ? (jCMethodDecl.restype != null ? jCMethodDecl.restype.getStartPosition() : jCMethodDecl.getStartPosition()) : jCMethodDecl.typarams.iterator().next().getStartPosition();
        if (!jCMethodDecl.sym.isConstructor() || this.origClassName != null) {
            if (this.nameChanged(jCMethodDecl.name, jCMethodDecl2.name)) {
                this.copyTo(n2, jCMethodDecl.pos);
                if (jCMethodDecl.sym.isConstructor() && this.origClassName != null) {
                    this.printer.print(jCMethodDecl2.name);
                    n2 = jCMethodDecl.pos + this.origClassName.length();
                } else {
                    this.printer.print(jCMethodDecl2.name);
                    this.diffInfo.put(jCMethodDecl.pos, "Rename method " + jCMethodDecl.name);
                    n2 = jCMethodDecl.pos + jCMethodDecl.name.length();
                }
            } else {
                int n7 = n2;
                n2 = jCMethodDecl.pos + jCMethodDecl.name.length();
                this.copyTo(n7, n2);
            }
        }
        if (jCMethodDecl.params.isEmpty()) {
            int n8 = jCMethodDecl.restype != null ? jCMethodDecl.restype.getStartPosition() : jCMethodDecl.getStartPosition();
            TokenUtilities.moveFwdToToken(this.tokenSequence, n8, JavaTokenId.RPAREN);
            n6 = this.tokenSequence.offset();
        } else {
            n6 = jCMethodDecl.params.iterator().next().getStartPosition();
        }
        if (!this.listsMatch(jCMethodDecl.params, jCMethodDecl2.params)) {
            this.copyTo(n2, n6);
            VeryPretty veryPretty = new VeryPretty(this.context);
            veryPretty.setPrec(0);
            n2 = this.diffParameterList(jCMethodDecl.params, jCMethodDecl2.params, false, n6, veryPretty);
            this.printer.print(veryPretty.toString());
        }
        this.tokenSequence.moveNext();
        n6 = this.tokenSequence.offset();
        if (n2 < n6) {
            int n9 = n2;
            n2 = n6;
            this.copyTo(n9, n2);
        }
        if (jCMethodDecl.thrown.isEmpty()) {
            n6 = (jCMethodDecl.body == null ? this.endPos(jCMethodDecl) : jCMethodDecl.body.pos) - 1;
            this.tokenSequence.move(n6);
            this.tokenSequence.moveNext();
            if (this.tokenSequence.token().id() != JavaTokenId.WHITESPACE) {
                ++n6;
            }
        } else {
            n6 = jCMethodDecl.thrown.iterator().next().getStartPosition();
        }
        int n10 = n2;
        n2 = n6;
        this.copyTo(n10, n2);
        PositionEstimator positionEstimator = EstimatorFactory.throwz(jCMethodDecl.getThrows(), jCMethodDecl2.getThrows(), this.workingCopy);
        n2 = this.diffList2(jCMethodDecl.thrown, jCMethodDecl2.thrown, n6, positionEstimator);
        n6 = this.endPos(jCMethodDecl) - 1;
        n2 = this.diffTree((JCTree)jCMethodDecl.body, (JCTree)jCMethodDecl2.body, n2);
        this.copyTo(n2, nArray[1]);
        return nArray[1];
    }

    protected int diffVarDef(JCTree.JCVariableDecl jCVariableDecl, JCTree.JCVariableDecl jCVariableDecl2, int[] nArray) {
        int n = nArray[0];
        if (!this.matchModifiers(jCVariableDecl.mods, jCVariableDecl2.mods)) {
            if (this.hasModifiers(jCVariableDecl2.mods)) {
                n = this.diffModifiers(jCVariableDecl.mods, jCVariableDecl2.mods, jCVariableDecl, n);
            } else {
                int n2 = this.getOldPos(jCVariableDecl.mods);
                this.copyTo(n, n2);
                n = this.getOldPos(jCVariableDecl.vartype);
            }
        }
        int[] nArray2 = this.getBounds(jCVariableDecl.vartype);
        this.copyTo(n, nArray2[0]);
        n = this.diffTree((JCTree)jCVariableDecl.vartype, (JCTree)jCVariableDecl2.vartype, nArray2);
        if (this.nameChanged(jCVariableDecl.name, jCVariableDecl2.name)) {
            this.copyTo(n, jCVariableDecl.pos);
            this.printer.print(jCVariableDecl2.name);
            this.diffInfo.put(jCVariableDecl.pos, "Rename variable " + jCVariableDecl.name);
            n = jCVariableDecl.pos + jCVariableDecl.name.length();
        }
        if (jCVariableDecl2.init != null && jCVariableDecl.init != null) {
            int n3 = n;
            n = this.getOldPos(jCVariableDecl.init);
            this.copyTo(n3, n);
            n = this.diffTree((JCTree)jCVariableDecl.init, (JCTree)jCVariableDecl2.init, new int[]{n, this.endPos(jCVariableDecl.init)});
        } else {
            if (jCVariableDecl.init != null && jCVariableDecl2.init == null) {
                int n4 = this.getOldPos(jCVariableDecl.init);
                this.tokenSequence.move(n4);
                PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.BACKWARD);
                PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.BACKWARD);
                this.tokenSequence.moveNext();
                int n5 = this.tokenSequence.offset();
                this.copyTo(n, n5);
                n = this.endPos(jCVariableDecl.init);
            }
            if (jCVariableDecl.init == null && jCVariableDecl2.init != null) {
                int n6 = n;
                n = this.endPos(jCVariableDecl.init);
                this.copyTo(n6, n);
                this.printer.print(jCVariableDecl2.init);
            }
        }
        this.copyTo(n, nArray[1]);
        return nArray[1];
    }

    protected int diffBlock(JCTree.JCBlock jCBlock, JCTree.JCBlock jCBlock2, int n) {
        PositionEstimator positionEstimator;
        int[] nArray;
        int n2 = n;
        if (jCBlock.flags != jCBlock2.flags) {
            this.append(TreeDiff.Diff.flags(jCBlock.pos, this.endPos(jCBlock), jCBlock.flags, jCBlock2.flags));
        }
        VeryPretty veryPretty = new VeryPretty(this.context, JavaFormatOptions.getDefault());
        int n3 = this.printer.indent();
        veryPretty.reset(n3);
        veryPretty.indent();
        if (jCBlock.stats.head != null && ((JCTree.JCStatement)jCBlock.stats.head).pos == jCBlock.pos) {
            jCBlock.stats = jCBlock.stats.tail;
        }
        if (jCBlock2.stats.head != null && ((JCTree.JCStatement)jCBlock2.stats.head).pos == jCBlock.pos) {
            jCBlock2.stats = jCBlock2.stats.tail;
        }
        if (n2 < (nArray = this.diffList(jCBlock.stats, jCBlock2.stats, jCBlock.pos + 1, positionEstimator = EstimatorFactory.deprecated(jCBlock.getStatements(), jCBlock2.getStatements(), this.workingCopy), Measure.DEFAULT, veryPretty))[0]) {
            this.copyTo(n2, nArray[0]);
        }
        n2 = nArray[1];
        this.printer.print(veryPretty.toString());
        if (n2 < this.endPos(jCBlock)) {
            int n4 = n2;
            n2 = this.endPos(jCBlock);
            this.copyTo(n4, n2);
        }
        this.printer.undent(n3);
        return n2;
    }

    protected int diffDoLoop(JCTree.JCDoWhileLoop jCDoWhileLoop, JCTree.JCDoWhileLoop jCDoWhileLoop2, int[] nArray) {
        int n = nArray[0];
        int[] nArray2 = this.getBounds(jCDoWhileLoop.body);
        this.copyTo(n, nArray2[0]);
        n = this.diffTree((JCTree)jCDoWhileLoop.body, (JCTree)jCDoWhileLoop2.body, nArray2);
        int[] nArray3 = this.getBounds(jCDoWhileLoop.cond);
        this.copyTo(n, nArray3[0]);
        n = this.diffTree((JCTree)jCDoWhileLoop.cond, (JCTree)jCDoWhileLoop2.cond, nArray3);
        this.copyTo(n, nArray[1]);
        return nArray[1];
    }

    protected int diffWhileLoop(JCTree.JCWhileLoop jCWhileLoop, JCTree.JCWhileLoop jCWhileLoop2, int[] nArray) {
        int n = nArray[0];
        int[] nArray2 = this.getBounds(jCWhileLoop.cond);
        this.copyTo(n, nArray2[0]);
        n = this.diffTree((JCTree)jCWhileLoop.cond, (JCTree)jCWhileLoop2.cond, nArray2);
        int[] nArray3 = this.getBounds(jCWhileLoop.body);
        this.copyTo(n, nArray3[0]);
        n = this.diffTree((JCTree)jCWhileLoop.body, (JCTree)jCWhileLoop2.body, nArray3);
        this.copyTo(n, nArray[1]);
        return nArray[1];
    }

    protected int diffForLoop(JCTree.JCForLoop jCForLoop, JCTree.JCForLoop jCForLoop2, int[] nArray) {
        int n = nArray[0];
        int n2 = jCForLoop.cond != null ? jCForLoop.cond.pos - 1 : -2;
        int n3 = jCForLoop.cond != null ? this.endPos(jCForLoop.cond) + 1 : -2;
        this.copyTo(nArray[0], this.getOldPos((JCTree)jCForLoop.init.head));
        n = this.diffList(jCForLoop.init, jCForLoop2.init, TreeDiff.LineInsertionType.NONE, n2);
        this.copyTo(n, this.getOldPos(jCForLoop.cond));
        n = this.diffTree((JCTree)jCForLoop.cond, (JCTree)jCForLoop2.cond, this.getBounds(jCForLoop.cond));
        if (jCForLoop.step.nonEmpty()) {
            this.copyTo(n, this.getOldPos((JCTree)jCForLoop.step.head));
        } else {
            this.copyTo(n, n3);
        }
        n = this.diffList(jCForLoop.step, jCForLoop2.step, TreeDiff.LineInsertionType.NONE, n3);
        this.copyTo(n, this.getOldPos(jCForLoop.body));
        n = this.diffTree((JCTree)jCForLoop.body, (JCTree)jCForLoop2.body, this.getBounds(jCForLoop.body));
        this.copyTo(n, nArray[1]);
        return nArray[1];
    }

    protected int diffForeachLoop(JCTree.JCEnhancedForLoop jCEnhancedForLoop, JCTree.JCEnhancedForLoop jCEnhancedForLoop2, int[] nArray) {
        int n = nArray[0];
        int[] nArray2 = this.getBounds(jCEnhancedForLoop.var);
        this.copyTo(n, nArray2[0]);
        n = this.diffTree((JCTree)jCEnhancedForLoop.var, (JCTree)jCEnhancedForLoop2.var, nArray2);
        int[] nArray3 = this.getBounds(jCEnhancedForLoop.expr);
        this.copyTo(n, nArray3[0]);
        n = this.diffTree((JCTree)jCEnhancedForLoop.expr, (JCTree)jCEnhancedForLoop2.expr, nArray3);
        int[] nArray4 = this.getBounds(jCEnhancedForLoop.body);
        this.copyTo(n, nArray4[0]);
        n = this.diffTree((JCTree)jCEnhancedForLoop.body, (JCTree)jCEnhancedForLoop2.body, nArray4);
        this.copyTo(n, nArray[1]);
        return nArray[1];
    }

    protected int diffLabelled(JCTree.JCLabeledStatement jCLabeledStatement, JCTree.JCLabeledStatement jCLabeledStatement2, int[] nArray) {
        int n = nArray[0];
        if (this.nameChanged(jCLabeledStatement.label, jCLabeledStatement2.label)) {
            int n2 = n;
            n = this.getOldPos(jCLabeledStatement);
            this.copyTo(n2, n);
            this.printer.print(jCLabeledStatement2.label);
            n += jCLabeledStatement.label.length();
        }
        int[] nArray2 = this.getBounds(jCLabeledStatement.body);
        this.copyTo(n, nArray2[0]);
        n = this.diffTree((JCTree)jCLabeledStatement.body, (JCTree)jCLabeledStatement2.body, nArray2);
        this.copyTo(n, nArray[1]);
        return nArray[1];
    }

    protected int diffSwitch(JCTree.JCSwitch jCSwitch, JCTree.JCSwitch jCSwitch2, int[] nArray) {
        int n = nArray[0];
        int[] nArray2 = this.getBounds(jCSwitch.selector);
        this.copyTo(n, nArray2[0]);
        n = this.diffTree((JCTree)jCSwitch.selector, (JCTree)jCSwitch2.selector, nArray2);
        int n2 = jCSwitch.cases.size() > 0 ? ((JCTree.JCCase)jCSwitch.cases.head).pos : -2;
        PositionEstimator positionEstimator = EstimatorFactory.deprecated(jCSwitch.getCases(), jCSwitch2.getCases(), this.workingCopy);
        this.copyTo(n, n2);
        int[] nArray3 = this.diffList(jCSwitch.cases, jCSwitch2.cases, n2, positionEstimator, Measure.DEFAULT, this.printer);
        this.copyTo(nArray3[1], nArray[1]);
        return nArray[1];
    }

    protected int diffCase(JCTree.JCCase jCCase, JCTree.JCCase jCCase2, int[] nArray) {
        VeryPretty veryPretty;
        PositionEstimator positionEstimator;
        int n;
        int[] nArray2;
        int n2 = nArray[0];
        if (jCCase.pat != null) {
            int[] nArray3 = this.getBounds(jCCase.pat);
            this.copyTo(n2, nArray3[0]);
            n2 = this.diffTree((JCTree)jCCase.pat, (JCTree)jCCase2.pat, nArray3);
        }
        if (n2 < (nArray2 = this.diffList(jCCase.stats, jCCase2.stats, n = ((JCTree.JCStatement)jCCase.stats.head).pos, positionEstimator = EstimatorFactory.deprecated(jCCase.getStatements(), jCCase2.getStatements(), this.workingCopy), Measure.DEFAULT, veryPretty = new VeryPretty(this.context, JavaFormatOptions.getDefault())))[0]) {
            this.copyTo(n2, nArray2[0]);
        }
        this.printer.print(veryPretty.toString());
        this.copyTo(nArray2[1], nArray[1]);
        return nArray[1];
    }

    protected int diffSynchronized(JCTree.JCSynchronized jCSynchronized, JCTree.JCSynchronized jCSynchronized2, int[] nArray) {
        int n = nArray[0];
        int[] nArray2 = this.getBounds(jCSynchronized.lock);
        this.copyTo(n, nArray2[0]);
        n = this.diffTree((JCTree)jCSynchronized.lock, (JCTree)jCSynchronized2.lock, nArray2);
        int[] nArray3 = this.getBounds(jCSynchronized.body);
        this.copyTo(n, nArray3[0]);
        n = this.diffTree((JCTree)jCSynchronized.body, (JCTree)jCSynchronized2.body, nArray3);
        this.copyTo(n, nArray[1]);
        return nArray[1];
    }

    protected int diffTry(JCTree.JCTry jCTry, JCTree.JCTry jCTry2, int[] nArray) {
        int n = nArray[0];
        int[] nArray2 = this.getBounds(jCTry.body);
        this.copyTo(n, nArray2[0]);
        n = this.diffTree((JCTree)jCTry.body, (JCTree)jCTry2.body, nArray2);
        int n2 = jCTry.catchers.head != null ? this.getOldPos((JCTree)jCTry.catchers.head) : jCTry.body.endpos + 1;
        VeryPretty veryPretty = new VeryPretty(this.context);
        PositionEstimator positionEstimator = EstimatorFactory.deprecated(jCTry.getCatches(), jCTry2.getCatches(), this.workingCopy);
        int[] nArray3 = this.diffList(jCTry.catchers, jCTry2.catchers, n2, positionEstimator, Measure.DEFAULT, veryPretty);
        if (n < nArray3[0]) {
            this.copyTo(n, nArray3[0]);
        }
        this.printer.print(veryPretty.toString());
        int n3 = n = jCTry.catchers.head != null ? this.endPos(jCTry.catchers) : n2;
        if (jCTry.finalizer != null) {
            int[] nArray4 = this.getBounds(jCTry.finalizer);
            this.copyTo(n, nArray4[0]);
            n = this.diffTree((JCTree)jCTry.finalizer, (JCTree)jCTry2.finalizer, nArray4);
            this.copyTo(n, nArray[1]);
        } else if (nArray3[1] < nArray[1]) {
            this.copyTo(n, nArray[1]);
        }
        return nArray[1];
    }

    protected int diffCatch(JCTree.JCCatch jCCatch, JCTree.JCCatch jCCatch2, int[] nArray) {
        int n = nArray[0];
        int[] nArray2 = this.getBounds(jCCatch.param);
        this.copyTo(n, nArray2[0]);
        n = this.diffTree((JCTree)jCCatch.param, (JCTree)jCCatch2.param, nArray2);
        int[] nArray3 = this.getBounds(jCCatch.body);
        this.copyTo(n, nArray3[0]);
        n = this.diffTree((JCTree)jCCatch.body, (JCTree)jCCatch2.body, nArray3);
        this.copyTo(n, nArray[1]);
        return nArray[1];
    }

    protected int diffConditional(JCTree.JCConditional jCConditional, JCTree.JCConditional jCConditional2, int[] nArray) {
        int n = nArray[0];
        int[] nArray2 = this.getBounds(jCConditional.cond);
        this.copyTo(n, nArray2[0]);
        n = this.diffTree((JCTree)jCConditional.cond, (JCTree)jCConditional2.cond, nArray2);
        int[] nArray3 = this.getBounds(jCConditional.truepart);
        this.copyTo(n, nArray3[0]);
        n = this.diffTree((JCTree)jCConditional.truepart, (JCTree)jCConditional2.truepart, nArray3);
        int[] nArray4 = this.getBounds(jCConditional.falsepart);
        this.copyTo(n, nArray4[0]);
        n = this.diffTree((JCTree)jCConditional.falsepart, (JCTree)jCConditional2.falsepart, nArray4);
        this.copyTo(n, nArray[1]);
        return nArray[1];
    }

    protected int diffIf(JCTree.JCIf jCIf, JCTree.JCIf jCIf2, int[] nArray) {
        int n = nArray[0];
        if (jCIf.elsepart == null && jCIf2.elsepart != null || jCIf.elsepart != null && jCIf2.elsepart == null) {
            this.append(TreeDiff.Diff.modify(jCIf, this.getOldPos(jCIf), jCIf2));
        } else {
            int[] nArray2 = this.getBounds(jCIf.cond);
            this.copyTo(n, nArray2[0]);
            n = this.diffTree((JCTree)jCIf.cond, (JCTree)jCIf2.cond, nArray2);
            int[] nArray3 = this.getBounds(jCIf.thenpart);
            this.copyTo(n, nArray3[0]);
            n = this.diffTree((JCTree)jCIf.thenpart, (JCTree)jCIf2.thenpart, nArray3);
            if (jCIf.elsepart != null) {
                nArray3 = new int[]{this.getOldPos(jCIf.elsepart), this.endPos(jCIf.elsepart)};
                this.copyTo(n, nArray3[0]);
                n = this.diffTree((JCTree)jCIf.elsepart, (JCTree)jCIf2.elsepart, nArray3);
            }
        }
        this.copyTo(n, nArray[1]);
        return nArray[1];
    }

    protected int diffExec(JCTree.JCExpressionStatement jCExpressionStatement, JCTree.JCExpressionStatement jCExpressionStatement2, int[] nArray) {
        int n = this.getOldPos(jCExpressionStatement);
        this.copyTo(nArray[0], n);
        n = this.diffTree((JCTree)jCExpressionStatement.expr, (JCTree)jCExpressionStatement2.expr, nArray);
        this.copyTo(n, nArray[1]);
        return nArray[1];
    }

    protected int diffBreak(JCTree.JCBreak jCBreak, JCTree.JCBreak jCBreak2, int[] nArray) {
        int n = nArray[0];
        if (this.nameChanged(jCBreak.label, jCBreak2.label)) {
            int n2 = n;
            n = this.getOldPos(jCBreak);
            this.copyTo(n2, n);
            this.printer.print("break ");
            this.printer.print(jCBreak2.label);
            n += 6 + jCBreak.label.length();
        }
        this.copyTo(n, nArray[1]);
        return nArray[1];
    }

    protected int diffContinue(JCTree.JCContinue jCContinue, JCTree.JCContinue jCContinue2, int[] nArray) {
        int n = nArray[0];
        if (this.nameChanged(jCContinue.label, jCContinue2.label)) {
            int n2 = n;
            n = this.getOldPos(jCContinue);
            this.copyTo(n2, n);
            this.printer.print("continue ");
            this.printer.print(jCContinue2.label);
            n += 9 + jCContinue.label.length();
        }
        this.copyTo(n, nArray[1]);
        return nArray[1];
    }

    protected int diffReturn(JCTree.JCReturn jCReturn, JCTree.JCReturn jCReturn2, int[] nArray) {
        int[] nArray2 = this.getBounds(jCReturn.expr);
        this.copyTo(nArray[0], nArray2[0]);
        int n = this.diffTree((JCTree)jCReturn.expr, (JCTree)jCReturn2.expr, nArray2);
        this.copyTo(n, nArray[1]);
        return nArray[1];
    }

    protected int diffThrow(JCTree.JCThrow jCThrow, JCTree.JCThrow jCThrow2, int[] nArray) {
        int n = nArray[0];
        int[] nArray2 = this.getBounds(jCThrow.expr);
        this.copyTo(n, nArray2[0]);
        n = this.diffTree((JCTree)jCThrow.expr, (JCTree)jCThrow2.expr, nArray2);
        this.copyTo(n, nArray[1]);
        return nArray[1];
    }

    protected int diffAssert(JCTree.JCAssert jCAssert, JCTree.JCAssert jCAssert2, int[] nArray) {
        int n = nArray[0];
        int[] nArray2 = this.getBounds(jCAssert.cond);
        this.copyTo(n, nArray2[0]);
        n = this.diffTree((JCTree)jCAssert.cond, (JCTree)jCAssert2.cond, nArray2);
        int[] nArray3 = this.getBounds(jCAssert.detail);
        this.copyTo(n, nArray3[0]);
        n = this.diffTree((JCTree)jCAssert.detail, (JCTree)jCAssert2.detail, nArray3);
        this.copyTo(n, nArray[1]);
        return nArray[1];
    }

    protected int diffApply(JCTree.JCMethodInvocation jCMethodInvocation, JCTree.JCMethodInvocation jCMethodInvocation2, int[] nArray) {
        int n = nArray[0];
        this.diffParameterList(jCMethodInvocation.typeargs, jCMethodInvocation2.typeargs, n);
        int[] nArray2 = this.getBounds(jCMethodInvocation.meth);
        n = this.diffTree((JCTree)jCMethodInvocation.meth, (JCTree)jCMethodInvocation2.meth, nArray2);
        if (!this.listsMatch(jCMethodInvocation.args, jCMethodInvocation2.args)) {
            if (jCMethodInvocation.args.nonEmpty()) {
                int n2 = n;
                n = this.getOldPos((JCTree)jCMethodInvocation.args.head);
                this.copyTo(n2, n);
            } else {
                int n3 = TokenUtilities.moveFwdToToken(this.tokenSequence, this.getOldPos(jCMethodInvocation.meth), JavaTokenId.RPAREN);
                int n4 = n;
                n = n3;
                this.copyTo(n4, n);
            }
            VeryPretty veryPretty = new VeryPretty(this.context, JavaFormatOptions.getDefault());
            n = this.diffParameterList(jCMethodInvocation.args, jCMethodInvocation2.args, false, n, veryPretty);
            this.printer.print(veryPretty.toString());
        }
        this.copyTo(n, nArray[1]);
        return nArray[1];
    }

    protected int diffNewClass(JCTree.JCNewClass jCNewClass, JCTree.JCNewClass jCNewClass2, int[] nArray) {
        int[] nArray2;
        int n = nArray[0];
        if (jCNewClass.encl != null) {
            nArray2 = this.getBounds(jCNewClass.encl);
            n = this.diffTree((JCTree)jCNewClass.encl, (JCTree)jCNewClass2.encl, nArray2);
        }
        this.diffParameterList(jCNewClass.typeargs, jCNewClass2.typeargs, n);
        nArray2 = this.getBounds(jCNewClass.clazz);
        this.copyTo(n, nArray2[0]);
        n = this.diffTree((JCTree)jCNewClass.clazz, (JCTree)jCNewClass2.clazz, nArray2);
        n = this.diffParameterList(jCNewClass.args, jCNewClass2.args, n);
        if (jCNewClass.def != null) {
            this.copyTo(n, this.getOldPos(jCNewClass.def));
            if (jCNewClass2.def != null) {
                this.anonClass = true;
                n = this.diffTree((JCTree)jCNewClass.def, (JCTree)jCNewClass2.def, this.getBounds(jCNewClass.def));
                this.anonClass = false;
            } else {
                n = this.endPos(jCNewClass.def);
            }
        }
        this.copyTo(n, nArray[1]);
        return nArray[1];
    }

    protected int diffNewArray(JCTree.JCNewArray jCNewArray, JCTree.JCNewArray jCNewArray2, int[] nArray) {
        int n = nArray[0];
        if (jCNewArray.elemtype != null) {
            int[] nArray2 = this.getBounds(jCNewArray.elemtype);
            this.copyTo(n, nArray2[0]);
            n = this.diffTree((JCTree)jCNewArray.elemtype, (JCTree)jCNewArray2.elemtype, nArray2);
        }
        if (jCNewArray.elems != null && jCNewArray.elems.head != null) {
            this.copyTo(n, this.getOldPos((JCTree)jCNewArray.elems.head));
            n = this.diffParameterList(jCNewArray.elems, jCNewArray2.elems, this.getOldPos((JCTree)jCNewArray.elems.head));
        }
        this.copyTo(n, nArray[1]);
        return nArray[1];
    }

    protected int diffParens(JCTree.JCParens jCParens, JCTree.JCParens jCParens2, int[] nArray) {
        int n = nArray[0];
        this.copyTo(n, this.getOldPos(jCParens.expr));
        n = this.diffTree((JCTree)jCParens.expr, (JCTree)jCParens2.expr, this.getBounds(jCParens.expr));
        return n;
    }

    protected int diffAssign(JCTree.JCAssign jCAssign, JCTree.JCAssign jCAssign2, int[] nArray) {
        int n = nArray[0];
        int[] nArray2 = this.getBounds(jCAssign.lhs);
        this.copyTo(n, nArray2[0]);
        n = this.diffTree((JCTree)jCAssign.lhs, (JCTree)jCAssign2.lhs, nArray2);
        int[] nArray3 = this.getBounds(jCAssign.rhs);
        this.copyTo(n, nArray3[0]);
        n = this.diffTree((JCTree)jCAssign.rhs, (JCTree)jCAssign2.rhs, nArray3);
        this.copyTo(n, nArray[1]);
        return nArray[1];
    }

    protected int diffAssignop(JCTree.JCAssignOp jCAssignOp, JCTree.JCAssignOp jCAssignOp2, int[] nArray) {
        int n = nArray[0];
        int[] nArray2 = this.getBounds(jCAssignOp.lhs);
        this.copyTo(n, nArray2[0]);
        n = this.diffTree((JCTree)jCAssignOp.lhs, (JCTree)jCAssignOp2.lhs, nArray2);
        if (jCAssignOp.tag != jCAssignOp2.tag) {
            this.copyTo(n, jCAssignOp.pos);
            this.printer.print(this.getAssignementOperator(jCAssignOp2));
            n = jCAssignOp.pos + this.getAssignementOperator(jCAssignOp).length();
        }
        int[] nArray3 = this.getBounds(jCAssignOp.rhs);
        this.copyTo(n, nArray3[0]);
        n = this.diffTree((JCTree)jCAssignOp.rhs, (JCTree)jCAssignOp2.rhs, nArray3);
        this.copyTo(n, nArray[1]);
        return nArray[1];
    }

    String getAssignementOperator(Tree tree) {
        switch (tree.getKind()) {
            case MULTIPLY_ASSIGNMENT: {
                return "*=";
            }
            case DIVIDE_ASSIGNMENT: {
                return "/=";
            }
            case REMAINDER_ASSIGNMENT: {
                return "%=";
            }
            case PLUS_ASSIGNMENT: {
                return "+=";
            }
            case MINUS_ASSIGNMENT: {
                return "-=";
            }
            case LEFT_SHIFT_ASSIGNMENT: {
                return "<<=";
            }
            case RIGHT_SHIFT_ASSIGNMENT: {
                return ">>=";
            }
            case AND_ASSIGNMENT: {
                return "&=";
            }
            case XOR_ASSIGNMENT: {
                return "^=";
            }
            case OR_ASSIGNMENT: {
                return "|=";
            }
            case UNSIGNED_RIGHT_SHIFT_ASSIGNMENT: {
                return ">>>=";
            }
        }
        throw new IllegalArgumentException("Illegal kind " + (Object)((Object)tree.getKind()));
    }

    protected int diffUnary(JCTree.JCUnary jCUnary, JCTree.JCUnary jCUnary2, int[] nArray) {
        int n = nArray[0];
        int[] nArray2 = this.getBounds(jCUnary.arg);
        this.copyTo(n, nArray2[0]);
        n = this.diffTree((JCTree)jCUnary.arg, (JCTree)jCUnary2.arg, nArray2);
        if (jCUnary.tag != jCUnary2.tag) {
            this.copyTo(n, jCUnary.pos);
            this.printer.print(this.operatorName(jCUnary2.tag));
            n = jCUnary.pos + this.operatorName(jCUnary.tag).length();
        }
        this.copyTo(n, nArray[1]);
        return nArray[1];
    }

    protected int diffBinary(JCTree.JCBinary jCBinary, JCTree.JCBinary jCBinary2, int[] nArray) {
        int n = nArray[0];
        int[] nArray2 = this.getBounds(jCBinary.lhs);
        this.copyTo(n, nArray2[0]);
        n = this.diffTree((JCTree)jCBinary.lhs, (JCTree)jCBinary2.lhs, nArray2);
        if (jCBinary.tag != jCBinary2.tag) {
            this.copyTo(n, jCBinary.pos);
            this.printer.print(this.operatorName(jCBinary2.tag));
            n = jCBinary.pos + this.operatorName(jCBinary.tag).toString().length();
        }
        int[] nArray3 = this.getBounds(jCBinary.rhs);
        this.copyTo(n, nArray3[0]);
        n = this.diffTree((JCTree)jCBinary.rhs, (JCTree)jCBinary2.rhs, nArray3);
        this.copyTo(n, nArray[1]);
        return nArray[1];
    }

    private String operatorName(int n) {
        return new Pretty(null, false).operatorName(n);
    }

    protected int diffTypeCast(JCTree.JCTypeCast jCTypeCast, JCTree.JCTypeCast jCTypeCast2, int[] nArray) {
        int n = nArray[0];
        int[] nArray2 = this.getBounds(jCTypeCast.clazz);
        this.copyTo(n, nArray2[0]);
        n = this.diffTree(jCTypeCast.clazz, jCTypeCast2.clazz, nArray2);
        int[] nArray3 = this.getBounds(jCTypeCast.expr);
        this.copyTo(n, nArray3[0]);
        n = this.diffTree((JCTree)jCTypeCast.expr, (JCTree)jCTypeCast2.expr, nArray3);
        this.copyTo(n, nArray[1]);
        return nArray[1];
    }

    protected int diffTypeTest(JCTree.JCInstanceOf jCInstanceOf, JCTree.JCInstanceOf jCInstanceOf2, int[] nArray) {
        int n = nArray[0];
        int[] nArray2 = this.getBounds(jCInstanceOf.expr);
        this.copyTo(n, nArray2[0]);
        n = this.diffTree((JCTree)jCInstanceOf.expr, (JCTree)jCInstanceOf2.expr, nArray2);
        int[] nArray3 = this.getBounds(jCInstanceOf.clazz);
        this.copyTo(n, nArray3[0]);
        n = this.diffTree(jCInstanceOf.clazz, jCInstanceOf2.clazz, nArray3);
        this.copyTo(n, nArray[1]);
        return nArray[1];
    }

    protected int diffIndexed(JCTree.JCArrayAccess jCArrayAccess, JCTree.JCArrayAccess jCArrayAccess2, int[] nArray) {
        int n = nArray[0];
        int[] nArray2 = this.getBounds(jCArrayAccess.indexed);
        this.copyTo(n, nArray2[0]);
        n = this.diffTree((JCTree)jCArrayAccess.indexed, (JCTree)jCArrayAccess2.indexed, nArray2);
        int[] nArray3 = this.getBounds(jCArrayAccess.index);
        this.copyTo(n, nArray3[0]);
        n = this.diffTree((JCTree)jCArrayAccess.index, (JCTree)jCArrayAccess2.index, nArray3);
        this.copyTo(n, nArray[1]);
        return nArray[1];
    }

    protected int diffSelect(JCTree.JCFieldAccess jCFieldAccess, JCTree.JCFieldAccess jCFieldAccess2, int[] nArray) {
        int n = nArray[0];
        this.copyTo(n, this.getOldPos(jCFieldAccess.selected));
        n = this.diffTree((JCTree)jCFieldAccess.selected, (JCTree)jCFieldAccess2.selected, this.getBounds(jCFieldAccess.selected));
        if (this.nameChanged(jCFieldAccess.name, jCFieldAccess2.name)) {
            this.copyTo(n, this.endPos(jCFieldAccess.selected));
            this.printer.print(".");
            this.printer.print(jCFieldAccess2.name);
            this.diffInfo.put(this.endPos(jCFieldAccess.selected) + 1, "Update reference to " + jCFieldAccess.name);
            n = this.endPos(jCFieldAccess.selected) + 1 + jCFieldAccess.name.length();
        }
        this.copyTo(n, nArray[1]);
        return nArray[1];
    }

    protected int diffIdent(JCTree.JCIdent jCIdent, JCTree.JCIdent jCIdent2, int n) {
        if (this.nameChanged(jCIdent.name, jCIdent2.name)) {
            this.copyTo(n, jCIdent.pos);
            this.printer.print(jCIdent2.name);
            this.diffInfo.put(jCIdent.pos, "Update reference to " + jCIdent.name);
            return this.endPos(jCIdent);
        }
        return n;
    }

    protected int diffLiteral(JCTree.JCLiteral jCLiteral, JCTree.JCLiteral jCLiteral2, int[] nArray) {
        if (jCLiteral.typetag != jCLiteral2.typetag || !jCLiteral.value.equals(jCLiteral2.value)) {
            int n = nArray[0];
            int[] nArray2 = this.getBounds(jCLiteral);
            this.copyTo(n, nArray2[0]);
            this.printer.print(jCLiteral2);
            this.copyTo(nArray2[1], nArray[1]);
        } else {
            this.copyTo(nArray[0], nArray[1]);
        }
        return nArray[1];
    }

    protected void diffTypeIdent(JCTree.JCPrimitiveTypeTree jCPrimitiveTypeTree, JCTree.JCPrimitiveTypeTree jCPrimitiveTypeTree2) {
        if (jCPrimitiveTypeTree.typetag != jCPrimitiveTypeTree2.typetag) {
            this.append(TreeDiff.Diff.modify(jCPrimitiveTypeTree, this.getOldPos(jCPrimitiveTypeTree), jCPrimitiveTypeTree2));
        }
    }

    protected int diffTypeArray(JCTree.JCArrayTypeTree jCArrayTypeTree, JCTree.JCArrayTypeTree jCArrayTypeTree2, int[] nArray) {
        int n = nArray[0];
        this.copyTo(n, nArray[0]);
        int[] nArray2 = this.getBounds(jCArrayTypeTree.elemtype);
        n = this.diffTree((JCTree)jCArrayTypeTree.elemtype, (JCTree)jCArrayTypeTree2.elemtype, nArray2);
        this.copyTo(n, nArray[1]);
        return nArray[1];
    }

    protected int diffTypeApply(JCTree.JCTypeApply jCTypeApply, JCTree.JCTypeApply jCTypeApply2, int[] nArray) {
        int n = nArray[0];
        int[] nArray2 = this.getBounds(jCTypeApply.clazz);
        this.copyTo(n, nArray2[0]);
        n = this.diffTree((JCTree)jCTypeApply.clazz, (JCTree)jCTypeApply2.clazz, nArray2);
        if (!this.listsMatch(jCTypeApply.arguments, jCTypeApply2.arguments)) {
            int n2;
            int n3 = n2 = jCTypeApply.arguments.nonEmpty() ? this.getOldPos((JCTree)jCTypeApply.arguments.head) : this.endPos(jCTypeApply.clazz);
            if (jCTypeApply2.arguments.nonEmpty()) {
                this.copyTo(n, n2);
            }
            VeryPretty veryPretty = new VeryPretty(this.context);
            n = this.diffParameterList(jCTypeApply.arguments, jCTypeApply2.arguments, jCTypeApply.arguments.isEmpty() || jCTypeApply2.arguments.isEmpty(), n2, veryPretty);
            this.printer.print(veryPretty.toString());
        }
        this.copyTo(n, nArray[1]);
        return nArray[1];
    }

    protected int diffTypeParameter(JCTree.JCTypeParameter jCTypeParameter, JCTree.JCTypeParameter jCTypeParameter2, int[] nArray) {
        int n = nArray[0];
        this.copyTo(n, this.getOldPos(jCTypeParameter));
        if (this.nameChanged(jCTypeParameter.name, jCTypeParameter2.name)) {
            this.printer.print(jCTypeParameter2.name);
            n += jCTypeParameter.name.length();
        }
        if (!this.listsMatch(jCTypeParameter.bounds, jCTypeParameter2.bounds)) {
            int n2;
            PositionEstimator positionEstimator = EstimatorFactory.implementz(jCTypeParameter.getBounds(), jCTypeParameter2.getBounds(), this.workingCopy);
            int n3 = n2 = jCTypeParameter.bounds.nonEmpty() ? this.getOldPos((JCTree)jCTypeParameter.bounds.head) : -1;
            if (n2 > -1) {
                this.copyTo(n, n2);
                n = this.diffList2(jCTypeParameter.bounds, jCTypeParameter2.bounds, n2, positionEstimator);
            }
        }
        this.copyTo(n, nArray[1]);
        return nArray[1];
    }

    protected int diffWildcard(JCTree.JCWildcard jCWildcard, JCTree.JCWildcard jCWildcard2, int[] nArray) {
        int n = nArray[0];
        if (jCWildcard.kind != jCWildcard2.kind) {
            this.copyTo(n, jCWildcard.pos);
            this.printer.print(((BoundKind)((Object)jCWildcard2.kind)).toString());
            n = jCWildcard.pos + ((BoundKind)((Object)jCWildcard.kind)).toString().length();
        }
        int[] nArray2 = this.getBounds(jCWildcard.inner);
        this.copyTo(n, nArray2[0]);
        n = this.diffTree(jCWildcard.inner, jCWildcard2.inner, nArray2);
        this.copyTo(n, nArray[1]);
        return nArray[1];
    }

    protected int diffTypeBoundKind(JCTree.TypeBoundKind typeBoundKind, JCTree.TypeBoundKind typeBoundKind2, int[] nArray) {
        int n = nArray[0];
        if (typeBoundKind.kind != typeBoundKind2.kind) {
            this.copyTo(n, typeBoundKind.pos);
            this.printer.print(typeBoundKind2.kind.toString());
            n = typeBoundKind.pos + typeBoundKind.kind.toString().length();
        }
        this.copyTo(n, nArray[1]);
        return nArray[1];
    }

    protected int diffAnnotation(JCTree.JCAnnotation jCAnnotation, JCTree.JCAnnotation jCAnnotation2, int[] nArray) {
        int n = nArray[0];
        int[] nArray2 = this.getBounds(jCAnnotation.annotationType);
        this.copyTo(n, nArray2[0]);
        n = this.diffTree(jCAnnotation.annotationType, jCAnnotation2.annotationType, nArray2);
        this.diffParameterList(jCAnnotation.args, jCAnnotation2.args, -1);
        this.copyTo(n, nArray[1]);
        return nArray[1];
    }

    protected int diffModifiers(JCTree.JCModifiers jCModifiers, JCTree.JCModifiers jCModifiers2, JCTree jCTree, int n) {
        int n2;
        if (jCModifiers == jCModifiers2) {
            return n;
        }
        int n3 = this.endPos(jCModifiers.annotations);
        int n4 = n2 = jCModifiers.pos != -1 ? this.getOldPos(jCModifiers) : this.getOldPos(jCTree);
        if (this.listsMatch(jCModifiers.annotations, jCModifiers2.annotations)) {
            int n5 = n;
            n = n2;
            this.copyTo(n5, n);
            if (n3 > 0) {
                int n6 = n;
                n = n3;
                this.copyTo(n6, n);
            }
        } else {
            if (jCModifiers.annotations.isEmpty()) {
                this.copyTo(n, n2);
            }
            PositionEstimator positionEstimator = EstimatorFactory.toplevel(jCModifiers.getAnnotations(), jCModifiers2.getAnnotations(), this.workingCopy);
            int[] nArray = this.diffList(jCModifiers.annotations, jCModifiers2.annotations, n2, positionEstimator, Measure.DEFAULT, this.printer);
            n = nArray[1];
        }
        if (jCModifiers.flags != jCModifiers2.flags) {
            int n7 = this.endPos(jCModifiers);
            if (n7 > 0) {
                this.printer.print(jCModifiers2.toString().trim());
                n = n7;
            } else {
                this.printer.print(jCModifiers2.toString());
            }
        }
        if (this.endPos(jCModifiers) > 0) {
            this.copyTo(n, this.endPos(jCModifiers));
            return this.endPos(jCModifiers);
        }
        return n;
    }

    protected void diffLetExpr(JCTree.LetExpr letExpr, JCTree.LetExpr letExpr2) {
        this.diffList(letExpr.defs, letExpr2.defs, TreeDiff.LineInsertionType.NONE, -2);
        this.diffTree((JCTree)letExpr.expr, (JCTree)letExpr2.expr, this.getBounds(letExpr.expr));
    }

    protected void diffErroneous(JCTree.JCErroneous jCErroneous, JCTree.JCErroneous jCErroneous2) {
        this.diffList(jCErroneous.errs, jCErroneous2.errs, TreeDiff.LineInsertionType.BEFORE, -2);
    }

    protected boolean listContains(java.util.List<? extends JCTree> list, JCTree jCTree) {
        for (JCTree jCTree2 : list) {
            if (!this.treesMatch(jCTree2, jCTree)) continue;
            return true;
        }
        return false;
    }

    protected boolean treesMatch(JCTree jCTree, JCTree jCTree2) {
        return this.treesMatch(jCTree, jCTree2, true);
    }

    public boolean treesMatch(JCTree jCTree, JCTree jCTree2, boolean bl) {
        if (jCTree == jCTree2) {
            return true;
        }
        if (jCTree == null || jCTree2 == null) {
            return false;
        }
        if (jCTree.tag != jCTree2.tag) {
            return false;
        }
        if (!bl) {
            return true;
        }
        switch (jCTree.tag) {
            case 1: {
                return ((JCTree.JCCompilationUnit)jCTree).sourcefile.equals(((JCTree.JCCompilationUnit)jCTree2).sourcefile);
            }
            case 2: {
                return this.matchImport((JCTree.JCImport)jCTree, (JCTree.JCImport)jCTree2);
            }
            case 3: {
                return ((JCTree.JCClassDecl)jCTree).sym == ((JCTree.JCClassDecl)jCTree2).sym;
            }
            case 4: {
                return ((JCTree.JCMethodDecl)jCTree).sym == ((JCTree.JCMethodDecl)jCTree2).sym;
            }
            case 5: {
                return ((JCTree.JCVariableDecl)jCTree).sym == ((JCTree.JCVariableDecl)jCTree2).sym;
            }
            case 6: {
                return true;
            }
            case 7: {
                return this.matchBlock((JCTree.JCBlock)jCTree, (JCTree.JCBlock)jCTree2);
            }
            case 8: {
                return this.matchDoLoop((JCTree.JCDoWhileLoop)jCTree, (JCTree.JCDoWhileLoop)jCTree2);
            }
            case 9: {
                return this.matchWhileLoop((JCTree.JCWhileLoop)jCTree, (JCTree.JCWhileLoop)jCTree2);
            }
            case 10: {
                return this.matchForLoop((JCTree.JCForLoop)jCTree, (JCTree.JCForLoop)jCTree2);
            }
            case 11: {
                return this.matchForeachLoop((JCTree.JCEnhancedForLoop)jCTree, (JCTree.JCEnhancedForLoop)jCTree2);
            }
            case 12: {
                return this.matchLabelled((JCTree.JCLabeledStatement)jCTree, (JCTree.JCLabeledStatement)jCTree2);
            }
            case 13: {
                return this.matchSwitch((JCTree.JCSwitch)jCTree, (JCTree.JCSwitch)jCTree2);
            }
            case 14: {
                return this.matchCase((JCTree.JCCase)jCTree, (JCTree.JCCase)jCTree2);
            }
            case 15: {
                return this.matchSynchronized((JCTree.JCSynchronized)jCTree, (JCTree.JCSynchronized)jCTree2);
            }
            case 16: {
                return this.matchTry((JCTree.JCTry)jCTree, (JCTree.JCTry)jCTree2);
            }
            case 17: {
                return this.matchCatch((JCTree.JCCatch)jCTree, (JCTree.JCCatch)jCTree2);
            }
            case 18: {
                return this.matchConditional((JCTree.JCConditional)jCTree, (JCTree.JCConditional)jCTree2);
            }
            case 19: {
                return this.matchIf((JCTree.JCIf)jCTree, (JCTree.JCIf)jCTree2);
            }
            case 20: {
                return this.treesMatch(((JCTree.JCExpressionStatement)jCTree).expr, ((JCTree.JCExpressionStatement)jCTree2).expr);
            }
            case 21: {
                return this.matchBreak((JCTree.JCBreak)jCTree, (JCTree.JCBreak)jCTree2);
            }
            case 22: {
                return this.matchContinue((JCTree.JCContinue)jCTree, (JCTree.JCContinue)jCTree2);
            }
            case 23: {
                return this.treesMatch(((JCTree.JCReturn)jCTree).expr, ((JCTree.JCReturn)jCTree2).expr);
            }
            case 24: {
                return this.treesMatch(((JCTree.JCThrow)jCTree).expr, ((JCTree.JCThrow)jCTree2).expr);
            }
            case 25: {
                return this.matchAssert((JCTree.JCAssert)jCTree, (JCTree.JCAssert)jCTree2);
            }
            case 26: {
                return this.matchApply((JCTree.JCMethodInvocation)jCTree, (JCTree.JCMethodInvocation)jCTree2);
            }
            case 27: {
                if (((JCTree.JCNewClass)jCTree2).def != null) {
                    ((JCTree.JCNewClass)jCTree2).def.sym = null;
                }
                return this.matchNewClass((JCTree.JCNewClass)jCTree, (JCTree.JCNewClass)jCTree2);
            }
            case 28: {
                return this.matchNewArray((JCTree.JCNewArray)jCTree, (JCTree.JCNewArray)jCTree2);
            }
            case 29: {
                return this.treesMatch(((JCTree.JCParens)jCTree).expr, ((JCTree.JCParens)jCTree2).expr);
            }
            case 30: {
                return this.matchAssign((JCTree.JCAssign)jCTree, (JCTree.JCAssign)jCTree2);
            }
            case 31: {
                return this.matchTypeCast((JCTree.JCTypeCast)jCTree, (JCTree.JCTypeCast)jCTree2);
            }
            case 32: {
                return this.matchTypeTest((JCTree.JCInstanceOf)jCTree, (JCTree.JCInstanceOf)jCTree2);
            }
            case 33: {
                return this.matchIndexed((JCTree.JCArrayAccess)jCTree, (JCTree.JCArrayAccess)jCTree2);
            }
            case 34: {
                return this.matchSelect((JCTree.JCFieldAccess)jCTree, (JCTree.JCFieldAccess)jCTree2);
            }
            case 35: {
                return ((JCTree.JCIdent)jCTree).sym == ((JCTree.JCIdent)jCTree2).sym;
            }
            case 36: {
                return this.matchLiteral((JCTree.JCLiteral)jCTree, (JCTree.JCLiteral)jCTree2);
            }
            case 37: {
                return ((JCTree.JCPrimitiveTypeTree)jCTree).typetag == ((JCTree.JCPrimitiveTypeTree)jCTree2).typetag;
            }
            case 38: {
                return this.treesMatch(((JCTree.JCArrayTypeTree)jCTree).elemtype, ((JCTree.JCArrayTypeTree)jCTree2).elemtype);
            }
            case 39: {
                return this.matchTypeApply((JCTree.JCTypeApply)jCTree, (JCTree.JCTypeApply)jCTree2);
            }
            case 40: {
                return this.matchTypeParameter((JCTree.JCTypeParameter)jCTree, (JCTree.JCTypeParameter)jCTree2);
            }
            case 41: {
                return this.matchWildcard((JCTree.JCWildcard)jCTree, (JCTree.JCWildcard)jCTree2);
            }
            case 42: {
                return ((JCTree.TypeBoundKind)jCTree).kind == ((JCTree.TypeBoundKind)jCTree2).kind;
            }
            case 43: {
                return this.matchAnnotation((JCTree.JCAnnotation)jCTree, (JCTree.JCAnnotation)jCTree2);
            }
            case 91: {
                return this.matchLetExpr((JCTree.LetExpr)jCTree, (JCTree.LetExpr)jCTree2);
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                return this.matchUnary((JCTree.JCUnary)jCTree, (JCTree.JCUnary)jCTree2);
            }
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                return this.matchBinary((JCTree.JCBinary)jCTree, (JCTree.JCBinary)jCTree2);
            }
            case 74: 
            case 75: 
            case 76: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: {
                return this.matchAssignop((JCTree.JCAssignOp)jCTree, (JCTree.JCAssignOp)jCTree2);
            }
        }
        String string = jCTree.getKind().toString() + " " + jCTree.getClass().getName();
        throw new AssertionError((Object)string);
    }

    protected boolean nameChanged(Name name, Name name2) {
        byte[] byArray;
        if (name == name2) {
            return false;
        }
        byte[] byArray2 = name.toUtf();
        int n = byArray2.length;
        if (n != (byArray = name2.toUtf()).length) {
            return true;
        }
        for (int i = 0; i < n; ++i) {
            if (byArray2[i] == byArray[i]) continue;
            return true;
        }
        return false;
    }

    protected int diffList(java.util.List<? extends JCTree> list, java.util.List<? extends JCTree> list2, TreeDiff.LineInsertionType lineInsertionType, int n) {
        int n2 = n;
        if (list == list2) {
            return n;
        }
        assert (list != null && list2 != null);
        int n3 = n;
        Iterator<? extends JCTree> iterator = list.iterator();
        Iterator<? extends JCTree> iterator2 = list2.iterator();
        JCTree jCTree = this.safeNext(iterator);
        JCTree jCTree2 = this.safeNext(iterator2);
        while (jCTree != null && jCTree2 != null) {
            int n4;
            if (this.oldTopLevel != null && (n4 = this.model.getEndPos(jCTree, this.oldTopLevel)) != -1) {
                n3 = n4;
            }
            if (this.treesMatch(jCTree, jCTree2, false)) {
                n2 = this.diffTree(jCTree, jCTree2, new int[]{this.getOldPos(jCTree), this.endPos(jCTree)});
                jCTree = this.safeNext(iterator);
                jCTree2 = this.safeNext(iterator2);
                continue;
            }
            if (!this.listContains(list2, jCTree) && !this.listContains(list, jCTree2)) {
                this.append(TreeDiff.Diff.modify(jCTree, this.getOldPos(jCTree), jCTree2));
                jCTree = this.safeNext(iterator);
                jCTree2 = this.safeNext(iterator2);
                continue;
            }
            if (!this.listContains(list2, jCTree)) {
                if (!this.isHidden(jCTree, this.oldParent)) {
                    this.append(TreeDiff.Diff.delete(jCTree, this.getOldPos(jCTree)));
                }
                jCTree = this.safeNext(iterator);
                continue;
            }
            if (!this.isHidden(jCTree2, this.newParent)) {
                this.append(TreeDiff.Diff.insert(jCTree2, this.getOldPos(jCTree), lineInsertionType, null));
            }
            jCTree2 = this.safeNext(iterator2);
        }
        while (jCTree != null) {
            if (!this.isHidden(jCTree, this.oldParent)) {
                this.append(TreeDiff.Diff.delete(jCTree, this.getOldPos(jCTree)));
            }
            if (this.oldTopLevel != null) {
                n3 = this.model.getEndPos(jCTree, this.oldTopLevel);
            }
            jCTree = this.safeNext(iterator);
        }
        while (jCTree2 != null) {
            if (!this.isHidden(jCTree2, this.newParent)) {
                this.append(TreeDiff.Diff.insert(jCTree2, n3, lineInsertionType, null));
            }
            jCTree2 = this.safeNext(iterator2);
        }
        return n2;
    }

    private JCTree safeNext(Iterator<? extends JCTree> iterator) {
        return iterator.hasNext() ? iterator.next() : null;
    }

    protected int diffParameterList(java.util.List<? extends JCTree> list, java.util.List<? extends JCTree> list2, int n) {
        JCTree jCTree;
        if (list == list2) {
            return n;
        }
        assert (list != null && list2 != null);
        int n2 = -2;
        Iterator<? extends JCTree> iterator = list.iterator();
        Iterator<? extends JCTree> iterator2 = list2.iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            jCTree = iterator.next();
            int n3 = n;
            n = this.getOldPos(jCTree);
            this.copyTo(n3, n);
            n = this.diffTree(jCTree, iterator2.next(), new int[]{n, this.endPos(jCTree)});
            if (this.oldTopLevel == null) continue;
            n2 = this.model.getEndPos(jCTree, this.oldTopLevel);
        }
        while (iterator.hasNext()) {
            jCTree = iterator.next();
            this.append(TreeDiff.Diff.delete(jCTree, this.getOldPos(jCTree)));
        }
        while (iterator2.hasNext()) {
            this.append(TreeDiff.Diff.insert(iterator2.next(), n2, TreeDiff.LineInsertionType.BEFORE));
        }
        return n;
    }

    protected int diffList2(java.util.List<? extends JCTree> list, java.util.List<? extends JCTree> list2, int n, PositionEstimator positionEstimator) {
        if (list == list2) {
            return n;
        }
        assert (list != null && list2 != null);
        int n2 = n;
        ListMatcher<? extends JCTree> listMatcher = ListMatcher.instance(list, list2);
        if (!listMatcher.match()) {
            return n;
        }
        Iterator<? extends JCTree> iterator = list.iterator();
        ListMatcher.ResultItem<? extends JCTree>[] resultItemArray = listMatcher.getTransformedResult();
        ListMatcher.Separator separator = listMatcher.separatorInstance();
        separator.compute();
        int[][] nArray = positionEstimator.getMatrix();
        int n3 = n;
        int n4 = 0;
        block6: for (int i = 0; i < resultItemArray.length; ++i) {
            ListMatcher.ResultItem<? extends JCTree> resultItem = resultItemArray[i];
            switch (resultItem.operation) {
                case MODIFY: {
                    this.tokenSequence.moveIndex(nArray[n4][4]);
                    if (this.tokenSequence.moveNext()) {
                        n3 = this.tokenSequence.offset();
                        if (JavaTokenId.COMMA == this.tokenSequence.token().id()) {
                            n3 += JavaTokenId.COMMA.fixedText().length();
                        }
                    }
                    JCTree jCTree = iterator.next();
                    ++n4;
                    this.copyTo(n2, this.getOldPos(jCTree));
                    if (this.treesMatch(jCTree, (JCTree)resultItem.element, false)) {
                        n2 = this.diffTree(jCTree, (JCTree)resultItem.element, this.getBounds(jCTree));
                        continue block6;
                    }
                    this.printer.print((JCTree)resultItem.element);
                    n2 = this.endPos(jCTree);
                    continue block6;
                }
                case INSERT: {
                    String string;
                    String string2 = separator.head(i) ? positionEstimator.head() : (separator.prev(i) ? positionEstimator.sep() : null);
                    String string3 = string = separator.next(i) ? positionEstimator.sep() : null;
                    if (positionEstimator.getIndentString() != null && !positionEstimator.getIndentString().equals(" ")) {
                        string2 = string2 + positionEstimator.getIndentString();
                    }
                    this.copyTo(n2, n3);
                    this.printer.print(string2);
                    this.printer.print((JCTree)resultItem.element);
                    this.printer.print(string);
                    continue block6;
                }
                case DELETE: {
                    int n5 = 0;
                    if (n4 == 0 && nArray[n4 + 1][2] != -1 && nArray[n4 + 1][2] == nArray[n4 + 1][3]) {
                        ++n5;
                    }
                    int n6 = this.toOff(separator.head(i) || separator.prev(i) ? nArray[n4][1] : nArray[n4][2 + n5]);
                    int n7 = this.toOff(separator.tail(i) || separator.next(i) ? nArray[n4 + 1][2] : nArray[n4][4]);
                    assert (n6 != -1 && n7 != -1) : "Invalid offset!";
                    this.tokenSequence.moveIndex(nArray[n4][4]);
                    if (this.tokenSequence.moveNext()) {
                        n3 = this.tokenSequence.offset();
                        if (JavaTokenId.COMMA == this.tokenSequence.token().id()) {
                            n3 += JavaTokenId.COMMA.fixedText().length();
                        }
                    }
                    n2 = n4 == 0 && !list2.isEmpty() ? n7 : this.endPos((JCTree)resultItem.element);
                    JCTree jCTree = iterator.next();
                    ++n4;
                    continue block6;
                }
                case NOCHANGE: {
                    this.tokenSequence.moveIndex(nArray[n4][4]);
                    if (this.tokenSequence.moveNext()) {
                        n3 = this.tokenSequence.offset();
                        if (JavaTokenId.COMMA == this.tokenSequence.token().id()) {
                            n3 += JavaTokenId.COMMA.fixedText().length();
                        }
                    }
                    JCTree jCTree = iterator.next();
                    ++n4;
                    int n8 = n2;
                    n2 = this.endPos(jCTree);
                    this.copyTo(n8, n2);
                }
            }
        }
        return n2;
    }

    private int toOff(int n) {
        if (n == -1) {
            return -1;
        }
        this.tokenSequence.moveIndex(n);
        this.tokenSequence.moveNext();
        return this.tokenSequence.offset();
    }

    private int diffParameterList(java.util.List<? extends JCTree> list, java.util.List<? extends JCTree> list2, boolean bl, int n, VeryPretty veryPretty) {
        if (list == list2 || list.isEmpty() && list2.isEmpty()) {
            return n;
        }
        assert (list != null && list2 != null);
        if (list2.isEmpty()) {
            int n2 = this.endPos(list);
            if (bl) {
                this.tokenSequence.move(n2);
                TokenUtilities.moveFwdToToken(this.tokenSequence, n2, JavaTokenId.GT);
                this.tokenSequence.moveNext();
                n2 = this.tokenSequence.offset();
                if (!PositionEstimator.nonRelevant.contains(this.tokenSequence.token())) {
                    veryPretty.print(" ");
                }
            }
            return n2;
        }
        ListMatcher<? extends JCTree> listMatcher = ListMatcher.instance(list, list2);
        if (!listMatcher.match()) {
            return n;
        }
        ListMatcher.ResultItem<? extends JCTree>[] resultItemArray = listMatcher.getResult();
        if (bl && list.isEmpty()) {
            veryPretty.print(JavaTokenId.LT.fixedText());
        }
        JCTree jCTree = null;
        int n3 = 0;
        block5: for (int i = 0; i < resultItemArray.length; ++i) {
            ListMatcher.ResultItem<? extends JCTree> resultItem = resultItemArray[i];
            switch (resultItem.operation) {
                case INSERT: {
                    Object object;
                    if (n3++ > 0) {
                        veryPretty.print(",");
                    }
                    if (jCTree != null && this.treesMatch(jCTree, (JCTree)resultItem.element, false)) {
                        object = this.printer;
                        this.printer = veryPretty;
                        this.diffTree(jCTree, (JCTree)resultItem.element, this.getBounds(jCTree));
                        this.printer = object;
                    } else {
                        veryPretty.print((JCTree)resultItem.element);
                    }
                    jCTree = null;
                    continue block5;
                }
                case DELETE: {
                    jCTree = (JCTree)resultItem.element;
                    continue block5;
                }
                case NOCHANGE: {
                    if (n3++ > 0) {
                        veryPretty.print(",");
                    }
                    Object object = this.getBounds((JCTree)resultItem.element);
                    this.tokenSequence.move(object[0]);
                    TokenUtilities.movePrevious(this.tokenSequence, object[0]);
                    this.tokenSequence.moveNext();
                    int n4 = this.tokenSequence.offset();
                    TokenUtilities.moveNext(this.tokenSequence, object[1]);
                    int n5 = this.tokenSequence.offset();
                    this.copyTo(n4, n5, veryPretty);
                    jCTree = null;
                    continue block5;
                }
            }
        }
        if (bl && list.isEmpty()) {
            veryPretty.print(JavaTokenId.GT.fixedText());
            veryPretty.print(" ");
        }
        return list.isEmpty() ? n : this.endPos(list);
    }

    private int[] diffList(java.util.List<? extends JCTree> list, java.util.List<? extends JCTree> list2, int n, PositionEstimator positionEstimator, Measure measure, VeryPretty veryPretty) {
        Object object;
        int[] nArray = new int[]{-1, -1};
        if (list == list2) {
            return nArray;
        }
        assert (list != null && list2 != null);
        ListMatcher<? extends JCTree> listMatcher = ListMatcher.instance(list, list2, measure);
        if (!listMatcher.match()) {
            return nArray;
        }
        JCTree jCTree = null;
        ListMatcher.ResultItem<? extends JCTree>[] resultItemArray = listMatcher.getResult();
        int n2 = n;
        int n3 = 0;
        block6: for (int i = 0; i < resultItemArray.length; ++i) {
            object = resultItemArray[i];
            switch (((ListMatcher.ResultItem)object).operation) {
                case MODIFY: {
                    continue block6;
                }
                case INSERT: {
                    Object object2;
                    int n4;
                    int n5 = positionEstimator.getInsertPos(n3);
                    String string = "";
                    String string2 = "";
                    if (n5 < 0 && list.isEmpty() && n3 == 0) {
                        n5 = n;
                        StringBuilder stringBuilder = new StringBuilder();
                        StringBuilder stringBuilder2 = new StringBuilder();
                        n5 = positionEstimator.prepare(n, stringBuilder, stringBuilder2);
                        if (i + 1 == resultItemArray.length) {
                            string2 = stringBuilder2.toString();
                        }
                        string = stringBuilder.toString();
                        n2 = n5;
                        if (nArray[0] < 0) {
                            nArray[0] = n2;
                        }
                        if (nArray[1] < 0) {
                            nArray[1] = n2;
                        }
                    } else {
                        if (nArray[0] < 0) {
                            nArray[0] = n2;
                        }
                        if (nArray[1] < 0) {
                            nArray[1] = n2;
                        }
                    }
                    int n6 = ((JCTree)((ListMatcher.ResultItem)object).element).getKind() != Tree.Kind.VARIABLE ? this.getOldPos((JCTree)((ListMatcher.ResultItem)object).element) : ((JCTree)((ListMatcher.ResultItem)object).element).pos;
                    boolean bl = false;
                    if (n6 > 0) {
                        for (JCTree object32 : list) {
                            n4 = object32.getKind() != Tree.Kind.VARIABLE ? this.getOldPos(object32) : object32.pos;
                            if (n6 != n4) continue;
                            bl = true;
                            object2 = this.printer;
                            int n7 = ((VeryPretty)object2).indent();
                            this.printer = new VeryPretty(this.context, JavaFormatOptions.getDefault());
                            this.printer.reset(n7);
                            int n8 = list.indexOf(object32);
                            int[] nArray2 = positionEstimator.getPositions(n8);
                            this.diffTree(object32, (JCTree)((ListMatcher.ResultItem)object).element, nArray2);
                            veryPretty.print(this.printer.toString());
                            this.printer = object2;
                            this.printer.undent(n7);
                            break;
                        }
                    }
                    if (bl) continue block6;
                    if (jCTree != null && this.treesMatch((JCTree)((ListMatcher.ResultItem)object).element, jCTree, false)) {
                        VeryPretty veryPretty2 = this.printer;
                        int n9 = veryPretty2.indent();
                        this.printer = new VeryPretty(this.context, JavaFormatOptions.getDefault());
                        this.printer.reset(n9);
                        n4 = list.indexOf(jCTree);
                        object2 = positionEstimator.getPositions(n4);
                        this.diffTree(jCTree, (JCTree)((ListMatcher.ResultItem)object).element, (int[])object2);
                        veryPretty.print(this.printer.toString());
                        this.printer = veryPretty2;
                        this.printer.undent(n9);
                        continue block6;
                    }
                    if (i == 0 && !list.isEmpty()) {
                        n2 = positionEstimator.getPositions(0)[0];
                    }
                    veryPretty.print(string);
                    int n10 = veryPretty.indent();
                    VeryPretty veryPretty2 = new VeryPretty(this.context, JavaFormatOptions.getDefault());
                    veryPretty2.reset(n10);
                    veryPretty2.enclClassName = veryPretty.enclClassName;
                    veryPretty2.print((JCTree)((ListMatcher.ResultItem)object).element);
                    veryPretty2.newline();
                    veryPretty.print(veryPretty2.toString());
                    veryPretty.undent(n10);
                    continue block6;
                }
                case DELETE: {
                    int[] nArray3 = positionEstimator.getPositions(n3);
                    jCTree = list.get(n3);
                    if (nArray[0] < 0) {
                        nArray[0] = nArray3[0];
                    }
                    ++n3;
                    nArray[1] = nArray3[1];
                    n2 = nArray3[1];
                    continue block6;
                }
                case NOCHANGE: {
                    int[] nArray4 = positionEstimator.getPositions(n3);
                    if (nArray[0] < 0) {
                        nArray[0] = nArray4[0];
                    }
                    this.copyTo(nArray4[0], nArray4[1], veryPretty);
                    nArray[1] = nArray4[1];
                    ++n3;
                    continue block6;
                }
            }
        }
        if (!list.isEmpty()) {
            Iterator<? extends JCTree> iterator = list.iterator();
            n3 = 0;
            while (iterator.hasNext()) {
                ++n3;
                iterator.next();
            }
            object = positionEstimator.getPositions(n3);
            nArray[1] = (int)object[1];
        }
        return nArray;
    }

    private java.util.List<JCTree> filterHidden(java.util.List<JCTree> list) {
        ArrayList<JCTree> arrayList = new ArrayList<JCTree>();
        for (JCTree jCTree : list) {
            if (Tree.Kind.METHOD == jCTree.getKind() && (((JCTree.JCMethodDecl)jCTree).mods.flags & 0x1000000000L) != 0L) continue;
            arrayList.add(jCTree);
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    private int diffListImports(java.util.List<? extends JCTree> list, java.util.List<? extends JCTree> list2, int n, PositionEstimator positionEstimator, Measure measure, VeryPretty veryPretty) {
        if (list == list2) {
            return n;
        }
        assert (list != null && list2 != null);
        ListMatcher<? extends JCTree> listMatcher = ListMatcher.instance(list, list2, measure);
        if (!listMatcher.match()) {
            return n;
        }
        JCTree jCTree = null;
        ListMatcher.ResultItem<? extends JCTree>[] resultItemArray = listMatcher.getResult();
        if (list.isEmpty() && !list2.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            StringBuilder stringBuilder2 = new StringBuilder();
            int n2 = positionEstimator.prepare(n, stringBuilder, stringBuilder2);
            this.copyTo(n, n2, veryPretty);
            veryPretty.print(stringBuilder.toString());
            for (JCTree jCTree2 : list2) {
                if (TreeDiff.LineInsertionType.BEFORE == positionEstimator.lineInsertType()) {
                    veryPretty.newline();
                }
                veryPretty.printExpr(jCTree2);
                if (TreeDiff.LineInsertionType.AFTER != positionEstimator.lineInsertType()) continue;
                veryPretty.newline();
            }
            return n2;
        }
        if (list2.isEmpty() && !list.isEmpty()) {
            int[] nArray = positionEstimator.sectionRemovalBounds(null);
            this.copyTo(n, nArray[0]);
            return nArray[1];
        }
        int n3 = 0;
        int n2 = n;
        n = positionEstimator.getInsertPos(0);
        this.copyTo(n2, n, veryPretty);
        block7: for (int i = 0; i < resultItemArray.length; ++i) {
            ListMatcher.ResultItem<? extends JCTree> resultItem = resultItemArray[i];
            switch (resultItem.operation) {
                case MODIFY: {
                    int[] nArray = positionEstimator.getPositions(n3);
                    this.copyTo(n, nArray[0], veryPretty);
                    VeryPretty veryPretty2 = this.printer;
                    this.printer = veryPretty;
                    n = this.diffTree(list.get(n3), (JCTree)resultItem.element, nArray);
                    this.printer = veryPretty2;
                    ++n3;
                    continue block7;
                }
                case INSERT: {
                    void var14_27;
                    Object object;
                    int n4;
                    int n6 = positionEstimator.getInsertPos(n3);
                    String string = "";
                    String string2 = "";
                    if (n6 < 0 && list.isEmpty() && n3 == 0) {
                        n6 = n;
                        StringBuilder stringBuilder = new StringBuilder();
                        StringBuilder stringBuilder2 = new StringBuilder();
                        n6 = positionEstimator.prepare(n, stringBuilder, stringBuilder2);
                        if (i + 1 == resultItemArray.length) {
                            string2 = stringBuilder2.toString();
                        }
                        String string3 = stringBuilder.toString();
                    }
                    int n5 = ((JCTree)resultItem.element).getKind() != Tree.Kind.VARIABLE ? this.getOldPos((JCTree)resultItem.element) : ((JCTree)resultItem.element).pos;
                    boolean bl = false;
                    if (n5 > 0) {
                        for (JCTree jCTree2 : list) {
                            n4 = jCTree2.getKind() != Tree.Kind.VARIABLE ? this.getOldPos(jCTree2) : jCTree2.pos;
                            if (n5 != n4) continue;
                            bl = true;
                            object = this.printer;
                            int n7 = ((VeryPretty)object).indent();
                            this.printer = new VeryPretty(this.context, JavaFormatOptions.getDefault());
                            this.printer.reset(n7);
                            int n8 = list.indexOf(jCTree2);
                            int[] nArray = positionEstimator.getPositions(n8);
                            this.diffTree(jCTree2, (JCTree)resultItem.element, nArray);
                            veryPretty.print(this.printer.toString());
                            this.printer = object;
                            this.printer.undent(n7);
                            break;
                        }
                    }
                    if (bl) continue block7;
                    if (jCTree != null && this.treesMatch((JCTree)resultItem.element, jCTree, false)) {
                        VeryPretty veryPretty3 = this.printer;
                        int n9 = veryPretty3.indent();
                        this.printer = new VeryPretty(this.context, JavaFormatOptions.getDefault());
                        this.printer.reset(n9);
                        n4 = list.indexOf(jCTree);
                        object = positionEstimator.getPositions(n4);
                        this.diffTree(jCTree, (JCTree)resultItem.element, (int[])object);
                        veryPretty.print(this.printer.toString());
                        this.printer = veryPretty3;
                        this.printer.undent(n9);
                        continue block7;
                    }
                    veryPretty.print((String)var14_27);
                    veryPretty.enclClassName = veryPretty.enclClassName;
                    if (TreeDiff.LineInsertionType.BEFORE == positionEstimator.lineInsertType()) {
                        veryPretty.newline();
                    }
                    veryPretty.print((JCTree)resultItem.element);
                    if (TreeDiff.LineInsertionType.AFTER != positionEstimator.lineInsertType()) continue block7;
                    veryPretty.newline();
                    continue block7;
                }
                case DELETE: {
                    int[] nArray = positionEstimator.getPositions(n3);
                    if (n < nArray[0]) {
                        this.copyTo(n, nArray[0], veryPretty);
                    }
                    jCTree = list.get(n3);
                    ++n3;
                    n = nArray[1];
                    continue block7;
                }
                case NOCHANGE: {
                    int[] nArray = positionEstimator.getPositions(n3);
                    if (nArray[0] > n && n3 != 0) {
                        this.copyTo(n, nArray[0], veryPretty);
                    }
                    n = nArray[1];
                    this.copyTo(nArray[0], n, veryPretty);
                    jCTree = null;
                    ++n3;
                    continue block7;
                }
            }
        }
        return n;
    }

    private boolean isHidden(JCTree jCTree, JCTree jCTree2) {
        if (jCTree2 == null) {
            return false;
        }
        if (jCTree.pos == -2) {
            return true;
        }
        return this.model.isSynthetic(jCTree);
    }

    protected void diffPrecedingComments(JCTree jCTree, JCTree jCTree2) {
        CommentSet commentSet = this.comments.getComments(jCTree2);
        if (!commentSet.hasChanges()) {
            return;
        }
        java.util.List<Comment> list = this.comments.getComments(jCTree).getPrecedingComments();
        java.util.List<Comment> list2 = commentSet.getPrecedingComments();
        this.diffCommentLists(jCTree, jCTree2, list, list2, false);
    }

    protected void diffTrailingComments(JCTree jCTree, JCTree jCTree2) {
        CommentSet commentSet = this.comments.getComments(jCTree2);
        if (!commentSet.hasChanges()) {
            return;
        }
        java.util.List<Comment> list = this.comments.getComments(jCTree).getTrailingComments();
        java.util.List<Comment> list2 = commentSet.getTrailingComments();
        this.diffCommentLists(jCTree, jCTree2, list, list2, true);
    }

    private void diffCommentLists(JCTree jCTree, JCTree jCTree2, java.util.List<Comment> list, java.util.List<Comment> list2, boolean bl) {
        int n = this.getOldPos(jCTree);
        Iterator<Comment> iterator = list.iterator();
        Iterator<Comment> iterator2 = list2.iterator();
        Comment comment = this.safeNext(iterator);
        Comment comment2 = this.safeNext(iterator2);
        while (comment != null && comment2 != null) {
            n = comment.pos();
            if (this.commentsMatch(comment, comment2)) {
                comment = this.safeNext(iterator);
                comment2 = this.safeNext(iterator2);
                continue;
            }
            if (!this.listContains(list2, comment)) {
                if (!this.listContains(list, comment2)) {
                    this.append(TreeDiff.Diff.modify(jCTree, jCTree2, comment, comment2));
                    comment = this.safeNext(iterator);
                    comment2 = this.safeNext(iterator2);
                    continue;
                }
                this.append(TreeDiff.Diff.delete(jCTree, jCTree2, comment));
                comment = this.safeNext(iterator);
                continue;
            }
            this.append(TreeDiff.Diff.insert(n, TreeDiff.LineInsertionType.BEFORE, jCTree, jCTree2, comment2, bl));
            comment2 = this.safeNext(iterator2);
        }
        while (comment != null) {
            this.append(TreeDiff.Diff.delete(jCTree, jCTree2, comment));
            comment = this.safeNext(iterator);
        }
        while (comment2 != null) {
            this.append(TreeDiff.Diff.insert(n, TreeDiff.LineInsertionType.BEFORE, jCTree, jCTree2, comment2, bl));
            n += comment2.endPos() - comment2.pos();
            comment2 = this.safeNext(iterator);
        }
    }

    private Comment safeNext(Iterator<Comment> iterator) {
        return iterator.hasNext() ? iterator.next() : null;
    }

    private boolean commentsMatch(Comment comment, Comment comment2) {
        if (comment == null && comment2 == null) {
            return true;
        }
        if (comment == null || comment2 == null) {
            return false;
        }
        return comment.equals(comment2);
    }

    private boolean listContains(java.util.List<Comment> list, Comment comment) {
        for (Comment comment2 : list) {
            if (!comment2.equals(comment)) continue;
            return true;
        }
        return false;
    }

    private static JCTree leftMostTree(JCTree jCTree) {
        switch (jCTree.tag) {
            case 26: {
                return CasualDiff.leftMostTree(((JCTree.JCMethodInvocation)jCTree).meth);
            }
            case 30: {
                return CasualDiff.leftMostTree(((JCTree.JCAssign)jCTree).lhs);
            }
            case 74: 
            case 75: 
            case 76: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: {
                return CasualDiff.leftMostTree(((JCTree.JCAssignOp)jCTree).lhs);
            }
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                return CasualDiff.leftMostTree(((JCTree.JCBinary)jCTree).lhs);
            }
            case 3: {
                JCTree.JCClassDecl jCClassDecl = (JCTree.JCClassDecl)jCTree;
                if (jCClassDecl.mods.pos == -1) break;
                return jCClassDecl.mods;
            }
            case 18: {
                return CasualDiff.leftMostTree(((JCTree.JCConditional)jCTree).cond);
            }
            case 20: {
                return CasualDiff.leftMostTree(((JCTree.JCExpressionStatement)jCTree).expr);
            }
            case 33: {
                return CasualDiff.leftMostTree(((JCTree.JCArrayAccess)jCTree).indexed);
            }
            case 4: {
                JCTree.JCMethodDecl jCMethodDecl = (JCTree.JCMethodDecl)jCTree;
                if (jCMethodDecl.mods.pos != -1) {
                    return jCMethodDecl.mods;
                }
                if (jCMethodDecl.restype != null) {
                    return CasualDiff.leftMostTree(jCMethodDecl.restype);
                }
                return jCMethodDecl;
            }
            case 34: {
                return CasualDiff.leftMostTree(((JCTree.JCFieldAccess)jCTree).selected);
            }
            case 39: {
                return CasualDiff.leftMostTree(((JCTree.JCTypeApply)jCTree).clazz);
            }
            case 38: {
                return CasualDiff.leftMostTree(((JCTree.JCArrayTypeTree)jCTree).elemtype);
            }
            case 32: {
                return CasualDiff.leftMostTree(((JCTree.JCInstanceOf)jCTree).expr);
            }
            case 52: 
            case 53: {
                return CasualDiff.leftMostTree(((JCTree.JCUnary)jCTree).arg);
            }
            case 5: {
                JCTree.JCVariableDecl jCVariableDecl = (JCTree.JCVariableDecl)jCTree;
                if (jCVariableDecl.mods.pos != -1) {
                    return jCVariableDecl.mods;
                }
                return CasualDiff.leftMostTree(jCVariableDecl.vartype);
            }
            case 1: {
                JCTree.JCCompilationUnit jCCompilationUnit = (JCTree.JCCompilationUnit)jCTree;
                assert (jCCompilationUnit.defs.size() > 0);
                return jCCompilationUnit.pid != null ? jCCompilationUnit.pid : (JCTree)jCCompilationUnit.defs.head;
            }
        }
        return jCTree;
    }

    private int getOldPos(JCTree jCTree) {
        return CasualDiff.getOldPos(jCTree, this.model, this.undo);
    }

    static int getOldPos(JCTree jCTree, ASTModel aSTModel, UndoList undoList) {
        JCTree jCTree2;
        int n = aSTModel.getStartPos(jCTree);
        if (n == -2 && (jCTree2 = undoList.getOld(CasualDiff.leftMostTree(jCTree))) != null && jCTree2 != jCTree) {
            n = CasualDiff.getOldPos(jCTree2, aSTModel, undoList);
        }
        if (n == -2) {
            n = jCTree.pos == -2 ? CasualDiff.leftMostTree((JCTree)jCTree).pos : jCTree.pos;
        }
        return n;
    }

    protected int diffTree(JCTree jCTree, JCTree jCTree2, int[] nArray) {
        if (jCTree == null && jCTree2 != null) {
            throw new IllegalArgumentException("Null is not allowed in parameters.");
        }
        if (jCTree == jCTree2) {
            return nArray[0];
        }
        this.diffPrecedingComments(jCTree, jCTree2);
        int n = -1;
        int n2 = this.getOldPos(jCTree);
        if (!(jCTree.tag == jCTree2.tag || compAssign.contains((Object)jCTree.getKind()) && compAssign.contains((Object)jCTree2.getKind()) || binaries.contains((Object)jCTree.getKind()) && binaries.contains((Object)jCTree2.getKind()) || unaries.contains((Object)jCTree.getKind()) && unaries.contains((Object)jCTree2.getKind()))) {
            this.printer.print(jCTree2);
            return this.endPos(jCTree);
        }
        switch (jCTree.tag) {
            case 1: {
                this.diffTopLevel((JCTree.JCCompilationUnit)jCTree, (JCTree.JCCompilationUnit)jCTree2);
                break;
            }
            case 2: {
                n = this.diffImport((JCTree.JCImport)jCTree, (JCTree.JCImport)jCTree2, nArray);
                break;
            }
            case 3: {
                n = this.diffClassDef((JCTree.JCClassDecl)jCTree, (JCTree.JCClassDecl)jCTree2, nArray);
                break;
            }
            case 4: {
                n = this.diffMethodDef((JCTree.JCMethodDecl)jCTree, (JCTree.JCMethodDecl)jCTree2, nArray);
                break;
            }
            case 5: {
                return this.diffVarDef((JCTree.JCVariableDecl)jCTree, (JCTree.JCVariableDecl)jCTree2, nArray);
            }
            case 6: {
                break;
            }
            case 7: {
                n = this.diffBlock((JCTree.JCBlock)jCTree, (JCTree.JCBlock)jCTree2, nArray[0]);
                break;
            }
            case 8: {
                n = this.diffDoLoop((JCTree.JCDoWhileLoop)jCTree, (JCTree.JCDoWhileLoop)jCTree2, nArray);
                break;
            }
            case 9: {
                n = this.diffWhileLoop((JCTree.JCWhileLoop)jCTree, (JCTree.JCWhileLoop)jCTree2, nArray);
                break;
            }
            case 10: {
                n = this.diffForLoop((JCTree.JCForLoop)jCTree, (JCTree.JCForLoop)jCTree2, nArray);
                break;
            }
            case 11: {
                n = this.diffForeachLoop((JCTree.JCEnhancedForLoop)jCTree, (JCTree.JCEnhancedForLoop)jCTree2, nArray);
                break;
            }
            case 12: {
                n = this.diffLabelled((JCTree.JCLabeledStatement)jCTree, (JCTree.JCLabeledStatement)jCTree2, nArray);
                break;
            }
            case 13: {
                n = this.diffSwitch((JCTree.JCSwitch)jCTree, (JCTree.JCSwitch)jCTree2, nArray);
                break;
            }
            case 14: {
                n = this.diffCase((JCTree.JCCase)jCTree, (JCTree.JCCase)jCTree2, nArray);
                break;
            }
            case 15: {
                n = this.diffSynchronized((JCTree.JCSynchronized)jCTree, (JCTree.JCSynchronized)jCTree2, nArray);
                break;
            }
            case 16: {
                n = this.diffTry((JCTree.JCTry)jCTree, (JCTree.JCTry)jCTree2, nArray);
                break;
            }
            case 17: {
                n = this.diffCatch((JCTree.JCCatch)jCTree, (JCTree.JCCatch)jCTree2, nArray);
                break;
            }
            case 18: {
                n = this.diffConditional((JCTree.JCConditional)jCTree, (JCTree.JCConditional)jCTree2, nArray);
                break;
            }
            case 19: {
                n = this.diffIf((JCTree.JCIf)jCTree, (JCTree.JCIf)jCTree2, nArray);
                break;
            }
            case 20: {
                n = this.diffExec((JCTree.JCExpressionStatement)jCTree, (JCTree.JCExpressionStatement)jCTree2, nArray);
                break;
            }
            case 21: {
                n = this.diffBreak((JCTree.JCBreak)jCTree, (JCTree.JCBreak)jCTree2, nArray);
                break;
            }
            case 22: {
                n = this.diffContinue((JCTree.JCContinue)jCTree, (JCTree.JCContinue)jCTree2, nArray);
                break;
            }
            case 23: {
                n = this.diffReturn((JCTree.JCReturn)jCTree, (JCTree.JCReturn)jCTree2, nArray);
                break;
            }
            case 24: {
                n = this.diffThrow((JCTree.JCThrow)jCTree, (JCTree.JCThrow)jCTree2, nArray);
                break;
            }
            case 25: {
                n = this.diffAssert((JCTree.JCAssert)jCTree, (JCTree.JCAssert)jCTree2, nArray);
                break;
            }
            case 26: {
                n = this.diffApply((JCTree.JCMethodInvocation)jCTree, (JCTree.JCMethodInvocation)jCTree2, nArray);
                break;
            }
            case 27: {
                n = this.diffNewClass((JCTree.JCNewClass)jCTree, (JCTree.JCNewClass)jCTree2, nArray);
                break;
            }
            case 28: {
                n = this.diffNewArray((JCTree.JCNewArray)jCTree, (JCTree.JCNewArray)jCTree2, nArray);
                break;
            }
            case 29: {
                n = this.diffParens((JCTree.JCParens)jCTree, (JCTree.JCParens)jCTree2, nArray);
                break;
            }
            case 30: {
                n = this.diffAssign((JCTree.JCAssign)jCTree, (JCTree.JCAssign)jCTree2, nArray);
                break;
            }
            case 31: {
                n = this.diffTypeCast((JCTree.JCTypeCast)jCTree, (JCTree.JCTypeCast)jCTree2, nArray);
                break;
            }
            case 32: {
                n = this.diffTypeTest((JCTree.JCInstanceOf)jCTree, (JCTree.JCInstanceOf)jCTree2, nArray);
                break;
            }
            case 33: {
                n = this.diffIndexed((JCTree.JCArrayAccess)jCTree, (JCTree.JCArrayAccess)jCTree2, nArray);
                break;
            }
            case 34: {
                n = this.diffSelect((JCTree.JCFieldAccess)jCTree, (JCTree.JCFieldAccess)jCTree2, nArray);
                break;
            }
            case 35: {
                n = this.diffIdent((JCTree.JCIdent)jCTree, (JCTree.JCIdent)jCTree2, nArray[0]);
                break;
            }
            case 36: {
                n = this.diffLiteral((JCTree.JCLiteral)jCTree, (JCTree.JCLiteral)jCTree2, nArray);
                break;
            }
            case 37: {
                this.diffTypeIdent((JCTree.JCPrimitiveTypeTree)jCTree, (JCTree.JCPrimitiveTypeTree)jCTree2);
                break;
            }
            case 38: {
                n = this.diffTypeArray((JCTree.JCArrayTypeTree)jCTree, (JCTree.JCArrayTypeTree)jCTree2, nArray);
                break;
            }
            case 39: {
                n = this.diffTypeApply((JCTree.JCTypeApply)jCTree, (JCTree.JCTypeApply)jCTree2, nArray);
                break;
            }
            case 40: {
                n = this.diffTypeParameter((JCTree.JCTypeParameter)jCTree, (JCTree.JCTypeParameter)jCTree2, nArray);
                break;
            }
            case 41: {
                n = this.diffWildcard((JCTree.JCWildcard)jCTree, (JCTree.JCWildcard)jCTree2, nArray);
                break;
            }
            case 42: {
                n = this.diffTypeBoundKind((JCTree.TypeBoundKind)jCTree, (JCTree.TypeBoundKind)jCTree2, nArray);
                break;
            }
            case 43: {
                n = this.diffAnnotation((JCTree.JCAnnotation)jCTree, (JCTree.JCAnnotation)jCTree2, nArray);
                break;
            }
            case 91: {
                this.diffLetExpr((JCTree.LetExpr)jCTree, (JCTree.LetExpr)jCTree2);
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                n = this.diffUnary((JCTree.JCUnary)jCTree, (JCTree.JCUnary)jCTree2, nArray);
                break;
            }
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                n = this.diffBinary((JCTree.JCBinary)jCTree, (JCTree.JCBinary)jCTree2, nArray);
                break;
            }
            case 74: 
            case 75: 
            case 76: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: {
                n = this.diffAssignop((JCTree.JCAssignOp)jCTree, (JCTree.JCAssignOp)jCTree2, nArray);
                break;
            }
            case 45: {
                this.diffErroneous((JCTree.JCErroneous)jCTree, (JCTree.JCErroneous)jCTree2);
                break;
            }
            default: {
                String string = "Diff not implemented: " + jCTree.getKind().toString() + " " + jCTree.getClass().getName();
                throw new AssertionError((Object)string);
            }
        }
        this.diffTrailingComments(jCTree, jCTree2);
        return n;
    }

    private int diffTree(JCTree jCTree, JCTree jCTree2, int n) {
        return this.diffTree(jCTree, jCTree2, new int[]{n, -1});
    }

    protected boolean listsMatch(java.util.List<? extends JCTree> list, java.util.List<? extends JCTree> list2) {
        if (list == list2) {
            return true;
        }
        int n = list.size();
        if (list2.size() != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (this.treesMatch(list.get(i), list2.get(i))) continue;
            return false;
        }
        return true;
    }

    private boolean matchImport(JCTree.JCImport jCImport, JCTree.JCImport jCImport2) {
        return jCImport.staticImport == jCImport2.staticImport && this.treesMatch(jCImport.qualid, jCImport2.qualid);
    }

    private boolean matchBlock(JCTree.JCBlock jCBlock, JCTree.JCBlock jCBlock2) {
        return jCBlock.flags == jCBlock2.flags && this.listsMatch(jCBlock.stats, jCBlock2.stats);
    }

    private boolean matchDoLoop(JCTree.JCDoWhileLoop jCDoWhileLoop, JCTree.JCDoWhileLoop jCDoWhileLoop2) {
        return this.treesMatch(jCDoWhileLoop.cond, jCDoWhileLoop2.cond) && this.treesMatch(jCDoWhileLoop.body, jCDoWhileLoop2.body);
    }

    private boolean matchWhileLoop(JCTree.JCWhileLoop jCWhileLoop, JCTree.JCWhileLoop jCWhileLoop2) {
        return this.treesMatch(jCWhileLoop.cond, jCWhileLoop2.cond) && this.treesMatch(jCWhileLoop.body, jCWhileLoop2.body);
    }

    private boolean matchForLoop(JCTree.JCForLoop jCForLoop, JCTree.JCForLoop jCForLoop2) {
        return this.listsMatch(jCForLoop.init, jCForLoop2.init) && this.treesMatch(jCForLoop.cond, jCForLoop2.cond) && this.listsMatch(jCForLoop.step, jCForLoop2.step) && this.treesMatch(jCForLoop.body, jCForLoop2.body);
    }

    private boolean matchForeachLoop(JCTree.JCEnhancedForLoop jCEnhancedForLoop, JCTree.JCEnhancedForLoop jCEnhancedForLoop2) {
        return this.treesMatch(jCEnhancedForLoop.var, jCEnhancedForLoop2.var) && this.treesMatch(jCEnhancedForLoop.expr, jCEnhancedForLoop2.expr) && this.treesMatch(jCEnhancedForLoop.body, jCEnhancedForLoop2.body);
    }

    private boolean matchLabelled(JCTree.JCLabeledStatement jCLabeledStatement, JCTree.JCLabeledStatement jCLabeledStatement2) {
        return jCLabeledStatement.label == jCLabeledStatement2.label && this.treesMatch(jCLabeledStatement.body, jCLabeledStatement2.body);
    }

    private boolean matchSwitch(JCTree.JCSwitch jCSwitch, JCTree.JCSwitch jCSwitch2) {
        return this.treesMatch(jCSwitch.selector, jCSwitch2.selector) && this.listsMatch(jCSwitch.cases, jCSwitch2.cases);
    }

    private boolean matchCase(JCTree.JCCase jCCase, JCTree.JCCase jCCase2) {
        return this.treesMatch(jCCase.pat, jCCase2.pat) && this.listsMatch(jCCase.stats, jCCase2.stats);
    }

    private boolean matchSynchronized(JCTree.JCSynchronized jCSynchronized, JCTree.JCSynchronized jCSynchronized2) {
        return this.treesMatch(jCSynchronized.lock, jCSynchronized2.lock) && this.treesMatch(jCSynchronized.body, jCSynchronized2.body);
    }

    private boolean matchTry(JCTree.JCTry jCTry, JCTree.JCTry jCTry2) {
        return this.treesMatch(jCTry.finalizer, jCTry2.finalizer) && this.listsMatch(jCTry.catchers, jCTry2.catchers) && this.treesMatch(jCTry.body, jCTry2.body);
    }

    private boolean matchCatch(JCTree.JCCatch jCCatch, JCTree.JCCatch jCCatch2) {
        return this.treesMatch(jCCatch.param, jCCatch2.param) && this.treesMatch(jCCatch.body, jCCatch2.body);
    }

    private boolean matchConditional(JCTree.JCConditional jCConditional, JCTree.JCConditional jCConditional2) {
        return this.treesMatch(jCConditional.cond, jCConditional2.cond) && this.treesMatch(jCConditional.truepart, jCConditional2.truepart) && this.treesMatch(jCConditional.falsepart, jCConditional2.falsepart);
    }

    private boolean matchIf(JCTree.JCIf jCIf, JCTree.JCIf jCIf2) {
        return this.treesMatch(jCIf.cond, jCIf2.cond) && this.treesMatch(jCIf.thenpart, jCIf2.thenpart) && this.treesMatch(jCIf.elsepart, jCIf2.elsepart);
    }

    private boolean matchBreak(JCTree.JCBreak jCBreak, JCTree.JCBreak jCBreak2) {
        return jCBreak.label == jCBreak2.label && this.treesMatch(jCBreak.target, jCBreak2.target);
    }

    private boolean matchContinue(JCTree.JCContinue jCContinue, JCTree.JCContinue jCContinue2) {
        return jCContinue.label == jCContinue2.label && this.treesMatch(jCContinue.target, jCContinue2.target);
    }

    private boolean matchAssert(JCTree.JCAssert jCAssert, JCTree.JCAssert jCAssert2) {
        return this.treesMatch(jCAssert.cond, jCAssert2.cond) && this.treesMatch(jCAssert.detail, jCAssert2.detail);
    }

    private boolean matchApply(JCTree.JCMethodInvocation jCMethodInvocation, JCTree.JCMethodInvocation jCMethodInvocation2) {
        return jCMethodInvocation.varargsElement == jCMethodInvocation2.varargsElement && this.listsMatch(jCMethodInvocation.typeargs, jCMethodInvocation2.typeargs) && this.treesMatch(jCMethodInvocation.meth, jCMethodInvocation2.meth) && this.listsMatch(jCMethodInvocation.args, jCMethodInvocation2.args);
    }

    private boolean matchNewClass(JCTree.JCNewClass jCNewClass, JCTree.JCNewClass jCNewClass2) {
        return jCNewClass.constructor == jCNewClass2.constructor && this.treesMatch(jCNewClass.getIdentifier(), jCNewClass2.getIdentifier()) && this.listsMatch(jCNewClass.typeargs, jCNewClass2.typeargs) && this.listsMatch(jCNewClass.args, jCNewClass2.args) && jCNewClass.varargsElement == jCNewClass2.varargsElement && this.treesMatch(jCNewClass.def, jCNewClass2.def);
    }

    private boolean matchNewArray(JCTree.JCNewArray jCNewArray, JCTree.JCNewArray jCNewArray2) {
        return this.treesMatch(jCNewArray.elemtype, jCNewArray2.elemtype) && this.listsMatch(jCNewArray.dims, jCNewArray2.dims) && this.listsMatch(jCNewArray.elems, jCNewArray2.elems);
    }

    private boolean matchAssign(JCTree.JCAssign jCAssign, JCTree.JCAssign jCAssign2) {
        return this.treesMatch(jCAssign.lhs, jCAssign2.lhs) && this.treesMatch(jCAssign.rhs, jCAssign2.rhs);
    }

    private boolean matchAssignop(JCTree.JCAssignOp jCAssignOp, JCTree.JCAssignOp jCAssignOp2) {
        return jCAssignOp.operator == jCAssignOp2.operator && this.treesMatch(jCAssignOp.lhs, jCAssignOp2.lhs) && this.treesMatch(jCAssignOp.rhs, jCAssignOp2.rhs);
    }

    private boolean matchUnary(JCTree.JCUnary jCUnary, JCTree.JCUnary jCUnary2) {
        return jCUnary.operator == jCUnary2.operator && this.treesMatch(jCUnary.arg, jCUnary2.arg);
    }

    private boolean matchBinary(JCTree.JCBinary jCBinary, JCTree.JCBinary jCBinary2) {
        return jCBinary.operator == jCBinary2.operator && this.treesMatch(jCBinary.lhs, jCBinary2.lhs) && this.treesMatch(jCBinary.rhs, jCBinary2.rhs);
    }

    private boolean matchTypeCast(JCTree.JCTypeCast jCTypeCast, JCTree.JCTypeCast jCTypeCast2) {
        return this.treesMatch(jCTypeCast.clazz, jCTypeCast2.clazz) && this.treesMatch(jCTypeCast.expr, jCTypeCast2.expr);
    }

    private boolean matchTypeTest(JCTree.JCInstanceOf jCInstanceOf, JCTree.JCInstanceOf jCInstanceOf2) {
        return this.treesMatch(jCInstanceOf.clazz, jCInstanceOf2.clazz) && this.treesMatch(jCInstanceOf.expr, jCInstanceOf2.expr);
    }

    private boolean matchIndexed(JCTree.JCArrayAccess jCArrayAccess, JCTree.JCArrayAccess jCArrayAccess2) {
        return this.treesMatch(jCArrayAccess.indexed, jCArrayAccess2.indexed) && this.treesMatch(jCArrayAccess.index, jCArrayAccess2.index);
    }

    private boolean matchSelect(JCTree.JCFieldAccess jCFieldAccess, JCTree.JCFieldAccess jCFieldAccess2) {
        return this.treesMatch(jCFieldAccess.selected, jCFieldAccess2.selected) && jCFieldAccess.sym == jCFieldAccess2.sym;
    }

    private boolean matchLiteral(JCTree.JCLiteral jCLiteral, JCTree.JCLiteral jCLiteral2) {
        return jCLiteral.typetag == jCLiteral2.typetag && jCLiteral.value == jCLiteral2.value;
    }

    private boolean matchTypeApply(JCTree.JCTypeApply jCTypeApply, JCTree.JCTypeApply jCTypeApply2) {
        return this.treesMatch(jCTypeApply.clazz, jCTypeApply2.clazz) && this.listsMatch(jCTypeApply.arguments, jCTypeApply2.arguments);
    }

    private boolean matchTypeParameter(JCTree.JCTypeParameter jCTypeParameter, JCTree.JCTypeParameter jCTypeParameter2) {
        return jCTypeParameter.name == jCTypeParameter2.name && this.listsMatch(jCTypeParameter.bounds, jCTypeParameter2.bounds);
    }

    private boolean matchWildcard(JCTree.JCWildcard jCWildcard, JCTree.JCWildcard jCWildcard2) {
        return jCWildcard.kind == jCWildcard2.kind && this.treesMatch(jCWildcard.inner, jCWildcard2.inner);
    }

    private boolean matchAnnotation(JCTree.JCAnnotation jCAnnotation, JCTree.JCAnnotation jCAnnotation2) {
        return this.treesMatch(jCAnnotation.annotationType, jCAnnotation2.annotationType) && this.listsMatch(jCAnnotation.args, jCAnnotation2.args);
    }

    private boolean matchModifiers(JCTree.JCModifiers jCModifiers, JCTree.JCModifiers jCModifiers2) {
        return jCModifiers.flags == jCModifiers2.flags && this.listsMatch(jCModifiers.annotations, jCModifiers2.annotations);
    }

    private boolean matchLetExpr(JCTree.LetExpr letExpr, JCTree.LetExpr letExpr2) {
        return this.listsMatch(letExpr.defs, letExpr2.defs) && this.treesMatch(letExpr.expr, letExpr2.expr);
    }

    private int[] getBounds(JCTree jCTree) {
        return new int[]{this.getOldPos(jCTree), this.endPos(jCTree)};
    }

    private void copyTo(int n, int n2) {
        this.copyTo(n, n2, this.printer);
    }

    private void copyTo(int n, int n2, VeryPretty veryPretty) {
        if (n == n2) {
            return;
        }
        if (n > n2 || n < 0 || n2 < 0) {
            throw new IllegalArgumentException("Illegal values: from = " + n + "; to = " + n2 + ".");
        }
        veryPretty.print(this.origText.substring(n, n2));
    }

    private java.util.List<Line> getLines(String string) {
        char[] cArray = string.toCharArray();
        ArrayList<Line> arrayList = new ArrayList<Line>();
        int n = 0;
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] != '\n') continue;
            arrayList.add(new Line(new String(cArray, n, i - n + 1), n, i + 1));
            n = i + 1;
        }
        if (n < cArray.length) {
            arrayList.add(new Line(new String(cArray, n, cArray.length - n), n, cArray.length));
        }
        return arrayList;
    }

    public java.util.List<TreeDiff.Diff> makeListMatch(String string, String string2) {
        java.util.List<Line> list = this.getLines(string);
        java.util.List<Line> list2 = this.getLines(string2);
        Object[] objectArray = list.toArray(new Line[list.size()]);
        Object[] objectArray2 = list2.toArray(new Line[list2.size()]);
        java.util.List list3 = new ComputeDiff(objectArray, objectArray2).diff();
        for (Object e : list3) {
            int n;
            StringBuilder stringBuilder;
            char c;
            Difference difference = (Difference)e;
            int n2 = difference.getDeletedStart();
            int n3 = difference.getDeletedEnd();
            int n4 = difference.getAddedStart();
            int n5 = difference.getAddedEnd();
            String string3 = this.toString(n2, n3);
            String string4 = this.toString(n4, n5);
            char c2 = n3 != -1 && n5 != -1 ? (char)'c' : (c = n3 == -1 ? (char)'a' : 'd');
            if (logDiffs) {
                System.out.println(string3 + c + string4);
                if (n3 != -1) {
                    this.printLines(n2, n3, "<", (Line[])objectArray);
                    if (n5 != -1) {
                        System.out.println("---");
                    }
                }
                if (n5 != -1) {
                    this.printLines(n4, n5, ">", (Line[])objectArray2);
                }
            }
            if (c == 'a') {
                stringBuilder = new StringBuilder();
                for (n = n4; n <= n5; ++n) {
                    stringBuilder.append(((Line)objectArray2[n]).data);
                }
                this.append(TreeDiff.Diff.insert(n3 == -1 ? ((Line)objectArray[n2]).start : ((Line)objectArray[n3]).end, stringBuilder.toString(), null, "", TreeDiff.LineInsertionType.NONE));
                continue;
            }
            if (c == 'd') {
                this.append(TreeDiff.Diff.delete(((Line)objectArray[n2]).start, ((Line)objectArray[n3]).end));
                continue;
            }
            stringBuilder = new StringBuilder();
            for (n = n2; n <= n3; ++n) {
                stringBuilder.append(((Line)objectArray[n]).data);
            }
            String string5 = stringBuilder.toString();
            stringBuilder = new StringBuilder();
            for (int i = n4; i <= n5; ++i) {
                stringBuilder.append(((Line)objectArray2[i]).data);
            }
            String string6 = stringBuilder.toString();
            this.makeTokenListMatch(string5, string6, ((Line)objectArray[n2]).start);
        }
        return null;
    }

    public java.util.List<TreeDiff.Diff> makeTokenListMatch(String string, String string2, int n) {
        Object[] objectArray;
        if (logDiffs) {
            System.out.println("----- token match for change -");
        }
        TokenSequence tokenSequence = TokenHierarchy.create((CharSequence)string, (Language)JavaTokenId.language()).tokenSequence(JavaTokenId.language());
        TokenSequence tokenSequence2 = TokenHierarchy.create((CharSequence)string2, (Language)JavaTokenId.language()).tokenSequence(JavaTokenId.language());
        ArrayList<Line> arrayList = new ArrayList<Line>();
        ArrayList<Line> arrayList2 = new ArrayList<Line>();
        while (tokenSequence.moveNext()) {
            objectArray = ((Object)tokenSequence.token().text()).toString();
            arrayList.add(new Line((String)objectArray, tokenSequence.offset(), tokenSequence.offset() + objectArray.length()));
        }
        while (tokenSequence2.moveNext()) {
            objectArray = ((Object)tokenSequence2.token().text()).toString();
            arrayList2.add(new Line((String)objectArray, tokenSequence2.offset(), tokenSequence2.offset() + objectArray.length()));
        }
        objectArray = arrayList.toArray(new Line[arrayList.size()]);
        Object[] objectArray2 = arrayList2.toArray(new Line[arrayList2.size()]);
        java.util.List list = new ComputeDiff(objectArray, objectArray2).diff();
        for (Object e : list) {
            int n2;
            StringBuilder stringBuilder;
            char c;
            Difference difference = (Difference)e;
            int n3 = difference.getDeletedStart();
            int n4 = difference.getDeletedEnd();
            int n5 = difference.getAddedStart();
            int n6 = difference.getAddedEnd();
            String string3 = this.toString(n3, n4);
            String string4 = this.toString(n5, n6);
            char c2 = n4 != -1 && n6 != -1 ? (char)'c' : (c = n4 == -1 ? (char)'a' : 'd');
            if (logDiffs) {
                System.out.println(string3 + c + string4);
                if (n4 != -1) {
                    this.printTokens(n3, n4, "<", (Line[])objectArray);
                    if (n6 != -1) {
                        System.out.println("---");
                    }
                }
                if (n6 != -1) {
                    this.printTokens(n5, n6, ">", (Line[])objectArray2);
                }
            }
            if (c == 'a') {
                stringBuilder = new StringBuilder();
                for (n2 = n5; n2 <= n6; ++n2) {
                    stringBuilder.append(((Line)objectArray2[n2]).data);
                }
                this.append(TreeDiff.Diff.insert(n + (n4 == -1 ? ((Line)objectArray[n3]).start : ((Line)objectArray[n4]).end), stringBuilder.toString(), null, "", TreeDiff.LineInsertionType.NONE));
                continue;
            }
            if (c == 'd') {
                this.append(TreeDiff.Diff.delete(n + ((Line)objectArray[n3]).start, n + ((Line)objectArray[n4]).end));
                continue;
            }
            stringBuilder = new StringBuilder();
            this.append(TreeDiff.Diff.delete(n + ((Line)objectArray[n3]).start, n + ((Line)objectArray[n4]).end));
            for (n2 = n5; n2 <= n6; ++n2) {
                stringBuilder.append(((Line)objectArray2[n2]).data);
            }
            this.append(TreeDiff.Diff.insert(n + (n4 == -1 ? ((Line)objectArray[n3]).start : ((Line)objectArray[n4]).end), stringBuilder.toString(), null, "", TreeDiff.LineInsertionType.NONE));
        }
        if (logDiffs) {
            System.out.println("----- end token match -");
        }
        return null;
    }

    protected String toString(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(n2 == -1 ? n : 1 + n);
        if (n2 != -1 && n != n2) {
            stringBuffer.append(",").append(1 + n2);
        }
        return stringBuffer.toString();
    }

    private void printLines(int n, int n2, String string, Line[] lineArray) {
        for (int i = n; i <= n2; ++i) {
            System.out.print(string + " " + lineArray[i]);
        }
    }

    private void printTokens(int n, int n2, String string, Line[] lineArray) {
        for (int i = n; i <= n2; ++i) {
            System.out.println(string + " '" + lineArray[i] + "'");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ChangeKind {
        INSERT,
        DELETE,
        MODIFY,
        NOCHANGE;

    }

    private static class Line {
        String data;
        int end;
        int start;

        Line(String string, int n, int n2) {
            this.start = n;
            this.end = n2;
            this.data = string;
        }

        public String toString() {
            return this.data.toString();
        }

        public boolean equals(Object object) {
            if (object instanceof Line) {
                return this.data.equals(((Line)object).data);
            }
            return false;
        }

        public int hashCode() {
            return this.data.hashCode();
        }
    }
}

