/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.save;

import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.tree.JCTree;

class Measure {
    static final Measure DEFAULT = new Measure();
    static final MethodMeasure METHOD = new MethodMeasure();
    static final VariableMeasure FIELD = new VariableMeasure();
    static final MemberMeasure MEMBER = new MemberMeasure();
    static final VariableMeasure PARAMETER = FIELD;
    static final ClassNameMeasure CLASS_NAME = new ClassNameMeasure();
    static final int INFINITE_DISTANCE = 1000;
    static final int OBJECTS_MATCH = 0;
    private static final StringMeasure STRING = new StringMeasure();

    Measure() {
    }

    int getDistance(Object object, Object object2) {
        assert (object != null && object2 != null) : "Shouldn't pass null value!";
        if (object == object2 || object.equals(object2)) {
            return 0;
        }
        return 1000;
    }

    private static final class ClassNameMeasure
    extends Measure {
        private ClassNameMeasure() {
        }

        public int getDistance(Object object, Object object2) {
            if (object == object2) {
                return 0;
            }
            if (object == null || object2 == null) {
                return 1000;
            }
            Tree tree = (Tree)object;
            Tree tree2 = (Tree)object2;
            if (tree.getKind() == tree2.getKind()) {
                return STRING.getDistance(tree.toString(), tree2.toString());
            }
            return 1000;
        }
    }

    private static final class MemberMeasure
    extends Measure {
        private MemberMeasure() {
        }

        int getDistance(Object object, Object object2) {
            int n = DEFAULT.getDistance(object, object2);
            if (n == 1000) {
                JCTree jCTree = (JCTree)object;
                JCTree jCTree2 = (JCTree)object2;
                if (jCTree.getKind() == jCTree2.getKind() && jCTree.pos == jCTree2.pos) {
                    return 500;
                }
            }
            return n;
        }
    }

    private static final class MethodMeasure
    extends Measure {
        private static final int NAME_WEIGHT = 60;
        private static final int PARAMETERS_WEIGHT = 40;

        private MethodMeasure() {
        }

        int getDistance(Object object, Object object2) {
            if (super.getDistance(object, object2) == 0) {
                return 0;
            }
            int n = 100;
            Tree tree = (Tree)object;
            Tree tree2 = (Tree)object2;
            if (tree.getKind() != Tree.Kind.METHOD || tree2.getKind() != Tree.Kind.METHOD) {
                return 1000;
            }
            MethodTree methodTree = (MethodTree)object;
            MethodTree methodTree2 = (MethodTree)object2;
            n = !"<init>".contentEquals(methodTree.getName()) && !"<init>".contentEquals(methodTree2.getName()) ? (n += STRING.getDistance(methodTree.getName().toString(), methodTree2.getName().toString()) * 60) : (n += 60000);
            Tree[] treeArray = new Tree[methodTree.getParameters().size()];
            Tree[] treeArray2 = new Tree[methodTree2.getParameters().size()];
            int n2 = 0;
            for (VariableTree variableTree : methodTree.getParameters()) {
                treeArray[n2++] = variableTree.getType();
            }
            n2 = 0;
            for (VariableTree variableTree : methodTree2.getParameters()) {
                treeArray2[n2++] = variableTree.getType();
            }
            n += new OrderedArrayMeasure(CLASS_NAME).getDistance(treeArray, treeArray2) * 40;
            return (n /= 100) > 1000 ? 1000 : n;
        }
    }

    private static final class OrderedArrayMeasure
    extends Measure {
        private final Measure measure;

        OrderedArrayMeasure(Measure measure) {
            this.measure = measure;
        }

        public int getDistance(Object object, Object object2) {
            Object[] objectArray = (Object[])object;
            Object[] objectArray2 = (Object[])object2;
            int n = Math.min(objectArray.length, objectArray2.length);
            int n2 = Math.abs(objectArray.length - objectArray2.length);
            int n3 = 0;
            if (n == 0) {
                if (n2 != 0) {
                    n3 = 1000;
                }
                return n3;
            }
            for (int i = 0; i < n; ++i) {
                n3 += this.measure.getDistance(objectArray[i], objectArray2[i]);
            }
            n3 += n2 * 1000;
            return (n3 /= n + n2) > 1000 ? 1000 : n3;
        }
    }

    private static final class StringMeasure
    extends Measure {
        private static final int SAME = 0;
        private static final int CASE_SAME = 1;
        private static final int DIFFERENT = 10;

        private StringMeasure() {
        }

        public final int getDistance(Object object, Object object2) {
            if (object == object2) {
                return 0;
            }
            if (object == null || object2 == null) {
                return 1000;
            }
            String string = (String)object;
            String string2 = (String)object2;
            int n = string.length();
            int n2 = string2.length();
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            char[] cArray = new char[n + 1];
            char[] cArray2 = new char[n2 + 1];
            string.getChars(0, n, cArray, 0);
            string2.getChars(0, n2, cArray2, 0);
            while (n4 < n && n5 < n2) {
                char c = cArray[n4];
                char c2 = cArray2[n5];
                int n6 = StringMeasure.compareChars(c, c2);
                if (n6 != 10) {
                    n3 += n6;
                    ++n4;
                    ++n5;
                    continue;
                }
                char c3 = cArray[n4 + 1];
                char c4 = cArray2[n5 + 1];
                if (c3 != '\u0000' && c4 != '\u0000') {
                    int n7 = StringMeasure.compareChars(c3, c4);
                    if (n7 != 10) {
                        n3 += 10 + n7;
                        n4 += 2;
                        n5 += 2;
                        continue;
                    }
                    int n8 = StringMeasure.compareChars(c, c4);
                    int n9 = StringMeasure.compareChars(c3, c2);
                    if (n8 != 10 && n9 != 10) {
                        n3 += 10 + n8 + n9;
                        n4 += 2;
                        n5 += 2;
                        continue;
                    }
                }
                if (n - n4 > n2 - n5) {
                    ++n4;
                } else if (n - n4 < n2 - n5) {
                    ++n5;
                } else {
                    ++n4;
                    ++n5;
                }
                n3 += 10;
            }
            return 1000 * (n3 += (n - n4 + n2 - n5) * 10) / Math.max(n2, n) / 10;
        }

        private static final int compareChars(char c, char c2) {
            char c3;
            if (c == c2) {
                return 0;
            }
            char c4 = Character.toLowerCase(c);
            return c4 == (c3 = Character.toLowerCase(c2)) ? 1 : 10;
        }
    }

    private static final class VariableMeasure
    extends Measure {
        private static final int NAME_WEIGHT = 40;
        private static final int TYPE_WEIGHT = 60;

        private VariableMeasure() {
        }

        public int getDistance(Object object, Object object2) {
            if (super.getDistance(object, object2) == 0) {
                return 0;
            }
            int n = 100;
            Tree tree = (Tree)object;
            Tree tree2 = (Tree)object2;
            if (tree.getKind() != Tree.Kind.VARIABLE || tree2.getKind() != Tree.Kind.VARIABLE) {
                return 1000;
            }
            VariableTree variableTree = (VariableTree)object;
            VariableTree variableTree2 = (VariableTree)object2;
            int n2 = STRING.getDistance(variableTree.getName().toString(), variableTree2.getName().toString());
            int n3 = CLASS_NAME.getDistance(variableTree.getType(), variableTree2.getType());
            if (n2 > 0 && n3 > 0) {
                return 1000;
            }
            n += n2 * 40;
            n += n3 * 60;
            return (n /= 100) > 1000 ? 1000 : n;
        }
    }
}

