/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.save;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Context;
import org.netbeans.api.java.source.query.CommentHandler;
import org.netbeans.api.java.source.query.CommentSet;
import org.netbeans.modules.java.source.builder.CommentHandlerService;

public class ModifiedTreeChecker
extends TreeScanner {
    boolean changed = false;
    private Symbol rootPackage;
    private CommentHandler comments;

    public ModifiedTreeChecker(Context context) {
        this.rootPackage = Symtab.instance((Context)context).rootPackage;
        this.comments = CommentHandlerService.instance(context);
    }

    public boolean isModified() {
        return this.changed;
    }

    private boolean checkTree(JCTree jCTree) {
        if (this.changed) {
            return false;
        }
        boolean bl = this.changed = jCTree.pos == -2;
        if (!this.changed && this.comments.hasComments(jCTree)) {
            CommentSet commentSet = this.comments.getComments(jCTree);
            this.changed = commentSet.hasChanges();
        }
        return !this.changed;
    }

    private boolean checkSymbol(Symbol symbol) {
        if (this.changed) {
            return false;
        }
        this.changed = symbol != null && ModifiedTreeChecker.symbolChanged(symbol, this.rootPackage);
        return !this.changed;
    }

    private static boolean symbolChanged(Symbol symbol, Symbol symbol2) {
        Symbol symbol3;
        if (symbol instanceof Symbol.PackageSymbol && (symbol3 = symbol.owner) != null && symbol3 != symbol2) {
            return ModifiedTreeChecker.symbolChanged(symbol3, symbol2);
        }
        return false;
    }

    public void visitTopLevel(JCTree.JCCompilationUnit jCCompilationUnit) {
        if (this.checkTree(jCCompilationUnit) && this.checkSymbol(jCCompilationUnit.packge)) {
            super.visitTopLevel(jCCompilationUnit);
        }
    }

    public void visitImport(JCTree.JCImport jCImport) {
        if (this.checkTree(jCImport)) {
            super.visitImport(jCImport);
        }
    }

    public void visitClassDef(JCTree.JCClassDecl jCClassDecl) {
        if (this.checkTree(jCClassDecl) && this.checkSymbol(jCClassDecl.sym)) {
            super.visitClassDef(jCClassDecl);
        }
    }

    public void visitMethodDef(JCTree.JCMethodDecl jCMethodDecl) {
        if (this.checkTree(jCMethodDecl) && this.checkSymbol(jCMethodDecl.sym)) {
            super.visitMethodDef(jCMethodDecl);
        }
    }

    public void visitVarDef(JCTree.JCVariableDecl jCVariableDecl) {
        if (this.checkTree(jCVariableDecl) && this.checkSymbol(jCVariableDecl.sym)) {
            super.visitVarDef(jCVariableDecl);
        }
    }

    public void visitSkip(JCTree.JCSkip jCSkip) {
        if (this.checkTree(jCSkip)) {
            super.visitSkip(jCSkip);
        }
    }

    public void visitBlock(JCTree.JCBlock jCBlock) {
        if (this.checkTree(jCBlock)) {
            super.visitBlock(jCBlock);
        }
    }

    public void visitDoLoop(JCTree.JCDoWhileLoop jCDoWhileLoop) {
        if (this.checkTree(jCDoWhileLoop)) {
            super.visitDoLoop(jCDoWhileLoop);
        }
    }

    public void visitWhileLoop(JCTree.JCWhileLoop jCWhileLoop) {
        if (this.checkTree(jCWhileLoop)) {
            super.visitWhileLoop(jCWhileLoop);
        }
    }

    public void visitForLoop(JCTree.JCForLoop jCForLoop) {
        if (this.checkTree(jCForLoop)) {
            super.visitForLoop(jCForLoop);
        }
    }

    public void visitLabelled(JCTree.JCLabeledStatement jCLabeledStatement) {
        if (this.checkTree(jCLabeledStatement)) {
            super.visitLabelled(jCLabeledStatement);
        }
    }

    public void visitSwitch(JCTree.JCSwitch jCSwitch) {
        if (this.checkTree(jCSwitch)) {
            super.visitSwitch(jCSwitch);
        }
    }

    public void visitCase(JCTree.JCCase jCCase) {
        if (this.checkTree(jCCase)) {
            super.visitCase(jCCase);
        }
    }

    public void visitSynchronized(JCTree.JCSynchronized jCSynchronized) {
        if (this.checkTree(jCSynchronized)) {
            super.visitSynchronized(jCSynchronized);
        }
    }

    public void visitTry(JCTree.JCTry jCTry) {
        if (this.checkTree(jCTry)) {
            super.visitTry(jCTry);
        }
    }

    public void visitCatch(JCTree.JCCatch jCCatch) {
        if (this.checkTree(jCCatch)) {
            super.visitCatch(jCCatch);
        }
    }

    public void visitConditional(JCTree.JCConditional jCConditional) {
        if (this.checkTree(jCConditional)) {
            super.visitConditional(jCConditional);
        }
    }

    public void visitIf(JCTree.JCIf jCIf) {
        if (this.checkTree(jCIf)) {
            super.visitIf(jCIf);
        }
    }

    public void visitExec(JCTree.JCExpressionStatement jCExpressionStatement) {
        if (this.checkTree(jCExpressionStatement)) {
            super.visitExec(jCExpressionStatement);
        }
    }

    public void visitBreak(JCTree.JCBreak jCBreak) {
        if (this.checkTree(jCBreak)) {
            super.visitBreak(jCBreak);
        }
    }

    public void visitContinue(JCTree.JCContinue jCContinue) {
        if (this.checkTree(jCContinue)) {
            super.visitContinue(jCContinue);
        }
    }

    public void visitReturn(JCTree.JCReturn jCReturn) {
        if (this.checkTree(jCReturn)) {
            super.visitReturn(jCReturn);
        }
    }

    public void visitThrow(JCTree.JCThrow jCThrow) {
        if (this.checkTree(jCThrow)) {
            super.visitThrow(jCThrow);
        }
    }

    public void visitAssert(JCTree.JCAssert jCAssert) {
        if (this.checkTree(jCAssert)) {
            super.visitAssert(jCAssert);
        }
    }

    public void visitApply(JCTree.JCMethodInvocation jCMethodInvocation) {
        if (this.checkTree(jCMethodInvocation)) {
            super.visitApply(jCMethodInvocation);
        }
    }

    public void visitNewClass(JCTree.JCNewClass jCNewClass) {
        if (this.checkTree(jCNewClass) && this.checkSymbol(jCNewClass.constructor)) {
            super.visitNewClass(jCNewClass);
        }
    }

    public void visitNewArray(JCTree.JCNewArray jCNewArray) {
        if (this.checkTree(jCNewArray)) {
            super.visitNewArray(jCNewArray);
        }
    }

    public void visitParens(JCTree.JCParens jCParens) {
        if (this.checkTree(jCParens)) {
            super.visitParens(jCParens);
        }
    }

    public void visitAssign(JCTree.JCAssign jCAssign) {
        if (this.checkTree(jCAssign)) {
            super.visitAssign(jCAssign);
        }
    }

    public void visitAssignop(JCTree.JCAssignOp jCAssignOp) {
        if (this.checkTree(jCAssignOp)) {
            super.visitAssignop(jCAssignOp);
        }
    }

    public void visitUnary(JCTree.JCUnary jCUnary) {
        if (this.checkTree(jCUnary)) {
            super.visitUnary(jCUnary);
        }
    }

    public void visitBinary(JCTree.JCBinary jCBinary) {
        if (this.checkTree(jCBinary)) {
            super.visitBinary(jCBinary);
        }
    }

    public void visitTypeCast(JCTree.JCTypeCast jCTypeCast) {
        if (this.checkTree(jCTypeCast)) {
            super.visitTypeCast(jCTypeCast);
        }
    }

    public void visitTypeTest(JCTree.JCInstanceOf jCInstanceOf) {
        if (this.checkTree(jCInstanceOf)) {
            super.visitTypeTest(jCInstanceOf);
        }
    }

    public void visitIndexed(JCTree.JCArrayAccess jCArrayAccess) {
        if (this.checkTree(jCArrayAccess)) {
            super.visitIndexed(jCArrayAccess);
        }
    }

    public void visitSelect(JCTree.JCFieldAccess jCFieldAccess) {
        if (this.checkTree(jCFieldAccess) && this.checkSymbol(jCFieldAccess.sym)) {
            super.visitSelect(jCFieldAccess);
        }
    }

    public void visitIdent(JCTree.JCIdent jCIdent) {
        if (this.checkTree(jCIdent) && this.checkSymbol(jCIdent.sym)) {
            super.visitIdent(jCIdent);
        }
    }

    public void visitLiteral(JCTree.JCLiteral jCLiteral) {
        if (this.checkTree(jCLiteral)) {
            super.visitLiteral(jCLiteral);
        }
    }

    public void visitTypeIdent(JCTree.JCPrimitiveTypeTree jCPrimitiveTypeTree) {
        if (this.checkTree(jCPrimitiveTypeTree)) {
            super.visitTypeIdent(jCPrimitiveTypeTree);
        }
    }

    public void visitTypeArray(JCTree.JCArrayTypeTree jCArrayTypeTree) {
        if (this.checkTree(jCArrayTypeTree)) {
            super.visitTypeArray(jCArrayTypeTree);
        }
    }

    public void visitTypeApply(JCTree.JCTypeApply jCTypeApply) {
        if (this.checkTree(jCTypeApply)) {
            super.visitTypeApply(jCTypeApply);
        }
    }

    public void visitTypeParameter(JCTree.JCTypeParameter jCTypeParameter) {
        if (this.checkTree(jCTypeParameter)) {
            super.visitTypeParameter(jCTypeParameter);
        }
    }

    public void visitWildcard(JCTree.JCWildcard jCWildcard) {
        if (this.checkTree(jCWildcard)) {
            super.visitWildcard(jCWildcard);
        }
    }

    public void visitErroneous(JCTree.JCErroneous jCErroneous) {
        if (this.checkTree(jCErroneous)) {
            super.visitErroneous(jCErroneous);
        }
    }
}

