/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.save;

import com.sun.tools.javac.parser.Scanner;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Name;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import org.netbeans.modules.java.source.save.SourceBuffer;

public class TokenList
extends AbstractList {
    private String sourceFile;
    private Token[] tokens;

    public static TokenList scan(Context context, String string, SourceBuffer sourceBuffer) throws IOException {
        TokenList tokenList = new TokenList(string);
        tokenList.scan(context, sourceBuffer);
        return tokenList;
    }

    private TokenList(String string) {
        this.sourceFile = string;
    }

    protected void scan(Context context, SourceBuffer sourceBuffer) throws IOException {
        Scanner.Factory factory = Scanner.Factory.instance((Context)context);
        Scanner scanner = factory.newScanner((CharSequence)sourceBuffer);
        ArrayList<Token> arrayList = new ArrayList<Token>();
        scanner.nextToken();
        while (scanner.token() != com.sun.tools.javac.parser.Token.EOF) {
            arrayList.add(new Token(scanner));
            scanner.nextToken();
        }
        this.tokens = arrayList.toArray(new Token[0]);
    }

    public Token get(int n) {
        return this.tokens[n];
    }

    public int size() {
        return this.tokens.length;
    }

    public int indexOf(int n) {
        int n2 = 0;
        int n3 = this.tokens.length - 1;
        int n4;
        while (this.tokens[n4 = (n2 + n3) / 2].pos != n) {
            if (n2 > n3) {
                return -1;
            }
            if (this.tokens[n4].pos < n) {
                n2 = n4 + 1;
                continue;
            }
            n3 = n4 - 1;
        }
        return n4;
    }

    public int indexOfEndPos(int n) {
        int n2 = 0;
        int n3 = this.tokens.length - 1;
        int n4;
        while (this.tokens[n4 = (n2 + n3) / 2].endPos != n) {
            if (n2 > n3) {
                return -1;
            }
            if (this.tokens[n4].endPos < n) {
                n2 = n4 + 1;
                continue;
            }
            n3 = n4 - 1;
        }
        return n4;
    }

    public String toString() {
        return "TokenList of " + this.sourceFile + ": " + this.tokens.length + " tokens";
    }

    public static class Token {
        private com.sun.tools.javac.parser.Token token;
        private int pos;
        private int endPos;
        private Name name;
        private String value;

        private Token(Scanner scanner) {
            this.token = scanner.token();
            this.pos = scanner.pos();
            this.endPos = scanner.endPos();
            switch (this.token) {
                case INTLITERAL: 
                case LONGLITERAL: 
                case FLOATLITERAL: 
                case DOUBLELITERAL: 
                case CHARLITERAL: 
                case STRINGLITERAL: {
                    this.value = scanner.stringVal();
                    break;
                }
                case LPAREN: 
                case RPAREN: 
                case LBRACE: 
                case RBRACE: 
                case LBRACKET: 
                case RBRACKET: 
                case COMMA: 
                case SEMI: 
                case DOT: {
                    break;
                }
                default: {
                    this.name = scanner.name();
                }
            }
        }

        public com.sun.tools.javac.parser.Token getToken() {
            return this.token;
        }

        public int getPos() {
            return this.pos;
        }

        public int getEndPos() {
            return this.endPos;
        }

        public Name getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public boolean isFlag() {
            return this.token == com.sun.tools.javac.parser.Token.PUBLIC || this.token == com.sun.tools.javac.parser.Token.PRIVATE || this.token == com.sun.tools.javac.parser.Token.PROTECTED || this.token == com.sun.tools.javac.parser.Token.STATIC || this.token == com.sun.tools.javac.parser.Token.FINAL || this.token == com.sun.tools.javac.parser.Token.SYNCHRONIZED || this.token == com.sun.tools.javac.parser.Token.VOLATILE || this.token == com.sun.tools.javac.parser.Token.TRANSIENT || this.token == com.sun.tools.javac.parser.Token.NATIVE || this.token == com.sun.tools.javac.parser.Token.INTERFACE || this.token == com.sun.tools.javac.parser.Token.ABSTRACT || this.token == com.sun.tools.javac.parser.Token.STRICTFP;
        }

        public boolean isIdentifier() {
            return this.token == com.sun.tools.javac.parser.Token.IDENTIFIER;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(this.token.name());
            stringBuffer.append(": pos=");
            stringBuffer.append(this.pos);
            stringBuffer.append(':');
            stringBuffer.append(this.pos);
            stringBuffer.append(", endPos=");
            stringBuffer.append(this.endPos);
            stringBuffer.append(':');
            stringBuffer.append(this.endPos);
            if (this.name != null) {
                stringBuffer.append(", name=");
                stringBuffer.append(this.name.toString());
            }
            if (this.value != null) {
                stringBuffer.append(", value=");
                stringBuffer.append(this.value);
            }
            return stringBuffer.toString();
        }
    }
}

