/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.script;

import com.sun.tools.javac.parser.Parser;
import com.sun.tools.javac.parser.Scanner;
import com.sun.tools.javac.parser.Token;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.java.source.script.PluginCompiler;
import org.netbeans.modules.java.source.script.Rule;
import org.netbeans.modules.java.source.script.TransformParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptHandler
extends TransformParser {
    private PluginCompiler pc;
    private final Map<JCTree, Object> attachMap = new HashMap<JCTree, Object>();
    private Name applyName = this.names.fromString("apply");
    private Name methodName = this.names.fromString("method");
    private Name noteName;
    private Name clazzName = this.names.fromString("clazz");

    public ScriptHandler(String string, String string2) throws IOException {
        this(new BufferedReader(new FileReader(string)), string2);
        this.fileName = string;
    }

    private ScriptHandler(Reader reader, String string) {
        super(reader, string);
        this.noteName = this.names.fromString("note");
    }

    private List<JCTree> parseScript() {
        if (this.scanner.token() == Token.EOF) {
            return List.nil();
        }
        JCTree.JCStatement jCStatement = this.statement();
        if (!this.hasErrors()) {
            return this.parseScript().prepend(jCStatement);
        }
        return List.nil();
    }

    public boolean isName(JCTree jCTree, Name name) {
        return jCTree != null && jCTree instanceof JCTree.JCIdent && ((JCTree.JCIdent)jCTree).name == name;
    }

    public Class compile() throws IOException {
        List<JCTree> list = this.parseScript();
        System.err.println("JCTree=" + list);
        if (list.isEmpty()) {
            return null;
        }
        this.pc = new PluginCompiler();
        if (this.pc.needsGeneration(this.fileName, 0L, true)) {
            this.pc.startGeneration();
            this.pc.write("import com.sun.tools.javac.code.Symbol;\n");
            this.pc.write("import com.sun.tools.javac.parser.*;\n");
            this.pc.write("import com.sun.tools.javac.tree.*;\n");
            this.pc.write("import com.sun.tools.javac.tree.JCTree.*;\n");
            this.pc.write("import com.sun.tools.javac.util.*;\n");
            this.pc.write("public class ");
            this.pc.writeClassName();
            this.pc.write(" extends GeneratedScript {\n");
            this.pc.write("public void execute() {\n");
            this.pc.write(" }\n");
            List<JCTree> list2 = list;
            while (list2.nonEmpty()) {
                if (list2.head instanceof JCTree.JCIf) {
                    final JCTree.JCIf jCIf = (JCTree.JCIf)list2.head;
                    jCIf.thenpart.accept(new JCTree.Visitor(){
                        final boolean isMethod;
                        final boolean isClass;
                        final String mname;
                        {
                            this.isMethod = ScriptHandler.this.isName(jCIf.cond, ScriptHandler.this.methodName);
                            this.isClass = ScriptHandler.this.isName(jCIf.cond, ScriptHandler.this.clazzName);
                            this.mname = this.isMethod ? "MethodDef" : (this.isClass ? "ClassDef" : "ERROR");
                            ScriptHandler.this.pc.write("    public void visit(");
                            ScriptHandler.this.pc.write(this.mname);
                            ScriptHandler.this.pc.write(" node) {\n");
                            if (!this.isMethod && !this.isClass) {
                                ScriptHandler.this.log.error(jCIf.pos, "illegal condition", new Object[0]);
                            }
                        }

                        @Override
                        public void visitTree(JCTree jCTree) {
                            ScriptHandler.this.log.error(jCTree.pos, "Missing code generator", new Object[0]);
                        }

                        @Override
                        public void visitTopLevel(JCTree.JCCompilationUnit jCCompilationUnit) {
                            this.visitTree(jCCompilationUnit);
                        }

                        @Override
                        public void visitImport(JCTree.JCImport jCImport) {
                            this.visitTree(jCImport);
                        }

                        @Override
                        public void visitClassDef(JCTree.JCClassDecl jCClassDecl) {
                            this.visitTree(jCClassDecl);
                        }

                        @Override
                        public void visitMethodDef(JCTree.JCMethodDecl jCMethodDecl) {
                            this.visitTree(jCMethodDecl);
                        }

                        @Override
                        public void visitVarDef(JCTree.JCVariableDecl jCVariableDecl) {
                            this.visitTree(jCVariableDecl);
                        }

                        @Override
                        public void visitSkip(JCTree.JCSkip jCSkip) {
                        }

                        @Override
                        public void visitBlock(JCTree.JCBlock jCBlock) {
                            List<JCTree.JCStatement> list = jCBlock.stats;
                            while (list.nonEmpty()) {
                                ((JCTree.JCStatement)list.head).accept(this);
                                list = list.tail;
                            }
                        }

                        @Override
                        public void visitDoLoop(JCTree.JCDoWhileLoop jCDoWhileLoop) {
                            this.visitTree(jCDoWhileLoop);
                        }

                        @Override
                        public void visitWhileLoop(JCTree.JCWhileLoop jCWhileLoop) {
                            this.visitTree(jCWhileLoop);
                        }

                        @Override
                        public void visitForLoop(JCTree.JCForLoop jCForLoop) {
                            this.visitTree(jCForLoop);
                        }

                        @Override
                        public void visitLabelled(JCTree.JCLabeledStatement jCLabeledStatement) {
                            this.visitTree(jCLabeledStatement);
                        }

                        @Override
                        public void visitSwitch(JCTree.JCSwitch jCSwitch) {
                            this.visitTree(jCSwitch);
                        }

                        @Override
                        public void visitCase(JCTree.JCCase jCCase) {
                            this.visitTree(jCCase);
                        }

                        @Override
                        public void visitSynchronized(JCTree.JCSynchronized jCSynchronized) {
                            this.visitTree(jCSynchronized);
                        }

                        @Override
                        public void visitTry(JCTree.JCTry jCTry) {
                            this.visitTree(jCTry);
                        }

                        @Override
                        public void visitCatch(JCTree.JCCatch jCCatch) {
                            this.visitTree(jCCatch);
                        }

                        @Override
                        public void visitConditional(JCTree.JCConditional jCConditional) {
                            this.visitTree(jCConditional);
                        }

                        @Override
                        public void visitIf(JCTree.JCIf jCIf2) {
                            this.visitTree(jCIf2);
                        }

                        @Override
                        public void visitExec(JCTree.JCExpressionStatement jCExpressionStatement) {
                            jCExpressionStatement.expr.accept(this);
                        }

                        @Override
                        public void visitBreak(JCTree.JCBreak jCBreak) {
                            this.visitTree(jCBreak);
                        }

                        @Override
                        public void visitContinue(JCTree.JCContinue jCContinue) {
                            this.visitTree(jCContinue);
                        }

                        @Override
                        public void visitReturn(JCTree.JCReturn jCReturn) {
                            this.visitTree(jCReturn);
                        }

                        @Override
                        public void visitThrow(JCTree.JCThrow jCThrow) {
                            this.visitTree(jCThrow);
                        }

                        @Override
                        public void visitAssert(JCTree.JCAssert jCAssert) {
                            this.visitTree(jCAssert);
                        }

                        @Override
                        public void visitApply(JCTree.JCMethodInvocation jCMethodInvocation) {
                            if (ScriptHandler.this.isName(jCMethodInvocation.meth, ScriptHandler.this.noteName)) {
                                this.write("\tSystem.err.println(\"NOTE!! \"+node);\n");
                                this.write("\taddResult(node,null,");
                                this.writeString(jCMethodInvocation.args);
                                this.write(");\n");
                            } else {
                                ScriptHandler.this.log.error(jCMethodInvocation.pos, "Unknown method", new Object[0]);
                            }
                        }

                        @Override
                        public void visitNewClass(JCTree.JCNewClass jCNewClass) {
                            this.visitTree(jCNewClass);
                        }

                        @Override
                        public void visitNewArray(JCTree.JCNewArray jCNewArray) {
                            this.visitTree(jCNewArray);
                        }

                        @Override
                        public void visitParens(JCTree.JCParens jCParens) {
                            jCParens.expr.accept(this);
                        }

                        @Override
                        public void visitAssign(JCTree.JCAssign jCAssign) {
                            this.visitTree(jCAssign);
                        }

                        @Override
                        public void visitAssignop(JCTree.JCAssignOp jCAssignOp) {
                            this.visitTree(jCAssignOp);
                        }

                        @Override
                        public void visitUnary(JCTree.JCUnary jCUnary) {
                            this.visitTree(jCUnary);
                        }

                        @Override
                        public void visitBinary(JCTree.JCBinary jCBinary) {
                            this.visitTree(jCBinary);
                        }

                        @Override
                        public void visitTypeCast(JCTree.JCTypeCast jCTypeCast) {
                            this.visitTree(jCTypeCast);
                        }

                        @Override
                        public void visitTypeTest(JCTree.JCInstanceOf jCInstanceOf) {
                            this.visitTree(jCInstanceOf);
                        }

                        @Override
                        public void visitIndexed(JCTree.JCArrayAccess jCArrayAccess) {
                            this.visitTree(jCArrayAccess);
                        }

                        @Override
                        public void visitSelect(JCTree.JCFieldAccess jCFieldAccess) {
                            this.visitTree(jCFieldAccess);
                        }

                        @Override
                        public void visitIdent(JCTree.JCIdent jCIdent) {
                            this.visitTree(jCIdent);
                        }

                        @Override
                        public void visitLiteral(JCTree.JCLiteral jCLiteral) {
                            this.visitTree(jCLiteral);
                        }

                        @Override
                        public void visitTypeIdent(JCTree.JCPrimitiveTypeTree jCPrimitiveTypeTree) {
                            this.visitTree(jCPrimitiveTypeTree);
                        }

                        @Override
                        public void visitTypeArray(JCTree.JCArrayTypeTree jCArrayTypeTree) {
                            this.visitTree(jCArrayTypeTree);
                        }

                        @Override
                        public void visitTypeApply(JCTree.JCTypeApply jCTypeApply) {
                            this.visitTree(jCTypeApply);
                        }

                        @Override
                        public void visitTypeParameter(JCTree.JCTypeParameter jCTypeParameter) {
                            this.visitTree(jCTypeParameter);
                        }

                        @Override
                        public void visitErroneous(JCTree.JCErroneous jCErroneous) {
                            this.visitTree(jCErroneous);
                        }

                        private void write(String string) {
                            try {
                                ScriptHandler.this.pc.write(string);
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }

                        private void writeQuoted(String string) {
                            try {
                                ScriptHandler.this.pc.writeQuoted(string);
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }

                        private void writeString(List<? extends JCTree> list) {
                            boolean bl = true;
                            while (list.nonEmpty()) {
                                if (bl) {
                                    bl = false;
                                } else {
                                    this.write("+");
                                }
                                this.writeString((JCTree)list.head);
                                list = list.tail;
                            }
                        }

                        private void writeString(JCTree jCTree) {
                            if (jCTree == null) {
                                this.writeQuoted("");
                            } else {
                                switch (jCTree.tag) {
                                    case 36: {
                                        Object object = ((JCTree.JCLiteral)jCTree).value;
                                        this.writeQuoted(object == null ? "NULL" : object.toString());
                                        break;
                                    }
                                    case 69: {
                                        JCTree.JCBinary jCBinary = (JCTree.JCBinary)jCTree;
                                        this.writeString(jCBinary.lhs);
                                        this.write("+");
                                        this.writeString(jCBinary.rhs);
                                        break;
                                    }
                                    default: {
                                        ScriptHandler.this.log.error(jCTree.pos, "Unsupported construct", new Object[0]);
                                    }
                                }
                            }
                        }
                    });
                    this.pc.write("    }\n");
                } else {
                    this.log.error(((JCTree)list2.head).pos, "illegal root statement", new Object[0]);
                }
                list2 = list2.tail;
            }
            this.dumpNameConsts(this.pc);
            this.pc.write("}\n");
            if (this.hasErrors()) {
                return null;
            }
        }
        return this.pc.loadClass(this.javacpath);
    }

    @Override
    public Parser makeParser() {
        return Factory.instance(this.context).newParser(this.scanner, this);
    }

    private static class Factory
    extends Parser.Factory {
        public static Factory instance(Context context) {
            Factory factory = (Factory)((Object)context.get(parserFactoryKey));
            if (factory == null) {
                factory = new Factory(context);
            }
            return factory;
        }

        protected Factory(Context context) {
            super(context);
        }

        public Parser newParser(final Scanner scanner, final ScriptHandler scriptHandler) {
            return new Parser(this, scanner, false){

                protected JCTree checkExprStat(JCTree jCTree) {
                    return jCTree;
                }

                public void accept(Token token) {
                    if (token != Token.SEMI || !scriptHandler.isToken(scriptHandler.impliesToken) && !scriptHandler.isToken(scriptHandler.suchthatToken)) {
                        super.accept(token);
                    }
                }

                protected JCTree.JCExpression term3() {
                    Name name;
                    JCTree.JCExpression jCExpression = super.term3();
                    if (jCExpression instanceof JCTree.JCFieldAccess && scriptHandler.scanner.token() == Token.LBRACE && (name = ((JCTree.JCFieldAccess)jCExpression).name) == scriptHandler.applyName) {
                        scanner.nextToken();
                        Rule rule = scriptHandler.parseRules();
                        this.accept(Token.RBRACE);
                        scriptHandler.attachMap.put(jCExpression, rule);
                    }
                    return jCExpression;
                }
            };
        }
    }
}

