/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.script;

import com.sun.tools.javac.parser.Lexer;
import com.sun.tools.javac.parser.Parser;
import com.sun.tools.javac.parser.Scanner;
import com.sun.tools.javac.parser.Token;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.DefaultFileManager;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Logger;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;

public class ScriptParser {
    protected static final Logger logger = Logger.getLogger("org.netbeans.modules.java.source");
    protected final Context context = this.createContext();
    protected ScriptLog log;
    protected Scanner scanner;
    protected Parser parser;
    protected final Name.Table names = Name.Table.instance((Context)this.context);
    protected final TreeMaker make = TreeMaker.instance(this.context);

    public void setIn(String string, String string2) {
        this.log.setSource(string, string2);
        this.reset();
        this.scanner = this.makeScanner(string2);
        this.parser = this.makeParser();
    }

    public void setIn(String string, Reader reader) {
        char[] cArray;
        try {
            int n;
            CharArrayWriter charArrayWriter = new CharArrayWriter();
            char[] cArray2 = new char[8192];
            while ((n = reader.read(cArray2)) > 0) {
                charArrayWriter.write(cArray2, 0, n);
            }
            charArrayWriter.write(0);
            cArray = charArrayWriter.toCharArray();
        }
        catch (IOException iOException) {
            cArray = new char[1];
        }
        this.log.setSource(string, new String(cArray, 0, cArray.length - 1));
        this.reset();
        this.scanner = this.makeScanner(cArray, cArray.length - 1);
        this.parser = this.makeParser();
    }

    public final JCTree.JCStatement statement() {
        return this.parser.statement();
    }

    public final JCTree.JCExpression expression() {
        return this.parser.expression();
    }

    public final boolean atEnd() {
        return this.scanner.token() == Token.EOF;
    }

    public boolean hasErrors() {
        return this.log.hasErrors();
    }

    public String getErrors() {
        return this.log.getErrors();
    }

    public JCTree statement(String string) {
        this.setIn("Script", string);
        return this.parser.statement();
    }

    public JCTree expression(String string) {
        this.setIn("Script", string);
        return this.parser.expression();
    }

    public static void main(String[] stringArray) {
        System.err.println("t=" + new ScriptParser().expression("2+2"));
    }

    protected Context createContext() {
        Context context = new Context();
        this.log = new ScriptLog(context);
        DefaultFileManager.preRegister((Context)context);
        return context;
    }

    protected ScriptParser() {
    }

    public boolean isToken(Name name) {
        return this.scanner.token() == Token.CUSTOM && this.scanner.name().equals(name);
    }

    public Name tokenName(Token token) {
        return this.names.fromString(token.name());
    }

    public void reset() {
        this.log.reset();
    }

    protected Scanner makeScanner(String string) {
        char[] cArray = new char[string.length() + 1];
        System.arraycopy(string.toCharArray(), 0, cArray, 0, string.length());
        return this.makeScanner(cArray, cArray.length - 1);
    }

    private Scanner makeScanner(char[] cArray, int n) {
        assert (cArray.length > n);
        Scanner.Factory factory = Scanner.Factory.instance((Context)this.context);
        return factory.newScanner(cArray, n);
    }

    protected Parser makeParser() {
        Parser.Factory factory = Parser.Factory.instance((Context)this.context);
        return factory.newParser((Lexer)this.scanner, false, false);
    }

    public static class ErrorMessage {
        String msg;
        int pos;

        public ErrorMessage(int n, String string) {
            this.pos = n;
            this.msg = string;
        }
    }

    static class ScriptLog
    extends Log {
        private ErrorMessage[] errors;
        private int errorListLength;
        private int maxErrors = 10;
        private String src = null;
        private boolean fatalError = false;

        ScriptLog(Context context) {
            super(context);
        }

        public void reset() {
            this.errorListLength = 0;
            this.errors = null;
        }

        public void prompt() {
        }

        public void flush() {
        }

        public final void setSource(String string, String string2) {
            this.src = string2;
            try {
                this.useSource(new SimpleJavaFileObject(new URI(string.replace(' ', '_')), JavaFileObject.Kind.SOURCE){

                    public CharSequence getCharContent(boolean bl) {
                        return ScriptLog.this.src;
                    }
                });
            }
            catch (URISyntaxException uRISyntaxException) {
                uRISyntaxException.printStackTrace();
            }
        }

        public final boolean hasErrors() {
            return this.fatalError;
        }

        public final String getErrors() {
            if (this.errorListLength <= 0) {
                return null;
            }
            StringBuffer stringBuffer = new StringBuffer();
            if (this.errorListLength > this.errors.length) {
                stringBuffer.append(this.errorListLength + " errors\n");
                this.errorListLength = this.errors.length;
            }
            for (int i = 0; i < this.errorListLength; ++i) {
                ErrorMessage errorMessage = this.errors[i];
                stringBuffer.append(this.source.getFile().getName());
                stringBuffer.append(':');
                stringBuffer.append(this.source.getLineNumber(errorMessage.pos));
                stringBuffer.append(": ");
                stringBuffer.append(errorMessage.msg);
            }
            return stringBuffer.toString();
        }

        public void report(JCDiagnostic jCDiagnostic) {
            this.rawError((int)jCDiagnostic.getPosition(), jCDiagnostic.getText());
        }

        public void rawError(int n, String string) {
            if (this.errors == null) {
                this.errors = new ErrorMessage[this.maxErrors];
            }
            if (this.errorListLength < this.maxErrors) {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                Log.printLines((PrintWriter)printWriter, (String)string);
                printWriter.flush();
                this.errors[this.errorListLength++] = new ErrorMessage(n, stringWriter.toString());
            }
            this.fatalError = true;
        }
    }
}

