/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.usages;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.lang.model.element.ElementKind;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.classfile.CPClassInfo;
import org.netbeans.modules.classfile.CPFieldInfo;
import org.netbeans.modules.classfile.CPInterfaceMethodInfo;
import org.netbeans.modules.classfile.CPMethodInfo;
import org.netbeans.modules.classfile.ClassFile;
import org.netbeans.modules.classfile.ClassName;
import org.netbeans.modules.classfile.ConstantPool;
import org.netbeans.modules.classfile.InvalidClassFormatException;
import org.netbeans.modules.classfile.LocalVariableTableEntry;
import org.netbeans.modules.classfile.Method;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.usages.ClassFileUtil;
import org.netbeans.modules.java.source.usages.ClassIndexImpl;
import org.netbeans.modules.java.source.usages.ClassIndexManager;
import org.netbeans.modules.java.source.usages.DocumentUtil;
import org.netbeans.modules.java.source.usages.Index;
import org.netbeans.modules.java.source.usages.RepositoryUpdater;
import org.netbeans.modules.java.source.util.LowMemoryEvent;
import org.netbeans.modules.java.source.util.LowMemoryListener;
import org.netbeans.modules.java.source.util.LowMemoryNotifier;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryAnalyser
implements LowMemoryListener {
    static final String OBJECT = Object.class.getName();
    private final Index index;
    private final Map<String, List<String>> refs = new HashMap<String, List<String>>();
    private final Set<String> toDelete = new HashSet<String>();
    private final AtomicBoolean lowMemory;
    private boolean cacheCleared;

    public BinaryAnalyser(Index index) {
        assert (index != null);
        this.index = index;
        this.lowMemory = new AtomicBoolean(false);
    }

    public final void analyse(final URL uRL, final ProgressHandle progressHandle) throws IOException, IllegalArgumentException {
        assert (uRL != null);
        ClassIndexManager.getDefault().writeLock(new ClassIndexManager.ExceptionAction<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void run() throws IOException {
                block21: {
                    LowMemoryNotifier.getDefault().addLowMemoryListener(BinaryAnalyser.this);
                    try {
                        String string = uRL.getProtocol();
                        if ("jar".equals(string)) {
                            URL uRL2 = FileUtil.getArchiveFile((URL)uRL);
                            if ("file".equals(uRL2.getProtocol())) {
                                File file = new File(URI.create(uRL2.toExternalForm()));
                                if (!file.exists() || !file.canRead()) break block21;
                                if (progressHandle != null) {
                                    progressHandle.setDisplayName(String.format(NbBundle.getMessage(BinaryAnalyser.class, (String)"MSG_Scannig"), file.getAbsolutePath()));
                                }
                                if (BinaryAnalyser.this.isUpToDate(null, file.lastModified())) break block21;
                                BinaryAnalyser.this.index.clear();
                                if (progressHandle != null) {
                                    progressHandle.setDisplayName(String.format(NbBundle.getMessage(RepositoryUpdater.class, (String)"MSG_Analyzing"), file.getAbsolutePath()));
                                }
                                ZipFile zipFile = new ZipFile(file);
                                try {
                                    BinaryAnalyser.this.analyseArchive(zipFile);
                                    break block21;
                                }
                                finally {
                                    zipFile.close();
                                }
                            }
                            FileObject fileObject = URLMapper.findFileObject((URL)uRL);
                            if (fileObject != null) {
                                if (progressHandle != null) {
                                    progressHandle.setDisplayName(String.format(NbBundle.getMessage(BinaryAnalyser.class, (String)"MSG_Scannig"), FileUtil.getFileDisplayName((FileObject)fileObject)));
                                }
                                if (!BinaryAnalyser.this.isUpToDate(null, fileObject.lastModified().getTime())) {
                                    BinaryAnalyser.this.index.clear();
                                    if (progressHandle != null) {
                                        progressHandle.setDisplayName(String.format(NbBundle.getMessage(RepositoryUpdater.class, (String)"MSG_Analyzing"), FileUtil.getFileDisplayName((FileObject)fileObject)));
                                    }
                                    BinaryAnalyser.this.analyseFileObjects(fileObject);
                                }
                            }
                            break block21;
                        }
                        if ("file".equals(string)) {
                            File file = new File(URI.create(uRL.toExternalForm()));
                            if (file.isDirectory()) {
                                String string2 = file.getAbsolutePath();
                                if (string2.charAt(string2.length() - 1) != File.separatorChar) {
                                    string2 = string2 + File.separatorChar;
                                }
                                if (progressHandle != null) {
                                    progressHandle.setDisplayName(String.format(NbBundle.getMessage(RepositoryUpdater.class, (String)"MSG_Analyzing"), file.getAbsolutePath()));
                                }
                                BinaryAnalyser.this.cacheCleared = false;
                                BinaryAnalyser.this.analyseFolder(file, string2);
                            }
                        } else {
                            FileObject fileObject = URLMapper.findFileObject((URL)uRL);
                            if (fileObject != null) {
                                if (progressHandle != null) {
                                    progressHandle.setDisplayName(String.format(NbBundle.getMessage(RepositoryUpdater.class, (String)"MSG_Analyzing"), FileUtil.getFileDisplayName((FileObject)fileObject)));
                                }
                                BinaryAnalyser.this.index.clear();
                                BinaryAnalyser.this.analyseFileObjects(fileObject);
                            }
                        }
                    }
                    finally {
                        LowMemoryNotifier.getDefault().removeLowMemoryListener(BinaryAnalyser.this);
                    }
                }
                BinaryAnalyser.this.store();
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analyseFolder(File file, String string) throws IOException {
        if (file.exists() && file.canRead()) {
            File[] fileArray;
            for (File file2 : fileArray = file.listFiles()) {
                int n;
                if (file2.isDirectory()) {
                    this.analyseFolder(file2, string);
                    continue;
                }
                if (!this.accepts(file2.getName())) continue;
                String string2 = file2.getAbsolutePath();
                long l = file2.lastModified();
                int n2 = string2.lastIndexOf(46);
                int n3 = n2 > (n = string2.lastIndexOf(47)) ? n2 : string2.length();
                String string3 = FileObjects.convertFolder2Package(string2.substring(string.length(), n3));
                if (!this.accepts(file2.getName()) || this.isUpToDate(string3, l)) continue;
                if (!this.cacheCleared) {
                    this.index.clear();
                    this.cacheCleared = true;
                }
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file2));
                try {
                    this.analyse(bufferedInputStream);
                }
                catch (InvalidClassFormatException invalidClassFormatException) {
                    Logger.getLogger(BinaryAnalyser.class.getName()).info("Invalid class file format: " + file2.getAbsolutePath());
                }
                finally {
                    ((InputStream)bufferedInputStream).close();
                }
                if (!this.lowMemory.getAndSet(false)) continue;
                this.store();
            }
        }
    }

    private void analyseArchive(ZipFile zipFile) throws IOException {
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            if (zipEntry.isDirectory() || !this.accepts(zipEntry.getName())) continue;
            InputStream inputStream = zipFile.getInputStream(zipEntry);
            try {
                this.analyse(inputStream);
            }
            catch (InvalidClassFormatException invalidClassFormatException) {
                Logger.getLogger(BinaryAnalyser.class.getName()).info("Invalid class file format: " + new File(zipFile.getName()).toURI() + "!/" + zipEntry.getName());
            }
            catch (IOException iOException) {
                Exceptions.attachMessage((Throwable)iOException, (String)("While scanning: " + zipEntry.getName()));
                throw iOException;
            }
            finally {
                inputStream.close();
            }
            if (!this.lowMemory.getAndSet(false)) continue;
            this.store();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analyseFileObjects(FileObject fileObject) throws IOException {
        for (FileObject fileObject2 : fileObject.getChildren()) {
            if (fileObject2.isFolder()) {
                this.analyseFileObjects(fileObject2);
                continue;
            }
            if (!this.accepts(fileObject2.getName())) continue;
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileObject2.getInputStream());
            try {
                this.analyse(bufferedInputStream);
            }
            catch (InvalidClassFormatException invalidClassFormatException) {
                Logger.getLogger(BinaryAnalyser.class.getName()).info("Invalid class file format: " + FileUtil.getFileDisplayName((FileObject)fileObject2));
            }
            finally {
                ((InputStream)bufferedInputStream).close();
            }
            if (!this.lowMemory.getAndSet(false)) continue;
            this.store();
        }
    }

    private final void delete(String string) throws IOException {
        assert (string != null);
        if (!this.index.isValid(false)) {
            return;
        }
        this.toDelete.add(string);
    }

    @Override
    public void lowMemory(LowMemoryEvent lowMemoryEvent) {
        this.lowMemory.set(true);
    }

    private boolean accepts(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1 || n + 1 == string.length()) {
            return false;
        }
        return "CLASS".equalsIgnoreCase(string.substring(n + 1));
    }

    private void analyse(InputStream inputStream) throws IOException {
        ClassFile classFile = new ClassFile(inputStream);
        ClassName className = classFile.getName();
        String string = BinaryAnalyser.nameToString(className);
        this.delete(string);
        Map<ClassName, Set<ClassIndexImpl.UsageType>> map = this.performAnalyse(classFile, string);
        ElementKind elementKind = ElementKind.CLASS;
        if (classFile.isEnum()) {
            elementKind = ElementKind.ENUM;
        } else if (classFile.isAnnotation()) {
            elementKind = ElementKind.ANNOTATION_TYPE;
        } else if ((classFile.getAccess() & 0x200) == 512) {
            elementKind = ElementKind.INTERFACE;
        }
        String string2 = string + DocumentUtil.encodeKind(elementKind);
        List<String> list = this.getClassReferences(string2);
        for (Map.Entry<ClassName, Set<ClassIndexImpl.UsageType>> entry : map.entrySet()) {
            ClassName className2 = entry.getKey();
            Set<ClassIndexImpl.UsageType> set = entry.getValue();
            list.add(DocumentUtil.encodeUsage(BinaryAnalyser.nameToString(className2), set));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store() throws IOException {
        try {
            if (this.refs.size() > 0 || this.toDelete.size() > 0) {
                this.index.store(this.refs, this.toDelete);
            }
        }
        finally {
            this.refs.clear();
            this.toDelete.clear();
        }
    }

    private final boolean isUpToDate(String string, long l) throws IOException {
        return this.index.isUpToDate(string, l);
    }

    private Map<ClassName, Set<ClassIndexImpl.UsageType>> performAnalyse(ClassFile classFile, String string) throws IOException {
        ClassName[] classNameArray;
        List list;
        Object object;
        Object object22;
        Object object3;
        Object object5;
        ClassName[] classNameArray2;
        HashMap<ClassName, Set<ClassIndexImpl.UsageType>> hashMap = new HashMap<ClassName, Set<ClassIndexImpl.UsageType>>();
        String string2 = classFile.getTypeSignature();
        if (string2 != null) {
            try {
                classNameArray2 = ClassFileUtil.getTypesFromClassTypeSignature(string2);
                for (ClassName className : classNameArray2) {
                    BinaryAnalyser.addUsage(hashMap, className, ClassIndexImpl.UsageType.TYPE_REFERENCE);
                }
            }
            catch (RuntimeException runtimeException) {
                StackTraceElement[] stackTraceElementArray;
                object5 = new StringBuilder("BinaryAnalyser: Cannot read type: " + string2 + " cause: " + runtimeException.getLocalizedMessage() + '\n');
                for (StackTraceElement object42 : stackTraceElementArray = runtimeException.getStackTrace()) {
                    ((StringBuilder)object5).append(object42.toString());
                    ((StringBuilder)object5).append('\n');
                }
                Logger.getLogger("global").log(Level.INFO, ((StringBuilder)object5).toString());
            }
        }
        if ((classNameArray2 = classFile.getSuperClass()) != null) {
            BinaryAnalyser.addUsage(hashMap, (ClassName)classNameArray2, ClassIndexImpl.UsageType.SUPER_CLASS);
        }
        object5 = classFile.getInterfaces();
        ConstantPool constantPool = object5.iterator();
        while (constantPool.hasNext()) {
            ClassName className = (ClassName)constantPool.next();
            BinaryAnalyser.addUsage(hashMap, className, ClassIndexImpl.UsageType.SUPER_INTERFACE);
        }
        constantPool = classFile.getConstantPool();
        Collection collection = constantPool.getAllConstants(CPFieldInfo.class);
        for (CPFieldInfo cPFieldInfo : collection) {
            ClassName className = ClassFileUtil.getType(constantPool.getClass(cPFieldInfo.getClassID()));
            if (className == null) continue;
            BinaryAnalyser.addUsage(hashMap, className, ClassIndexImpl.UsageType.FIELD_REFERENCE);
        }
        Object object6 = constantPool.getAllConstants(CPMethodInfo.class);
        Object object7 = object6.iterator();
        while (object7.hasNext()) {
            CPMethodInfo cPMethodInfo = (CPMethodInfo)object7.next();
            object3 = ClassFileUtil.getType(constantPool.getClass(cPMethodInfo.getClassID()));
            if (object3 == null) continue;
            BinaryAnalyser.addUsage(hashMap, (ClassName)object3, ClassIndexImpl.UsageType.METHOD_REFERENCE);
        }
        object6 = constantPool.getAllConstants(CPInterfaceMethodInfo.class);
        object7 = object6.iterator();
        while (object7.hasNext()) {
            CPMethodInfo cPMethodInfo = (CPMethodInfo)object7.next();
            object3 = ClassFileUtil.getType(constantPool.getClass(cPMethodInfo.getClassID()));
            if (object3 == null) continue;
            BinaryAnalyser.addUsage(hashMap, (ClassName)object3, ClassIndexImpl.UsageType.METHOD_REFERENCE);
        }
        object7 = classFile.getMethods();
        Iterator iterator = object7.iterator();
        while (iterator.hasNext()) {
            int n;
            LocalVariableTableEntry[] localVariableTableEntryArray;
            int n2;
            ClassName[] classNameArray3;
            object3 = (Method)iterator.next();
            object22 = object3.getReturnType();
            object = ClassFileUtil.getType((String)object22);
            if (object != null) {
                BinaryAnalyser.addUsage(hashMap, object, ClassIndexImpl.UsageType.TYPE_REFERENCE);
            }
            list = object3.getParameters();
            classNameArray = list.iterator();
            while (classNameArray.hasNext()) {
                classNameArray3 = (ClassName[])classNameArray.next();
                object22 = classNameArray3.getDescriptor();
                object = ClassFileUtil.getType((String)object22);
                if (object == null) continue;
                BinaryAnalyser.addUsage(hashMap, object, ClassIndexImpl.UsageType.TYPE_REFERENCE);
            }
            classNameArray3 = classNameArray = object3.getExceptionClasses();
            int n3 = classNameArray3.length;
            for (n2 = 0; n2 < n3; ++n2) {
                CPClassInfo cPClassInfo = classNameArray3[n2];
                object = cPClassInfo.getClassName();
                if (object == null) continue;
                BinaryAnalyser.addUsage(hashMap, object, ClassIndexImpl.UsageType.TYPE_REFERENCE);
            }
            object22 = object3.getTypeSignature();
            if (object22 != null) {
                try {
                    ClassName[] classNameArray4 = classNameArray3 = ClassFileUtil.getTypesFromMethodTypeSignature((String)object22);
                    n2 = classNameArray4.length;
                    for (int i = 0; i < n2; ++i) {
                        ClassName className = classNameArray4[i];
                        BinaryAnalyser.addUsage(hashMap, className, ClassIndexImpl.UsageType.TYPE_REFERENCE);
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    Logger.getLogger("global").warning("Invalid method signature: " + string + "::" + object3.getName() + " signature is:" + (String)object22);
                }
            }
            if ((classNameArray3 = object3.getCode()) == null) continue;
            LocalVariableTableEntry[] localVariableTableEntryArray2 = localVariableTableEntryArray = classNameArray3.getLocalVariableTable();
            int n4 = localVariableTableEntryArray2.length;
            for (n = 0; n < n4; ++n) {
                LocalVariableTableEntry localVariableTableEntry = localVariableTableEntryArray2[n];
                object = ClassFileUtil.getType(localVariableTableEntry.getDescription());
                if (object == null) continue;
                BinaryAnalyser.addUsage(hashMap, object, ClassIndexImpl.UsageType.TYPE_REFERENCE);
            }
            LocalVariableTableEntry[] localVariableTableEntryArray3 = localVariableTableEntryArray2 = object3.getCode().getLocalVariableTypeTable();
            n = localVariableTableEntryArray3.length;
            for (int i = 0; i < n; ++i) {
                LocalVariableTableEntry localVariableTableEntry = localVariableTableEntryArray3[i];
                try {
                    ClassName[] classNameArray5;
                    for (ClassName className : classNameArray5 = ClassFileUtil.getTypesFromFiledTypeSignature(localVariableTableEntry.getSignature())) {
                        BinaryAnalyser.addUsage(hashMap, className, ClassIndexImpl.UsageType.TYPE_REFERENCE);
                    }
                    continue;
                }
                catch (IllegalStateException illegalStateException) {
                    Logger.getLogger("global").warning("Invalid local variable signature: " + string + "::" + object3.getName());
                }
            }
        }
        Collection collection2 = classFile.getVariables();
        for (Object object22 : collection2) {
            object = object22.getDescriptor();
            list = ClassFileUtil.getType((String)object);
            if (list != null) {
                BinaryAnalyser.addUsage(hashMap, (ClassName)list, ClassIndexImpl.UsageType.TYPE_REFERENCE);
            }
            if ((object = object22.getTypeSignature()) == null) continue;
            try {
                for (ClassName className : classNameArray = ClassFileUtil.getTypesFromFiledTypeSignature((String)object)) {
                    BinaryAnalyser.addUsage(hashMap, className, ClassIndexImpl.UsageType.TYPE_REFERENCE);
                }
            }
            catch (IllegalStateException illegalStateException) {
                Logger.getLogger("global").warning("Invalid field signature: " + string + "::" + object22.getName() + " signature is: " + (String)object);
            }
        }
        object3 = constantPool.getAllConstants(CPClassInfo.class);
        object22 = object3.iterator();
        while (object22.hasNext()) {
            object = (CPClassInfo)object22.next();
            list = ClassFileUtil.getType((CPClassInfo)object);
            if (list == null || hashMap.keySet().contains(list)) continue;
            BinaryAnalyser.addUsage(hashMap, (ClassName)list, ClassIndexImpl.UsageType.TYPE_REFERENCE);
        }
        return hashMap;
    }

    private List<String> getClassReferences(String string) {
        assert (string != null);
        List<String> list = this.refs.get(string);
        if (list == null) {
            list = new ArrayList<String>();
            this.refs.put(string, list);
        }
        return list;
    }

    private static String nameToString(ClassName className) {
        return className.getInternalName().replace('/', '.');
    }

    private static void addUsage(Map<ClassName, Set<ClassIndexImpl.UsageType>> map, ClassName className, ClassIndexImpl.UsageType usageType) {
        if (OBJECT.equals(className.getExternalName())) {
            return;
        }
        Set<ClassIndexImpl.UsageType> set = map.get(className);
        if (set == null) {
            set = EnumSet.noneOf(ClassIndexImpl.UsageType.class);
            map.put(className, set);
        }
        set.add(usageType);
    }
}

