/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.usages;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.netbeans.modules.java.source.usages.ClassIndexImpl;
import org.netbeans.modules.java.source.usages.Index;
import org.netbeans.modules.java.source.usages.PersistentClassIndex;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassIndexManager {
    private static ClassIndexManager instance;
    private final Map<URL, ClassIndexImpl> instances = new HashMap<URL, ClassIndexImpl>();
    private ReadWriteLock lock = new ReentrantReadWriteLock(false);
    private boolean invalid;

    private ClassIndexManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T writeLock(ExceptionAction<T> exceptionAction) throws IOException {
        this.lock.writeLock().lock();
        try {
            T t = exceptionAction.run();
            return t;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T readLock(ExceptionAction<T> exceptionAction) throws IOException {
        this.lock.readLock().lock();
        try {
            T t = exceptionAction.run();
            return t;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public synchronized ClassIndexImpl getUsagesQuery(URL uRL) throws IOException {
        assert (uRL != null);
        if (this.invalid) {
            return null;
        }
        return this.instances.get(uRL);
    }

    public synchronized ClassIndexImpl createUsagesQuery(URL uRL, boolean bl) throws IOException {
        assert (uRL != null);
        if (this.invalid) {
            return null;
        }
        ClassIndexImpl classIndexImpl = this.instances.get(uRL);
        if (classIndexImpl == null) {
            classIndexImpl = PersistentClassIndex.create(uRL, Index.getDataFolder(uRL), bl);
            this.instances.put(uRL, classIndexImpl);
        }
        return classIndexImpl;
    }

    synchronized void removeRoot(URL uRL) throws IOException {
        ClassIndexImpl classIndexImpl = this.instances.remove(uRL);
        if (classIndexImpl != null) {
            classIndexImpl.close();
        }
    }

    public synchronized void close() {
        this.invalid = true;
        for (ClassIndexImpl classIndexImpl : this.instances.values()) {
            try {
                classIndexImpl.close();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    public static synchronized ClassIndexManager getDefault() {
        if (instance == null) {
            instance = new ClassIndexManager();
        }
        return instance;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ExceptionAction<T> {
        public T run() throws IOException;
    }
}

