/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.usages;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.modules.java.source.usages.ClassIndexImpl;
import org.netbeans.modules.java.source.usages.ResultConvertor;
import org.openide.ErrorManager;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Index {
    private static final int VERSION = 0;
    private static final int SUBVERSION = 1;
    private static final String NB_USER_DIR = "netbeans.user";
    private static final String SEGMENTS_FILE = "segments";
    private static final String CLASSES = "classes";
    private static final String SLICE_PREFIX = "s";
    private static final String INDEX_DIR = "var" + File.separatorChar + "cache" + File.separatorChar + "index" + File.separatorChar + 0 + '.' + 1;
    private static Properties segments;
    private static Map<String, String> invertedSegments;
    private static File cacheFolder;
    private static File segmentsFile;
    private static int index;

    public abstract boolean isValid(boolean var1) throws IOException;

    public abstract List<String> getUsagesData(String var1, Set<ClassIndexImpl.UsageType> var2, BooleanOperator var3) throws IOException;

    public abstract List<String> getUsagesFQN(String var1, Set<ClassIndexImpl.UsageType> var2, BooleanOperator var3) throws IOException;

    public abstract List<String> getReferencesData(String var1) throws IOException;

    public abstract <T> void getDeclaredTypes(String var1, ClassIndex.NameKind var2, ResultConvertor<T> var3, Set<? super T> var4) throws IOException;

    public abstract void getPackageNames(String var1, boolean var2, Set<String> var3) throws IOException;

    public abstract void store(Map<String, List<String>> var1, Set<String> var2) throws IOException;

    public abstract void store(Map<String, List<String>> var1, List<String> var2) throws IOException;

    public abstract boolean isUpToDate(String var1, long var2) throws IOException;

    public abstract void clear() throws IOException;

    public abstract void close() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadSegments() throws IOException {
        if (segments == null) {
            File file = Index.getCacheFolder();
            assert (file != null);
            segments = new Properties();
            invertedSegments = new HashMap<String, String>();
            segmentsFile = FileUtil.normalizeFile((File)new File(file, SEGMENTS_FILE));
            if (segmentsFile.exists()) {
                FileInputStream fileInputStream = new FileInputStream(segmentsFile);
                try {
                    segments.load(fileInputStream);
                }
                finally {
                    ((InputStream)fileInputStream).close();
                }
            }
            for (Map.Entry entry : segments.entrySet()) {
                String string = (String)entry.getKey();
                String string2 = (String)entry.getValue();
                invertedSegments.put(string2, string);
                try {
                    index = Math.max(index, Integer.parseInt(string.substring(SLICE_PREFIX.length())));
                }
                catch (NumberFormatException numberFormatException) {
                    ErrorManager.getDefault().notify((Throwable)numberFormatException);
                }
            }
            assert (segmentsFile != null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void storeSegments() throws IOException {
        assert (segmentsFile != null);
        FileOutputStream fileOutputStream = new FileOutputStream(segmentsFile);
        try {
            segments.store(fileOutputStream, null);
        }
        finally {
            ((OutputStream)fileOutputStream).close();
        }
    }

    public static URL getSourceRootForClassFolder(URL uRL) {
        if ("file".equals(uRL.getProtocol())) {
            try {
                File file = FileUtil.normalizeFile((File)new File(uRL.toURI()));
                File file2 = file.getParentFile();
                if (file2 == null) {
                    return null;
                }
                File file3 = file2.getParentFile();
                if (file3 == null || !((Object)file3).equals(cacheFolder)) {
                    return null;
                }
                String string = segments.getProperty(file2.getName());
                if (string != null) {
                    try {
                        return new URL(string);
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify((Throwable)iOException);
                    }
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                ErrorManager.getDefault().notify((Throwable)uRISyntaxException);
            }
        }
        return null;
    }

    public static synchronized File getDataFolder(URL uRL) throws IOException {
        File file;
        Index.loadSegments();
        String string = uRL.toExternalForm();
        String string2 = invertedSegments.get(string);
        if (string2 == null) {
            string2 = SLICE_PREFIX + ++index;
            while (segments.getProperty(string2) != null) {
                string2 = SLICE_PREFIX + ++index;
            }
            segments.put(string2, string);
            invertedSegments.put(string, string2);
            Index.storeSegments();
        }
        if (!(file = FileUtil.normalizeFile((File)new File(cacheFolder, string2))).exists()) {
            file.mkdir();
        }
        return file;
    }

    public static File getClassFolder(URL uRL) throws IOException {
        return Index.getClassFolderImpl(uRL);
    }

    public static File getClassFolder(File file) throws IOException {
        try {
            return Index.getClassFolderImpl(file.toURI().toURL());
        }
        catch (MalformedURLException malformedURLException) {
            ErrorManager.getDefault().notify((Throwable)malformedURLException);
            return null;
        }
    }

    private static File getClassFolderImpl(URL uRL) throws IOException {
        File file = Index.getDataFolder(uRL);
        File file2 = new File(file, CLASSES);
        if (!file2.exists()) {
            file2.mkdir();
        }
        return file2;
    }

    static File getNbUserDir() {
        String string = System.getProperty(NB_USER_DIR);
        assert (string != null);
        return new File(string);
    }

    private static synchronized File getCacheFolder() {
        if (cacheFolder == null) {
            File file = Index.getNbUserDir();
            cacheFolder = FileUtil.normalizeFile((File)new File(file, INDEX_DIR));
            if (!cacheFolder.exists()) {
                boolean bl = cacheFolder.mkdirs();
                assert (bl) : "Cannot create cache folder";
            } else assert (cacheFolder.isDirectory() && cacheFolder.canRead() && cacheFolder.canWrite());
        }
        return cacheFolder;
    }

    static synchronized void setCacheFolder(File file) {
        assert (file != null && file.exists() && file.canRead() && file.canWrite());
        cacheFolder = file;
    }

    static {
        index = 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BooleanOperator {
        AND,
        OR;

    }
}

