/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.usages;

import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.java.source.ElementHandleAccessor;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ResultConvertor<T> {
    public abstract T convert(ElementKind var1, String var2);

    public static ResultConvertor<FileObject> fileObjectConvertor(FileObject ... fileObjectArray) {
        assert (fileObjectArray != null);
        return new FileObjectConvertor(fileObjectArray);
    }

    public static ResultConvertor<ElementHandle<TypeElement>> elementHandleConvertor() {
        return new ElementHandleConvertor();
    }

    public static ResultConvertor<String> identityConvertor() {
        return new IdentityConvertor();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ElementHandleConvertor
    extends ResultConvertor<ElementHandle<TypeElement>> {
        private ElementHandleConvertor() {
        }

        @Override
        public ElementHandle<TypeElement> convert(ElementKind elementKind, String string) {
            return ElementHandleConvertor.createTypeHandle(elementKind, string);
        }

        private static ElementHandle<TypeElement> createTypeHandle(ElementKind elementKind, String string) {
            assert (string != null);
            return ElementHandleAccessor.INSTANCE.create(elementKind, string);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FileObjectConvertor
    extends ResultConvertor<FileObject> {
        private FileObject[] roots;

        private FileObjectConvertor(FileObject ... fileObjectArray) {
            this.roots = fileObjectArray;
        }

        @Override
        public FileObject convert(ElementKind elementKind, String string) {
            for (int i = 0; i < this.roots.length; ++i) {
                FileObject fileObject = FileObjectConvertor.resolveFile(this.roots[i], string);
                if (fileObject == null) continue;
                return fileObject;
            }
            return null;
        }

        private static FileObject resolveFile(FileObject fileObject, String string) {
            String string2;
            FileObject fileObject2;
            assert (string != null);
            int n = (string = string.replace('.', '/')).lastIndexOf(47);
            if (n < 0) {
                fileObject2 = fileObject;
                string2 = string;
            } else {
                assert (n > 0) : string;
                assert (n < string.length() - 1) : string;
                fileObject2 = fileObject.getFileObject(string.substring(0, n));
                string2 = string.substring(n + 1);
            }
            if (fileObject2 == null) {
                return null;
            }
            n = string2.indexOf(36);
            if (n > 0) {
                string2 = string2.substring(0, n);
            }
            for (FileObject fileObject3 : fileObject2.getChildren()) {
                if (!"java".equalsIgnoreCase(fileObject3.getExt()) || !string2.equals(fileObject3.getName())) continue;
                return fileObject3;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IdentityConvertor
    extends ResultConvertor<String> {
        private IdentityConvertor() {
        }

        @Override
        public String convert(ElementKind elementKind, String string) {
            return string;
        }
    }
}

