/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.java;

import org.netbeans.editor.ImageTokenID;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.ext.ExtFormatSupport;
import org.netbeans.editor.ext.FormatTokenPosition;
import org.netbeans.editor.ext.FormatWriter;
import org.netbeans.editor.ext.java.JavaSettingsDefaults;
import org.netbeans.editor.ext.java.JavaTokenContext;

public class JavaFormatSupport
extends ExtFormatSupport {
    private TokenContextPath tokenContextPath;

    public JavaFormatSupport(FormatWriter formatWriter) {
        this(formatWriter, JavaTokenContext.contextPath);
    }

    public JavaFormatSupport(FormatWriter formatWriter, TokenContextPath tokenContextPath) {
        super(formatWriter);
        this.tokenContextPath = tokenContextPath;
    }

    public TokenContextPath getTokenContextPath() {
        return this.tokenContextPath;
    }

    public boolean isComment(TokenItem tokenItem, int n) {
        TokenID tokenID = tokenItem.getTokenID();
        return tokenItem.getTokenContextPath() == this.tokenContextPath && (tokenID == JavaTokenContext.LINE_COMMENT || tokenID == JavaTokenContext.BLOCK_COMMENT);
    }

    public boolean isMultiLineComment(TokenItem tokenItem) {
        return tokenItem.getTokenID() == JavaTokenContext.BLOCK_COMMENT;
    }

    public boolean isMultiLineComment(FormatTokenPosition formatTokenPosition) {
        TokenItem tokenItem = formatTokenPosition.getToken();
        return tokenItem == null ? false : this.isMultiLineComment(tokenItem);
    }

    public boolean isJavaDocComment(TokenItem tokenItem) {
        return this.isMultiLineComment(tokenItem) && tokenItem.getImage().startsWith("/**");
    }

    public TokenID getWhitespaceTokenID() {
        return JavaTokenContext.WHITESPACE;
    }

    public TokenContextPath getWhitespaceTokenContextPath() {
        return this.tokenContextPath;
    }

    public boolean canModifyWhitespace(TokenItem tokenItem) {
        if (tokenItem.getTokenContextPath() == JavaTokenContext.contextPath) {
            switch (tokenItem.getTokenID().getNumericID()) {
                case 5: 
                case 8: {
                    return true;
                }
            }
        }
        return false;
    }

    public TokenItem findStatement(TokenItem tokenItem) {
        TokenItem tokenItem2 = null;
        for (TokenItem tokenItem3 = this.getPreviousToken(tokenItem); tokenItem3 != null; tokenItem3 = tokenItem3.getPrevious()) {
            if (tokenItem3.getTokenContextPath() != this.tokenContextPath) continue;
            switch (tokenItem3.getTokenID().getNumericID()) {
                case 51: {
                    if (this.isForLoopSemicolon(tokenItem3)) break;
                    return tokenItem2 != null ? tokenItem2 : tokenItem3;
                }
                case 57: 
                case 82: {
                    return tokenItem2 != null ? tokenItem2 : tokenItem3;
                }
                case 58: {
                    if (!this.isArrayInitializationBraceBlock(tokenItem3, null)) {
                        return tokenItem2 != null ? tokenItem2 : tokenItem3;
                    }
                    tokenItem3 = this.findMatchingToken(tokenItem3, null, (ImageTokenID)JavaTokenContext.LBRACE, true);
                    break;
                }
                case 50: {
                    TokenItem tokenItem4 = this.findAnyToken(tokenItem3, null, new TokenID[]{JavaTokenContext.CASE, JavaTokenContext.DEFAULT, JavaTokenContext.FOR, JavaTokenContext.QUESTION, JavaTokenContext.ASSERT}, tokenItem3.getTokenContextPath(), true);
                    if (tokenItem4 == null) break;
                    switch (tokenItem4.getTokenID().getNumericID()) {
                        case 75: 
                        case 80: 
                        case 88: {
                            return tokenItem2 != null ? tokenItem2 : tokenItem3;
                        }
                    }
                    break;
                }
                case 75: 
                case 80: 
                case 81: 
                case 106: {
                    return tokenItem3;
                }
                case 88: 
                case 90: 
                case 115: {
                    TokenItem tokenItem5;
                    if (tokenItem2 != null && tokenItem2.getTokenID() == JavaTokenContext.LPAREN && (tokenItem5 = this.findMatchingToken(tokenItem2, tokenItem, (ImageTokenID)JavaTokenContext.RPAREN, false)) != null && tokenItem5.getNext() != null && (tokenItem5 = this.findImportantToken(tokenItem5.getNext(), tokenItem, false)) != null) {
                        return tokenItem5;
                    }
                    return tokenItem3;
                }
            }
            if (!this.isImportant(tokenItem3, 0)) continue;
            tokenItem2 = tokenItem3;
        }
        return tokenItem2;
    }

    public TokenItem findIf(TokenItem tokenItem) {
        if (tokenItem == null || !this.tokenEquals(tokenItem, (TokenID)JavaTokenContext.ELSE, this.tokenContextPath)) {
            throw new IllegalArgumentException("Only accept 'else'.");
        }
        int n = 0;
        int n2 = 0;
        block7: while ((tokenItem = this.findStatement(tokenItem)) != null) {
            switch (tokenItem.getTokenID().getNumericID()) {
                case 57: {
                    if (--n >= 0) break;
                    return null;
                }
                case 58: {
                    ++n;
                    break;
                }
                case 82: {
                    if (n != 0) break;
                    ++n2;
                    break;
                }
                case 50: 
                case 51: 
                case 75: 
                case 80: 
                case 81: 
                case 88: 
                case 115: {
                    break;
                }
                case 90: {
                    if (n != 0 || n2-- != 0) continue block7;
                    return tokenItem;
                }
            }
        }
        return null;
    }

    public TokenItem findSwitch(TokenItem tokenItem) {
        if (tokenItem == null || !this.tokenEquals(tokenItem, (TokenID)JavaTokenContext.CASE, this.tokenContextPath) && !this.tokenEquals(tokenItem, (TokenID)JavaTokenContext.DEFAULT, this.tokenContextPath)) {
            throw new IllegalArgumentException("Only accept 'case' or 'default'.");
        }
        int n = 1;
        while ((tokenItem = this.findStatement(tokenItem)) != null) {
            switch (tokenItem.getTokenID().getNumericID()) {
                case 57: {
                    if (--n >= 0) break;
                    return null;
                }
                case 58: {
                    ++n;
                    break;
                }
                case 80: 
                case 106: {
                    if (n != 0) break;
                    return tokenItem;
                }
            }
        }
        return null;
    }

    public TokenItem findTry(TokenItem tokenItem) {
        if (tokenItem == null || !this.tokenEquals(tokenItem, (TokenID)JavaTokenContext.CATCH, this.tokenContextPath)) {
            throw new IllegalArgumentException("Only accept 'catch'.");
        }
        int n = 0;
        while ((tokenItem = this.findStatement(tokenItem)) != null) {
            switch (tokenItem.getTokenID().getNumericID()) {
                case 57: {
                    if (--n >= 0) break;
                    return null;
                }
                case 58: {
                    ++n;
                    break;
                }
                case 113: {
                    if (n != 0) break;
                    return tokenItem;
                }
            }
        }
        return null;
    }

    public TokenItem findStatementStart(TokenItem tokenItem) {
        return this.findStatementStart(tokenItem, true);
    }

    public TokenItem findStatementStart(TokenItem tokenItem, boolean bl) {
        TokenItem tokenItem2 = this.findStatement(tokenItem);
        if (tokenItem2 != null) {
            switch (tokenItem2.getTokenID().getNumericID()) {
                case 51: {
                    TokenItem tokenItem3 = this.findStatement(tokenItem2);
                    if (tokenItem3 == null) {
                        return tokenItem;
                    }
                    switch (tokenItem3.getTokenID().getNumericID()) {
                        case 50: 
                        case 51: 
                        case 57: 
                        case 58: 
                        case 75: 
                        case 80: {
                            return tokenItem2;
                        }
                        case 81: 
                        case 88: 
                        case 90: 
                        case 107: 
                        case 115: {
                            return this.findStatementStart(tokenItem2, bl);
                        }
                        case 82: {
                            TokenItem tokenItem4 = this.findIf(tokenItem3);
                            if (tokenItem4 != null) {
                                return this.findStatementStart(tokenItem4, bl);
                            }
                            return tokenItem3;
                        }
                    }
                    TokenItem tokenItem5 = this.findStatement(tokenItem3);
                    if (tokenItem5 != null) {
                        switch (tokenItem5.getTokenID().getNumericID()) {
                            case 50: 
                            case 51: 
                            case 57: 
                            case 58: {
                                return tokenItem3;
                            }
                            case 81: 
                            case 88: 
                            case 90: 
                            case 107: 
                            case 115: {
                                return this.findStatementStart(tokenItem5, bl);
                            }
                            case 82: {
                                TokenItem tokenItem6 = this.findIf(tokenItem5);
                                if (tokenItem6 != null) {
                                    return this.findStatementStart(tokenItem6, bl);
                                }
                                return tokenItem5;
                            }
                        }
                    }
                    return tokenItem3;
                }
                case 57: {
                    return tokenItem;
                }
                case 58: {
                    TokenItem tokenItem7;
                    TokenItem tokenItem8 = this.findMatchingToken(tokenItem2, null, (ImageTokenID)JavaTokenContext.LBRACE, true);
                    if (tokenItem8 != null && (tokenItem7 = this.findStatement(tokenItem8)) != null) {
                        switch (tokenItem7.getTokenID().getNumericID()) {
                            case 82: {
                                TokenItem tokenItem9 = this.findIf(tokenItem7);
                                if (tokenItem9 != null) {
                                    return this.findStatementStart(tokenItem9, bl);
                                }
                                return tokenItem7;
                            }
                            case 76: {
                                TokenItem tokenItem10 = this.findTry(tokenItem7);
                                if (tokenItem10 != null) {
                                    return this.findStatementStart(tokenItem10, bl);
                                }
                                return tokenItem7;
                            }
                            case 81: 
                            case 88: 
                            case 90: 
                            case 107: 
                            case 115: {
                                return this.findStatementStart(tokenItem7, bl);
                            }
                        }
                        if (tokenItem7.getTokenID().getNumericID() == 57) {
                            return tokenItem2;
                        }
                        return tokenItem7;
                    }
                    return tokenItem2;
                }
                case 50: 
                case 75: 
                case 80: {
                    return tokenItem;
                }
                case 82: {
                    TokenItem tokenItem11 = this.findIf(tokenItem2);
                    return tokenItem11 != null ? this.findStatementStart(tokenItem11, bl) : tokenItem2;
                }
                case 81: 
                case 88: 
                case 90: 
                case 107: 
                case 115: {
                    if (!bl) {
                        return tokenItem2;
                    }
                    return this.findStatementStart(tokenItem2, bl);
                }
                case 6: {
                    return tokenItem2;
                }
            }
            return tokenItem2;
        }
        return tokenItem;
    }

    public int getTokenIndent(TokenItem tokenItem, boolean bl) {
        FormatTokenPosition formatTokenPosition = this.getPosition(tokenItem, 0);
        FormatTokenPosition formatTokenPosition2 = bl ? this.findLineFirstNonWhitespace(formatTokenPosition) : this.findLineFirstNonWhitespaceAndNonLeftBrace(formatTokenPosition);
        if (formatTokenPosition2 != null) {
            formatTokenPosition = formatTokenPosition2;
        }
        return this.getVisualColumnOffset(formatTokenPosition);
    }

    public int getTokenIndent(TokenItem tokenItem) {
        return this.getTokenIndent(tokenItem, false);
    }

    public int findIndent(TokenItem tokenItem) {
        TokenItem tokenItem2;
        TokenItem tokenItem3;
        TokenItem tokenItem4;
        TokenItem tokenItem5;
        int n = -1;
        if (tokenItem != null) {
            block0 : switch (tokenItem.getTokenID().getNumericID()) {
                case 82: {
                    tokenItem5 = this.findIf(tokenItem);
                    if (tokenItem5 == null) break;
                    n = this.getTokenIndent(tokenItem5);
                    break;
                }
                case 57: {
                    tokenItem4 = this.findStatement(tokenItem);
                    if (tokenItem4 == null) {
                        n = 0;
                        break;
                    }
                    switch (tokenItem4.getTokenID().getNumericID()) {
                        case 81: 
                        case 82: 
                        case 88: 
                        case 90: 
                        case 115: {
                            n = this.getTokenIndent(tokenItem4);
                            break block0;
                        }
                        case 57: {
                            n = this.getTokenIndent(tokenItem4) + this.getShiftWidth();
                            break block0;
                        }
                    }
                    tokenItem4 = this.findStatementStart(tokenItem);
                    if (tokenItem4 == null) {
                        n = 0;
                        break;
                    }
                    if (tokenItem4 == tokenItem) {
                        tokenItem4 = this.findStatement(tokenItem);
                        n = tokenItem4 != null ? (n = this.getTokenIndent(tokenItem4)) : 0;
                        break;
                    }
                    n = this.getTokenIndent(tokenItem4);
                    switch (tokenItem4.getTokenID().getNumericID()) {
                        case 57: {
                            n += this.getShiftWidth();
                        }
                    }
                    break;
                }
                case 58: {
                    tokenItem3 = this.findMatchingToken(tokenItem, null, (ImageTokenID)JavaTokenContext.LBRACE, true);
                    if (tokenItem3 != null) {
                        tokenItem2 = this.findStatement(tokenItem3);
                        boolean bl = false;
                        if (tokenItem2 == null) {
                            tokenItem2 = tokenItem3;
                        } else {
                            switch (tokenItem2.getTokenID().getNumericID()) {
                                case 51: 
                                case 57: 
                                case 58: {
                                    tokenItem2 = tokenItem3;
                                    bl = true;
                                }
                            }
                        }
                        n = this.getTokenIndent(tokenItem2, bl);
                        break;
                    }
                    n = this.getTokenIndent(tokenItem);
                    break;
                }
                case 75: 
                case 80: {
                    tokenItem2 = this.findSwitch(tokenItem);
                    if (tokenItem2 == null) break;
                    n = this.getTokenIndent(tokenItem2);
                }
            }
        }
        if (n < 0 && (tokenItem5 = this.findImportantToken(tokenItem, null, true)) != null) {
            if (tokenItem5.getTokenContextPath() != this.tokenContextPath) {
                return this.getTokenIndent(tokenItem5);
            }
            switch (tokenItem5.getTokenID().getNumericID()) {
                case 51: {
                    tokenItem4 = this.findStatementStart(tokenItem);
                    n = this.getTokenIndent(tokenItem4);
                    break;
                }
                case 57: {
                    tokenItem3 = this.findStatementStart(tokenItem5, false);
                    if (tokenItem3 == null) {
                        tokenItem3 = tokenItem5;
                    }
                    n = this.getTokenIndent(tokenItem3) + this.getShiftWidth();
                    break;
                }
                case 58: {
                    tokenItem2 = this.findStatementStart(tokenItem);
                    n = this.getTokenIndent(tokenItem2);
                    break;
                }
                case 50: {
                    TokenItem tokenItem6 = this.findAnyToken(tokenItem5, null, new TokenID[]{JavaTokenContext.CASE, JavaTokenContext.DEFAULT, JavaTokenContext.FOR, JavaTokenContext.QUESTION, JavaTokenContext.ASSERT}, tokenItem5.getTokenContextPath(), true);
                    if (tokenItem6 != null && tokenItem6.getTokenID().getNumericID() == 52) {
                        n = this.getTokenIndent(tokenItem6) + this.getShiftWidth();
                        break;
                    }
                    n = this.getTokenIndent(tokenItem5) + this.getShiftWidth();
                    break;
                }
                case 52: 
                case 81: 
                case 82: {
                    n = this.getTokenIndent(tokenItem5) + this.getShiftWidth();
                    break;
                }
                case 54: {
                    TokenItem tokenItem7 = this.findMatchingToken(tokenItem5, null, (ImageTokenID)JavaTokenContext.LPAREN, true);
                    if (tokenItem7 != null && (tokenItem7 = this.findImportantToken(tokenItem7, null, true)) != null && tokenItem7.getTokenContextPath() == this.tokenContextPath) {
                        switch (tokenItem7.getTokenID().getNumericID()) {
                            case 88: 
                            case 90: 
                            case 115: {
                                n = this.getTokenIndent(tokenItem7) + this.getShiftWidth();
                            }
                        }
                    }
                    if (n >= 0) break;
                    n = this.computeStatementIndent(tokenItem5);
                    break;
                }
                case 49: {
                    if (this.isEnumComma(tokenItem5)) {
                        n = this.getTokenIndent(tokenItem5);
                        break;
                    }
                }
                default: {
                    n = this.computeStatementIndent(tokenItem5);
                }
            }
            if (n < 0) {
                n = this.getTokenIndent(tokenItem5);
            }
        }
        if (n < 0) {
            n = 0;
        }
        return n;
    }

    private int computeStatementIndent(TokenItem tokenItem) {
        TokenItem tokenItem2 = this.findStatementStart(tokenItem);
        int n = this.getTokenIndent(tokenItem2);
        int n2 = this.getTokenIndent(tokenItem);
        if (n2 > n) {
            return n2;
        }
        if (tokenItem2 != null) {
            TokenItem tokenItem3;
            FormatTokenPosition formatTokenPosition;
            if (tokenItem != null && this.tokenEquals(tokenItem, (TokenID)JavaTokenContext.COMMA, this.tokenContextPath) && this.isArrayInitializationBraceBlock(tokenItem, null) && !this.isInsideParens(tokenItem, tokenItem2)) {
                n -= this.getFormatStatementContinuationIndent();
            }
            if (tokenItem != null && (formatTokenPosition = this.findLineFirstNonWhitespace(this.getPosition(tokenItem, 0))) != null && (tokenItem3 = formatTokenPosition.getToken()) != null && tokenItem3.getTokenID() == JavaTokenContext.ANNOTATION) {
                n -= this.getFormatStatementContinuationIndent();
            }
            n += this.getFormatStatementContinuationIndent();
        }
        return n;
    }

    public FormatTokenPosition indentLine(FormatTokenPosition formatTokenPosition) {
        int n = 0;
        FormatTokenPosition formatTokenPosition2 = this.findLineFirstNonWhitespace(formatTokenPosition);
        if (formatTokenPosition2 != null) {
            if (this.isComment(formatTokenPosition2)) {
                if (this.isMultiLineComment(formatTokenPosition2) && formatTokenPosition2.getOffset() != 0) {
                    n = this.getLineIndent(this.getPosition(formatTokenPosition2.getToken(), 0), true) + 1;
                    if (!this.isIndentOnly()) {
                        if (this.getChar(formatTokenPosition2) != '*') {
                            if (this.isJavaDocComment(formatTokenPosition2.getToken())) {
                                if (this.getFormatLeadingStarInComment()) {
                                    this.insertString(formatTokenPosition2, "* ");
                                }
                            } else {
                                n = this.getLineIndent(formatTokenPosition, true);
                            }
                        } else if (this.isJavaDocComment(formatTokenPosition2.getToken()) && !this.getFormatLeadingStarInComment()) {
                            int n2 = -1;
                            if (formatTokenPosition2.getOffset() + 1 < formatTokenPosition2.getToken().getImage().length()) {
                                FormatTokenPosition formatTokenPosition3 = this.getPosition(formatTokenPosition2.getToken(), formatTokenPosition2.getOffset() + 1);
                                char c = this.getChar(formatTokenPosition3);
                                if (c != '/') {
                                    n2 = this.getChar(formatTokenPosition3) == ' ' ? 2 : 1;
                                }
                            } else {
                                n2 = 1;
                            }
                            if (n2 != -1) {
                                this.remove(formatTokenPosition2, n2);
                            }
                        }
                    } else if (this.getChar(formatTokenPosition2) != '*' && this.isJavaDocComment(formatTokenPosition2.getToken()) && this.getFormatLeadingStarInComment()) {
                        this.insertString(formatTokenPosition2, "* ");
                        this.setIndentShift(2);
                    }
                } else {
                    n = !this.isMultiLineComment(formatTokenPosition2) ? this.findIndent(formatTokenPosition2.getToken()) : (this.isJavaDocComment(formatTokenPosition2.getToken()) ? this.findIndent(formatTokenPosition2.getToken()) : (formatTokenPosition2.getToken().getImage().indexOf(10) == -1 ? this.findIndent(formatTokenPosition2.getToken()) : this.getLineIndent(formatTokenPosition2, true)));
                }
            } else {
                n = this.findIndent(formatTokenPosition2.getToken());
            }
        } else {
            TokenItem tokenItem = formatTokenPosition.getToken();
            if (tokenItem == null && (tokenItem = this.findLineStart(formatTokenPosition).getToken()) == null) {
                tokenItem = this.getLastToken();
            }
            if (tokenItem != null && this.isMultiLineComment(tokenItem)) {
                if (this.getFormatLeadingStarInComment() && (this.isIndentOnly() || this.isJavaDocComment(tokenItem))) {
                    this.insertString(formatTokenPosition, "* ");
                    this.setIndentShift(2);
                }
                n = this.getVisualColumnOffset(this.getPosition(tokenItem, 0)) + 1;
            } else {
                n = this.findIndent(formatTokenPosition.getToken());
            }
        }
        return this.changeLineIndent(formatTokenPosition, n);
    }

    public boolean isForLoopSemicolon(TokenItem tokenItem) {
        if (tokenItem == null || !this.tokenEquals(tokenItem, (TokenID)JavaTokenContext.SEMICOLON, this.tokenContextPath)) {
            throw new IllegalArgumentException("Only accept ';'.");
        }
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        for (tokenItem = tokenItem.getPrevious(); tokenItem != null; tokenItem = tokenItem.getPrevious()) {
            if (this.tokenEquals(tokenItem, (TokenID)JavaTokenContext.LPAREN, this.tokenContextPath)) {
                if (n == 0) {
                    FormatTokenPosition formatTokenPosition = this.getPosition(tokenItem, 0);
                    return (formatTokenPosition = this.findImportant(formatTokenPosition, null, false, true)) != null && this.tokenEquals(formatTokenPosition.getToken(), (TokenID)JavaTokenContext.FOR, this.tokenContextPath);
                }
                --n;
                continue;
            }
            if (this.tokenEquals(tokenItem, (TokenID)JavaTokenContext.RPAREN, this.tokenContextPath)) {
                ++n;
                continue;
            }
            if (this.tokenEquals(tokenItem, (TokenID)JavaTokenContext.LBRACE, this.tokenContextPath)) {
                if (n2 == 0) {
                    return false;
                }
                --n2;
                continue;
            }
            if (this.tokenEquals(tokenItem, (TokenID)JavaTokenContext.RBRACE, this.tokenContextPath)) {
                ++n2;
                continue;
            }
            if (!this.tokenEquals(tokenItem, (TokenID)JavaTokenContext.SEMICOLON, this.tokenContextPath)) continue;
            if (bl) {
                return false;
            }
            bl = true;
        }
        return false;
    }

    private boolean isInsideParens(TokenItem tokenItem, TokenItem tokenItem2) {
        int n = 0;
        for (tokenItem = tokenItem.getPrevious(); tokenItem != null && tokenItem != tokenItem2; tokenItem = tokenItem.getPrevious()) {
            if (this.tokenEquals(tokenItem, (TokenID)JavaTokenContext.LPAREN, this.tokenContextPath)) {
                if (--n >= 0) continue;
                return true;
            }
            if (!this.tokenEquals(tokenItem, (TokenID)JavaTokenContext.RPAREN, this.tokenContextPath)) continue;
            ++n;
        }
        return false;
    }

    private boolean isArrayInitializationBraceBlock(TokenItem tokenItem, TokenItem tokenItem2) {
        int n = 0;
        block5: for (tokenItem = tokenItem.getPrevious(); tokenItem != null && tokenItem != tokenItem2 && tokenItem.getTokenContextPath() == this.tokenContextPath; tokenItem = tokenItem.getPrevious()) {
            switch (tokenItem.getTokenID().getNumericID()) {
                case 58: {
                    ++n;
                    continue block5;
                }
                case 57: {
                    if (--n >= 0) continue block5;
                    TokenItem tokenItem3 = this.findImportantToken(tokenItem, tokenItem2, true);
                    return tokenItem3 != null && tokenItem3.getTokenContextPath() == this.tokenContextPath && (JavaTokenContext.RBRACKET.equals(tokenItem3.getTokenID()) || JavaTokenContext.EQ.equals(tokenItem3.getTokenID()));
                }
                case 51: 
                case 81: 
                case 88: 
                case 90: 
                case 115: {
                    if (n != 0) continue block5;
                    return false;
                }
            }
        }
        return false;
    }

    public boolean isEnumComma(TokenItem tokenItem) {
        TokenItem tokenItem2;
        TokenItem tokenItem3;
        while (tokenItem != null && this.tokenEquals(tokenItem, (TokenID)JavaTokenContext.COMMA, this.tokenContextPath) && (tokenItem3 = this.findStatementStart(tokenItem)) != tokenItem) {
            tokenItem = tokenItem3;
        }
        return tokenItem != null && this.tokenEquals(tokenItem, (TokenID)JavaTokenContext.IDENTIFIER, this.tokenContextPath) && (tokenItem3 = this.findImportantToken(tokenItem, null, true)) != null && this.tokenEquals(tokenItem3, (TokenID)JavaTokenContext.LBRACE, this.tokenContextPath) && (tokenItem2 = this.findStatementStart(tokenItem3)) != null && this.findToken(tokenItem2, tokenItem3, (TokenID)JavaTokenContext.ENUM, this.tokenContextPath, null, false) != null;
    }

    public boolean getFormatSpaceBeforeParenthesis() {
        return this.getSettingBoolean("java-format-space-before-parenthesis", JavaSettingsDefaults.defaultJavaFormatSpaceBeforeParenthesis);
    }

    public boolean getFormatSpaceAfterComma() {
        return this.getSettingBoolean("java-format-space-after-comma", JavaSettingsDefaults.defaultJavaFormatSpaceAfterComma);
    }

    public boolean getFormatNewlineBeforeBrace() {
        return this.getSettingBoolean("java-format-newline-before-brace", JavaSettingsDefaults.defaultJavaFormatNewlineBeforeBrace);
    }

    public boolean getFormatLeadingSpaceInComment() {
        return this.getSettingBoolean("java-format-leading-space-in-comment", JavaSettingsDefaults.defaultJavaFormatLeadingSpaceInComment);
    }

    public boolean getFormatLeadingStarInComment() {
        return this.getSettingBoolean("java-format-leading-star-in-comment", JavaSettingsDefaults.defaultJavaFormatLeadingStarInComment);
    }

    private int getFormatStatementContinuationIndent() {
        return this.getSettingInteger("java-format-statement-continuation-indent", JavaSettingsDefaults.defaultJavaFormatStatementContinuationIndent);
    }

    public FormatTokenPosition findLineFirstNonWhitespaceAndNonLeftBrace(FormatTokenPosition formatTokenPosition) {
        FormatTokenPosition formatTokenPosition2 = super.findLineFirstNonWhitespace(formatTokenPosition);
        if (formatTokenPosition2 == null) {
            return null;
        }
        if (!formatTokenPosition2.getToken().getImage().startsWith("{")) {
            return formatTokenPosition2;
        }
        FormatTokenPosition formatTokenPosition3 = this.findNextEOL(formatTokenPosition2);
        TokenItem tokenItem = this.findMatchingToken(formatTokenPosition2.getToken(), formatTokenPosition3 != null ? formatTokenPosition3.getToken() : null, (ImageTokenID)JavaTokenContext.RBRACE, false);
        if (tokenItem != null) {
            return formatTokenPosition2;
        }
        FormatTokenPosition formatTokenPosition4 = this.getNextPosition(formatTokenPosition2);
        if (formatTokenPosition4 == null) {
            return formatTokenPosition2;
        }
        FormatTokenPosition formatTokenPosition5 = this.findImportant(formatTokenPosition4, null, true, false);
        if (formatTokenPosition5 != null) {
            return formatTokenPosition5;
        }
        return formatTokenPosition2;
    }
}

