/*
 * Decompiled with CFR 0.152.
 */
package org.openidex.search;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.openide.ErrorManager;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openidex.search.SearchGroup;
import org.openidex.search.SearchInfo;
import org.openidex.search.SearchType;
import org.openidex.search.Utils;

public class DataObjectSearchGroup
extends SearchGroup {
    private static boolean lowMemoryWarning = false;
    private static int lowMemoryWarningCount = 0;
    private static int MB = 0x100000;
    private static int REQUIRED_PER_ITERATION = 2 * MB;
    private static int REQUIRED_PER_FULL_GC = 7 * MB;
    static /* synthetic */ Class class$org$openide$loaders$DataObject;

    protected void add(SearchType searchType) {
        boolean bl = false;
        Class[] classArray = searchType.getSearchTypeClasses();
        for (int i = 0; i < classArray.length; ++i) {
            if (classArray[i] != (class$org$openide$loaders$DataObject == null ? DataObjectSearchGroup.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject)) continue;
            bl = true;
            break;
        }
        if (bl) {
            super.add(searchType);
        }
    }

    public void doSearch() {
        Node[] nodeArray = DataObjectSearchGroup.normalizeNodes(this.searchRoots.toArray(new Node[this.searchRoots.size()]));
        lowMemoryWarning = false;
        lowMemoryWarningCount = 0;
        DataObjectSearchGroup.assureMemory(REQUIRED_PER_ITERATION, true);
        for (int i = 0; i < nodeArray.length; ++i) {
            Node node = nodeArray[i];
            SearchInfo searchInfo = Utils.getSearchInfo(node);
            if (searchInfo == null) continue;
            Iterator iterator = searchInfo.objectsToSearch();
            while (iterator.hasNext()) {
                if (this.stopped) {
                    return;
                }
                DataObjectSearchGroup.assureMemory(REQUIRED_PER_ITERATION, false);
                this.processSearchObject(iterator.next());
            }
        }
    }

    private static void assureMemory(int n, boolean bl) {
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.totalMemory();
        long l2 = runtime.maxMemory();
        long l3 = Math.max(l / 13L, (long)(n + REQUIRED_PER_FULL_GC));
        if (l == l2 && runtime.freeMemory() < l3) {
            if (bl) {
                try {
                    byte[] byArray = new byte[(int)l3];
                    byArray[0] = 75;
                    byArray = null;
                    return;
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    DataObjectSearchGroup.throwNoMemory();
                }
            } else {
                lowMemoryWarning = true;
            }
        } else if (lowMemoryWarning) {
            lowMemoryWarning = false;
            ++lowMemoryWarningCount;
        }
        if (lowMemoryWarningCount > 7 || l == l2 && runtime.freeMemory() < (long)REQUIRED_PER_FULL_GC) {
            DataObjectSearchGroup.throwNoMemory();
        }
    }

    private static void throwNoMemory() {
        RuntimeException runtimeException = new RuntimeException("Low memory condition");
        String string = NbBundle.getMessage((Class)DataObjectSearchGroup.class, (String)"EX_memory");
        ErrorManager.getDefault().annotate((Throwable)runtimeException, 256, null, string, null, null);
        throw runtimeException;
    }

    public Node getNodeForFoundObject(Object object) {
        if (!(object instanceof DataObject)) {
            return null;
        }
        return ((DataObject)object).getNodeDelegate();
    }

    private static Node[] normalizeNodes(Node[] nodeArray) {
        int n;
        if (nodeArray.length < 2) {
            return nodeArray;
        }
        HashMap<Object, Boolean> hashMap = new HashMap<Object, Boolean>(2 * nodeArray.length, 0.75f);
        HashMap hashMap2 = new HashMap(2 * nodeArray.length, 0.75f);
        ArrayList<Object> arrayList = new ArrayList<Object>(10);
        ArrayList<Node> arrayList2 = new ArrayList<Node>(nodeArray.length);
        for (n = 0; n < nodeArray.length; ++n) {
            hashMap.put(nodeArray[n], Boolean.FALSE);
        }
        for (n = 0; n < nodeArray.length; ++n) {
            Object object;
            arrayList.clear();
            boolean bl = false;
            for (object = nodeArray[n].getParentNode(); object != null; object = object.getParentNode()) {
                if (hashMap.containsKey(object)) {
                    bl = true;
                    break;
                }
                if (hashMap2.containsKey(object)) break;
                arrayList.add(object);
            }
            if (bl) {
                hashMap.put(nodeArray[n], Boolean.TRUE);
                object = arrayList.iterator();
                while (object.hasNext()) {
                    hashMap.put(object.next(), Boolean.TRUE);
                }
                continue;
            }
            object = arrayList.iterator();
            while (object.hasNext()) {
                hashMap2.put(object.next(), Boolean.TRUE);
            }
            arrayList2.add(nodeArray[n]);
        }
        return arrayList2.toArray(new Node[arrayList2.size()]);
    }
}

