/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.netbeans.modules.form.ComponentContainer;
import org.netbeans.modules.form.FormDesigner;
import org.netbeans.modules.form.FormLoaderSettings;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.HandleLayer;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADVisualComponent;
import org.netbeans.modules.form.RADVisualContainer;
import org.netbeans.modules.form.layoutsupport.LayoutConstraints;
import org.netbeans.modules.form.layoutsupport.LayoutSupportManager;
import org.openide.ErrorManager;

class ComponentDragger {
    private FormDesigner formDesigner;
    private HandleLayer handleLayer;
    private RADVisualComponent[] selectedComponents;
    private Rectangle[] originalBounds;
    private Point hotspot;
    private Point mousePosition;
    private int resizeType;
    private RADVisualContainer targetMetaContainer;
    private Container targetContainer;
    private Container targetContainerDel;
    static Stroke dashedStroke1 = new BasicStroke(2.0f, 2, 0, 10.0f, new float[]{1.0f, 4.0f}, 0.0f);
    static Stroke dashedStroke2 = new BasicStroke(2.0f, 2, 0, 10.0f, new float[]{2.0f, 8.0f}, 0.0f);

    ComponentDragger(FormDesigner formDesigner, HandleLayer handleLayer, RADVisualComponent[] rADVisualComponentArray, Rectangle[] rectangleArray, Point point, RADVisualContainer rADVisualContainer) {
        this.formDesigner = formDesigner;
        this.handleLayer = handleLayer;
        this.selectedComponents = rADVisualComponentArray;
        this.originalBounds = rectangleArray;
        this.hotspot = point;
        this.mousePosition = point;
        this.resizeType = 0;
        if (rADVisualContainer != null) {
            this.targetMetaContainer = rADVisualContainer;
        }
    }

    ComponentDragger(FormDesigner formDesigner, HandleLayer handleLayer, RADVisualComponent[] rADVisualComponentArray, Rectangle[] rectangleArray, Point point, int n) {
        this.formDesigner = formDesigner;
        this.handleLayer = handleLayer;
        this.selectedComponents = rADVisualComponentArray;
        this.originalBounds = rectangleArray;
        this.hotspot = point;
        this.mousePosition = point;
        this.resizeType = n;
    }

    void drag(Point point, RADVisualContainer rADVisualContainer) {
        this.targetMetaContainer = rADVisualContainer;
        this.mousePosition = point;
    }

    void paintDragFeedback(Graphics2D graphics2D) {
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setStroke(dashedStroke1);
        Color color = graphics2D.getColor();
        graphics2D.setColor(FormLoaderSettings.getInstance().getSelectionBorderColor());
        ArrayList arrayList = new ArrayList(this.selectedComponents.length);
        ArrayList arrayList2 = new ArrayList(this.selectedComponents.length);
        boolean bl = this.computeConstraints(this.mousePosition, arrayList, arrayList2);
        Point point = null;
        LayoutSupportManager layoutSupportManager = null;
        if (bl) {
            point = SwingUtilities.convertPoint(this.targetContainerDel, 0, 0, this.handleLayer);
            layoutSupportManager = this.targetMetaContainer.getLayoutSupport();
            if (this.resizeType == 0) {
                this.paintTargetContainerFeedback(graphics2D, this.targetContainerDel);
            }
        }
        for (int i = 0; i < this.selectedComponents.length; ++i) {
            RADVisualComponent rADVisualComponent = this.selectedComponents[i];
            boolean bl2 = false;
            if (bl) {
                Component component = (Component)this.formDesigner.getComponent(rADVisualComponent);
                LayoutConstraints layoutConstraints = (LayoutConstraints)arrayList.get(i);
                int n = (Integer)arrayList2.get(i);
                if (layoutConstraints != null || n >= 0) {
                    graphics2D.translate(point.x, point.y);
                    bl2 = layoutSupportManager.paintDragFeedback(this.targetContainer, this.targetContainerDel, component, layoutConstraints, n, graphics2D);
                    graphics2D.translate(-point.x, -point.y);
                }
            }
            if (bl2) continue;
            this.paintDragFeedback(graphics2D, rADVisualComponent);
        }
        graphics2D.setColor(color);
        graphics2D.setStroke(stroke);
    }

    void dropComponents(Point point, RADVisualContainer rADVisualContainer) {
        RADVisualComponent[] rADVisualComponentArray;
        RADVisualComponent[] rADVisualComponentArray2;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        LayoutConstraints[] layoutConstraintsArray;
        RADVisualComponent[] rADVisualComponentArray3;
        int n6;
        ArrayList<LayoutConstraints> arrayList = null;
        ArrayList arrayList2 = null;
        this.targetMetaContainer = rADVisualContainer;
        if (this.targetMetaContainer != null) {
            arrayList = new ArrayList<LayoutConstraints>(this.selectedComponents.length);
            arrayList2 = new ArrayList(this.selectedComponents.length);
            this.computeConstraints(point, arrayList, arrayList2);
        }
        if (this.targetMetaContainer == null) {
            arrayList2 = null;
            arrayList = null;
        }
        FormModel formModel = this.formDesigner.getFormModel();
        LayoutSupportManager layoutSupportManager = null;
        RADVisualComponent[] rADVisualComponentArray4 = null;
        LayoutConstraints[] layoutConstraintsArray2 = null;
        ArrayList<Integer> arrayList3 = null;
        ArrayList<RADVisualComponent> arrayList4 = null;
        if (this.targetMetaContainer != null) {
            layoutSupportManager = this.targetMetaContainer.getLayoutSupport();
            rADVisualComponentArray4 = this.targetMetaContainer.getSubComponents();
            layoutConstraintsArray2 = new LayoutConstraints[rADVisualComponentArray4.length];
            this.adjustIndices(arrayList2);
            for (n6 = 0; n6 < this.selectedComponents.length; ++n6) {
                if (this.selectedComponents[n6].getParentContainer() != this.targetMetaContainer) {
                    if (arrayList3 == null) {
                        arrayList3 = new ArrayList<Integer>(this.selectedComponents.length);
                    }
                    arrayList3.add(new Integer(n6));
                    continue;
                }
                if (arrayList4 == null) {
                    arrayList4 = new ArrayList<RADVisualComponent>(this.selectedComponents.length);
                }
                arrayList4.add(this.selectedComponents[n6]);
            }
            if (arrayList3 != null && arrayList3.size() > 0) {
                n6 = arrayList3.size();
                rADVisualComponentArray3 = new RADVisualComponent[n6];
                layoutConstraintsArray = new LayoutConstraints[n6];
                for (n5 = 0; n5 < n6; ++n5) {
                    n4 = (Integer)arrayList3.get(n5);
                    rADVisualComponentArray3[n5] = this.selectedComponents[n4];
                    layoutConstraintsArray[n5] = (LayoutConstraints)arrayList.get(n4);
                }
                n5 = (Integer)arrayList3.get(0);
                n4 = (Integer)arrayList2.get(n5);
                try {
                    layoutSupportManager.acceptNewComponents(rADVisualComponentArray3, layoutConstraintsArray, n4);
                }
                catch (RuntimeException runtimeException) {
                    ErrorManager.getDefault().notify(1, (Throwable)runtimeException);
                    return;
                }
                for (n3 = 0; n3 < n6; ++n3) {
                    n2 = (Integer)arrayList3.get(n3);
                    arrayList.set(n2, layoutConstraintsArray[n3]);
                }
                arrayList3.clear();
            }
        }
        n6 = this.selectedComponents.length + (rADVisualComponentArray4 != null ? rADVisualComponentArray4.length : 0);
        rADVisualComponentArray3 = new ArrayList(n6);
        layoutConstraintsArray = new ArrayList(n6);
        n5 = 0;
        for (n4 = 0; n4 < n6; ++n4) {
            rADVisualComponentArray3.add(null);
            layoutConstraintsArray.add(null);
        }
        if (this.targetMetaContainer != null) {
            for (n4 = 0; n4 < this.selectedComponents.length; ++n4) {
                n3 = (Integer)arrayList2.get(n4);
                if (n3 < 0 || n3 >= n6 || !this.checkTarget(this.selectedComponents[n4])) continue;
                while (rADVisualComponentArray3.get(n3) != null) {
                    if (++n3 != n6) continue;
                    n3 = 0;
                }
                rADVisualComponentArray3.set(n3, this.selectedComponents[n4]);
            }
            for (n4 = 0; n4 < rADVisualComponentArray4.length; ++n4) {
                RADVisualComponent rADVisualComponent = rADVisualComponentArray4[n4];
                layoutConstraintsArray2[n4] = layoutSupportManager.getConstraints(rADVisualComponent);
                n2 = rADVisualComponentArray3.indexOf(rADVisualComponent);
                if (n2 >= 0) continue;
                while (rADVisualComponentArray3.get(n5) != null) {
                    ++n5;
                }
                rADVisualComponentArray3.set(n5, rADVisualComponent);
                layoutConstraintsArray.set(n5, layoutConstraintsArray2[n4]);
            }
        }
        for (n4 = 0; n4 < this.selectedComponents.length; ++n4) {
            RADVisualComponent rADVisualComponent = this.selectedComponents[n4];
            n2 = rADVisualComponentArray3.indexOf(rADVisualComponent);
            if (n2 >= 0) {
                layoutConstraintsArray.set(n2, arrayList != null ? (Object)arrayList.get(n4) : null);
                continue;
            }
            if (!this.checkTarget(rADVisualComponent)) continue;
            while (rADVisualComponentArray3.get(n5) != null) {
                ++n5;
            }
            rADVisualComponentArray3.set(n5, rADVisualComponent);
            layoutConstraintsArray.set(n5, arrayList != null ? (Object)arrayList.get(n4) : null);
        }
        for (n4 = 0; n4 < n6; ++n4) {
            RADVisualComponent rADVisualComponent = (RADVisualComponent)rADVisualComponentArray3.get(n4);
            if (rADVisualComponent != null) {
                RADVisualContainer rADVisualContainer2 = rADVisualComponent.getParentContainer();
                if (rADVisualContainer2 == this.targetMetaContainer) continue;
                if (arrayList3 == null) {
                    arrayList3 = new ArrayList(this.selectedComponents.length);
                }
                arrayList3.add((Integer)((Object)rADVisualComponent));
                formModel.removeComponent(rADVisualComponent, false);
                continue;
            }
            rADVisualComponentArray3.remove(n4);
            layoutConstraintsArray.remove(n4);
            --n4;
            --n6;
        }
        if (n6 == 0) {
            return;
        }
        n4 = formModel.isUndoRedoRecording() ? 1 : 0;
        if (n4 != 0) {
            formModel.setUndoRedoRecording(false);
        }
        RADComponent[] rADComponentArray = new RADVisualComponent[n6];
        LayoutConstraints[] layoutConstraintsArray3 = new LayoutConstraints[n6];
        if (this.targetMetaContainer != null) {
            for (int i = 0; i < n6; ++i) {
                rADComponentArray[i] = (RADVisualComponent)rADVisualComponentArray3.get(i);
                layoutConstraintsArray3[i] = (LayoutConstraints)layoutConstraintsArray.get(i);
            }
            layoutSupportManager.removeAll();
            this.targetMetaContainer.initSubComponents(rADComponentArray);
            layoutSupportManager.addComponents((RADVisualComponent[])rADComponentArray, layoutConstraintsArray3, 0);
        } else {
            ComponentContainer componentContainer = formModel.getModelContainer();
            for (n = 0; n < n6; ++n) {
                rADComponentArray[n] = (RADVisualComponent)rADVisualComponentArray3.get(n);
                componentContainer.add(rADComponentArray[n]);
            }
        }
        if (arrayList3 != null) {
            n6 = arrayList3.size();
            rADVisualComponentArray2 = new RADVisualComponent[n6];
            for (n = 0; n < n6; ++n) {
                rADVisualComponentArray2[n] = (RADVisualComponent)arrayList3.get(n);
                formModel.fireComponentAdded(rADVisualComponentArray2[n], false);
            }
        } else {
            rADVisualComponentArray2 = new RADVisualComponent[]{};
            formModel.fireComponentsReordered(this.targetMetaContainer, new int[0]);
        }
        if (arrayList4 != null) {
            n6 = arrayList4.size();
            rADVisualComponentArray = new RADVisualComponent[n6];
            for (int i = 0; i < n6; ++i) {
                rADVisualComponentArray[i] = (RADVisualComponent)arrayList4.get(i);
                formModel.fireComponentLayoutChanged(rADVisualComponentArray[i], null, null, null);
            }
        } else {
            rADVisualComponentArray = new RADVisualComponent[]{};
        }
        if (n4 != 0) {
            DropUndoableEdit dropUndoableEdit = new DropUndoableEdit();
            dropUndoableEdit.formModel = formModel;
            dropUndoableEdit.targetContainer = this.targetMetaContainer;
            dropUndoableEdit.targetComponentsBeforeMove = rADVisualComponentArray4;
            dropUndoableEdit.targetConstraintsBeforeMove = layoutConstraintsArray2;
            dropUndoableEdit.targetComponentsAfterMove = rADComponentArray;
            dropUndoableEdit.targetConstraintsAfterMove = layoutConstraintsArray3;
            dropUndoableEdit.componentsMovedFromOutside = rADVisualComponentArray2;
            dropUndoableEdit.componentsMovedWithinTarget = rADVisualComponentArray;
            formModel.addUndoableEdit(dropUndoableEdit);
        }
        if (n4 != 0) {
            formModel.setUndoRedoRecording(true);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ComponentDragger.this.formDesigner.setSelectedComponents(ComponentDragger.this.selectedComponents);
            }
        });
    }

    private boolean computeConstraints(Point point, List list, List list2) {
        if (this.selectedComponents == null || this.selectedComponents.length == 0) {
            return false;
        }
        if (this.targetMetaContainer == null) {
            return false;
        }
        RADVisualContainer rADVisualContainer = null;
        block0: do {
            if (rADVisualContainer != null) {
                this.targetMetaContainer = rADVisualContainer;
                rADVisualContainer = null;
            }
            LayoutSupportManager layoutSupportManager = this.targetMetaContainer.getLayoutSupport();
            this.targetContainer = (Container)this.formDesigner.getComponent(this.targetMetaContainer);
            if (this.targetContainer == null) {
                return false;
            }
            this.targetContainerDel = this.targetMetaContainer.getContainerDelegate(this.targetContainer);
            if (this.targetContainerDel == null) {
                return false;
            }
            Point point2 = SwingUtilities.convertPoint(this.handleLayer, point, this.targetContainerDel);
            for (int i = 0; i < this.selectedComponents.length; ++i) {
                LayoutConstraints layoutConstraints = null;
                int n = -1;
                RADVisualComponent rADVisualComponent = this.selectedComponents[i];
                Component component = (Component)this.formDesigner.getComponent(rADVisualComponent);
                if (component != null) {
                    if (!this.checkTarget(rADVisualComponent)) {
                        rADVisualContainer = rADVisualComponent.getParentContainer();
                        list.clear();
                        list2.clear();
                        if (rADVisualContainer != null) continue block0;
                        return false;
                    }
                    if (this.resizeType == 0) {
                        Point point3 = new Point(this.hotspot.x - this.originalBounds[i].x, this.hotspot.y - this.originalBounds[i].y);
                        n = layoutSupportManager.getNewIndex(this.targetContainer, this.targetContainerDel, component, rADVisualComponent.getComponentIndex(), point2, point3);
                        layoutConstraints = layoutSupportManager.getNewConstraints(this.targetContainer, this.targetContainerDel, component, rADVisualComponent.getComponentIndex(), point2, point3);
                        if (layoutConstraints == null && n >= 0) {
                            LayoutSupportManager.storeConstraints(rADVisualComponent);
                            layoutConstraints = layoutSupportManager.getStoredConstraints(rADVisualComponent);
                        }
                    } else {
                        int n2 = 0;
                        int n3 = 0;
                        int n4 = 0;
                        int n5 = 0;
                        if ((this.resizeType & 2) != 0) {
                            n3 = point.y - this.hotspot.y;
                        } else if ((this.resizeType & 1) != 0) {
                            n2 = this.hotspot.y - point.y;
                        }
                        if ((this.resizeType & 8) != 0) {
                            n5 = point.x - this.hotspot.x;
                        } else if ((this.resizeType & 4) != 0) {
                            n4 = this.hotspot.x - point.x;
                        }
                        Insets insets = new Insets(n2, n4, n3, n5);
                        layoutConstraints = layoutSupportManager.getResizedConstraints(this.targetContainer, this.targetContainerDel, component, rADVisualComponent.getComponentIndex(), this.handleLayer.convertRectangleToComponent(new Rectangle(this.originalBounds[i]), this.targetContainerDel), insets, point2);
                    }
                }
                list.add(layoutConstraints);
                list2.add(new Integer(n));
            }
        } while (rADVisualContainer != null);
        return true;
    }

    private boolean checkTarget(RADVisualComponent rADVisualComponent) {
        if (!(rADVisualComponent instanceof RADVisualContainer)) {
            return true;
        }
        for (RADComponent rADComponent = this.targetMetaContainer; rADComponent != null; rADComponent = rADComponent.getParentComponent()) {
            if (rADComponent != rADVisualComponent) continue;
            return false;
        }
        return true;
    }

    private void adjustIndices(List list) {
        int n = -1;
        int n2 = 0;
        for (int i = 0; i < list.size(); ++i) {
            int n3;
            int n4 = (Integer)list.get(i);
            if (n4 < 0) continue;
            if (n4 == n) {
                n3 = n2;
            } else {
                n3 = 0;
                RADVisualComponent[] rADVisualComponentArray = this.targetMetaContainer.getSubComponents();
                for (int j = 0; j < n4; ++j) {
                    RADVisualComponent rADVisualComponent = rADVisualComponentArray[j];
                    boolean bl = false;
                    for (int k = 0; k < this.selectedComponents.length; ++k) {
                        if (rADVisualComponent != this.selectedComponents[k]) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) continue;
                    ++n3;
                }
                n = n4;
                n2 = n3;
            }
            if (n3 == 0) continue;
            list.set(i, new Integer(n4 -= n3));
        }
    }

    private void paintDragFeedback(Graphics2D graphics2D, RADVisualComponent rADVisualComponent) {
        Object object = this.formDesigner.getComponent(rADVisualComponent);
        if (!(object instanceof Component) || !((Component)object).isShowing()) {
            return;
        }
        Component component = (Component)object;
        Rectangle rectangle = component.getBounds();
        rectangle = SwingUtilities.convertRectangle(component.getParent(), rectangle, this.handleLayer);
        rectangle.translate(this.mousePosition.x - this.hotspot.x, this.mousePosition.y - this.hotspot.y);
        graphics2D.draw(new Rectangle2D.Double(rectangle.x, rectangle.y, rectangle.width, rectangle.height));
        if (rADVisualComponent instanceof RADVisualContainer) {
            RADVisualComponent[] rADVisualComponentArray = ((RADVisualContainer)rADVisualComponent).getSubComponents();
            for (int i = 0; i < rADVisualComponentArray.length; ++i) {
                this.paintDragFeedback(graphics2D, rADVisualComponentArray[i]);
            }
        }
    }

    private void paintTargetContainerFeedback(Graphics2D graphics2D, Container container) {
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setStroke(dashedStroke2);
        Color color = graphics2D.getColor();
        graphics2D.setColor(FormLoaderSettings.getInstance().getDragBorderColor());
        Rectangle rectangle = new Rectangle(new Point(0, 0), container.getSize());
        rectangle = SwingUtilities.convertRectangle(container, rectangle, this.handleLayer);
        graphics2D.draw(new Rectangle2D.Double(rectangle.x, rectangle.y, rectangle.width, rectangle.height));
        graphics2D.setColor(color);
        graphics2D.setStroke(stroke);
    }

    private static class DropUndoableEdit
    extends AbstractUndoableEdit {
        FormModel formModel;
        RADVisualContainer targetContainer;
        RADVisualComponent[] targetComponentsBeforeMove;
        LayoutConstraints[] targetConstraintsBeforeMove;
        RADVisualComponent[] targetComponentsAfterMove;
        LayoutConstraints[] targetConstraintsAfterMove;
        RADVisualComponent[] componentsMovedFromOutside;
        RADVisualComponent[] componentsMovedWithinTarget;

        private DropUndoableEdit() {
        }

        public void undo() throws CannotUndoException {
            super.undo();
            boolean bl = this.formModel.isUndoRedoRecording();
            if (bl) {
                this.formModel.setUndoRedoRecording(false);
            }
            for (int i = 0; i < this.componentsMovedFromOutside.length; ++i) {
                this.formModel.removeComponentImpl(this.componentsMovedFromOutside[i], false);
            }
            if (this.targetContainer != null) {
                LayoutSupportManager layoutSupportManager = this.targetContainer.getLayoutSupport();
                layoutSupportManager.removeAll();
                this.targetContainer.initSubComponents(this.targetComponentsBeforeMove);
                layoutSupportManager.addComponents(this.targetComponentsBeforeMove, this.targetConstraintsBeforeMove, 0);
                for (int i = 0; i < this.componentsMovedWithinTarget.length; ++i) {
                    this.formModel.fireComponentLayoutChanged(this.componentsMovedWithinTarget[i], null, null, null);
                }
            }
            if (bl) {
                this.formModel.setUndoRedoRecording(true);
            }
        }

        public void redo() throws CannotRedoException {
            int n;
            Object object;
            super.redo();
            boolean bl = this.formModel.isUndoRedoRecording();
            if (bl) {
                this.formModel.setUndoRedoRecording(false);
            }
            if (this.targetContainer != null) {
                object = this.targetContainer.getLayoutSupport();
                ((LayoutSupportManager)object).removeAll();
                this.targetContainer.initSubComponents(this.targetComponentsAfterMove);
                ((LayoutSupportManager)object).addComponents(this.targetComponentsAfterMove, this.targetConstraintsAfterMove, 0);
            } else {
                object = this.formModel.getModelContainer();
                for (int i = 0; i < this.targetComponentsAfterMove.length; ++i) {
                    object.add(this.targetComponentsAfterMove[i]);
                }
            }
            for (n = 0; n < this.componentsMovedFromOutside.length; ++n) {
                this.formModel.fireComponentAdded(this.componentsMovedFromOutside[n], false);
            }
            for (n = 0; n < this.componentsMovedWithinTarget.length; ++n) {
                this.formModel.fireComponentLayoutChanged(this.componentsMovedWithinTarget[n], null, null, null);
            }
            if (bl) {
                this.formModel.setUndoRedoRecording(true);
            }
        }

        public String getUndoPresentationName() {
            return "";
        }

        public String getRedoPresentationName() {
            return "";
        }
    }
}

