/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.form.FormProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CustomCodeData {
    private CodeCategory defaultCategory = CodeCategory.CREATE_AND_INIT;
    private List<EditableBlock> initEditableBlocks = new ArrayList<EditableBlock>();
    private List<GuardedBlock> initGuardedBlocks = new ArrayList<GuardedBlock>();
    private VariableDeclaration declaration;
    private List<EditableBlock> declarationEditableBlocks = new ArrayList<EditableBlock>();
    private List<GuardedBlock> declarationGuardedBlocks = new ArrayList<GuardedBlock>();
    private int highestPreference;

    CustomCodeData() {
    }

    int getEditableBlockCount(CodeCategory codeCategory) {
        return this.getEditableList(codeCategory).size();
    }

    EditableBlock getEditableBlock(CodeCategory codeCategory, int n) {
        return this.getEditableList(codeCategory).get(n);
    }

    int getGuardedBlockCount(CodeCategory codeCategory) {
        return this.getGuardedList(codeCategory).size();
    }

    GuardedBlock getGuardedBlock(CodeCategory codeCategory, int n) {
        return this.getGuardedList(codeCategory).get(n);
    }

    VariableDeclaration getDeclarationData() {
        return this.declaration;
    }

    void addEditableBlock(String string, FormProperty formProperty, int n, String string2, String string3) {
        this.addEditableBlock(null, string, formProperty, n, string2, string3, false, false);
    }

    void addEditableBlock(String string, FormProperty formProperty, int n, String string2, String string3, boolean bl, boolean bl2) {
        this.addEditableBlock(null, string, formProperty, n, string2, string3, bl, bl2);
    }

    void addEditableBlock(CodeCategory codeCategory, String string, FormProperty formProperty, int n, String string2, String string3, boolean bl, boolean bl2) {
        List<EditableBlock> list;
        if (codeCategory == null) {
            codeCategory = this.defaultCategory;
        }
        if ((list = this.getEditableList(codeCategory)).size() <= this.getGuardedList(codeCategory).size()) {
            this.highestPreference = 0;
            list.add(new EditableBlock());
        }
        EditableBlock editableBlock = list.get(list.size() - 1);
        editableBlock.addEntry(new CodeEntry(string, formProperty, string2, string3, bl, bl2), n > this.highestPreference);
        if (n > this.highestPreference) {
            this.highestPreference = n;
        }
    }

    void addGuardedBlock(String string) {
        this.addGuardedBlock(null, string, null, null, false, null, null, null);
    }

    void addGuardedBlock(String string, String string2, String string3, boolean bl, FormProperty formProperty, String string4, String string5) {
        this.addGuardedBlock(null, string, string2, string3, bl, formProperty, string4, string5);
    }

    void addGuardedBlock(CodeCategory codeCategory, String string, String string2, String string3, boolean bl, FormProperty formProperty, String string4, String string5) {
        if (codeCategory == null) {
            codeCategory = this.defaultCategory;
        }
        assert (this.getGuardedList(codeCategory).size() + 1 == this.getEditableList(codeCategory).size());
        CodeEntry codeEntry = null;
        int n = 0;
        int n2 = 0;
        if (string2 != null) {
            int n3 = string2.length();
            int n4 = string2.indexOf(string3);
            int n5 = string2.lastIndexOf(string3);
            if (n4 > 0 && n5 < n3 - 1) {
                int n6 = string3.length();
                String string6 = string2.substring(n4 + n6, n5);
                string2 = string2.substring(0, n4) + string6 + string2.substring(n5 + n6);
                n = n4;
                n2 = n3 - n6 - n5;
                codeEntry = new CodeEntry(bl ? string6 : null, formProperty, string4, string5, false, false);
            } else {
                string2 = null;
            }
        }
        GuardedBlock guardedBlock = new GuardedBlock(string, string2, n, n2, bl, codeEntry);
        this.getGuardedList(codeCategory).add(guardedBlock);
    }

    void setDefaultCategory(CodeCategory codeCategory) {
        this.defaultCategory = codeCategory;
    }

    void setDeclarationData(boolean bl, int n) {
        this.declaration = new VariableDeclaration(bl, n);
    }

    private List<EditableBlock> getEditableList(CodeCategory codeCategory) {
        switch (codeCategory) {
            case CREATE_AND_INIT: {
                return this.initEditableBlocks;
            }
            case DECLARATION: {
                return this.declarationEditableBlocks;
            }
        }
        return null;
    }

    private List<GuardedBlock> getGuardedList(CodeCategory codeCategory) {
        switch (codeCategory) {
            case CREATE_AND_INIT: {
                return this.initGuardedBlocks;
            }
            case DECLARATION: {
                return this.declarationGuardedBlocks;
            }
        }
        return null;
    }

    void check() {
        this.checkEditableGuardedPairs(this.initEditableBlocks, this.initGuardedBlocks);
        this.checkEditableGuardedPairs(this.declarationEditableBlocks, this.declarationGuardedBlocks);
    }

    private void checkEditableGuardedPairs(List<EditableBlock> list, List<GuardedBlock> list2) {
        assert (list.size() == 0 && list2.size() == 0 || list.size() == list2.size() + 1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum CodeCategory {
        CREATE_AND_INIT,
        DECLARATION;

    }

    static class CodeEntry {
        private String code;
        private FormProperty targetProperty;
        private String displayName;
        private String hint;
        private boolean pre;
        private boolean post;

        private CodeEntry(String string, FormProperty formProperty, String string2, String string3, boolean bl, boolean bl2) {
            assert (!bl && !bl2 || bl != bl2);
            this.code = string;
            this.targetProperty = formProperty;
            this.displayName = string2;
            this.hint = string3;
            this.pre = bl;
            this.post = bl2;
        }

        String getCode() {
            return this.code;
        }

        void setCode(String string) {
            this.code = string;
        }

        String getName() {
            return this.targetProperty.getName();
        }

        String getDisplayName() {
            return this.displayName;
        }

        String getToolTipText() {
            return this.hint;
        }

        FormProperty getTargetProperty() {
            return this.targetProperty;
        }

        boolean isPropertyPreInit() {
            return this.pre;
        }

        boolean isPropertyPostInit() {
            return this.post;
        }

        public String toString() {
            return this.displayName;
        }
    }

    static class EditableBlock {
        private List<CodeEntry> entries = new ArrayList<CodeEntry>();
        private int prefEntryIndex;

        EditableBlock() {
        }

        private void addEntry(CodeEntry codeEntry, boolean bl) {
            this.entries.add(codeEntry);
            if (bl) {
                this.prefEntryIndex = this.entries.size() - 1;
            }
        }

        int getPreferredEntryIndex() {
            return this.prefEntryIndex;
        }

        CodeEntry[] getEntries() {
            return this.entries.toArray(new CodeEntry[this.entries.size()]);
        }
    }

    static class GuardedBlock {
        private String defaultCode;
        private String customCode;
        private int headerLength;
        private int footerLength;
        private boolean customCodeSet;
        private CodeEntry customEntry;

        private GuardedBlock(String string, String string2, int n, int n2, boolean bl, CodeEntry codeEntry) {
            this.defaultCode = string;
            this.customCode = string2;
            this.headerLength = n;
            this.footerLength = n2;
            this.customCodeSet = bl;
            this.customEntry = codeEntry;
        }

        String getDefaultCode() {
            return this.defaultCode;
        }

        String getCustomCode() {
            return this.customCode;
        }

        void setCustomizedCode(String string) {
            this.customEntry.setCode(string);
            if (string != null) {
                this.customCode = this.customCode.substring(0, this.headerLength) + string + this.customCode.substring(this.customCode.length() - this.footerLength);
                this.customCodeSet = true;
            } else {
                this.customCodeSet = false;
            }
        }

        boolean isCustomizable() {
            return this.customCode != null;
        }

        boolean isCustomized() {
            return this.customCodeSet;
        }

        CodeEntry getCustomEntry() {
            return this.customEntry;
        }

        int getHeaderLength() {
            return this.headerLength;
        }

        int getFooterLength() {
            return this.footerLength;
        }
    }

    static class VariableDeclaration {
        boolean local;
        int modifiers;

        private VariableDeclaration(boolean bl, int n) {
            this.local = bl;
            this.modifiers = n;
        }
    }
}

