/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;
import org.netbeans.modules.form.ComponentContainer;
import org.netbeans.modules.form.Event;
import org.netbeans.modules.form.FormEvents;
import org.netbeans.modules.form.FormModelEvent;
import org.netbeans.modules.form.FormModelListener;
import org.netbeans.modules.form.FormSettings;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.MetaComponentCreator;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADFormContainer;
import org.netbeans.modules.form.RADVisualComponent;
import org.netbeans.modules.form.RADVisualContainer;
import org.netbeans.modules.form.RADVisualFormContainer;
import org.netbeans.modules.form.codestructure.CodeStructure;
import org.netbeans.modules.form.layoutdesign.LayoutComponent;
import org.netbeans.modules.form.layoutdesign.LayoutModel;
import org.netbeans.modules.form.layoutsupport.LayoutConstraints;
import org.netbeans.modules.form.layoutsupport.LayoutSupportDelegate;
import org.netbeans.modules.form.layoutsupport.LayoutSupportManager;
import org.openide.awt.UndoRedo;
import org.openide.util.Mutex;
import org.openide.util.MutexException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormModel {
    private String formName;
    private boolean readOnly = false;
    private Class formBaseClass;
    private RADComponent topRADComponent;
    private ArrayList<RADComponent> otherComponents = new ArrayList(10);
    private ComponentContainer modelContainer;
    private LayoutModel layoutModel;
    private Map<String, RADComponent> idToComponents = new HashMap<String, RADComponent>();
    private boolean formLoaded = false;
    private UndoRedo.Manager undoRedoManager;
    private boolean undoRedoRecording = false;
    private CompoundEdit compoundEdit;
    private boolean autoEndCoumpoundEdit;
    private boolean undoCompoundEdit = false;
    private FormEvents formEvents;
    private ArrayList listeners;
    private EventBroker eventBroker;
    private MetaComponentCreator metaCreator;
    private CodeStructure codeStructure = new CodeStructure(false);
    private FormSettings settings = new FormSettings(this);
    private boolean freeDesignDefaultLayout = false;
    private static int traceCount = 0;
    private static final boolean TRACE = false;

    FormModel() {
    }

    public void setFormBaseClass(Class clazz) throws Exception {
        if (this.formBaseClass != null) {
            throw new IllegalStateException("Form type already initialized.");
        }
        RADComponent rADComponent = Component.class.isAssignableFrom(clazz) ? (FormUtils.isContainer(clazz) ? new RADVisualFormContainer() : new RADVisualComponent(){

            public String getName() {
                return FormUtils.getBundleString("CTL_FormTopContainerName");
            }

            public void setName(String string) {
            }
        }) : (Object.class != clazz ? new RADFormContainer() : null);
        if (rADComponent != null) {
            this.topRADComponent = rADComponent;
            rADComponent.initialize(this);
            rADComponent.initInstance(clazz);
            rADComponent.setInModel(true);
        }
        this.formBaseClass = clazz;
        this.layoutModel = new LayoutModel();
        this.layoutModel.setChangeRecording(false);
    }

    public Class getFormBaseClass() {
        return this.formBaseClass;
    }

    void setName(String string) {
        this.formName = string;
    }

    void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    public final String getName() {
        return this.formName;
    }

    public final boolean isReadOnly() {
        return this.readOnly;
    }

    public final boolean isFormLoaded() {
        return this.formLoaded;
    }

    public final boolean wasCorrected() {
        return this.formLoaded && this.layoutModel != null && this.layoutModel.wasCorrected();
    }

    public final RADComponent getTopRADComponent() {
        return this.topRADComponent;
    }

    public ComponentContainer getModelContainer() {
        if (this.modelContainer == null) {
            this.modelContainer = new ModelContainer();
        }
        return this.modelContainer;
    }

    public Collection<RADComponent> getOtherComponents() {
        return Collections.unmodifiableCollection(this.otherComponents);
    }

    public final LayoutModel getLayoutModel() {
        return this.layoutModel;
    }

    public final RADComponent getMetaComponent(String string) {
        return this.idToComponents.get(string);
    }

    public RADComponent findRADComponent(String string) {
        for (RADComponent rADComponent : this.idToComponents.values()) {
            if (!string.equals(rADComponent.getName())) continue;
            return rADComponent;
        }
        return null;
    }

    public List<RADComponent> getComponentList() {
        return new ArrayList<RADComponent>(this.idToComponents.values());
    }

    public List<RADComponent> getOrderedComponentList() {
        ArrayList<RADComponent> arrayList = new ArrayList<RADComponent>(this.idToComponents.size());
        FormModel.collectMetaComponents(this.getModelContainer(), arrayList);
        return arrayList;
    }

    public Collection<RADComponent> getAllComponents() {
        return Collections.unmodifiableCollection(this.idToComponents.values());
    }

    public Collection<RADComponent> getNonVisualComponents() {
        ArrayList<RADComponent> arrayList = new ArrayList<RADComponent>(this.otherComponents.size());
        for (RADComponent rADComponent : this.otherComponents) {
            if (Component.class.isAssignableFrom(rADComponent.getBeanClass())) continue;
            arrayList.add(rADComponent);
        }
        return arrayList;
    }

    public FormEvents getFormEvents() {
        if (this.formEvents == null) {
            this.formEvents = new FormEvents(this);
        }
        return this.formEvents;
    }

    private static void collectMetaComponents(ComponentContainer componentContainer, List list) {
        RADComponent[] rADComponentArray = componentContainer.getSubBeans();
        for (int i = 0; i < rADComponentArray.length; ++i) {
            RADComponent rADComponent = rADComponentArray[i];
            list.add(rADComponent);
            if (!(rADComponent instanceof ComponentContainer)) continue;
            FormModel.collectMetaComponents((ComponentContainer)((Object)rADComponent), list);
        }
    }

    private static void collectVisualMetaComponents(RADVisualContainer rADVisualContainer, List list) {
        RADVisualComponent[] rADVisualComponentArray = rADVisualContainer.getSubComponents();
        for (int i = 0; i < rADVisualComponentArray.length; ++i) {
            RADVisualComponent rADVisualComponent = rADVisualComponentArray[i];
            list.add(rADVisualComponent);
            if (!(rADVisualComponent instanceof RADVisualContainer)) continue;
            FormModel.collectVisualMetaComponents((RADVisualContainer)rADVisualComponent, list);
        }
    }

    public MetaComponentCreator getComponentCreator() {
        if (this.metaCreator == null) {
            this.metaCreator = new MetaComponentCreator(this);
        }
        return this.metaCreator;
    }

    public void addComponent(RADComponent rADComponent, ComponentContainer componentContainer, boolean bl) {
        if (bl || !rADComponent.isInModel()) {
            FormModel.setInModelRecursively(rADComponent, true);
            bl = true;
        }
        if (componentContainer != null) {
            componentContainer.add(rADComponent);
        } else {
            rADComponent.setParentComponent(null);
            this.otherComponents.add(rADComponent);
        }
        FormModelEvent formModelEvent = this.fireComponentAdded(rADComponent, bl);
    }

    public void addVisualComponent(RADVisualComponent rADVisualComponent, RADVisualContainer rADVisualContainer, Object object, boolean bl) {
        LayoutSupportManager layoutSupportManager = rADVisualContainer.getLayoutSupport();
        if (layoutSupportManager != null) {
            int n;
            RADVisualComponent[] rADVisualComponentArray = new RADVisualComponent[]{rADVisualComponent};
            LayoutConstraints layoutConstraints = object instanceof LayoutConstraints ? (LayoutConstraints)object : null;
            LayoutConstraints[] layoutConstraintsArray = new LayoutConstraints[]{layoutConstraints};
            int n2 = n = object instanceof Integer ? (Integer)object : -1;
            if (bl || !rADVisualComponent.isInModel()) {
                FormModel.setInModelRecursively(rADVisualComponent, true);
                bl = true;
            }
            try {
                layoutSupportManager.acceptNewComponents(rADVisualComponentArray, layoutConstraintsArray, n);
            }
            catch (RuntimeException runtimeException) {
                if (bl) {
                    FormModel.setInModelRecursively(rADVisualComponent, false);
                }
                throw runtimeException;
            }
            rADVisualContainer.add(rADVisualComponent, n);
            layoutSupportManager.addComponents(rADVisualComponentArray, layoutConstraintsArray, n);
            FormModelEvent formModelEvent = this.fireComponentAdded(rADVisualComponent, bl);
        } else {
            this.addComponent(rADVisualComponent, rADVisualContainer, bl);
        }
    }

    public void setContainerLayoutImpl(RADVisualContainer rADVisualContainer, LayoutSupportDelegate layoutSupportDelegate, LayoutManager layoutManager) throws Exception {
        LayoutSupportDelegate layoutSupportDelegate2;
        LayoutSupportManager layoutSupportManager = rADVisualContainer.getLayoutSupport();
        LayoutSupportDelegate layoutSupportDelegate3 = layoutSupportDelegate2 = layoutSupportManager != null ? layoutSupportManager.getLayoutDelegate() : null;
        if (layoutSupportManager == null) {
            rADVisualContainer.setOldLayoutSupport(true);
        }
        rADVisualContainer.setLayoutSupportDelegate(layoutSupportDelegate, layoutManager);
        this.fireContainerLayoutExchanged(rADVisualContainer, layoutSupportDelegate2, layoutSupportDelegate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContainerLayout(RADVisualContainer rADVisualContainer, LayoutSupportDelegate layoutSupportDelegate, LayoutManager layoutManager) throws Exception {
        LayoutSupportManager layoutSupportManager = rADVisualContainer.getLayoutSupport();
        this.setContainerLayoutImpl(rADVisualContainer, layoutSupportDelegate, layoutManager);
        if (layoutSupportManager == null) {
            Object object = this.layoutModel.getChangeMark();
            UndoableEdit undoableEdit = this.layoutModel.getUndoableEdit();
            boolean bl = true;
            try {
                this.layoutModel.changeContainerToComponent(rADVisualContainer.getId());
                bl = false;
            }
            finally {
                if (object != null && !object.equals(this.layoutModel.getChangeMark())) {
                    this.addUndoableEdit(undoableEdit);
                }
                if (bl) {
                    this.forceUndoOfCompoundEdit();
                }
            }
        }
    }

    void setNaturalContainerLayoutImpl(RADVisualContainer rADVisualContainer) {
        LayoutSupportManager layoutSupportManager = rADVisualContainer.getLayoutSupport();
        LayoutSupportDelegate layoutSupportDelegate = layoutSupportManager.getLayoutDelegate();
        rADVisualContainer.setOldLayoutSupport(false);
        this.fireContainerLayoutExchanged(rADVisualContainer, layoutSupportDelegate, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNaturalContainerLayout(RADVisualContainer rADVisualContainer) {
        LayoutSupportManager layoutSupportManager = rADVisualContainer.getLayoutSupport();
        if (layoutSupportManager == null) {
            return;
        }
        this.setNaturalContainerLayoutImpl(rADVisualContainer);
        Object object = this.layoutModel.getChangeMark();
        UndoableEdit undoableEdit = this.layoutModel.getUndoableEdit();
        boolean bl = true;
        try {
            if (!this.layoutModel.changeComponentToContainer(rADVisualContainer.getId())) {
                this.layoutModel.addRootComponent(new LayoutComponent(rADVisualContainer.getId(), true));
            }
            bl = false;
        }
        finally {
            if (object != null && !object.equals(this.layoutModel.getChangeMark())) {
                this.addUndoableEdit(undoableEdit);
            }
            if (bl) {
                this.forceUndoOfCompoundEdit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeComponent(RADComponent rADComponent, boolean bl) {
        Object object = null;
        UndoableEdit undoableEdit = null;
        boolean bl2 = true;
        try {
            if (bl && this.layoutModel != null) {
                object = this.layoutModel.getChangeMark();
                undoableEdit = this.layoutModel.getUndoableEdit();
                this.layoutModel.removeComponent(rADComponent.getId(), true);
                this.removeLayoutComponentsRecursively(rADComponent);
            }
            bl2 = false;
        }
        finally {
            this.removeComponentImpl(rADComponent, bl);
            if (object != null && !object.equals(this.layoutModel.getChangeMark())) {
                this.addUndoableEdit(undoableEdit);
            }
            if (bl2) {
                this.forceUndoOfCompoundEdit();
            }
        }
    }

    void removeComponentImpl(RADComponent rADComponent, boolean bl) {
        RADComponent rADComponent2;
        if (bl && this.formEvents != null) {
            this.removeEventHandlersRecursively(rADComponent);
        }
        ComponentContainer componentContainer = (rADComponent2 = rADComponent.getParentComponent()) instanceof ComponentContainer ? (ComponentContainer)((Object)rADComponent2) : this.getModelContainer();
        int n = componentContainer.getIndexOf(rADComponent);
        componentContainer.remove(rADComponent);
        if (bl) {
            FormModel.setInModelRecursively(rADComponent, false);
        }
        FormModelEvent formModelEvent = this.fireComponentRemoved(rADComponent, componentContainer, n, bl);
    }

    private void removeLayoutComponentsRecursively(RADComponent rADComponent) {
        RADComponent[] rADComponentArray;
        if (rADComponent instanceof ComponentContainer) {
            rADComponentArray = ((ComponentContainer)((Object)rADComponent)).getSubBeans();
            for (int i = 0; i < rADComponentArray.length; ++i) {
                this.removeLayoutComponentsRecursively(rADComponentArray[i]);
            }
        }
        RADComponent[] rADComponentArray2 = rADComponentArray = this.layoutModel == null ? null : this.layoutModel.getLayoutComponent(rADComponent.getId());
        if (rADComponentArray != null && rADComponentArray.getParent() == null) {
            this.layoutModel.removeComponent(rADComponentArray.getId(), true);
        }
    }

    void updateMapping(RADComponent rADComponent, boolean bl) {
        if (bl) {
            this.idToComponents.put(rADComponent.getId(), rADComponent);
        } else {
            this.idToComponents.remove(rADComponent.getId());
        }
    }

    private void removeEventHandlersRecursively(RADComponent rADComponent) {
        int n;
        Object[] objectArray;
        if (rADComponent instanceof ComponentContainer) {
            objectArray = ((ComponentContainer)((Object)rADComponent)).getSubBeans();
            for (n = 0; n < objectArray.length; ++n) {
                this.removeEventHandlersRecursively((RADComponent)objectArray[n]);
            }
        }
        objectArray = rADComponent.getKnownEvents();
        for (n = 0; n < objectArray.length; ++n) {
            if (!((Event)objectArray[n]).hasEventHandlers()) continue;
            this.getFormEvents().detachEvent((Event)objectArray[n]);
        }
    }

    static void setInModelRecursively(RADComponent rADComponent, boolean bl) {
        if (rADComponent instanceof ComponentContainer) {
            RADComponent[] rADComponentArray = ((ComponentContainer)((Object)rADComponent)).getSubBeans();
            for (int i = 0; i < rADComponentArray.length; ++i) {
                FormModel.setInModelRecursively(rADComponentArray[i], bl);
            }
        }
        rADComponent.setInModel(bl);
    }

    public void setUndoRedoRecording(boolean bl) {
        FormModel.t("turning undo/redo recording " + (bl ? "on" : "off"));
        this.undoRedoRecording = bl;
    }

    public boolean isUndoRedoRecording() {
        return this.undoRedoRecording;
    }

    public boolean startCompoundEdit(boolean bl) {
        if (this.compoundEdit == null) {
            FormModel.t("starting compound edit");
            this.compoundEdit = new CompoundEdit();
            this.autoEndCoumpoundEdit = bl;
            return true;
        }
        return false;
    }

    public CompoundEdit endCompoundEdit(boolean bl) {
        if (this.compoundEdit != null) {
            FormModel.t("ending compound edit: " + bl);
            this.compoundEdit.end();
            this.autoEndCoumpoundEdit = false;
            if (bl && this.undoRedoRecording && this.compoundEdit.isSignificant()) {
                this.getUndoRedoManager().undoableEditHappened(new UndoableEditEvent(this, this.compoundEdit));
            } else {
                this.undoCompoundEdit = false;
            }
            CompoundEdit compoundEdit = this.compoundEdit;
            this.compoundEdit = null;
            return compoundEdit;
        }
        return null;
    }

    public void forceUndoOfCompoundEdit() {
        if (this.compoundEdit != null) {
            this.undoCompoundEdit = true;
        }
    }

    public boolean isCompoundEditInProgress() {
        return this.compoundEdit != null && this.compoundEdit.isInProgress();
    }

    public void addUndoableEdit(UndoableEdit undoableEdit) {
        FormModel.t("adding undoable edit");
        if (this.isCompoundEditInProgress()) {
            this.compoundEdit.addEdit(undoableEdit);
        } else {
            this.getUndoRedoManager().undoableEditHappened(new UndoableEditEvent(this, undoableEdit));
        }
    }

    UndoRedo.Manager getUndoRedoManager() {
        return this.undoRedoManager;
    }

    public synchronized void addFormModelListener(FormModelListener formModelListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(formModelListener);
    }

    public synchronized void removeFormModelListener(FormModelListener formModelListener) {
        if (this.listeners != null) {
            this.listeners.remove(formModelListener);
        }
    }

    public void fireFormLoaded() {
        FormModel.t("firing form loaded");
        this.formLoaded = true;
        this.eventBroker = new EventBroker();
        if (!this.readOnly && !Boolean.getBoolean("netbeans.form.no_undo")) {
            this.undoRedoManager = new UndoRedoManager();
            this.undoRedoManager.setLimit(50);
            this.setUndoRedoRecording(true);
            if (this.layoutModel != null) {
                this.layoutModel.setChangeRecording(true);
            }
        }
        this.sendEventLater(new FormModelEvent(this, 1));
    }

    public void fireFormToBeSaved() {
        FormModel.t("firing form to be saved");
        this.sendEventImmediately(new FormModelEvent(this, 2));
    }

    public void fireFormToBeClosed() {
        FormModel.t("firing form to be closed");
        if (this.undoRedoManager != null) {
            this.undoRedoManager.discardAllEdits();
        }
        this.sendEventImmediately(new FormModelEvent(this, 3));
    }

    public FormModelEvent fireContainerLayoutExchanged(RADVisualContainer rADVisualContainer, LayoutSupportDelegate layoutSupportDelegate, LayoutSupportDelegate layoutSupportDelegate2) {
        FormModel.t("firing container layout exchange, container: " + (rADVisualContainer != null ? rADVisualContainer.getName() : "null"));
        FormModelEvent formModelEvent = new FormModelEvent(this, 4);
        formModelEvent.setLayout(rADVisualContainer, layoutSupportDelegate, layoutSupportDelegate2);
        this.sendEvent(formModelEvent);
        if (this.undoRedoRecording && rADVisualContainer != null && layoutSupportDelegate != layoutSupportDelegate2) {
            this.addUndoableEdit(formModelEvent.getUndoableEdit());
        }
        return formModelEvent;
    }

    public FormModelEvent fireContainerLayoutChanged(RADVisualContainer rADVisualContainer, String string, Object object, Object object2) {
        FormModel.t("firing container layout change, container: " + (rADVisualContainer != null ? rADVisualContainer.getName() : "null") + ", property: " + string);
        FormModelEvent formModelEvent = new FormModelEvent(this, 5);
        formModelEvent.setComponentAndContainer(rADVisualContainer, rADVisualContainer);
        formModelEvent.setProperty(string, object, object2);
        this.sendEvent(formModelEvent);
        if (this.undoRedoRecording && rADVisualContainer != null && (string == null || object != object2)) {
            this.addUndoableEdit(formModelEvent.getUndoableEdit());
        }
        return formModelEvent;
    }

    public FormModelEvent fireComponentLayoutChanged(RADVisualComponent rADVisualComponent, String string, Object object, Object object2) {
        FormModel.t("firing component layout change: " + (rADVisualComponent != null ? rADVisualComponent.getName() : "null"));
        FormModelEvent formModelEvent = new FormModelEvent(this, 6);
        formModelEvent.setComponentAndContainer(rADVisualComponent, null);
        formModelEvent.setProperty(string, object, object2);
        this.sendEvent(formModelEvent);
        if (this.undoRedoRecording && rADVisualComponent != null && string != null && object != object2) {
            this.addUndoableEdit(formModelEvent.getUndoableEdit());
        }
        return formModelEvent;
    }

    public FormModelEvent fireComponentAdded(RADComponent rADComponent, boolean bl) {
        FormModel.t("firing component added: " + (rADComponent != null ? rADComponent.getName() : "null"));
        FormModelEvent formModelEvent = new FormModelEvent(this, 7);
        formModelEvent.setAddData(rADComponent, null, bl);
        this.sendEvent(formModelEvent);
        if (this.undoRedoRecording && rADComponent != null) {
            this.addUndoableEdit(formModelEvent.getUndoableEdit());
        }
        return formModelEvent;
    }

    public FormModelEvent fireComponentRemoved(RADComponent rADComponent, ComponentContainer componentContainer, int n, boolean bl) {
        FormModel.t("firing component removed: " + (rADComponent != null ? rADComponent.getName() : "null"));
        FormModelEvent formModelEvent = new FormModelEvent(this, 8);
        formModelEvent.setRemoveData(rADComponent, componentContainer, n, bl);
        this.sendEvent(formModelEvent);
        if (this.undoRedoRecording && rADComponent != null && componentContainer != null) {
            this.addUndoableEdit(formModelEvent.getUndoableEdit());
        }
        return formModelEvent;
    }

    public FormModelEvent fireComponentsReordered(ComponentContainer componentContainer, int[] nArray) {
        FormModel.t("firing components reorder in container: " + (componentContainer instanceof RADComponent ? ((RADComponent)((Object)componentContainer)).getName() : "<top>"));
        FormModelEvent formModelEvent = new FormModelEvent(this, 9);
        formModelEvent.setComponentAndContainer(null, componentContainer);
        formModelEvent.setReordering(nArray);
        this.sendEvent(formModelEvent);
        if (this.undoRedoRecording && componentContainer != null) {
            this.addUndoableEdit(formModelEvent.getUndoableEdit());
        }
        return formModelEvent;
    }

    public FormModelEvent fireComponentPropertyChanged(RADComponent rADComponent, String string, Object object, Object object2) {
        FormModel.t("firing component property change, component: " + (rADComponent != null ? rADComponent.getName() : "<null component>") + ", property: " + string);
        FormModelEvent formModelEvent = new FormModelEvent(this, 10);
        formModelEvent.setComponentAndContainer(rADComponent, null);
        formModelEvent.setProperty(string, object, object2);
        this.sendEvent(formModelEvent);
        if (this.undoRedoRecording && rADComponent != null && string != null && object != object2) {
            this.addUndoableEdit(formModelEvent.getUndoableEdit());
        }
        return formModelEvent;
    }

    public FormModelEvent fireSyntheticPropertyChanged(RADComponent rADComponent, String string, Object object, Object object2) {
        FormModel.t("firing synthetic property change, component: " + (rADComponent != null ? rADComponent.getName() : "null") + ", property: " + string);
        FormModelEvent formModelEvent = new FormModelEvent(this, 11);
        formModelEvent.setComponentAndContainer(rADComponent, null);
        formModelEvent.setProperty(string, object, object2);
        this.sendEvent(formModelEvent);
        if (this.undoRedoRecording && string != null && object != object2) {
            this.addUndoableEdit(formModelEvent.getUndoableEdit());
        }
        return formModelEvent;
    }

    public FormModelEvent fireEventHandlerAdded(Event event, String string, String string2, boolean bl) {
        FormModel.t("event handler added: " + string);
        FormModelEvent formModelEvent = new FormModelEvent(this, 12);
        formModelEvent.setEvent(event, string, string2, bl);
        this.sendEvent(formModelEvent);
        if (this.undoRedoRecording && event != null && string != null) {
            this.addUndoableEdit(formModelEvent.getUndoableEdit());
        }
        return formModelEvent;
    }

    public FormModelEvent fireEventHandlerRemoved(Event event, String string, boolean bl) {
        FormModel.t("firing event handler removed: " + string);
        FormModelEvent formModelEvent = new FormModelEvent(this, 13);
        formModelEvent.setEvent(event, string, null, bl);
        this.sendEvent(formModelEvent);
        if (this.undoRedoRecording && event != null && string != null) {
            this.addUndoableEdit(formModelEvent.getUndoableEdit());
        }
        return formModelEvent;
    }

    public FormModelEvent fireEventHandlerRenamed(String string, String string2) {
        FormModel.t("event handler renamed: " + string + " to " + string2);
        FormModelEvent formModelEvent = new FormModelEvent(this, 14);
        formModelEvent.setEvent(string, string2);
        this.sendEvent(formModelEvent);
        if (this.undoRedoRecording && string != null && string2 != null) {
            this.addUndoableEdit(formModelEvent.getUndoableEdit());
        }
        return formModelEvent;
    }

    public FormModelEvent fireFormChanged(boolean bl) {
        FormModel.t("firing form change");
        FormModelEvent formModelEvent = new FormModelEvent(this, 15);
        if (bl) {
            this.sendEventImmediately(formModelEvent);
        } else {
            this.sendEvent(formModelEvent);
        }
        return formModelEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireEvents(FormModelEvent[] formModelEventArray) {
        ArrayList arrayList;
        FormModel formModel = this;
        synchronized (formModel) {
            if (this.listeners == null) {
                return;
            }
            arrayList = (ArrayList)this.listeners.clone();
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            FormModelListener formModelListener = (FormModelListener)arrayList.get(i);
            formModelListener.formChanged(formModelEventArray);
        }
    }

    void sendEvent(FormModelEvent formModelEvent) {
        EventBroker eventBroker = this.getEventBroker();
        if (eventBroker != null) {
            eventBroker.sendEvent(formModelEvent);
        } else {
            FormModel.t("no event broker, firing event directly: " + formModelEvent.getChangeType());
            this.fireEvents(new FormModelEvent[]{formModelEvent});
        }
    }

    void sendEventLater(FormModelEvent formModelEvent) {
        EventBroker eventBroker = this.getEventBroker();
        if (eventBroker != null) {
            eventBroker.sendEventLater(formModelEvent);
        } else {
            FormModel.t("no event broker, firing event directly: " + formModelEvent.getChangeType());
            this.fireEvents(new FormModelEvent[]{formModelEvent});
        }
    }

    void sendEventImmediately(FormModelEvent formModelEvent) {
        this.fireEvents(new FormModelEvent[]{formModelEvent});
    }

    EventBroker getEventBroker() {
        return this.eventBroker;
    }

    public FormSettings getSettings() {
        return this.settings;
    }

    CodeStructure getCodeStructure() {
        return this.codeStructure;
    }

    public boolean isFreeDesignDefaultLayout() {
        return this.freeDesignDefaultLayout;
    }

    void setFreeDesignDefaultLayout(boolean bl) {
        this.freeDesignDefaultLayout = bl;
    }

    static void t(String string) {
    }

    private class EventBroker
    implements Runnable {
        private List eventList;

        private EventBroker() {
        }

        public void sendEvent(FormModelEvent formModelEvent) {
            if (this.shouldSendLater(formModelEvent)) {
                this.sendEventLater(formModelEvent);
            } else {
                this.sendEventImmediately(formModelEvent);
            }
        }

        public void sendEventImmediately(FormModelEvent formModelEvent) {
            FormModel.t("firing event directly from event broker: " + formModelEvent.getChangeType());
            FormModel.this.fireEvents(new FormModelEvent[]{formModelEvent});
        }

        public void sendEventLater(FormModelEvent formModelEvent) {
            if (!EventQueue.isDispatchThread()) {
                this.sendEventImmediately(formModelEvent);
                return;
            }
            if (this.eventList == null) {
                this.eventList = new ArrayList();
                if (formModelEvent.isModifying() && FormModel.this.isUndoRedoRecording() && FormModel.this.startCompoundEdit(true)) {
                    FormModel.t("compound undoable edit started from event broker");
                }
                EventQueue.invokeLater(this);
            }
            this.eventList.add(formModelEvent);
            FormModel.t("event " + formModelEvent.getChangeType() + " added to queue in event broker");
        }

        private boolean shouldSendLater(FormModelEvent formModelEvent) {
            return this.eventList != null || formModelEvent.isModifying();
        }

        private List pickUpEvents() {
            List list = this.eventList;
            this.eventList = null;
            return list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            List list = this.pickUpEvents();
            boolean bl = false;
            try {
                if (list != null && !list.isEmpty()) {
                    FormModelEvent[] formModelEventArray = new FormModelEvent[list.size()];
                    list.toArray(formModelEventArray);
                    FormModel.t("firing event batch of " + list.size() + " events from event broker");
                    FormModel.this.fireEvents(formModelEventArray);
                }
                bl = true;
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (FormModel.this.autoEndCoumpoundEdit) {
                    CompoundEdit compoundEdit = FormModel.this.endCompoundEdit(true);
                    if (compoundEdit != null) {
                        FormModel.t("coumpound undoable edit ended automatically");
                        if ((FormModel.this.undoCompoundEdit || !bl) && FormModel.this.getUndoRedoManager().canUndo()) {
                            FormModel.this.undoCompoundEdit = false;
                            FormModel.this.getUndoRedoManager().undo();
                        }
                    }
                    FormModel.this.undoCompoundEdit = false;
                }
                throw throwable;
            }
            if (FormModel.this.autoEndCoumpoundEdit) {
                CompoundEdit compoundEdit = FormModel.this.endCompoundEdit(true);
                if (compoundEdit != null) {
                    FormModel.t("coumpound undoable edit ended automatically");
                    if ((FormModel.this.undoCompoundEdit || !bl) && FormModel.this.getUndoRedoManager().canUndo()) {
                        FormModel.this.undoCompoundEdit = false;
                        FormModel.this.getUndoRedoManager().undo();
                    }
                }
                FormModel.this.undoCompoundEdit = false;
            }
        }
    }

    final class ModelContainer
    implements ComponentContainer {
        ModelContainer() {
        }

        public RADComponent[] getSubBeans() {
            int n = FormModel.this.otherComponents.size();
            if (FormModel.this.topRADComponent != null) {
                ++n;
            }
            RADComponent[] rADComponentArray = new RADComponent[n];
            FormModel.this.otherComponents.toArray(rADComponentArray);
            if (FormModel.this.topRADComponent != null) {
                rADComponentArray[n - 1] = FormModel.this.topRADComponent;
            }
            return rADComponentArray;
        }

        public void initSubComponents(RADComponent[] rADComponentArray) {
            FormModel.this.otherComponents.clear();
            for (int i = 0; i < rADComponentArray.length; ++i) {
                if (rADComponentArray[i] == FormModel.this.topRADComponent) continue;
                FormModel.this.otherComponents.add(rADComponentArray[i]);
            }
        }

        public void reorderSubComponents(int[] nArray) {
            RADComponent[] rADComponentArray = new RADComponent[FormModel.this.otherComponents.size()];
            for (int i = 0; i < nArray.length; ++i) {
                rADComponentArray[nArray[i]] = (RADComponent)FormModel.this.otherComponents.get(i);
            }
            FormModel.this.otherComponents.clear();
            FormModel.this.otherComponents.addAll(Arrays.asList(rADComponentArray));
        }

        public void add(RADComponent rADComponent) {
            rADComponent.setParentComponent(null);
            FormModel.this.otherComponents.add(rADComponent);
        }

        public void remove(RADComponent rADComponent) {
            if (FormModel.this.otherComponents.remove(rADComponent)) {
                rADComponent.setParentComponent(null);
            }
        }

        public int getIndexOf(RADComponent rADComponent) {
            int n = FormModel.this.otherComponents.indexOf(rADComponent);
            if (n < 0 && rADComponent == FormModel.this.topRADComponent) {
                n = FormModel.this.otherComponents.size();
            }
            return n;
        }
    }

    class UndoRedoManager
    extends UndoRedo.Manager {
        private Mutex.ExceptionAction runUndo = new Mutex.ExceptionAction(){

            public Object run() throws Exception {
                UndoRedoManager.this.superUndo();
                return null;
            }
        };
        private Mutex.ExceptionAction runRedo = new Mutex.ExceptionAction(){

            public Object run() throws Exception {
                UndoRedoManager.this.superRedo();
                return null;
            }
        };

        UndoRedoManager() {
        }

        public void superUndo() throws CannotUndoException {
            super.undo();
        }

        public void superRedo() throws CannotRedoException {
            super.redo();
        }

        public void undo() throws CannotUndoException {
            if (EventQueue.isDispatchThread()) {
                this.superUndo();
            } else {
                try {
                    Mutex.EVENT.readAccess(this.runUndo);
                }
                catch (MutexException mutexException) {
                    Exception exception = mutexException.getException();
                    if (exception instanceof CannotUndoException) {
                        throw (CannotUndoException)exception;
                    }
                    exception.printStackTrace();
                }
            }
        }

        public void redo() throws CannotRedoException {
            if (EventQueue.isDispatchThread()) {
                this.superRedo();
            } else {
                try {
                    Mutex.EVENT.readAccess(this.runRedo);
                }
                catch (MutexException mutexException) {
                    Exception exception = mutexException.getException();
                    if (exception instanceof CannotRedoException) {
                        throw (CannotRedoException)exception;
                    }
                    exception.printStackTrace();
                }
            }
        }
    }
}

