/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.beans.PropertyEditor;
import org.netbeans.modules.form.FormAwareEditor;
import org.netbeans.modules.form.FormModel;

public interface FormPropertyContext {
    public boolean useMultipleEditors();

    public void initPropertyEditor(PropertyEditor var1);

    public FormModel getFormModel();

    public static class DefaultImpl
    extends DefaultSupport {
        FormModel formModel;

        public DefaultImpl(FormModel formModel) {
            this.formModel = formModel;
        }

        public FormModel getFormModel() {
            return this.formModel;
        }
    }

    public static abstract class DefaultSupport
    implements FormPropertyContext {
        public boolean useMultipleEditors() {
            FormModel formModel = this.getFormModel();
            return formModel != null;
        }

        public void initPropertyEditor(PropertyEditor propertyEditor) {
            FormModel formModel = this.getFormModel();
            if (formModel != null && propertyEditor instanceof FormAwareEditor) {
                ((FormAwareEditor)((Object)propertyEditor)).setFormModel(formModel);
            }
        }
    }

    public static class EmptyImpl
    implements FormPropertyContext {
        private static EmptyImpl theInstance = null;

        public boolean useMultipleEditors() {
            return false;
        }

        public void initPropertyEditor(PropertyEditor propertyEditor) {
        }

        public FormModel getFormModel() {
            return null;
        }

        public static EmptyImpl getInstance() {
            if (theInstance == null) {
                theInstance = new EmptyImpl();
            }
            return theInstance;
        }
    }
}

