/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.AWTKeyStroke;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Area;
import java.beans.FeatureDescriptor;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TooManyListenersException;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.plaf.UIResource;
import javax.swing.undo.UndoableEdit;
import org.netbeans.modules.form.ComponentContainer;
import org.netbeans.modules.form.ComponentDragger;
import org.netbeans.modules.form.ComponentInspector;
import org.netbeans.modules.form.ComponentLayer;
import org.netbeans.modules.form.CopySupport;
import org.netbeans.modules.form.FormDataObject;
import org.netbeans.modules.form.FormDesigner;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormJavaSource;
import org.netbeans.modules.form.FormLAF;
import org.netbeans.modules.form.FormLoaderSettings;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormRootNode;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.MetaComponentCreator;
import org.netbeans.modules.form.NewComponentDrop;
import org.netbeans.modules.form.NonVisualTray;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADComponentNode;
import org.netbeans.modules.form.RADMenuItemComponent;
import org.netbeans.modules.form.RADVisualComponent;
import org.netbeans.modules.form.RADVisualContainer;
import org.netbeans.modules.form.fakepeer.FakePeerSupport;
import org.netbeans.modules.form.layoutdesign.LayoutComponent;
import org.netbeans.modules.form.layoutdesign.LayoutDesigner;
import org.netbeans.modules.form.layoutdesign.LayoutModel;
import org.netbeans.modules.form.layoutdesign.LayoutTestUtils;
import org.netbeans.modules.form.layoutsupport.LayoutConstraints;
import org.netbeans.modules.form.layoutsupport.LayoutSupportManager;
import org.netbeans.modules.form.palette.PaletteItem;
import org.netbeans.modules.form.palette.PaletteUtils;
import org.netbeans.modules.form.project.ClassSource;
import org.netbeans.spi.palette.PaletteController;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.nodes.NodeOp;
import org.openide.nodes.NodeOperation;
import org.openide.nodes.NodeTransfer;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;

class HandleLayer
extends JPanel
implements MouseListener,
MouseMotionListener {
    static final int COMP_DEEPEST = 0;
    static final int COMP_SELECTED = 1;
    static final int COMP_ABOVE_SELECTED = 2;
    static final int COMP_UNDER_SELECTED = 3;
    private static final int DESIGNER_RESIZING = 256;
    private static MessageFormat resizingHintFormat;
    private static MessageFormat sizeHintFormat;
    private FormDesigner formDesigner;
    private boolean viewOnly;
    private ComponentDrag draggedComponent;
    private JPanel dragPanel;
    private Point lastMousePosition;
    private int lastXPosDiff;
    private int lastYPosDiff;
    private Point lastLeftMousePoint;
    private Point prevLeftMousePoint;
    private boolean draggingEnded;
    private int resizeType;
    private SelectionDragger selectionDragger;
    private Image resizeHandle;
    private DropTarget dropTarget;
    private NewComponentDropListener dropListener;
    private static FormLoaderSettings formSettings;
    private static int lastPaintWidth;
    private Stroke paintStroke;
    private JPanel darkerPanel = null;

    HandleLayer(FormDesigner formDesigner) {
        this.formDesigner = formDesigner;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setLayout(null);
        this.dragPanel = new JPanel();
        this.dragPanel.setLayout(null);
        this.dragPanel.setBounds(-1, -1, 0, 0);
        this.add(this.dragPanel);
        HashSet<AWTKeyStroke> hashSet = new HashSet<AWTKeyStroke>();
        hashSet.add(AWTKeyStroke.getAWTKeyStroke(9, 128, true));
        this.setFocusTraversalKeys(0, hashSet);
        hashSet.clear();
        hashSet.add(AWTKeyStroke.getAWTKeyStroke(9, 192, true));
        this.setFocusTraversalKeys(1, hashSet);
        this.getAccessibleContext().setAccessibleName(FormUtils.getBundleString("ACSN_HandleLayer"));
        this.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_HandleLayer"));
        this.dropListener = new NewComponentDropListener();
        this.dropTarget = new DropTarget(this, this.dropListener);
    }

    void setViewOnly(boolean bl) {
        if (this.viewOnly == bl) {
            return;
        }
        if (bl) {
            this.dropTarget.removeDropTargetListener(this.dropListener);
        } else {
            try {
                this.dropTarget.addDropTargetListener(this.dropListener);
            }
            catch (TooManyListenersException tooManyListenersException) {
                tooManyListenersException.printStackTrace();
            }
        }
        this.viewOnly = bl;
    }

    private FormModel getFormModel() {
        return this.formDesigner.getFormModel();
    }

    private MetaComponentCreator getComponentCreator() {
        return this.formDesigner.getFormModel().getComponentCreator();
    }

    private LayoutModel getLayoutModel() {
        return this.formDesigner.getFormModel().getLayoutModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.formDesigner.getDesignerMode() == 1) {
            RADComponent rADComponent = this.formDesigner.getConnectionSource();
            RADComponent rADComponent2 = this.formDesigner.getConnectionTarget();
            if (rADComponent != null || rADComponent2 != null) {
                graphics2D.setColor(formSettings.getConnectionBorderColor());
                graphics2D.setStroke(this.getPaintStroke());
                if (rADComponent != null) {
                    this.paintSelection(graphics2D, rADComponent, false);
                }
                if (rADComponent2 != null) {
                    this.paintSelection(graphics2D, rADComponent2, false);
                }
            }
            return;
        }
        if (this.draggedComponent != null) {
            FormLAF.setUseDesignerDefaults(true);
            this.draggedComponent.paintFeedback(graphics2D);
            FormLAF.setUseDesignerDefaults(false);
        } else {
            graphics2D.setColor(formSettings.getSelectionBorderColor());
            graphics2D.setStroke(this.getPaintStroke());
            boolean bl = false;
            try {
                boolean bl2 = this.selectedComponentsInSameVisibleContainer();
                for (RADComponent rADComponent : this.formDesigner.getSelectedComponents()) {
                    RADVisualComponent rADVisualComponent = this.formDesigner.componentToLayoutComponent(rADComponent);
                    if (rADVisualComponent != null) {
                        rADComponent = rADVisualComponent;
                    }
                    this.paintSelection(graphics2D, rADComponent, bl2);
                }
                bl = true;
            }
            finally {
                if (!bl) {
                    this.formDesigner.clearSelection();
                }
            }
            if (this.selectionDragger != null) {
                this.selectionDragger.paintDragFeedback(graphics2D);
            }
        }
    }

    private void paintSelection(Graphics2D graphics2D, RADComponent rADComponent, boolean bl) {
        if (!(rADComponent instanceof RADVisualComponent) && !(rADComponent instanceof RADMenuItemComponent)) {
            return;
        }
        Object object = this.formDesigner.getComponent(rADComponent);
        if (!(object instanceof Component)) {
            return;
        }
        Component component = (Component)object;
        Container container = component.getParent();
        if (container != null && component.isShowing()) {
            Rectangle rectangle = component.getBounds();
            RADComponent rADComponent2 = rADComponent.getParentComponent();
            this.convertRectangleFromComponent(rectangle, container);
            Rectangle rectangle2 = new Rectangle(0, 0, container.getWidth(), container.getHeight());
            rectangle2 = this.convertVisibleRectangleFromComponent(rectangle2, container);
            if (bl && this.formDesigner.isInDesignedTree(rADComponent2) && rADComponent2 instanceof RADVisualContainer && ((RADVisualContainer)rADComponent2).getLayoutSupport() == null) {
                Container container2 = this.formDesigner.getTopVisualContainer();
                Point point = this.convertPointFromComponent(0, 0, container2);
                graphics2D.translate(point.x, point.y);
                LayoutDesigner layoutDesigner = this.formDesigner.getLayoutDesigner();
                Color color = graphics2D.getColor();
                graphics2D.setColor(formSettings.getGuidingLineColor());
                Shape shape = graphics2D.getClip();
                rectangle2.translate(-point.x, -point.y);
                Area area = new Area(rectangle2);
                if (shape != null) {
                    area.intersect(new Area(shape));
                }
                graphics2D.setClip(area);
                layoutDesigner.paintSelection(graphics2D, rADComponent.getId());
                graphics2D.setClip(shape);
                graphics2D.setColor(color);
                rectangle2.translate(point.x, point.y);
                graphics2D.translate(-point.x, -point.y);
            }
            int n = 0;
            if (bl) {
                n = this.getComponentResizable((RADVisualComponent)rADComponent);
            }
            if (n == 0) {
                rectangle = rectangle.intersection(rectangle2);
            }
            int n2 = formSettings.getSelectionBorderSize() % 2;
            int n3 = rectangle.x - n2;
            int n4 = rectangle.y - n2;
            int n5 = rectangle.width + n2;
            int n6 = rectangle.height + n2;
            graphics2D.drawRect(n3, n4, n5, n6);
            if (bl) {
                Image image = this.resizeHandle();
                int n7 = image.getHeight(null);
                int n8 = image.getWidth(null);
                if ((n & 4) != 0) {
                    graphics2D.drawImage(image, n3 - n8 + 1, n4 + (n6 - n7) / 2, null);
                    if ((n & 1) != 0) {
                        graphics2D.drawImage(image, n3 - n8 + 1, n4 - n7 + 1, null);
                    }
                    if ((n & 2) != 0) {
                        graphics2D.drawImage(image, n3 - n8 + 1, n4 + n6, null);
                    }
                }
                if ((n & 8) != 0) {
                    graphics2D.drawImage(image, n3 + n5, n4 + (n6 - n7) / 2, null);
                    if ((n & 1) != 0) {
                        graphics2D.drawImage(image, n3 + n5, n4 - n7 + 1, null);
                    }
                    if ((n & 2) != 0) {
                        graphics2D.drawImage(image, n3 + n5, n4 + n6, null);
                    }
                }
                if ((n & 1) != 0) {
                    graphics2D.drawImage(image, n3 + (n5 - n8) / 2, n4 - n7 + 1, null);
                }
                if ((n & 2) != 0) {
                    graphics2D.drawImage(image, n3 + (n5 - n8) / 2, n4 + n6, null);
                }
            }
        }
    }

    private Image resizeHandle() {
        if (this.resizeHandle == null) {
            this.resizeHandle = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/form/resources/resize_handle.png")).getImage();
        }
        return this.resizeHandle;
    }

    private Stroke getPaintStroke() {
        int n = formSettings.getSelectionBorderSize();
        if (lastPaintWidth != n) {
            this.paintStroke = null;
        }
        if (this.paintStroke == null) {
            this.paintStroke = new BasicStroke(n);
            lastPaintWidth = n;
        }
        return this.paintStroke;
    }

    void maskDraggingComponents() {
        if (this.draggedComponent != null) {
            this.draggedComponent.maskDraggingComponents();
        }
    }

    public boolean isOpaque() {
        return false;
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 9 || keyEvent.getKeyChar() == '\t') {
            if (!keyEvent.isControlDown()) {
                RADVisualComponent rADVisualComponent;
                if (keyEvent.getID() == 401 && (rADVisualComponent = this.formDesigner.getNextVisualComponent(!keyEvent.isShiftDown())) != null) {
                    this.formDesigner.setSelectedComponent(rADVisualComponent);
                }
                keyEvent.consume();
                return;
            }
        } else {
            if (n == 32) {
                List list;
                if (!this.viewOnly && keyEvent.getID() == 402 && (list = this.formDesigner.getSelectedComponents()).size() == 1) {
                    RADComponent rADComponent = (RADComponent)list.get(0);
                    if (this.formDesigner.getDesignerMode() == 0) {
                        this.formDesigner.startInPlaceEditing(rADComponent);
                    }
                }
                keyEvent.consume();
                return;
            }
            if (n == 27) {
                if (this.formDesigner.getDesignerMode() != 0) {
                    this.formDesigner.toggleSelectionMode();
                    this.repaint();
                    keyEvent.consume();
                    return;
                }
                if (this.endDragging(null)) {
                    this.repaint();
                    keyEvent.consume();
                    return;
                }
            } else if (n == 525 || n == 121 && keyEvent.isShiftDown()) {
                Point point = null;
                List list = this.formDesigner.getSelectedComponents();
                if (list.size() > 0) {
                    RADComponent rADComponent = (RADComponent)list.get(0);
                    Component component = (Component)this.formDesigner.getComponent(rADComponent);
                    if (component instanceof Component) {
                        Component component2 = component;
                        point = this.convertPointFromComponent(component2.getLocation(), component2.getParent());
                    } else {
                        point = new Point(6, 6);
                    }
                    this.showContextMenu(point);
                    keyEvent.consume();
                    return;
                }
            } else if ((n == 68 || n == 69) && keyEvent.isAltDown() && keyEvent.isControlDown() && keyEvent.getID() == 401) {
                FormModel formModel = this.formDesigner.getFormModel();
                LayoutModel layoutModel = formModel.getLayoutModel();
                if (layoutModel != null) {
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    for (RADComponent rADComponent : formModel.getAllComponents()) {
                        if (rADComponent == formModel.getTopRADComponent()) continue;
                        hashMap.put(rADComponent.getId(), rADComponent.getName());
                    }
                    System.out.println(layoutModel.dump(hashMap));
                }
            } else if (n == 87 && keyEvent.isAltDown() && keyEvent.isControlDown() && keyEvent.getID() == 401) {
                FormModel formModel;
                LayoutModel layoutModel;
                if (this.formDesigner.getLayoutDesigner().logTestCode() && (layoutModel = (formModel = this.formDesigner.getFormModel()).getLayoutModel()) != null) {
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    for (RADComponent object2 : formModel.getAllComponents()) {
                        hashMap.put(object2.getId(), object2.getName());
                    }
                    Object object3 = this.formDesigner.getFormEditor().getFormDataObject();
                    LayoutTestUtils.writeTest(this.formDesigner, object3, hashMap, layoutModel);
                    LayoutDesigner layoutDesigner = this.formDesigner.getLayoutDesigner();
                    layoutDesigner.setModelCounter(layoutDesigner.getModelCounter() + 1);
                }
            } else if (n == 83 && keyEvent.isAltDown() && keyEvent.isControlDown() && keyEvent.getID() == 401 && LayoutDesigner.testMode()) {
                FormDataObject formDataObject = this.formDesigner.getFormEditor().getFormDataObject();
                FileObject fileObject = formDataObject.getFormFile();
                SaveCookie saveCookie = formDataObject.getCookie(SaveCookie.class);
                try {
                    if (saveCookie != null) {
                        saveCookie.save();
                    }
                    FileObject fileObject2 = fileObject.copy(LayoutTestUtils.getTargetFolder(fileObject), fileObject.getName() + "Test-StartingForm", fileObject.getExt());
                    this.formDesigner.getLayoutDesigner().setModelCounter(0);
                    this.formDesigner.resetTopDesignComponent(true);
                    StatusDisplayer.getDefault().setStatusText("The form was successfully copied to: " + fileObject2.getPath());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        super.processKeyEvent(keyEvent);
    }

    public boolean isFocusable() {
        return true;
    }

    private RADComponent getMetaComponentAt(Point point, int n) {
        Component[] componentArray = HandleLayer.getDeepestComponentsAt(this.formDesigner.getComponentLayer(), point);
        if (componentArray.length == 0) {
            return null;
        }
        int n2 = n == 0 ? componentArray.length - 1 : 0;
        Component component = componentArray[n2];
        RADVisualComponent rADVisualComponent = this.formDesigner.getTopDesignComponent();
        RADComponent rADComponent = null;
        RADComponent rADComponent2 = null;
        do {
            RADComponent rADComponent3;
            if ((rADComponent3 = this.formDesigner.getMetaComponent(component)) == null || this.isDraggedComponent(rADComponent3)) continue;
            if (rADComponent == null) {
                rADComponent = rADComponent3;
            }
            switch (n) {
                case 0: {
                    return rADComponent3;
                }
                case 1: {
                    if (this.formDesigner.isComponentSelected(rADComponent3)) {
                        return rADComponent3;
                    }
                    if (rADComponent3 != rADVisualComponent) break;
                    return rADComponent;
                }
                case 2: {
                    if (rADComponent2 != null && this.formDesigner.isComponentSelected(rADComponent2)) {
                        return rADComponent3;
                    }
                    if (rADComponent3 != rADVisualComponent) break;
                    return rADComponent;
                }
                case 3: {
                    if (this.formDesigner.isComponentSelected(rADComponent3)) {
                        return rADComponent2 != null ? rADComponent2 : rADVisualComponent;
                    }
                    if (rADComponent3 != rADVisualComponent) break;
                    return rADVisualComponent;
                }
            }
            rADComponent2 = rADComponent3;
        } while ((component = n2 + 1 < componentArray.length ? componentArray[++n2] : component.getParent()) != null);
        return rADComponent;
    }

    private static Component[] getDeepestComponentsAt(Container container, Point point) {
        Component component = SwingUtilities.getDeepestComponentAt(container, point.x, point.y);
        if (component == null) {
            return new Component[0];
        }
        Container container2 = component.getParent();
        Component[] componentArray = container2.getComponents();
        Point point2 = SwingUtilities.convertPoint(container, point, container2);
        Component[] componentArray2 = new Component[1];
        ArrayList<Component> arrayList = null;
        for (int i = 0; i < componentArray.length; ++i) {
            component = componentArray[i];
            Point point3 = component.getLocation();
            if (!component.isVisible() || !component.contains(point2.x - point3.x, point2.y - point3.y)) continue;
            if (componentArray2[0] == null) {
                componentArray2[0] = component;
                continue;
            }
            if (arrayList == null) {
                arrayList = new ArrayList<Component>();
                arrayList.add(componentArray2[0]);
            }
            arrayList.add(component);
        }
        if (arrayList == null) {
            return componentArray2[0] != null ? componentArray2 : new Component[]{};
        }
        componentArray2 = new Component[arrayList.size()];
        arrayList.toArray(componentArray2);
        return componentArray2;
    }

    RADVisualContainer getMetaContainerAt(Point point, int n) {
        RADComponent rADComponent = this.getMetaComponentAt(point, n);
        if (rADComponent == null) {
            return null;
        }
        if (rADComponent instanceof RADVisualContainer) {
            return (RADVisualContainer)rADComponent;
        }
        if (rADComponent instanceof RADVisualComponent) {
            return (RADVisualContainer)rADComponent.getParentComponent();
        }
        return null;
    }

    private RADComponent selectComponent(MouseEvent mouseEvent) {
        int n = !mouseEvent.isAltDown() ? 0 : (!mouseEvent.isShiftDown() ? 2 : 3);
        RADComponent rADComponent = this.getMetaComponentAt(mouseEvent.getPoint(), n);
        if ((mouseEvent.isControlDown() || mouseEvent.isShiftDown()) && !mouseEvent.isAltDown()) {
            if (rADComponent != null) {
                if (this.formDesigner.isComponentSelected(rADComponent)) {
                    this.formDesigner.removeComponentFromSelection(rADComponent);
                } else {
                    this.formDesigner.addComponentToSelection(rADComponent);
                }
            }
        } else if (rADComponent != null) {
            if (!this.formDesigner.isComponentSelected(rADComponent)) {
                this.formDesigner.setSelectedComponent(rADComponent);
            }
        } else {
            this.formDesigner.clearSelection();
        }
        return rADComponent;
    }

    private void selectOtherComponentsNode() {
        FormEditor formEditor = this.formDesigner.getFormEditor();
        ComponentInspector componentInspector = ComponentInspector.getInstance();
        Node[] nodeArray = new Node[]{((FormRootNode)formEditor.getFormRootNode()).getOthersNode()};
        try {
            componentInspector.setSelectedNodes(nodeArray, formEditor);
            this.formDesigner.clearSelectionImpl();
            this.formDesigner.repaintSelection();
        }
        catch (PropertyVetoException propertyVetoException) {
            ErrorManager.getDefault().notify(1, (Throwable)propertyVetoException);
        }
        this.formDesigner.setActivatedNodes(nodeArray);
    }

    private boolean processDoubleClick(MouseEvent mouseEvent) {
        if (mouseEvent.isShiftDown() || mouseEvent.isControlDown()) {
            return false;
        }
        RADComponent rADComponent = this.getMetaComponentAt(mouseEvent.getPoint(), 1);
        if (rADComponent == null) {
            return true;
        }
        if (mouseEvent.isAltDown()) {
            if (rADComponent == this.formDesigner.getTopDesignComponent()) {
                if ((rADComponent = rADComponent.getParentComponent()) == null) {
                    return true;
                }
            } else {
                return false;
            }
        }
        this.formDesigner.startInPlaceEditing(rADComponent);
        return true;
    }

    private void processMouseClickInLayoutSupport(RADComponent rADComponent, MouseEvent mouseEvent) {
        LayoutSupportManager layoutSupportManager;
        if (!(rADComponent instanceof RADVisualComponent)) {
            return;
        }
        RADVisualContainer rADVisualContainer = rADComponent instanceof RADVisualContainer ? (RADVisualContainer)rADComponent : (RADVisualContainer)rADComponent.getParentComponent();
        LayoutSupportManager layoutSupportManager2 = layoutSupportManager = rADVisualContainer != null ? rADVisualContainer.getLayoutSupport() : null;
        if (layoutSupportManager == null) {
            return;
        }
        Container container = (Container)this.formDesigner.getComponent(rADVisualContainer);
        Container container2 = rADVisualContainer.getContainerDelegate(container);
        Point point = this.convertPointToComponent(mouseEvent.getPoint(), container2);
        layoutSupportManager.processMouseClick(point, container, container2);
    }

    private void showContextMenu(Point point) {
        ComponentInspector componentInspector = ComponentInspector.getInstance();
        TopComponent topComponent = TopComponent.getRegistry().getActivated();
        if (topComponent != this.formDesigner.multiViewObserver.getTopComponent() && topComponent != componentInspector) {
            return;
        }
        this.formDesigner.componentActivated();
        Node[] nodeArray = componentInspector.getSelectedNodes();
        JPopupMenu jPopupMenu = NodeOp.findContextMenu((Node[])nodeArray);
        if (jPopupMenu != null) {
            jPopupMenu.show(this, point.x, point.y);
        }
    }

    private boolean anyDragger() {
        return this.draggedComponent != null || this.selectionDragger != null;
    }

    private RADVisualComponent[] getComponentsToDrag() {
        List list = this.formDesigner.getSelectedComponents();
        ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
        Object object = null;
        for (Object object2 : list) {
            if (!(object2 instanceof RADVisualComponent)) continue;
            boolean bl = false;
            for (RADComponent rADComponent : list) {
                if (rADComponent == object2 || !rADComponent.isParentComponent((RADComponent)object2)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            Object object3 = (RADVisualContainer)((RADComponent)object2).getParentComponent();
            if (HandleLayer.substituteForContainer((RADVisualContainer)object3)) {
                object2 = object3;
                object3 = (RADVisualContainer)((RADComponent)object2).getParentComponent();
            }
            if (object != null) {
                if (object != object3) {
                    return null;
                }
            } else {
                if (object3 == null || !this.formDesigner.getTopDesignComponent().isParentComponent((RADComponent)object2)) {
                    return null;
                }
                object = object3;
            }
            arrayList.add(object2);
        }
        return arrayList.isEmpty() ? null : arrayList.toArray(new RADVisualComponent[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean endDragging(MouseEvent mouseEvent) {
        if (!this.anyDragger()) {
            return false;
        }
        if (this.resizeType != 0) {
            this.resizeType = 0;
            Cursor cursor = this.getCursor();
            if (cursor != null && cursor.getType() != 0) {
                this.setCursor(Cursor.getDefaultCursor());
            }
            if (this.getToolTipText() != null) {
                this.setToolTipText(null);
            }
        }
        boolean bl = true;
        if (this.draggedComponent != null) {
            boolean bl2 = true;
            try {
                bl2 = this.draggedComponent.end(mouseEvent);
            }
            finally {
                if (bl2) {
                    this.draggedComponent = null;
                    this.draggingEnded = true;
                } else {
                    bl = false;
                }
            }
        } else if (this.selectionDragger != null) {
            if (mouseEvent != null) {
                this.selectionDragger.drop(mouseEvent.getPoint());
            }
            this.selectionDragger = null;
        }
        if (bl) {
            this.draggingEnded = true;
            StatusDisplayer.getDefault().setStatusText("");
        }
        FormEditor.getAssistantModel(this.getFormModel()).setContext("select");
        return bl;
    }

    private boolean isDraggedComponent(RADComponent rADComponent) {
        if (this.draggedComponent != null && this.draggedComponent.movingComponents != null) {
            for (RADVisualComponent rADVisualComponent : this.draggedComponent.movingComponents) {
                if (rADVisualComponent != rADComponent && !rADVisualComponent.isParentComponent(rADComponent)) continue;
                return true;
            }
        }
        return false;
    }

    private void highlightPanel(MouseEvent mouseEvent, boolean bl) {
        JPanel jPanel;
        Component[] componentArray = HandleLayer.getDeepestComponentsAt(this.formDesigner.getComponentLayer(), mouseEvent.getPoint());
        if (componentArray.length == 0) {
            return;
        }
        Component component = componentArray[componentArray.length - 1];
        RADComponent rADComponent = this.formDesigner.getMetaComponent(component);
        if (rADComponent != null && !(rADComponent instanceof RADVisualContainer)) {
            Component component2 = component = (rADComponent = rADComponent.getParentComponent()) != null ? (Component)this.formDesigner.getComponent(rADComponent) : null;
        }
        if (rADComponent == null || rADComponent == this.formDesigner.getTopDesignComponent() || !(component instanceof JPanel)) {
            component = null;
        }
        if (this.darkerPanel != (jPanel = (JPanel)component) || bl && !this.shouldHighlightPanel(jPanel, rADComponent)) {
            if (this.darkerPanel != null) {
                if (this.darkerPanel.getBorder() instanceof HighlightBorder) {
                    this.darkerPanel.setBorder(null);
                }
                this.darkerPanel = null;
            }
            if (this.shouldHighlightPanel(jPanel, rADComponent)) {
                jPanel.setBorder(new HighlightBorder(HandleLayer.darkerPanelColor(jPanel.getBackground()), 1));
                this.darkerPanel = jPanel;
            }
        }
    }

    private boolean shouldHighlightPanel(JPanel jPanel, RADComponent rADComponent) {
        if (jPanel != null) {
            RADVisualContainer rADVisualContainer;
            RADVisualContainer rADVisualContainer2;
            if (jPanel.getBorder() != null) {
                return false;
            }
            if (!(jPanel.getBackground() instanceof UIResource)) {
                return false;
            }
            if (rADComponent == this.formDesigner.getTopDesignComponent()) {
                return false;
            }
            if (this.formDesigner.getDesignerMode() == 0 && this.formDesigner.getSelectedLayoutComponents().contains(rADComponent)) {
                return false;
            }
            if (rADComponent instanceof RADVisualContainer && (rADVisualContainer2 = (rADVisualContainer = (RADVisualContainer)rADComponent).getParentContainer()) != null) {
                LayoutSupportManager layoutSupportManager = rADVisualContainer2.getLayoutSupport();
                if (layoutSupportManager != null && layoutSupportManager.isDedicated()) {
                    return false;
                }
                JPanel jPanel2 = (JPanel)this.formDesigner.getComponent(rADComponent);
                Component component = (Component)rADVisualContainer2.getBeanInstance();
                Component component2 = (Component)this.formDesigner.getComponent(rADVisualContainer2);
                if (component2.getSize().equals(jPanel2.getSize()) && jPanel2.getLocation().equals(new Point(0, 0))) {
                    if (component instanceof JPanel) {
                        return this.shouldHighlightPanel((JPanel)component, rADVisualContainer2);
                    }
                    return false;
                }
            }
        }
        return jPanel != null;
    }

    private static Color darkerPanelColor(Color color) {
        double d = 0.9;
        return new Color((int)((double)color.getRed() * d), (int)((double)color.getGreen() * d), (int)((double)color.getBlue() * d));
    }

    private void checkResizing(MouseEvent mouseEvent) {
        Serializable serializable;
        if (this.formDesigner.getTopDesignComponent() == null) {
            return;
        }
        int n = this.checkComponentsResizing(mouseEvent);
        if (n == 0) {
            n = this.checkDesignerResizing(mouseEvent);
            if (n == 0) {
                if (this.getToolTipText() != null) {
                    this.setToolTipText(null);
                }
            } else if (this.getToolTipText() == null) {
                MessageFormat messageFormat;
                serializable = this.formDesigner.getComponentLayer().getDesignerSize();
                if (this.viewOnly) {
                    if (sizeHintFormat == null) {
                        sizeHintFormat = new MessageFormat(FormUtils.getBundleString("FMT_HINT_DesignerSize"));
                    }
                    messageFormat = sizeHintFormat;
                } else {
                    if (resizingHintFormat == null) {
                        resizingHintFormat = new MessageFormat(FormUtils.getBundleString("FMT_HINT_DesignerResizing"));
                    }
                    messageFormat = resizingHintFormat;
                }
                String string = messageFormat.format(new Object[]{new Integer(((Dimension)serializable).width), new Integer(((Dimension)serializable).height)});
                this.setToolTipText(string);
                ToolTipManager.sharedInstance().mouseEntered(mouseEvent);
            }
        } else if (this.getToolTipText() != null) {
            this.setToolTipText(null);
        }
        if (n != 0 && !this.viewOnly) {
            this.setResizingCursor(n);
        } else {
            serializable = this.getCursor();
            if (serializable != null && serializable.getType() != 0) {
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    private int checkDesignerResizing(MouseEvent mouseEvent) {
        if (!(mouseEvent.isAltDown() || mouseEvent.isControlDown() || mouseEvent.isShiftDown())) {
            ComponentLayer componentLayer = this.formDesigner.getComponentLayer();
            int n = this.getSelectionResizable(mouseEvent.getPoint(), componentLayer.getComponentContainer(), componentLayer.getDesignerOutsets().right + 2);
            this.resizeType = this.validDesignerResizing(n) ? n | 0x100 : 0;
        } else {
            this.resizeType = 0;
        }
        return this.resizeType;
    }

    private boolean validDesignerResizing(int n) {
        return n == 10 || n == 2 || n == 8;
    }

    private int checkComponentsResizing(MouseEvent mouseEvent) {
        this.resizeType = 0;
        if (mouseEvent.isAltDown() || mouseEvent.isControlDown() || mouseEvent.isShiftDown()) {
            return 0;
        }
        if (!this.selectedComponentsInSameVisibleContainer()) {
            return 0;
        }
        Point point = mouseEvent.getPoint();
        RADComponent rADComponent = this.selectedComponentAt(point, 6);
        if (!(rADComponent instanceof RADVisualComponent)) {
            return 0;
        }
        this.resizeType = this.getComponentResizable(point, (RADVisualComponent)rADComponent);
        return this.resizeType;
    }

    private boolean selectedComponentsInSameVisibleContainer() {
        RADComponent rADComponent = null;
        Iterator iterator = this.formDesigner.getSelectedComponents().iterator();
        while (iterator.hasNext()) {
            RADVisualComponent rADVisualComponent = this.formDesigner.componentToLayoutComponent((RADComponent)iterator.next());
            if (rADVisualComponent == null) {
                return false;
            }
            if (!(rADComponent == null ? !this.formDesigner.isInDesignedTree(rADComponent = rADVisualComponent.getParentComponent()) : rADVisualComponent.getParentComponent() != rADComponent)) continue;
            return false;
        }
        return true;
    }

    private RADComponent selectedComponentAt(Point point, int n) {
        RADComponent rADComponent = null;
        for (RADComponent rADComponent2 : this.formDesigner.getSelectedLayoutComponents()) {
            Component component = (Component)this.formDesigner.getComponent(rADComponent2);
            if (component == null || component.getParent() == null) continue;
            Rectangle rectangle = new Rectangle(-n, -n, component.getWidth() + 2 * n, component.getHeight() + 2 * n);
            this.convertRectangleFromComponent(rectangle, component);
            if (!rectangle.contains(point)) continue;
            rADComponent = rADComponent2;
        }
        return rADComponent;
    }

    private int getComponentResizable(Point point, RADVisualComponent rADVisualComponent) {
        int n = this.getComponentResizable(rADVisualComponent);
        if (n != 0) {
            Component component = (Component)this.formDesigner.getComponent(rADVisualComponent);
            n &= this.getSelectionResizable(point, component, 6);
        }
        return n;
    }

    private int getComponentResizable(RADVisualComponent rADVisualComponent) {
        int n;
        RADVisualContainer rADVisualContainer = rADVisualComponent.getParentContainer();
        if (rADVisualContainer == null || rADVisualComponent == this.formDesigner.getTopDesignComponent()) {
            return 0;
        }
        Component component = (Component)this.formDesigner.getComponent(rADVisualComponent);
        LayoutSupportManager layoutSupportManager = rADVisualContainer.getLayoutSupport();
        if (layoutSupportManager == null) {
            List list = this.formDesigner.getSelectedComponents();
            n = list.size() == 1 ? 15 : 0;
        } else {
            Container container = (Container)this.formDesigner.getComponent(rADVisualContainer);
            Container container2 = rADVisualContainer.getContainerDelegate(container);
            n = layoutSupportManager.getResizableDirections(container, container2, component, rADVisualContainer.getIndexOf(rADVisualComponent));
        }
        return n;
    }

    private int getSelectionResizable(Point point, Component component, int n) {
        if (component == null) {
            return 0;
        }
        int n2 = 0;
        Rectangle rectangle = new Rectangle(0, 0, component.getWidth(), component.getHeight());
        this.convertRectangleFromComponent(rectangle, component);
        rectangle.grow(n, n);
        if (rectangle.contains(point)) {
            rectangle.grow(-n, -n);
            rectangle.grow(-3, -3);
            if (rectangle.width < 0) {
                rectangle.width = 0;
            }
            if (rectangle.height < 0) {
                rectangle.height = 0;
            }
            if (point.y >= rectangle.y + rectangle.height) {
                n2 |= 2;
            } else if (point.y < rectangle.y) {
                n2 |= 1;
            }
            if (point.x >= rectangle.x + rectangle.width) {
                n2 |= 8;
            } else if (point.x < rectangle.x) {
                n2 |= 4;
            }
        }
        return n2;
    }

    private void setResizingCursor(int n) {
        Cursor cursor = null;
        if ((n & 1) != 0) {
            cursor = (n & 4) != 0 ? Cursor.getPredefinedCursor(6) : ((n & 8) != 0 ? Cursor.getPredefinedCursor(7) : Cursor.getPredefinedCursor(8));
        } else if ((n & 2) != 0) {
            cursor = (n & 4) != 0 ? Cursor.getPredefinedCursor(4) : ((n & 8) != 0 ? Cursor.getPredefinedCursor(5) : Cursor.getPredefinedCursor(9));
        } else if ((n & 4) != 0) {
            cursor = Cursor.getPredefinedCursor(10);
        } else if ((n & 8) != 0) {
            cursor = Cursor.getPredefinedCursor(11);
        }
        if (cursor == null) {
            cursor = Cursor.getDefaultCursor();
        }
        this.setCursor(cursor);
    }

    private void setUserDesignerSize() {
        String string;
        int n;
        NotifyDescriptor.InputLine inputLine = new NotifyDescriptor.InputLine(FormUtils.getBundleString("CTL_SetDesignerSize_Label"), FormUtils.getBundleString("CTL_SetDesignerSize_Title"));
        Dimension dimension = this.formDesigner.getComponentLayer().getDesignerSize();
        inputLine.setInputText(Integer.toString(dimension.width) + ", " + Integer.toString(dimension.height));
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)inputLine) == NotifyDescriptor.OK_OPTION && (n = (string = inputLine.getInputText()).indexOf(44)) > 0) {
            int n2 = string.length();
            try {
                int n3 = Integer.parseInt(string.substring(0, n));
                while (++n < n2 && string.charAt(n) == ' ') {
                }
                int n4 = Integer.parseInt(string.substring(n, n2));
                if (n3 >= 0 && n4 >= 0) {
                    dimension = new Dimension(n3, n4);
                    this.formDesigner.setDesignerSize(dimension, null);
                    this.setToolTipText(null);
                    this.setCursor(Cursor.getDefaultCursor());
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private Object getConstraintsAtPoint(RADComponent rADComponent, Point point, Point point2) {
        int n;
        Point point3;
        Container container;
        Container container2;
        if (!(rADComponent instanceof RADVisualComponent)) {
            return null;
        }
        RADVisualContainer rADVisualContainer = rADComponent instanceof RADVisualContainer ? (RADVisualContainer)rADComponent : (RADVisualContainer)rADComponent.getParentComponent();
        LayoutSupportManager layoutSupportManager = rADVisualContainer != null ? rADVisualContainer.getLayoutSupport() : null;
        Object object = layoutSupportManager.getNewConstraints(container2 = (Container)this.formDesigner.getComponent(rADVisualContainer), container = rADVisualContainer.getContainerDelegate(container2), null, -1, point3 = this.convertPointToComponent(point.x, point.y, container), point2);
        if (object == null && rADComponent.getBeanInstance() instanceof Component && (n = layoutSupportManager.getNewIndex(container2, container, (Component)rADComponent.getBeanInstance(), -1, point3, point2)) != -1) {
            object = new Integer(n);
        }
        return object;
    }

    private static boolean substituteForContainer(RADVisualContainer rADVisualContainer) {
        return rADVisualContainer != null && rADVisualContainer.getBeanClass().isAssignableFrom(JScrollPane.class) && rADVisualContainer.getSubComponents().length > 0;
    }

    boolean mouseOnVisual(Point point) {
        Rectangle rectangle = this.formDesigner.getComponentLayer().getDesignerOuterBounds();
        return rectangle.contains(point);
    }

    boolean mouseOnNonVisualTray(Point point) {
        NonVisualTray nonVisualTray = this.formDesigner.getNonVisualTray();
        return nonVisualTray != null ? nonVisualTray.getBounds().contains(point) : false;
    }

    private Point convertPointFromComponent(Point point, Component component) {
        return this.formDesigner.pointFromComponentToHandleLayer(point, component);
    }

    private Point convertPointFromComponent(int n, int n2, Component component) {
        return this.formDesigner.pointFromComponentToHandleLayer(new Point(n, n2), component);
    }

    private Point convertPointToComponent(Point point, Component component) {
        return this.formDesigner.pointFromHandleToComponentLayer(point, component);
    }

    private Point convertPointToComponent(int n, int n2, Component component) {
        return this.formDesigner.pointFromHandleToComponentLayer(new Point(n, n2), component);
    }

    private Rectangle convertRectangleFromComponent(Rectangle rectangle, Component component) {
        Point point = this.convertPointFromComponent(rectangle.x, rectangle.y, component);
        rectangle.x = point.x;
        rectangle.y = point.y;
        return rectangle;
    }

    Rectangle convertRectangleToComponent(Rectangle rectangle, Component component) {
        Point point = this.convertPointToComponent(rectangle.x, rectangle.y, component);
        rectangle.x = point.x;
        rectangle.y = point.y;
        return rectangle;
    }

    Rectangle convertVisibleRectangleFromComponent(Rectangle rectangle, Component component) {
        while (!this.formDesigner.isCoordinatesRoot(component)) {
            Container container = component.getParent();
            Rectangle rectangle2 = new Rectangle(0, 0, container.getWidth(), container.getHeight());
            rectangle.translate(component.getX(), component.getY());
            rectangle = rectangle.intersection(rectangle2);
            component = container;
        }
        component = this;
        while (!this.formDesigner.isCoordinatesRoot(component)) {
            rectangle.translate(-component.getX(), -component.getY());
            component = component.getParent();
        }
        return rectangle;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (SwingUtilities.isRightMouseButton(mouseEvent) && !this.draggingEnded && !this.endDragging(null)) {
            if (this.mouseOnNonVisualTray(mouseEvent.getPoint())) {
                this.dispatchToNonVisualTray(mouseEvent);
            } else {
                this.showContextMenu(mouseEvent.getPoint());
            }
        }
        this.highlightPanel(mouseEvent, true);
        mouseEvent.consume();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.isVisible()) {
            return;
        }
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            if (this.formDesigner.getDesignerMode() == 0 && !this.draggingEnded && !this.endDragging(mouseEvent)) {
                boolean bl;
                boolean bl2 = bl = mouseEvent.isControlDown() || mouseEvent.isAltDown() || mouseEvent.isShiftDown();
                if ((this.resizeType & 0x100) != 0 && mouseEvent.getClickCount() == 2 && !bl && !this.viewOnly) {
                    this.setUserDesignerSize();
                } else if (this.mouseOnNonVisualTray(mouseEvent.getPoint())) {
                    this.dispatchToNonVisualTray(mouseEvent);
                } else if (this.prevLeftMousePoint != null && mouseEvent.getClickCount() == 1 && this.prevLeftMousePoint.distance(mouseEvent.getPoint()) <= 2.0 && !bl) {
                    RADComponent rADComponent = this.getMetaComponentAt(mouseEvent.getPoint(), 1);
                    if (rADComponent != null) {
                        this.formDesigner.startInPlaceEditing(rADComponent);
                    }
                } else if (mouseEvent.getClickCount() == 1 && mouseEvent.isShiftDown() && !mouseEvent.isAltDown() && !mouseEvent.isControlDown()) {
                    this.selectComponent(mouseEvent);
                }
            }
            this.prevLeftMousePoint = this.lastLeftMousePoint;
            this.lastLeftMousePoint = null;
        } else if (this.mouseOnNonVisualTray(mouseEvent.getPoint())) {
            this.dispatchToNonVisualTray(mouseEvent);
        }
        mouseEvent.consume();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.formDesigner.getDesignerMode() == 2) {
            this.formDesigner.requestActive();
            PaletteItem paletteItem = PaletteUtils.getSelectedItem();
            if (null != paletteItem) {
                StatusDisplayer.getDefault().setStatusText(FormUtils.getFormattedBundleString("FMT_MSG_AddingComponent", new String[]{paletteItem.getNode().getDisplayName()}));
            }
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.draggedComponent != null && this.formDesigner.getDesignerMode() == 2) {
            this.draggedComponent.move(null);
            this.repaint();
            StatusDisplayer.getDefault().setStatusText("");
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.formDesigner.componentActivated();
        if (!this.isVisible()) {
            return;
        }
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            if (this.formDesigner.getDesignerMode() != 0) {
                this.formDesigner.toggleSelectionMode();
                this.repaint();
            } else if (this.endDragging(null)) {
                this.repaint();
            } else if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                if (this.mouseOnNonVisualTray(mouseEvent.getPoint())) {
                    this.dispatchToNonVisualTray(mouseEvent);
                } else if (!this.mouseOnVisual(mouseEvent.getPoint())) {
                    this.selectOtherComponentsNode();
                } else {
                    RADComponent rADComponent = this.getMetaComponentAt(mouseEvent.getPoint(), 1);
                    if (!this.formDesigner.isComponentSelected(rADComponent)) {
                        this.formDesigner.setSelectedComponent(rADComponent);
                    }
                    this.processMouseClickInLayoutSupport(rADComponent, mouseEvent);
                }
                this.draggingEnded = false;
            }
            mouseEvent.consume();
        } else if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            boolean bl;
            this.lastLeftMousePoint = mouseEvent.getPoint();
            boolean bl2 = bl = mouseEvent.isControlDown() || mouseEvent.isAltDown() || mouseEvent.isShiftDown();
            if (this.formDesigner.getDesignerMode() == 0) {
                if (this.mouseOnNonVisualTray(mouseEvent.getPoint())) {
                    this.dispatchToNonVisualTray(mouseEvent);
                } else {
                    this.checkResizing(mouseEvent);
                    if (!(mouseEvent.isShiftDown() && mouseEvent.isAltDown() && mouseEvent.isControlDown())) {
                        RADComponent rADComponent;
                        if (!this.mouseOnVisual(this.lastLeftMousePoint)) {
                            if (this.resizeType == 0 && this.selectedComponentAt(this.lastLeftMousePoint, 0) == null) {
                                this.selectOtherComponentsNode();
                            }
                        } else if (!(this.resizeType != 0 || mouseEvent.getClickCount() == 2 && this.processDoubleClick(mouseEvent) || mouseEvent.isShiftDown() && !mouseEvent.isAltDown() || (rADComponent = this.selectComponent(mouseEvent)) == null || bl)) {
                            this.processMouseClickInLayoutSupport(rADComponent, mouseEvent);
                        }
                    }
                }
                this.draggingEnded = false;
            } else if (!this.viewOnly) {
                if (this.formDesigner.getDesignerMode() == 1) {
                    this.selectComponent(mouseEvent);
                } else if (this.formDesigner.getDesignerMode() == 2) {
                    this.endDragging(mouseEvent);
                    if (!mouseEvent.isShiftDown()) {
                        this.formDesigner.toggleSelectionMode();
                    }
                }
            }
            mouseEvent.consume();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.formDesigner.getDesignerMode() != 0) {
            return;
        }
        Point point = mouseEvent.getPoint();
        if (this.lastMousePosition != null) {
            this.lastXPosDiff = point.x - this.lastMousePosition.x;
            this.lastYPosDiff = point.y - this.lastMousePosition.y;
        }
        if (!this.draggingEnded && !this.anyDragger() && this.lastLeftMousePoint != null) {
            if (!(this.viewOnly || mouseEvent.isControlDown() || mouseEvent.isShiftDown() && !mouseEvent.isAltDown() || this.resizeType == 0 && !(this.lastLeftMousePoint.distance(point) > 6.0))) {
                RADVisualComponent[] rADVisualComponentArray;
                if ((this.resizeType & 0x100) == 0) {
                    rADVisualComponentArray = this.getComponentsToDrag();
                } else {
                    RADVisualComponent[] rADVisualComponentArray2 = new RADVisualComponent[1];
                    rADVisualComponentArray = rADVisualComponentArray2;
                    rADVisualComponentArray2[0] = this.formDesigner.getTopDesignComponent();
                }
                RADVisualComponent[] rADVisualComponentArray3 = rADVisualComponentArray;
                if (rADVisualComponentArray3 != null) {
                    this.draggedComponent = this.resizeType == 0 ? new ExistingComponentDrag(rADVisualComponentArray3, this.lastLeftMousePoint, mouseEvent.getModifiers()) : new ResizeComponentDrag(rADVisualComponentArray3, this.lastLeftMousePoint, this.resizeType & 0xFFFFFEFF);
                }
            }
            if (this.draggedComponent == null && this.formDesigner.getTopDesignComponent() instanceof RADVisualContainer && this.lastLeftMousePoint.distance(point) > 4.0 && !mouseEvent.isAltDown() && !mouseEvent.isControlDown() && (mouseEvent.isShiftDown() || this.getMetaComponentAt(this.lastLeftMousePoint, 0) == this.formDesigner.getTopDesignComponent())) {
                this.selectionDragger = new SelectionDragger(this.lastLeftMousePoint);
            }
        }
        if (this.draggedComponent != null) {
            this.draggedComponent.move(mouseEvent);
            this.highlightPanel(mouseEvent, false);
            this.repaint();
        } else if (this.selectionDragger != null) {
            this.selectionDragger.drag(point);
            this.repaint();
        }
        this.lastMousePosition = point;
        mouseEvent.consume();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        if (this.lastMousePosition != null) {
            this.lastXPosDiff = point.x - this.lastMousePosition.x;
            this.lastYPosDiff = point.y - this.lastMousePosition.y;
        }
        if (this.formDesigner.getDesignerMode() == 2) {
            PaletteItem paletteItem = PaletteUtils.getSelectedItem();
            if (null == paletteItem) {
                if (null != this.draggedComponent) {
                    this.endDragging(mouseEvent);
                }
                return;
            }
            if (this.draggedComponent == null) {
                if (paletteItem.getComponentClassName().indexOf(46) == -1 && !FormJavaSource.isInDefaultPackage(this.getFormModel())) {
                    String string = FormUtils.getBundleString("MSG_DefaultPackageBean");
                    NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string, 2);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                    this.formDesigner.toggleSelectionMode();
                    return;
                }
                this.draggedComponent = new NewComponentDrag(paletteItem);
            }
            this.draggedComponent.move(mouseEvent);
            this.repaint();
        } else if (this.formDesigner.getDesignerMode() == 0 && !this.anyDragger()) {
            this.checkResizing(mouseEvent);
        }
        this.highlightPanel(mouseEvent, false);
        this.lastMousePosition = point;
    }

    private void dispatchToNonVisualTray(MouseEvent mouseEvent) {
        NonVisualTray nonVisualTray = this.formDesigner.getNonVisualTray();
        if (nonVisualTray == null) {
            return;
        }
        Point point = SwingUtilities.convertPoint(this, mouseEvent.getPoint(), nonVisualTray);
        Component component = SwingUtilities.getDeepestComponentAt(nonVisualTray, point.x, point.y);
        point = SwingUtilities.convertPoint(nonVisualTray, point, component);
        component.dispatchEvent(new MouseEvent(component, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger()));
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        if (this.mouseOnNonVisualTray(mouseEvent.getPoint())) {
            NonVisualTray nonVisualTray = this.formDesigner.getNonVisualTray();
            Point point = SwingUtilities.convertPoint(this, mouseEvent.getPoint(), nonVisualTray);
            JComponent jComponent = (JComponent)SwingUtilities.getDeepestComponentAt(nonVisualTray, point.x, point.y);
            point = SwingUtilities.convertPoint(nonVisualTray, point, jComponent);
            return jComponent.getToolTipText(new MouseEvent(nonVisualTray, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger()));
        }
        return super.getToolTipText(mouseEvent);
    }

    private static void doLayout(Component component) {
        if (component instanceof Container) {
            Container container = (Container)component;
            container.doLayout();
            int n = container.getComponentCount();
            for (int i = 0; i < n; ++i) {
                HandleLayer.doLayout(container.getComponent(i));
            }
        }
    }

    private static void paintDraggedComponent(Component component, Graphics graphics) {
        try {
            if (component instanceof JComponent) {
                component.paint(graphics);
            } else {
                component.getPeer().paint(graphics);
            }
        }
        catch (RuntimeException runtimeException) {
            ErrorManager.getDefault().notify(1, (Throwable)runtimeException);
        }
    }

    static {
        formSettings = FormLoaderSettings.getInstance();
        lastPaintWidth = -1;
    }

    private abstract class ComponentDrag {
        RADVisualComponent[] movingComponents;
        RADVisualContainer targetContainer;
        RADVisualContainer fixedTarget;
        Component[] showingComponents;
        Rectangle[] originalBounds;
        Rectangle compoundBounds;
        Rectangle[] movingBounds;
        Point hotSpot;
        Point convertPoint;
        boolean newDrag;
        boolean oldDrag;
        Object layoutUndoMark;
        UndoableEdit layoutUndoEdit;

        ComponentDrag() {
            this.convertPoint = HandleLayer.this.formDesigner.getTopVisualContainer() == null ? new Point(0, 0) : HandleLayer.this.convertPointFromComponent(0, 0, HandleLayer.this.formDesigner.getTopVisualContainer());
        }

        ComponentDrag(RADVisualComponent[] rADVisualComponentArray, Point point) {
            this();
            this.movingComponents = rADVisualComponentArray;
            int n = rADVisualComponentArray.length;
            this.showingComponents = new Component[n];
            this.originalBounds = new Rectangle[n];
            this.movingBounds = new Rectangle[n];
            for (int i = 0; i < n; ++i) {
                this.showingComponents[i] = (Component)handleLayer.formDesigner.getComponent(this.movingComponents[i]);
                this.originalBounds[i] = this.showingComponents[i].getBounds();
                handleLayer.convertRectangleFromComponent(this.originalBounds[i], this.showingComponents[i].getParent());
                this.compoundBounds = this.compoundBounds != null ? this.compoundBounds.union(this.originalBounds[i]) : this.originalBounds[i];
                this.movingBounds[i] = new Rectangle();
                this.movingBounds[i].width = this.originalBounds[i].width;
                this.movingBounds[i].height = this.originalBounds[i].height;
            }
            this.hotSpot = point == null ? new Point(4, 4) : new Point(point.x - this.convertPoint.x, point.y - this.convertPoint.y);
        }

        final RADVisualContainer getSourceContainer() {
            return this.movingComponents != null && HandleLayer.this.formDesigner.getTopDesignComponent() != this.movingComponents[0] ? this.movingComponents[0].getParentContainer() : null;
        }

        final boolean isTopComponent() {
            return this.movingComponents != null && HandleLayer.this.formDesigner.getTopDesignComponent() == this.movingComponents[0];
        }

        final RADVisualContainer getTargetContainer(Point point, int n) {
            Object object;
            if (this.fixedTarget != null) {
                return this.fixedTarget;
            }
            int n2 = (n & 8) != 0 ? 1 : 0;
            Object object2 = HandleLayer.this.getMetaContainerAt(point, n2);
            if (object2 != null && ((RADVisualContainer)object2).getLayoutSupport() == null && (object = HandleLayer.this.getMetaContainerAt(this.getMoveDirectionSensitivePoint(point, n), n2)) != null && ((RADVisualContainer)object).getLayoutSupport() == null) {
                object2 = object;
            }
            if (this.movingComponents != null) {
                object = Arrays.asList(this.movingComponents);
                while (object.contains(object2)) {
                    object2 = ((RADVisualComponent)object2).getParentContainer();
                }
            }
            if (HandleLayer.substituteForContainer((RADVisualContainer)object2)) {
                object2 = ((RADVisualComponent)object2).getParentContainer();
            }
            return object2;
        }

        private Point getMoveDirectionSensitivePoint(Point point, int n) {
            if (HandleLayer.this.lastMousePosition != null && this.compoundBounds != null && (n & 0xB) == 0) {
                int n2;
                int n3;
                if (this.compoundBounds.width <= 0 || this.compoundBounds.height <= 0) {
                    return point;
                }
                if (HandleLayer.this.lastXPosDiff != 0 && HandleLayer.this.lastYPosDiff != 0) {
                    double d;
                    double d2 = HandleLayer.this.lastXPosDiff;
                    double d3 = HandleLayer.this.lastYPosDiff;
                    double d4 = Math.abs(d3 / d2);
                    if (d4 > (d = this.compoundBounds.getHeight() / this.compoundBounds.getWidth())) {
                        n3 = point.x + (int)Math.round(this.compoundBounds.getHeight() / d4 / 2.0) * (HandleLayer.this.lastXPosDiff > 0 ? 1 : -1);
                        n2 = point.y - this.convertPoint.y - this.hotSpot.y + this.compoundBounds.y + (HandleLayer.this.lastYPosDiff > 0 ? this.compoundBounds.height : 0);
                    } else {
                        n3 = point.x - this.convertPoint.x - this.hotSpot.x + this.compoundBounds.x + (HandleLayer.this.lastXPosDiff > 0 ? this.compoundBounds.width : 0);
                        n2 = point.y + (int)Math.round(this.compoundBounds.getWidth() * d4 / 2.0) * (HandleLayer.this.lastYPosDiff > 0 ? 1 : -1);
                    }
                } else {
                    int n4 = HandleLayer.this.lastXPosDiff == 0 ? point.x : (n3 = point.x - this.convertPoint.x - this.hotSpot.x + this.compoundBounds.x + (HandleLayer.this.lastXPosDiff > 0 ? this.compoundBounds.width : 0));
                    n2 = HandleLayer.this.lastYPosDiff == 0 ? point.y : point.y - this.convertPoint.y - this.hotSpot.y + this.compoundBounds.y + (HandleLayer.this.lastYPosDiff > 0 ? this.compoundBounds.height : 0);
                }
                Rectangle rectangle = HandleLayer.this.formDesigner.getComponentLayer().getDesignerInnerBounds();
                if (n3 < rectangle.x && n3 + 8 >= rectangle.x) {
                    n3 = rectangle.x;
                } else if (n3 > rectangle.x + rectangle.width && n3 - 8 < rectangle.x + rectangle.width) {
                    n3 = rectangle.x + rectangle.width - 1;
                }
                if (n2 < rectangle.y && n2 + 8 >= rectangle.y) {
                    n2 = rectangle.y;
                } else if (n2 > rectangle.y + rectangle.height && n2 - 8 < rectangle.y + rectangle.height) {
                    n2 = rectangle.y + rectangle.height - 1;
                }
                return new Point(n3, n2);
            }
            return point;
        }

        final void move(MouseEvent mouseEvent) {
            if (mouseEvent == null) {
                this.move(null, 0);
            } else {
                this.move(mouseEvent.getPoint(), mouseEvent.getModifiers());
            }
        }

        void move(Point point, int n) {
            if (point == null) {
                for (int i = 0; i < this.movingBounds.length; ++i) {
                    this.movingBounds[i].x = Integer.MIN_VALUE;
                }
                return;
            }
            this.targetContainer = this.getTargetContainer(point, n);
            if (this.newDrag && this.targetContainer != null && this.targetContainer.getLayoutSupport() == null) {
                point.x -= this.convertPoint.x;
                point.y -= this.convertPoint.y;
                HandleLayer.this.formDesigner.getLayoutDesigner().move(point, this.targetContainer.getId(), (n & 8) == 0, (n & 2) != 0, this.movingBounds);
                String[] stringArray = HandleLayer.this.formDesigner.getLayoutDesigner().positionCode();
                FormEditor.getAssistantModel(HandleLayer.this.getFormModel()).setContext(stringArray[0], stringArray[1]);
            } else if (this.oldDrag && this.targetContainer != null && this.targetContainer.getLayoutSupport() != null) {
                this.oldMove(point);
                for (int i = 0; i < this.movingBounds.length; ++i) {
                    this.movingBounds[i].x = point.x - this.convertPoint.x - this.hotSpot.x + this.originalBounds[i].x - this.convertPoint.x;
                    this.movingBounds[i].y = point.y - this.convertPoint.y - this.hotSpot.y + this.originalBounds[i].y - this.convertPoint.y;
                }
            } else {
                FormEditor.getAssistantModel(HandleLayer.this.getFormModel()).setContext("generalPosition");
                for (int i = 0; i < this.movingBounds.length; ++i) {
                    this.movingBounds[i].x = point.x - this.convertPoint.x - this.hotSpot.x + this.originalBounds[i].x - this.convertPoint.x;
                    this.movingBounds[i].y = point.y - this.convertPoint.y - this.hotSpot.y + this.originalBounds[i].y - this.convertPoint.y;
                }
            }
        }

        final void maskDraggingComponents() {
            if (!this.isTopComponent() && this.showingComponents != null) {
                for (int i = 0; i < this.showingComponents.length; ++i) {
                    Rectangle rectangle = this.movingBounds[i];
                    this.showingComponents[i].setBounds(rectangle.x + Short.MIN_VALUE, rectangle.y + Short.MIN_VALUE, rectangle.width, rectangle.height);
                }
            }
        }

        final void paintFeedback(Graphics2D graphics2D) {
            if (this.movingBounds.length < 1 || this.movingBounds[0].x == Integer.MIN_VALUE) {
                return;
            }
            for (int i = 0; i < this.showingComponents.length; ++i) {
                Graphics graphics = graphics2D.create(this.movingBounds[i].x + this.convertPoint.x, this.movingBounds[i].y + this.convertPoint.y, this.movingBounds[i].width + 1, this.movingBounds[i].height + 1);
                if (this.newDrag && (this.targetContainer != null && this.targetContainer.getLayoutSupport() == null || this.targetContainer == null && this.isTopComponent())) {
                    if (!this.isTopComponent()) {
                        HandleLayer.doLayout(this.showingComponents[i]);
                        HandleLayer.paintDraggedComponent(this.showingComponents[i], graphics);
                    }
                    graphics.setColor(formSettings.getSelectionBorderColor());
                    graphics.drawRect(0, 0, this.movingBounds[i].width, this.movingBounds[i].height);
                    graphics2D.translate(this.convertPoint.x, this.convertPoint.y);
                    graphics2D.setColor(formSettings.getGuidingLineColor());
                    HandleLayer.this.formDesigner.getLayoutDesigner().paintMoveFeedback(graphics2D);
                    graphics2D.translate(-this.convertPoint.x, -this.convertPoint.y);
                    continue;
                }
                if (this.oldDrag && (this.targetContainer != null && this.targetContainer.getLayoutSupport() != null || this.targetContainer == null && this.isTopComponent())) {
                    if (this.isTopComponent()) continue;
                    HandleLayer.doLayout(this.showingComponents[i]);
                    this.oldPaintFeedback(graphics2D, graphics, i);
                    continue;
                }
                HandleLayer.doLayout(this.showingComponents[i]);
                HandleLayer.paintDraggedComponent(this.showingComponents[i], graphics);
            }
        }

        final boolean end(final MouseEvent mouseEvent) {
            HandleLayer.this.dragPanel.removeAll();
            boolean bl = mouseEvent == null ? this.end(null, 0) : this.end(mouseEvent.getPoint(), mouseEvent.getModifiers());
            if (bl) {
                this.movingComponents = null;
                this.targetContainer = null;
                this.fixedTarget = null;
                this.showingComponents = null;
            } else {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        ComponentDrag.this.init();
                        ComponentDrag.this.move(mouseEvent);
                    }
                });
            }
            return bl;
        }

        void init() {
            if (this.showingComponents != null) {
                RADVisualContainer rADVisualContainer = this.getSourceContainer();
                boolean bl = rADVisualContainer != null && rADVisualContainer.getLayoutSupport() != null;
                HandleLayer.this.dragPanel.removeAll();
                for (int i = 0; i < this.showingComponents.length; ++i) {
                    Component component = this.showingComponents[i];
                    if (component.getParent() == null) {
                        HandleLayer.this.dragPanel.add(component);
                    } else if (bl) {
                        component.setVisible(false);
                    }
                    this.avoidDoubleBuffering(component);
                }
            }
        }

        private void avoidDoubleBuffering(Component component) {
            if (component instanceof JComponent) {
                ((JComponent)component).setDoubleBuffered(false);
            }
            if (component instanceof Container) {
                Container container = (Container)component;
                for (int i = 0; i < container.getComponentCount(); ++i) {
                    this.avoidDoubleBuffering(container.getComponent(i));
                }
            }
        }

        boolean end(Point point, int n) {
            return true;
        }

        void oldMove(Point point) {
        }

        void oldPaintFeedback(Graphics2D graphics2D, Graphics graphics, int n) {
        }

        final void createLayoutUndoableEdit() {
            this.layoutUndoMark = HandleLayer.this.getLayoutModel().getChangeMark();
            this.layoutUndoEdit = HandleLayer.this.getLayoutModel().getUndoableEdit();
        }

        final void placeLayoutUndoableEdit(boolean bl) {
            if (!this.layoutUndoMark.equals(HandleLayer.this.getLayoutModel().getChangeMark())) {
                HandleLayer.this.getFormModel().addUndoableEdit(this.layoutUndoEdit);
            }
            if (bl) {
                HandleLayer.this.getFormModel().forceUndoOfCompoundEdit();
            }
            this.layoutUndoMark = null;
            this.layoutUndoEdit = null;
        }
    }

    private class ExistingComponentDrag
    extends ComponentDrag {
        private int modifiers;
        private ComponentDragger oldDragger;

        ExistingComponentDrag(RADVisualComponent[] rADVisualComponentArray, Point point, int n) {
            super(rADVisualComponentArray, point);
            this.modifiers = n;
            this.init();
        }

        void init() {
            int n;
            RADVisualContainer rADVisualContainer = this.getSourceContainer();
            String[] stringArray = new String[this.showingComponents.length];
            for (n = 0; n < this.showingComponents.length; ++n) {
                stringArray[n] = this.movingComponents[n].getId();
                this.originalBounds[n].x -= this.convertPoint.x;
                this.originalBounds[n].y -= this.convertPoint.y;
            }
            if (rADVisualContainer.getLayoutSupport() == null) {
                HandleLayer.this.formDesigner.getLayoutDesigner().startMoving(stringArray, this.originalBounds, this.hotSpot);
            } else {
                LayoutComponent[] layoutComponentArray = new LayoutComponent[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    layoutComponentArray[i] = HandleLayer.this.getLayoutModel().getLayoutComponent(stringArray[i]);
                    if (layoutComponentArray[i] != null) continue;
                    layoutComponentArray[i] = new LayoutComponent(stringArray[i], false);
                }
                HandleLayer.this.formDesigner.getLayoutDesigner().startAdding(layoutComponentArray, this.originalBounds, this.hotSpot, null);
            }
            if ((this.modifiers & 8) != 0) {
                this.fixedTarget = (this.modifiers & 1) != 0 || HandleLayer.this.formDesigner.getTopDesignComponent() == rADVisualContainer ? rADVisualContainer : rADVisualContainer.getParentContainer();
            }
            for (n = 0; n < this.originalBounds.length; ++n) {
                this.originalBounds[n].x += this.convertPoint.x;
                this.originalBounds[n].y += this.convertPoint.y;
            }
            this.oldDragger = new ComponentDragger(HandleLayer.this.formDesigner, HandleLayer.this, this.movingComponents, this.originalBounds, new Point(this.hotSpot.x + this.convertPoint.x, this.hotSpot.y + this.convertPoint.y), this.fixedTarget);
            this.oldDrag = true;
            this.newDrag = true;
            super.init();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean end(Point point, int n) {
            RADVisualContainer rADVisualContainer = this.getSourceContainer();
            if (point != null) {
                if (this.targetContainer == null || this.targetContainer.getLayoutSupport() != null) {
                    this.createLayoutUndoableEdit();
                    boolean bl = true;
                    try {
                        HandleLayer.this.formDesigner.getLayoutDesigner().removeDraggedComponents();
                        this.oldDragger.dropComponents(point, this.targetContainer);
                        bl = false;
                    }
                    finally {
                        this.placeLayoutUndoableEdit(bl);
                    }
                } else {
                    int n2;
                    if (this.targetContainer != rADVisualContainer) {
                        for (n2 = 0; n2 < this.movingComponents.length; ++n2) {
                            HandleLayer.this.getFormModel().removeComponent(this.movingComponents[n2], false);
                        }
                        for (n2 = 0; n2 < this.movingComponents.length; ++n2) {
                            HandleLayer.this.getFormModel().addVisualComponent(this.movingComponents[n2], this.targetContainer, null, false);
                        }
                    }
                    this.createLayoutUndoableEdit();
                    n2 = 1;
                    try {
                        HandleLayer.this.formDesigner.getLayoutDesigner().endMoving(true);
                        n2 = 0;
                    }
                    finally {
                        HandleLayer.this.getFormModel().fireContainerLayoutChanged(this.targetContainer, null, null, null);
                        this.placeLayoutUndoableEdit(n2 != 0);
                    }
                }
            } else {
                HandleLayer.this.formDesigner.getLayoutDesigner().endMoving(false);
                HandleLayer.this.formDesigner.updateContainerLayout(rADVisualContainer);
            }
            return true;
        }

        void oldMove(Point point) {
            this.oldDragger.drag(point, this.targetContainer);
        }

        void oldPaintFeedback(Graphics2D graphics2D, Graphics graphics, int n) {
            this.oldDragger.paintDragFeedback(graphics2D);
            Component component = this.showingComponents[n];
            HandleLayer.paintDraggedComponent(component, graphics);
        }
    }

    private static class HighlightBorder
    extends LineBorder {
        HighlightBorder(Color color, int n) {
            super(color, n);
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(0, 0, 0, 0);
        }
    }

    private class NewComponentDrag
    extends ComponentDrag {
        private PaletteItem paletteItem;
        RADComponent addedComponent;
        private int index = -1;
        private LayoutConstraints constraints;

        NewComponentDrag(PaletteItem paletteItem) {
            this.paletteItem = paletteItem;
            this.showingComponents = new Component[1];
            this.init();
        }

        void init() {
            RADVisualComponent rADVisualComponent = HandleLayer.this.getComponentCreator().precreateVisualComponent(this.paletteItem.getComponentClassSource());
            if (rADVisualComponent != null) {
                if (this.movingComponents == null) {
                    this.movingComponents = new RADVisualComponent[1];
                }
                this.movingComponents[0] = rADVisualComponent;
                LayoutComponent layoutComponent = HandleLayer.this.getComponentCreator().getPrecreatedLayoutComponent();
                LayoutComponent[] layoutComponentArray = new LayoutComponent[]{layoutComponent};
                this.showingComponents[0] = (Component)rADVisualComponent.getBeanInstance();
                if (!(this.showingComponents[0] instanceof JComponent)) {
                    FakePeerSupport.attachFakePeer(this.showingComponents[0]);
                    if (this.showingComponents[0] instanceof Container) {
                        FakePeerSupport.attachFakePeerRecursively((Container)this.showingComponents[0]);
                    }
                }
                Dimension dimension = this.showingComponents[0].getPreferredSize();
                if (this.originalBounds == null) {
                    this.hotSpot = new Point();
                    this.originalBounds = new Rectangle[]{new Rectangle(this.convertPoint.x, this.convertPoint.y, dimension.width, dimension.height)};
                    this.movingBounds = new Rectangle[]{new Rectangle(0, 0, dimension.width, dimension.height)};
                } else {
                    this.movingBounds[0].width = dimension.width;
                    this.movingBounds[0].height = dimension.height;
                    this.originalBounds[0] = this.movingBounds[0];
                    this.movingBounds[0] = new Rectangle(this.movingBounds[0]);
                    this.originalBounds[0].x += this.convertPoint.x;
                    this.originalBounds[0].y += this.convertPoint.y;
                }
                this.compoundBounds = this.originalBounds[0];
                this.hotSpot.x = this.movingBounds[0].x + dimension.width / 2 - 4;
                this.hotSpot.y = this.movingBounds[0].y + dimension.height / 2;
                if (this.hotSpot.x < this.movingBounds[0].x) {
                    this.hotSpot.x = this.movingBounds[0].x;
                }
                if (HandleLayer.this.formDesigner.getLayoutDesigner() != null) {
                    HandleLayer.this.formDesigner.getLayoutDesigner().startAdding(layoutComponentArray, this.movingBounds, this.hotSpot, this.targetContainer != null ? this.targetContainer.getId() : null);
                }
                this.oldDrag = true;
                this.newDrag = true;
            } else if (this.paletteItem.getComponentClass() != null) {
                Node node = this.paletteItem.getNode();
                Image image = node == null ? Utilities.loadImage((String)"org/netbeans/modules/form/resources/form.gif") : node.getIcon(1);
                this.showingComponents[0] = new JLabel(new ImageIcon(image));
                Dimension dimension = this.showingComponents[0].getPreferredSize();
                this.hotSpot = new Point(dimension.width / 2, dimension.height / 2);
                if (this.hotSpot.x < 0) {
                    this.hotSpot.x = 0;
                }
                this.originalBounds = new Rectangle[]{new Rectangle(this.convertPoint.x, this.convertPoint.y, dimension.width, dimension.height)};
                this.showingComponents[0].setBounds(this.originalBounds[0]);
                this.movingBounds = new Rectangle[]{this.showingComponents[0].getBounds()};
                this.oldDrag = false;
                this.newDrag = false;
            } else {
                this.showingComponents = null;
                this.movingBounds = new Rectangle[0];
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        HandleLayer.this.endDragging(null);
                    }
                });
            }
            super.init();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean end(Point point, int n) {
            if (point != null) {
                Object object;
                boolean bl;
                boolean bl2;
                this.targetContainer = this.getTargetContainer(point, n);
                if (this.targetContainer != null && this.movingComponents != null) {
                    bl2 = this.targetContainer.getLayoutSupport() == null;
                    bl = !bl2;
                } else {
                    bl = false;
                    bl2 = false;
                }
                Object object2 = bl ? (!this.paletteItem.isMenu() && this.paletteItem.isVisual() ? HandleLayer.this.getConstraintsAtPoint(this.targetContainer, point, this.hotSpot) : null) : null;
                if (this.movingComponents != null) {
                    this.addedComponent = this.movingComponents[0];
                    object = HandleLayer.this.getComponentCreator().getPrecreatedLayoutComponent();
                    boolean bl3 = HandleLayer.this.getComponentCreator().addPrecreatedComponent(this.targetContainer, object2);
                    if (HandleLayer.this.getLayoutModel() != null) {
                        this.createLayoutUndoableEdit();
                        boolean bl4 = true;
                        try {
                            HandleLayer.this.formDesigner.getLayoutDesigner().endMoving(bl3 && bl2);
                            if (bl3) {
                                if (((LayoutComponent)object).isLayoutContainer() && !bl2) {
                                    HandleLayer.this.getLayoutModel().addRootComponent((LayoutComponent)object);
                                }
                            } else {
                                HandleLayer.this.repaint();
                            }
                            bl4 = false;
                        }
                        finally {
                            this.placeLayoutUndoableEdit(bl4);
                        }
                    }
                } else {
                    object = this.targetContainer;
                    if (Border.class.isAssignableFrom(this.paletteItem.getComponentClass())) {
                        int n2 = (n & 8) != 0 ? 1 : 0;
                        object = HandleLayer.this.getMetaComponentAt(point, n2);
                    }
                    this.addedComponent = HandleLayer.this.getComponentCreator().createComponent(this.paletteItem.getComponentClassSource(), (RADComponent)object, object2);
                    if (this.addedComponent == null) {
                        HandleLayer.this.repaint();
                    }
                }
                if (this.addedComponent != null && (object = this.addedComponent.getBeanInfo().getBeanDescriptor()) != null && ((FeatureDescriptor)object).getValue("customizeOnCreation") != null) {
                    n &= 0xFFFFFFFE;
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            RADComponentNode rADComponentNode = NewComponentDrag.this.addedComponent.getNodeReference();
                            if (rADComponentNode.hasCustomizer()) {
                                NodeOperation.getDefault().customize((Node)rADComponentNode);
                            }
                        }
                    });
                }
                if ((n & 1) != 0) {
                    return false;
                }
            } else {
                if (HandleLayer.this.formDesigner.getLayoutDesigner() != null) {
                    HandleLayer.this.formDesigner.getLayoutDesigner().endMoving(false);
                }
                HandleLayer.this.getComponentCreator().releasePrecreatedComponent();
            }
            HandleLayer.this.formDesigner.toggleSelectionMode();
            return true;
        }

        void oldMove(Point point) {
            LayoutSupportManager layoutSupportManager = this.targetContainer.getLayoutSupport();
            Container container = (Container)HandleLayer.this.formDesigner.getComponent(this.targetContainer);
            Container container2 = this.targetContainer.getContainerDelegate(container);
            Point point2 = HandleLayer.this.convertPointToComponent(point.x, point.y, container2);
            Point point3 = this.hotSpot;
            this.index = layoutSupportManager.getNewIndex(container, container2, this.showingComponents[0], -1, point2, point3);
            this.constraints = layoutSupportManager.getNewConstraints(container, container2, this.showingComponents[0], -1, point2, point3);
        }

        void oldPaintFeedback(Graphics2D graphics2D, Graphics graphics, int n) {
            LayoutSupportManager layoutSupportManager = this.targetContainer.getLayoutSupport();
            Container container = (Container)HandleLayer.this.formDesigner.getComponent(this.targetContainer);
            Container container2 = this.targetContainer.getContainerDelegate(container);
            Point point = HandleLayer.this.convertPointFromComponent(0, 0, container2);
            graphics2D.setColor(formSettings.getSelectionBorderColor());
            graphics2D.setStroke(ComponentDragger.dashedStroke1);
            graphics2D.translate(point.x, point.y);
            layoutSupportManager.paintDragFeedback(container, container2, this.showingComponents[0], this.constraints, this.index, graphics2D);
            graphics2D.translate(-point.x, -point.y);
            HandleLayer.paintDraggedComponent(this.showingComponents[0], graphics);
        }
    }

    private class NewComponentDropListener
    implements DropTargetListener {
        private NewComponentDropListener() {
        }

        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            try {
                Transferable transferable = dropTargetDragEvent.getTransferable();
                PaletteItem paletteItem = null;
                if (dropTargetDragEvent.isDataFlavorSupported(PaletteController.ITEM_DATA_FLAVOR)) {
                    Lookup lookup = (Lookup)transferable.getTransferData(PaletteController.ITEM_DATA_FLAVOR);
                    paletteItem = (PaletteItem)lookup.lookup(PaletteItem.class);
                } else {
                    ClassSource classSource = CopySupport.getCopiedBeanClassSource(transferable);
                    if (classSource != null) {
                        paletteItem = new PaletteItem(classSource);
                    } else {
                        NewComponentDrop newComponentDrop;
                        Node node = NodeTransfer.node((Transferable)transferable, (int)1);
                        if (node != null && (newComponentDrop = (NewComponentDrop)node.getCookie(NewComponentDrop.class)) != null) {
                            paletteItem = newComponentDrop.getPaletteItem();
                        }
                    }
                }
                if (paletteItem != null) {
                    if (paletteItem.getComponentClassName().indexOf(46) != -1 || FormJavaSource.isInDefaultPackage(HandleLayer.this.getFormModel())) {
                        HandleLayer.this.draggedComponent = new NewComponentDrag(paletteItem);
                        HandleLayer.this.draggedComponent.move(dropTargetDragEvent.getLocation(), 0);
                        HandleLayer.this.repaint();
                    } else {
                        dropTargetDragEvent.rejectDrag();
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            if (HandleLayer.this.draggedComponent != null) {
                HandleLayer.this.draggedComponent.move(dropTargetDragEvent.getLocation(), 0);
                HandleLayer.this.repaint();
            }
        }

        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }

        public void dragExit(DropTargetEvent dropTargetEvent) {
            if (HandleLayer.this.draggedComponent != null) {
                HandleLayer.this.endDragging(null);
                HandleLayer.this.repaint();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            if (HandleLayer.this.draggedComponent != null) {
                NewComponentDrag newComponentDrag = (NewComponentDrag)HandleLayer.this.draggedComponent;
                try {
                    newComponentDrag.end(dropTargetDropEvent.getLocation(), 0);
                }
                finally {
                    HandleLayer.this.draggedComponent = null;
                    HandleLayer.this.draggingEnded = true;
                }
                if (newComponentDrag.addedComponent != null) {
                    NewComponentDrop newComponentDrop;
                    String string = newComponentDrag.addedComponent.getId();
                    Node node = NodeTransfer.node((Transferable)dropTargetDropEvent.getTransferable(), (int)1);
                    if (node != null && (newComponentDrop = (NewComponentDrop)node.getCookie(NewComponentDrop.class)) != null) {
                        newComponentDrop.componentAdded(HandleLayer.this.getFormModel(), string);
                    }
                }
                HandleLayer.this.formDesigner.toggleSelectionMode();
                HandleLayer.this.formDesigner.requestActive();
            }
        }
    }

    private class ResizeComponentDrag
    extends ComponentDrag {
        private int resizeType;
        private Dimension originalSize;
        private ComponentDragger oldDragger;

        ResizeComponentDrag(RADVisualComponent[] rADVisualComponentArray, Point point, int n) {
            super(rADVisualComponentArray, point);
            this.resizeType = n;
            this.init();
        }

        void init() {
            String[] stringArray;
            RADVisualContainer rADVisualContainer = this.getSourceContainer();
            if (this.isTopComponent()) {
                stringArray = HandleLayer.this.getLayoutModel();
                this.newDrag = stringArray != null && stringArray.getLayoutComponent(this.movingComponents[0].getId()) != null;
                this.oldDrag = !this.newDrag;
                this.fixedTarget = null;
                this.originalSize = HandleLayer.this.formDesigner.getComponentLayer().getDesignerSize();
            } else if (rADVisualContainer != null) {
                if (rADVisualContainer.getLayoutSupport() == null) {
                    this.newDrag = true;
                } else {
                    this.oldDrag = true;
                }
                this.fixedTarget = rADVisualContainer;
            }
            if (this.newDrag) {
                stringArray = new String[this.showingComponents.length];
                for (int i = 0; i < this.showingComponents.length; ++i) {
                    stringArray[i] = this.movingComponents[i].getId();
                    this.originalBounds[i].x -= this.convertPoint.x;
                    this.originalBounds[i].y -= this.convertPoint.y;
                }
                int[] nArray = new int[2];
                int n = this.resizeType & 0xC;
                nArray[0] = n == 4 ? 0 : (n == 8 ? 1 : -1);
                int n2 = this.resizeType & 3;
                nArray[1] = n2 == 1 ? 0 : (n2 == 2 ? 1 : -1);
                HandleLayer.this.formDesigner.getLayoutDesigner().startResizing(stringArray, this.originalBounds, this.hotSpot, nArray, rADVisualContainer != null);
                for (int i = 0; i < this.originalBounds.length; ++i) {
                    this.originalBounds[i].x += this.convertPoint.x;
                    this.originalBounds[i].y += this.convertPoint.y;
                }
            } else if (this.oldDrag) {
                this.oldDragger = new ComponentDragger(HandleLayer.this.formDesigner, HandleLayer.this, this.movingComponents, this.originalBounds, new Point(this.hotSpot.x + this.convertPoint.x, this.hotSpot.y + this.convertPoint.y), this.resizeType);
            }
            super.init();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean end(Point point, int n) {
            if (point != null) {
                if (this.newDrag) {
                    this.showingComponents[0].setSize(this.movingBounds[0].width, this.movingBounds[0].height);
                    HandleLayer.doLayout(this.showingComponents[0]);
                    this.createLayoutUndoableEdit();
                    boolean bl = true;
                    try {
                        HandleLayer.this.formDesigner.getLayoutDesigner().endMoving(true);
                        for (int i = 0; i < this.movingComponents.length; ++i) {
                            RADVisualContainer rADVisualContainer;
                            RADVisualComponent rADVisualComponent = this.movingComponents[i];
                            if (!(rADVisualComponent instanceof RADVisualContainer) || (rADVisualContainer = (RADVisualContainer)rADVisualComponent).getLayoutSupport() != null) continue;
                            HandleLayer.this.getFormModel().fireContainerLayoutChanged(rADVisualContainer, null, null, null);
                        }
                        bl = false;
                    }
                    finally {
                        if (this.targetContainer != null) {
                            HandleLayer.this.getFormModel().fireContainerLayoutChanged(this.targetContainer, null, null, null);
                        }
                        this.placeLayoutUndoableEdit(bl);
                    }
                } else if (this.targetContainer != null) {
                    this.oldDragger.dropComponents(point, this.targetContainer);
                }
                if (this.isTopComponent()) {
                    HandleLayer.this.formDesigner.setDesignerSize(new Dimension(this.movingBounds[0].width, this.movingBounds[0].height), this.originalSize);
                }
            } else {
                HandleLayer.this.formDesigner.getLayoutDesigner().endMoving(false);
                if (this.isTopComponent()) {
                    ComponentLayer componentLayer = HandleLayer.this.formDesigner.getComponentLayer();
                    if (!componentLayer.getDesignerSize().equals(this.originalSize)) {
                        componentLayer.setDesignerSize(this.originalSize);
                        componentLayer.revalidate();
                    }
                    componentLayer.repaint();
                } else {
                    HandleLayer.this.formDesigner.updateContainerLayout(this.getSourceContainer());
                }
            }
            return true;
        }

        void move(Point point, int n) {
            if (this.isTopComponent()) {
                Cloneable cloneable;
                if (this.newDrag) {
                    point.x -= this.convertPoint.x;
                    point.y -= this.convertPoint.y;
                    HandleLayer.this.formDesigner.getLayoutDesigner().move(point, null, (n & 8) == 0, (n & 2) != 0, this.movingBounds);
                    this.showingComponents[0].setSize(this.movingBounds[0].width, this.movingBounds[0].height);
                } else {
                    cloneable = HandleLayer.this.formDesigner.getComponentLayer().getDesignerInnerBounds();
                    int n2 = cloneable.width;
                    int n3 = cloneable.height;
                    if ((this.resizeType & 2) != 0 && (n3 = point.y - cloneable.y) < 0) {
                        n3 = 0;
                    }
                    if ((this.resizeType & 8) != 0 && (n2 = point.x - cloneable.x) < 0) {
                        n2 = 0;
                    }
                    this.movingBounds[0].width = n2;
                    this.movingBounds[0].height = n3;
                }
                cloneable = new Dimension(this.movingBounds[0].width, this.movingBounds[0].height);
                HandleLayer.this.formDesigner.getComponentLayer().setDesignerSize((Dimension)cloneable);
                HandleLayer.doLayout(HandleLayer.this.formDesigner.getComponentLayer());
            } else if (this.oldDrag && (this.targetContainer = this.getTargetContainer(point, n)) != null && this.targetContainer.getLayoutSupport() != null) {
                this.oldMove(point);
                for (int i = 0; i < this.movingBounds.length; ++i) {
                    int n4 = point.x - this.convertPoint.x - this.hotSpot.x;
                    if ((this.resizeType & 4) != 0) {
                        this.movingBounds[i].x = this.originalBounds[i].x - this.convertPoint.x + n4;
                        n4 = -n4;
                    } else {
                        this.movingBounds[i].x = this.originalBounds[i].x - this.convertPoint.x;
                    }
                    if ((this.resizeType & 0xC) != 0) {
                        this.movingBounds[i].width = this.originalBounds[i].width + n4;
                    }
                    int n5 = point.y - this.convertPoint.y - this.hotSpot.y;
                    if ((this.resizeType & 1) != 0) {
                        this.movingBounds[i].y = this.originalBounds[i].y - this.convertPoint.y + n5;
                        n5 = -n5;
                    } else {
                        this.movingBounds[i].y = this.originalBounds[i].y - this.convertPoint.y;
                    }
                    if ((this.resizeType & 3) == 0) continue;
                    this.movingBounds[i].height = this.originalBounds[i].height + n5;
                }
            } else {
                super.move(point, n);
            }
        }

        void oldMove(Point point) {
            this.oldDragger.drag(point, this.targetContainer);
            FormEditor.getAssistantModel(HandleLayer.this.getFormModel()).setContext("generalResizing");
        }

        void oldPaintFeedback(Graphics2D graphics2D, Graphics graphics, int n) {
            HandleLayer.paintDraggedComponent(this.showingComponents[n], graphics);
            this.oldDragger.paintDragFeedback(graphics2D);
        }
    }

    private class SelectionDragger {
        private Point startPoint;
        private Point lastPoint;

        public SelectionDragger(Point point) {
            this.startPoint = point;
        }

        public void paintDragFeedback(Graphics graphics) {
            if (this.startPoint != null && this.lastPoint != null) {
                Rectangle rectangle = this.getRectangle();
                graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }

        public void drag(Point point) {
            this.lastPoint = point;
        }

        public void drop(Point point) {
            if (this.startPoint != null && point != null) {
                this.lastPoint = point;
                ArrayList arrayList = new ArrayList();
                this.collectSelectedComponents(this.getRectangle(), HandleLayer.this.formDesigner.getComponentLayer().getComponentContainer(), arrayList);
                RADComponent[] rADComponentArray = new RADComponent[arrayList.size()];
                arrayList.toArray(rADComponentArray);
                HandleLayer.this.formDesigner.setSelectedComponents(rADComponentArray);
            }
        }

        private Rectangle getRectangle() {
            int n;
            int n2 = this.startPoint.x <= this.lastPoint.x ? this.startPoint.x : this.lastPoint.x;
            int n3 = this.startPoint.y <= this.lastPoint.y ? this.startPoint.y : this.lastPoint.y;
            int n4 = this.lastPoint.x - this.startPoint.x;
            if (n4 < 0) {
                n4 = -n4;
            }
            if ((n = this.lastPoint.y - this.startPoint.y) < 0) {
                n = -n;
            }
            return new Rectangle(n2, n3, n4, n);
        }

        private boolean collectSelectedComponents(Rectangle rectangle, Container container, List list) {
            ArrayList<Component> arrayList = new ArrayList<Component>();
            Component[] componentArray = container.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                Component component = componentArray[i];
                Rectangle rectangle2 = HandleLayer.this.convertRectangleFromComponent(componentArray[i].getBounds(), container);
                boolean bl = rectangle.intersects(rectangle2);
                RADComponent rADComponent = HandleLayer.this.formDesigner.getMetaComponent(component);
                if (rADComponent != null) {
                    if (bl) {
                        list.add(rADComponent);
                    }
                    if (!(rADComponent instanceof ComponentContainer)) continue;
                }
                if (!bl || !(component instanceof Container)) continue;
                arrayList.add(component);
            }
            if (list.size() > 1 || list.size() == 1 && arrayList.size() == 0) {
                return true;
            }
            Object e = list.size() == 1 ? (Object)list.get(0) : null;
            for (int i = 0; i < arrayList.size(); ++i) {
                list.clear();
                if (!this.collectSelectedComponents(rectangle, (Container)arrayList.get(i), list)) continue;
                return true;
            }
            if (e != null) {
                list.add(e);
                return true;
            }
            return false;
        }
    }
}

